<?php
/**
 * Supports trait
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay\Core
 */

namespace Wpayme\WordPress\Pay\Core;

/**
 * Supports trait class
 */
trait SupportsTrait {
	/**
	 * Supported features.
	 *
	 * @var array
	 */
	protected $supports = [];

	/**
	 * Add support.
	 *
	 * @param string $feature Feature.
	 * @return void
	 */
	public function add_support( $feature ) {
		$this->supports[] = $feature;
	}

	/**
	 * Check if supports a given feature.
	 *
	 * @param string $feature The feature to check.
	 * @return bool True if supported, false otherwise.
	 */
	public function supports( $feature ) {
		return in_array( $feature, $this->supports, true );
	}
}
