<?php
/**
 * Editor Blocks.
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 */

namespace Wpayme\WordPress\Pay\Blocks;

use Wpayme\WordPress\Number\Number;
use Wpayme\WordPress\Number\Parser as NumberParser;
use Wpayme\WordPress\Money\Money;
use Wpayme\WordPress\Pay\Forms\FormsSource;
use Wpayme\WordPress\Pay\Payments\Payment;
use Wpayme\WordPress\Pay\Plugin;
use WP_Error;

/**
 * Blocks
 *
 * @author  Reüel van der Steege
 * @since   2.5.0
 * @version 2.1.7
 */
class BlocksModule {
	/**
	 * Setup.
	 *
	 * @return void
	 */
	public function setup() {
		global $wp_version;

		add_filter( 'block_categories_all', [ $this, 'block_categories' ], 10 );

		if ( \version_compare( $wp_version, '5.8', '<' ) ) {
			add_filter( 'block_categories', [ $this, 'block_categories' ], 10 );
		}
	}

	/**
	 * Block categories.
	 *
	 * @param array $categories Block categories.
	 * @return array
	 */
	public function block_categories( $categories ) {
		$categories[] = [
			'slug'  => 'wpayme-pay',
			'title' => \__( 'Wpayme Pay', 'wpayme' ),
			'icon'  => null,
		];

		return $categories;
	}
}
