<?php
/**
 * Action Scheduler Controller
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay
 */

namespace Wpayme\WordPress\Pay;

/**
 * Action Scheduler Controller class
 */
class ActionSchedulerController {
	/**
	 * Setup.
	 *
	 * @return void
	 */
	public function setup() {
		\add_action( 'action_scheduler_begin_execute', [ $this, 'begin_execute' ], 10, 2 );
	}

	/**
	 * Action scheduler begin execute.
	 *
	 * @link https://github.com/woocommerce/action-scheduler/blob/3.7.1/classes/abstracts/ActionScheduler_Abstract_QueueRunner.php#L84
	 * @param int    $action_id Action ID.
	 * @param string $context   Context.
	 * @return void
	 */
	public function begin_execute( $action_id, $context ) {
		if ( \defined( 'WPAYME_ACTION_SCHEDULER_CONTEXT' ) ) {
			return;
		}

		\define( 'WPAYME_ACTION_SCHEDULER_CONTEXT', $context );
	}
}
