/* global wpaymeAdminTourSettings */
jQuery(document).ready(function($) {
    // Add the "Start Tour" button to the dashboard if it doesn't exist yet
    if (typeof wpaymeAdminTourSettings !== 'undefined' && $('.start-tour').length === 0) {
        // Create the Start Tour button and add it to the dashboard
        var dashboardUrl = wpaymeAdminTourSettings.dashboardUrl || '';
        
        // Check if we're already on the dashboard page
        if (window.location.href.indexOf('page=wpayme') !== -1) {
            console.log('Wpayme Tour Settings: Current page is dashboard');
            
            // Add Start Tour button next to the page title
            var $pageTitle = $('#wpbody-content .wrap h1');
            if ($pageTitle.length > 0) {
                // Create URL with nonce for the Start tour button
                // Use force_tour instead of ignore_tour to ensure it always works
                var startTourUrl = dashboardUrl + '&wpayme_pay_force_tour=true&wpayme_pay_nonce=' + wpaymeAdminTourSettings.forceTourNonce;
                
                // Add timestamp to avoid caching
                startTourUrl += '&_ts=' + new Date().getTime();
                
                // Add the button after the title
                var $startButton = $('<a href="' + startTourUrl + '" class="page-title-action start-tour">' + 
                    wpaymeAdminTourSettings.startTourText + '</a>');
                
                // Add only the start button
                $pageTitle.append(' ').append($startButton);
                
                console.log('Wpayme Tour Settings: Added start tour button to dashboard');
            } else {
                console.log('Wpayme Tour Settings: Could not find page title to add tour button');
            }
        }
    } else {
        console.log('Wpayme Tour Settings: Either wpaymeAdminTourSettings not defined or button already exists');
    }
}); 