<?php
/**
 * WPayme PayPal Add-On
 *
 * @package           Wpayme\WordPress\Pay\Gateways\PayPal
 * @author            Wpayme <hi@wpayme.com>
 * @copyright         2021 Wpayme
 * @license           GPL-2.0-or-later
 *
 * @wordpress-plugin
 * Plugin Name: WPayme PayPal Add-On
 * Plugin URI: https://www.wpayme.com/plugins/wpayme-pay-paypal/
 * Description: Extend the WPayme plugin with the PayPal gateway to receive payments with PayPal through a variety of WordPress plugins.
 *
 * Version: 2.3.7
 * Requires at least: 4.7
 * Requires PHP: 7.4
 *
 * Author: Wpayme
 * Author URI: https://www.wpayme.com/
 *
 * Text Domain: wpayme-pay-paypal
 * Domain Path: /languages/
 *
 * License: GPL-3.0-or-later
 *
 * Requires Plugins: wpayme-ideal
 * Depends: wp-pay/core
 *
 * GitHub URI: https://github.com/wp-pay-gateways/paypal
 *
 * Update URI: https://www.wpayme.com/plugins/wpayme-pay-paypal/
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

add_filter(
	'wpayme_pay_gateways',
	function( $gateways ) {
		$gateways[] = new \Wpayme\WordPress\Pay\Gateways\PayPal\Integration(
			[
				'id'         => 'paypal',
				'name'       => 'PayPal',
				'mode'       => 'live',
				'webscr_url' => 'https://www.paypal.com/cgi-bin/webscr',
				'ipn_pb_url' => 'https://ipnpb.paypal.com/cgi-bin/webscr',
			]
		);

		$gateways[] = new \Wpayme\WordPress\Pay\Gateways\PayPal\Integration(
			[
				'id'         => 'paypal-sandbox',
				'name'       => 'PayPal - Sandbox',
				'mode'       => 'test',
				'webscr_url' => 'https://www.sandbox.paypal.com/cgi-bin/webscr',
				'ipn_pb_url' => 'https://ipnpb.sandbox.paypal.com/cgi-bin/webscr',
			]
		);

		return $gateways;
	}
);
