<?php
/**
 * Plugin Name: WPayme Gravity Forms Add-On
 * Plugin URI: https://www.wpayme.com/plugins/wpayme-pay-gravityforms/
 * Description: Extend the WPayme plugin with Gravity Forms support to receive payments through a variety of payment providers.
 *
 * Version: 4.9.0
 * Requires at least: 4.7
 * Requires PHP: 7.4
 *
 * Author: Wpayme
 * Author URI: https://www.wpayme.com/
 *
 * Text Domain: wpayme-pay-gravity-forms
 * Domain Path: /languages/
 *
 * License: GPL-3.0-or-later
 *
 * Depends: wp-pay/core
 *
 * GitHub URI: https://github.com/wpayme/wp-wpayme-pay-gravityforms
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay\Extensions\GravityForms
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Autoload.
 */
require_once __DIR__ . '/vendor/autoload_packages.php';

/**
 * Bootstrap.
 */
\Wpayme\WordPress\Pay\Plugin::instance(
	[
		'file'             => __FILE__,
		'action_scheduler' => __DIR__ . '/packages/woocommerce/action-scheduler/action-scheduler.php',
	]
);

add_filter(
	'wpayme_pay_plugin_integrations',
	function ( $integrations ) {
		foreach ( $integrations as $integration ) {
			if ( $integration instanceof \Wpayme\WordPress\Pay\Extensions\GravityForms\Extension ) {
				return $integrations;
			}
		}

		$integrations[] = new \Wpayme\WordPress\Pay\Extensions\GravityForms\Extension();

		return $integrations;
	}
);
