<?php
// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Admin feed Gravity Forms box.
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay\Extensions\GravityForms
 */

// Check user permissions.
if ( ! current_user_can( 'gravityforms_edit_forms' ) ) {
	return;
}

?>
<form method="post" action="">
	<?php

	// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Reading GET parameter for display purposes only (showing success/error message), not processing form data. Value is sanitized and only used for display.
	$message = array_key_exists( 'message', $_GET ) ? filter_var( wp_unslash( $_GET['message'] ), \FILTER_SANITIZE_NUMBER_INT ) : null;

	if ( null !== $message ) {
		// Notice.
		$msg   = __( 'There was an error updating this payment feed.', 'wpayme' );
		$class = 'error';

		if ( '1' === $message ) {
			$class = 'updated';
			$msg   = __( 'Payment feed updated successfully.', 'wpayme' );
		}

		printf(
			'<div class="%s below-h2"><p>%s</p></div>',
			esc_attr( $class ),
			esc_html( $msg )
		);
	}

	?>

	<div id="titlediv">
		<div id="titlewrap">
			<?php

			$title = empty( $post_id ) ? '' : get_the_title( $post_id );

			$title_placeholder = __( 'Enter title here', 'wpayme' );

			?>

			<label class="screen-reader-text" id="title-prompt-text" for="title">
				<?php echo esc_html( $title_placeholder ); ?>
			</label>

			<input type="text" name="_wpayme_pay_gf_post_title" size="30" value="<?php echo esc_attr( $title ); ?>" id="title" spellcheck="true" autocomplete="off" placeholder="<?php echo esc_attr( $title_placeholder ); ?>" />
		</div>
	</div>

	<?php require __DIR__ . '/html-admin-feed-settings.php'; ?>

	<?php submit_button(); ?>
</form>
