<?php
/**
 * Payment form post type
 *
 * @author    Wpayme <hi@wpayme.com>
 * @copyright 2024-2025 Wpayme
 * @license   GPL-3.0-or-later
 * @package   Wpayme\WordPress\Pay\Extensions\GravityForms
 */

namespace Wpayme\WordPress\Pay\Extensions\GravityForms;

/**
 * Title: WordPress payment form post type
 * Description:
 * Copyright: 2024-2025 Wpayme
 * Company: Wpayme
 *
 * @author  Remco Tolsma
 * @version 2.1.2
 * @since   1.1.0
 */
class PaymentFormPostType {
	/**
	 * Construct and initialize payment form post type
	 */
	public function __construct() {
		/**
		 * Priority of the initial post types function should be set to < 10.
		 *
		 * @link https://core.trac.wordpress.org/ticket/28488
		 * @link https://core.trac.wordpress.org/changeset/29318
		 *
		 * @link https://github.com/WordPress/WordPress/blob/4.0/wp-includes/post.php#L167
		 */
		add_action( 'init', [ $this, 'init' ], 0 ); // Highest priority.
	}

	/**
	 * Initialize.
	 *
	 * @return void
	 */
	public function init() {
		register_post_type(
			'wpayme_pay_gf',
			[
				'label'              => __( 'Payment Feeds', 'wpayme' ),
				'labels'             => [
					'name'                  => __( 'Payment Feeds', 'wpayme' ),
					'singular_name'         => __( 'Payment Feed', 'wpayme' ),
					'add_new'               => __( 'Add New', 'wpayme' ),
					'add_new_item'          => __( 'Add New Payment Feed', 'wpayme' ),
					'edit_item'             => __( 'Edit Payment Feed', 'wpayme' ),
					'new_item'              => __( 'New Payment Feed', 'wpayme' ),
					'all_items'             => __( 'All Payment Feeds', 'wpayme' ),
					'view_item'             => __( 'View Payment Feed', 'wpayme' ),
					'search_items'          => __( 'Search Payment Feeds', 'wpayme' ),
					'not_found'             => __( 'No payment feeds found.', 'wpayme' ),
					'not_found_in_trash'    => __( 'No payment feeds found in Trash.', 'wpayme' ),
					'menu_name'             => __( 'Payment Feeds', 'wpayme' ),
					'filter_items_list'     => __( 'Filter payment feeds list', 'wpayme' ),
					'items_list_navigation' => __( 'Payment feeds list navigation', 'wpayme' ),
					'items_list'            => __( 'Payment feeds list', 'wpayme' ),
				],
				'public'             => false,
				'publicly_queryable' => false,
				'show_ui'            => false,
				'show_in_nav_menus'  => false,
				'show_in_menu'       => false,
				'show_in_admin_bar'  => false,
				'supports'           => [ 'title', 'revisions' ],
				'rewrite'            => false,
				'query_var'          => false,
			]
		);
	}
}
