<?php if ( ! defined( 'ABSPATH' ) ) exit;  ?>
<div class="wrap wpaigen-generate-page">
  <h1 class="wp-heading-inline"><?php echo esc_html( get_admin_page_title() ); ?></h1>

  <div class="wpaigen-header">
    <div class="wpaigen-logo">Generate Article</div>
    <p>Effortlessly create content with AI assistance.</p>
  </div>

  <div class="wpaigen-grid-2-col">
    <div class="wpaigen-card">
      <h2>Article Generation</h2>
      <form id="wpaigen-generate-form">
        <div class="wpaigen-form-group">
          <label for="wpaigen-keyword">Keyword:</label>
          <input type="text" id="wpaigen-keyword" name="keyword" placeholder="e.g., Kopi Indonesia, Pola Hidup Sehat"
            required>
        </div>

        <div class="wpaigen-form-group">
          <label for="wpaigen-language">Language:</label>
          <select id="wpaigen-language" name="language">
            <option value="indonesian">Indonesia</option>
            <option value="english">English</option>
            <option value="spanish" class="pro-feature" disabled>Spanish (Pro)</option>
            <option value="french" class="pro-feature" disabled>French (Pro)</option>
            <option value="german" class="pro-feature" disabled>German (Pro)</option>
            <option value="mandarin" class="pro-feature" disabled>Mandarin Chinese (Pro)</option>
            <option value="arabic" class="pro-feature" disabled>Arabic (Pro)</option>
            <option value="portuguese" class="pro-feature" disabled>Portuguese (Pro)</option>
            <option value="russian" class="pro-feature" disabled>Russian (Pro)</option>
            <option value="japanese" class="pro-feature" disabled>Japanese (Pro)</option>
            <option value="korean" class="pro-feature" disabled>Korean (Pro)</option>
            <option value="javanese" class="pro-feature" disabled>Javanese (Pro)</option>
          </select>
          <span
            class="pro-info language-info <?php echo ( get_option( 'wpaigen_license_type', 'free' ) === 'free' ) ? '' : 'wpaigen-hidden'; ?>">
            <span class="dashicons dashicons-lock"></span> Upgrade to Pro for more languages.
          </span>
        </div>

        <div class="wpaigen-form-group">
          <label for="wpaigen-length">Word Count:</label>
          <input type="number" id="wpaigen-length" name="length" min="50" max="200" value="200" required>
          <span
            class="pro-info length-info <?php echo ( get_option( 'wpaigen_license_type', 'free' ) === 'free' ) ? '' : 'wpaigen-hidden'; ?>">
            Max 200 words for Free version. <br> <span class="dashicons dashicons-lock"></span> Upgrade to Pro for
            unlimited.
          </span>
        </div>

        <div class="wpaigen-form-group">
          <label for="wpaigen-tone">Writing Style:</label>
          <select id="wpaigen-tone" name="tone">
            <option value="professional">Professional</option>
            <option value="casual" class="pro-feature" disabled>Casual (Pro)</option>
            <option value="seo" class="pro-feature" disabled>SEO-Optimized (Pro)</option>
            <option value="persuasive" class="pro-feature" disabled>Persuasive (Pro)</option>
            <option value="narrative" class="pro-feature" disabled>Narrative (Pro)</option>
            <option value="news" class="pro-feature" disabled>News (Pro)</option>
          </select>
          <span
            class="pro-info tone-info <?php echo ( get_option( 'wpaigen_license_type', 'free' ) === 'free' ) ? '' : 'wpaigen-hidden'; ?>">
            <span class="dashicons dashicons-lock"></span> Unlock more styles in Pro.
          </span>
        </div>

        <div class="wpaigen-form-group checkbox-group">
          <input type="checkbox" id="wpaigen-use-featured-image" name="use_featured_image" checked>
          <label for="wpaigen-use-featured-image">Include Featured Image</label>
        </div>

        <div class="wpaigen-form-actions">
          <button type="submit" id="wpaigen-generate-btn" class="button button-primary wpaigen-button">Generate
            Article</button>
          <button type="button" id="wpaigen-schedule-btn" class="button button-secondary wpaigen-button">
            <span class="dashicons dashicons-clock"></span> Schedule
          </button>
        </div>
        <div id="wpaigen-generate-message" class="wpaigen-message"></div>
      </form>
    </div>

    <div class="wpaigen-sidebar">
      <div class="wpaigen-card wpaigen-trends-card">
        <div class="wpaigen-trends-header">
          <h2 class="wpaigen-trends-title">
            <span class="dashicons dashicons-chart-line"></span>
            Trending Keywords
          </h2>
          <button type="button" class="wpaigen-refresh-btn">
            <span class="dashicons dashicons-update"></span>
            Refresh
          </button>
        </div>
        <div class="wpaigen-keywords-list">
          <!-- Keywords will be loaded here via JavaScript -->
        </div>
      </div>

      <div class="wpaigen-card wpaigen-tips-card">
        <h2>Pro-Tips for Optimal Content</h2>
        <ul>
          <li>
            <span class="dashicons dashicons-lightbulb"></span>
            <strong>Keyword Selection:</strong> Choose relevant and specific keywords to maximize SEO impact.
          </li>
          <li>
            <span class="dashicons dashicons-groups"></span>
            <strong>Target Audience:</strong> Tailor your writing style to resonate with your target readers for better
            engagement.
          </li>
          <li>
            <span class="dashicons dashicons-edit"></span>
            <strong>Writing Style:</strong> Experiment with different tones to find a unique voice for your brand.
          </li>
        </ul>
      </div>

      <div
        class="wpaigen-card wpaigen-cta-card <?php echo ( get_option( 'wpaigen_license_type', 'free' ) === 'pro' ) ? 'wpaigen-hidden' : ''; ?>">
        <h2>🚀 Boost Your Content Strategy!</h2>
        <p>Upgrade to WPaigen Pro for unlimited access to advanced features and unleash your full content creation
          potential.</p>
        <a href="<?php echo esc_url( admin_url( 'admin.php?page=wpaigen' ) ); ?>"
          class="button button-secondary wpaigen-button">Upgrade to Pro</a>
      </div>
    </div>
  </div>

  <div id="wpaigen-loading-overlay" class="wpaigen-loading-overlay">
    <div class="wpaigen-loading-spinner">
      <div class="spinner-border"></div>
      <p id="wpaigen-loading-text">Generating Article...</p>
    </div>
  </div>

  <!-- Schedule Modal -->
  <div id="wpaigen-schedule-modal" class="wpaigen-modal" style="display: none;">
    <div class="wpaigen-modal-content wpaigen-schedule-modal-content">
      <div class="wpaigen-modal-header">
        <h3>Schedule Article</h3>
        <button type="button" class="wpaigen-modal-close" id="wpaigen-close-schedule-modal">
          <span class="dashicons dashicons-no-alt"></span>
        </button>
      </div>
      <div class="wpaigen-modal-body">
        <form id="wpaigen-schedule-form">
          <div class="wpaigen-form-group">
            <label for="wpaigen-schedule-timezone">Timezone:</label>
            <select id="wpaigen-schedule-timezone" name="timezone">
              <option value="UTC">UTC (Universal Time)</option>
              <option value="Asia/Jakarta">Asia/Jakarta (UTC+7)</option>
              <option value="America/New_York">America/New_York (UTC-5)</option>
              <option value="America/Los_Angeles">America/Los_Angeles (UTC-8)</option>
              <option value="Europe/London">Europe/London (UTC+0)</option>
              <option value="Europe/Paris">Europe/Paris (UTC+1)</option>
              <option value="Australia/Sydney">Australia/Sydney (UTC+10)</option>
              <option value="Asia/Singapore">Asia/Singapore (UTC+8)</option>
              <option value="Asia/Tokyo">Asia/Tokyo (UTC+9)</option>
              <option value="America/Chicago">America/Chicago (UTC-6)</option>
            </select>
            <small>Schedule times will use this timezone. Your browser timezone: <strong id="browser-timezone">Detecting...</strong></small>
          </div>

          <div class="wpaigen-form-group">
            <label for="wpaigen-schedule-date">Schedule Date & Time:</label>
            <input type="datetime-local" id="wpaigen-schedule-date" name="scheduled_date" required>
            <p class="description">Select when this article should be published in your selected timezone.</p>
          </div>

          <div class="wpaigen-form-group">
            <h4>Article Preview</h4>
            <div class="wpaigen-schedule-preview">
              <div class="preview-item">
                <strong>Keyword:</strong> <span id="preview-keyword"></span>
              </div>
              <div class="preview-item">
                <strong>Language:</strong> <span id="preview-language"></span>
              </div>
              <div class="preview-item">
                <strong>Word Count:</strong> <span id="preview-length"></span>
              </div>
              <div class="preview-item">
                <strong>Tone:</strong> <span id="preview-tone"></span>
              </div>
              <div class="preview-item">
                <strong>Featured Image:</strong> <span id="preview-featured-image"></span>
              </div>
            </div>
          </div>

          <div class="wpaigen-form-actions">
            <button type="button" class="button" id="wpaigen-cancel-schedule">Cancel</button>
            <button type="submit" id="wpaigen-confirm-schedule" class="button button-primary">Schedule Article</button>
          </div>
        </form>
        <div id="wpaigen-schedule-message" class="wpaigen-message"></div>
      </div>
    </div>
  </div>

</div>