<?php
/*
 * Plugin Name: WP Social Followers Count
 * Version: 1.0.0
 * Plugin URI: http://plugins.jeweltheme.com
 * Description: WP Social Follower will show your Facebook Page Likes, Twitter Followers, Google Plus Circles, Subscribers, Youtube Subscribers, Dribbble Followers. Nicely hand crafted designed by <a href="https://jeweltheme.com" target="_blank">Jewel Theme</a>. Easy to use WP Social Follower Plugin.
 * Author: Liton Arefin
 * Author URI: https://jeweltheme.com
 * Text Domain: wp-social-follower
 * License: GNU/GPL http://www.gnu.org/copyleft/gpl.html
 */

if ( ! defined('ABSPATH')) exit;  // if direct access 
	require_once(ABSPATH.'wp-admin/includes/plugin.php');

add_action('wp_enqueue_scripts','wp_social_followers');

function wp_social_followers(){
  	wp_enqueue_style( 'wp-social-follower-style', plugin_dir_url( __FILE__ ) . 'style.css');
  	wp_enqueue_style( 'font-awesome.min', plugin_dir_url( __FILE__ ) . 'font-awesome.min.css');
}

function wp_social_followers_number_shorten($n) {
	    // first strip any formatting;
	    $n = (0+str_replace(",","",$n));
	    
	    // is this a number?
	    if(!is_numeric($n)) return false;
	    
	    // now filter it;
	    if($n>1000000000000) return round(($n/1000000000000),1).'T';
	    else if($n>1000000000) return round(($n/1000000000),1).'B';
	    else if($n>1000000) return round(($n/1000000),1).'M';
	    else if($n>1000) return round(($n/1000),1).'K';
	    
	    return number_format($n);
	}
class WP_Social_Followers extends WP_Widget{
	
	// public $id = 'facebook';
	protected $api_url = 'https://graph.facebook.com';

	public function __construct(){
		parent::__construct(
			'wp_social_authors', 
			'&#x1F536; ' . esc_html__( 'WP Social Follower', 'wp-social-follower' ), // Name
			array( 'description' => esc_html__( 'Shows Social Followers Counter.', 'wp-social-follower' ), ) // Args
			);
	}

	public function form( $instance ){
		$form_args = array(

				// Widget Title
				'title'							=> '',

				// Facebook
				'facebook_page_url'				=> '',
				'facebook_app_id'				=> '',
				'facebook_access_token'			=> '',
				'facebook_text'					=> '',

				// Twitter
				'twitter_id'					=> '',
				'twitter_comsumer_key'			=> '',
				'twitter_comsumer_secret'		=> '',
				'twitter_access_token'			=> '',
				'twitter_access_token_secret'	=> '',
				'twitter_text'					=> '',

				// Google Plus
				'googleplus_id'					=> '',
				'googleplus_text'				=> '',

				// Youtube
				'youtube_id'					=> '',
				'youtube_channel'				=> '',
				'youtube_app_key'				=> '',
				'youtube_text'					=> '',
				
				// Dribbble Socials
				'dribbble'						=> '',
				'dribbble_access_token'			=> '',
				'dribbble_text'					=> ''
			);

		$instance 	= wp_parse_args( (array) $instance, $form_args );

		$title 							= htmlspecialchars($instance['title']);	
		
		$facebook_page_url 				= htmlspecialchars($instance['facebook_page_url']);	
		$facebook_app_id 				= htmlspecialchars($instance['facebook_app_id']);	
		$facebook_access_token 			= htmlspecialchars($instance['facebook_access_token']);	
		$facebook_text 					= htmlspecialchars($instance['facebook_text']);	

		$twitter_id 					= htmlspecialchars($instance['twitter_id']);	
		$twitter_comsumer_key 			= htmlspecialchars($instance['twitter_comsumer_key']);	
		$twitter_comsumer_secret 		= htmlspecialchars($instance['twitter_comsumer_secret']);	
		$twitter_access_token 			= htmlspecialchars($instance['twitter_access_token']);	
		$twitter_access_token_secret 	= htmlspecialchars($instance['twitter_access_token_secret']);	
		$twitter_text 					= htmlspecialchars($instance['twitter_text']);	

		$googleplus_id 					= htmlspecialchars($instance['googleplus_id']);	
		$googleplus_text 				= htmlspecialchars($instance['googleplus_text']);	
		
		$youtube_id 					= htmlspecialchars($instance['youtube_id']);	
		$youtube_channel 				= htmlspecialchars($instance['youtube_channel']);	
		$youtube_app_key 				= htmlspecialchars($instance['youtube_app_key']);	
		$youtube_text 					= htmlspecialchars($instance['youtube_text']);	

		$dribbble 						= htmlspecialchars($instance['dribbble']);	
		$dribbble_access_token 			= htmlspecialchars($instance['dribbble_access_token']);	
		$dribbble_text 					= htmlspecialchars($instance['dribbble_text']);	

	?>



		<div class='wp-social-followers-count'>
			<p>
				<label for="<?php echo $this->get_field_name( 'title' ); ?>"><?php echo esc_html__( "Title:", "wp-social-follower" );?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_name( 'facebook_page_url' ); ?>"><?php echo esc_html__( "Facebook Page Url:", "wp-social-follower" );?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'facebook_page_url' ); ?>" name="<?php echo $this->get_field_name( 'facebook_page_url' ); ?>" type="text" value="<?php echo esc_attr( $facebook_page_url ); ?>" />
				<span style="font-size:10px; font-style: italic;"><?php echo esc_html__("Example: https://www.facebook.com/jwthemeltd", "wp-social-follower");?></span>
			</p>
			<p>
				<label for="<?php echo $this->get_field_name( 'facebook_app_id' ); ?>"><?php echo esc_html__( "Facebook App ID:", "wp-social-follower" );?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'facebook_app_id' ); ?>" name="<?php echo $this->get_field_name( 'facebook_app_id' ); ?>" type="text" value="<?php echo esc_attr( $facebook_app_id ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_name( 'facebook_access_token' ); ?>"><?php echo esc_html__( "Facebook Access Token:", "wp-social-follower" );?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'facebook_access_token' ); ?>" name="<?php echo $this->get_field_name( 'facebook_access_token' ); ?>" type="text" value="<?php echo esc_attr( $facebook_access_token ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_name( 'facebook_text' ); ?>"><?php echo esc_html__( "Facebook Like Text:", "wp-social-follower" );?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'facebook_text' ); ?>" name="<?php echo $this->get_field_name( 'facebook_text' ); ?>" type="text" value="<?php echo esc_attr( $facebook_text ); ?>" />
			</p>	
			<p>
				<label for="<?php echo $this->get_field_name( 'twitter_id' ); ?>"><?php echo esc_html__( "Twitter ID:", "wp-social-follower" );?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'twitter_id' ); ?>" name="<?php echo $this->get_field_name( 'twitter_id' ); ?>" type="text" value="<?php echo esc_attr( $twitter_id ); ?>" />
				<span style="font-size:10px; font-style: italic;"><?php echo esc_html__("Example: jwthemeltd", "wp-social-follower");?></span>
			</p>
			<p>
				<label for="<?php echo $this->get_field_name( 'twitter_comsumer_key' ); ?>"><?php echo esc_html__( "Twitter Consumer Key:", "wp-social-follower" );?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'twitter_comsumer_key' ); ?>" name="<?php echo $this->get_field_name( 'twitter_comsumer_key' ); ?>" type="text" value="<?php echo esc_attr( $twitter_comsumer_key ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_name( 'twitter_comsumer_secret' ); ?>"><?php echo esc_html__( "Twitter Consumer Secret:", "wp-social-follower" );?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'twitter_comsumer_secret' ); ?>" name="<?php echo $this->get_field_name( 'twitter_comsumer_secret' ); ?>" type="text" value="<?php echo esc_attr( $twitter_comsumer_secret ); ?>" />
			</p>			
			<p>
				<label for="<?php echo $this->get_field_name( 'twitter_access_token' ); ?>"><?php echo esc_html__( "Twitter Access Token:", "wp-social-follower" );?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'twitter_access_token' ); ?>" name="<?php echo $this->get_field_name( 'twitter_access_token' ); ?>" type="text" value="<?php echo esc_attr( $twitter_access_token ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_name( 'twitter_access_token_secret' ); ?>"><?php echo esc_html__( "Twitter Access Token Secret:", "wp-social-follower" );?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'twitter_access_token_secret' ); ?>" name="<?php echo $this->get_field_name( 'twitter_access_token_secret' ); ?>" type="text" value="<?php echo esc_attr( $twitter_access_token_secret ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_name( 'twitter_text' ); ?>"><?php echo esc_html__( "Twitter Text:", "wp-social-follower" );?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'twitter_text' ); ?>" name="<?php echo $this->get_field_name( 'twitter_text' ); ?>" type="text" value="<?php echo esc_attr( $twitter_text ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_name( 'googleplus_id' ); ?>"><?php echo esc_html__( "Google Plus ID:", "wp-social-follower" );?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'googleplus_id' ); ?>" name="<?php echo $this->get_field_name( 'googleplus_id' ); ?>" type="text" value="<?php echo esc_attr( $googleplus_id ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_name( 'googleplus_text' ); ?>"><?php echo esc_html__( "Google Plus Text:", "wp-social-follower" );?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'googleplus_text' ); ?>" name="<?php echo $this->get_field_name( 'googleplus_text' ); ?>" type="text" value="<?php echo esc_attr( $googleplus_text ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_name( 'youtube_id' ); ?>"><?php echo esc_html__( "Youtube ID:", "wp-social-follower" );?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'youtube_id' ); ?>" name="<?php echo $this->get_field_name( 'youtube_id' ); ?>" type="text" value="<?php echo esc_attr( $youtube_id ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_name( 'youtube_channel' ); ?>"><?php echo esc_html__( "Youtube Channel ID:", "wp-social-follower" );?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'youtube_channel' ); ?>" name="<?php echo $this->get_field_name( 'youtube_channel' ); ?>" type="text" value="<?php echo esc_attr( $youtube_channel ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_name( 'youtube_app_key' ); ?>"><?php echo esc_html__( "Youtube API Key:", "wp-social-follower" );?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'youtube_app_key' ); ?>" name="<?php echo $this->get_field_name( 'youtube_app_key' ); ?>" type="text" value="<?php echo esc_attr( $youtube_app_key ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_name( 'youtube_text' ); ?>"><?php echo esc_html__( "Youtube Text:", "wp-social-follower" );?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'youtube_text' ); ?>" name="<?php echo $this->get_field_name( 'youtube_text' ); ?>" type="text" value="<?php echo esc_attr( $youtube_text ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_name( 'dribbble' ); ?>"><?php echo esc_html__( "Dribbble:", "wp-social-follower" );?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'dribbble' ); ?>" name="<?php echo $this->get_field_name( 'dribbble' ); ?>" type="text" value="<?php echo esc_attr( $dribbble ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_name( 'dribbble_access_token' ); ?>"><?php echo esc_html__( "Dribbble Access Token:", "wp-social-follower" );?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'dribbble_access_token' ); ?>" name="<?php echo $this->get_field_name( 'dribbble_access_token' ); ?>" type="text" value="<?php echo esc_attr( $dribbble_access_token ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_name( 'dribbble_text' ); ?>"><?php echo esc_html__( "Dribbble Text:", "wp-social-follower" );?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'dribbble_text' ); ?>" name="<?php echo $this->get_field_name( 'dribbble_text' ); ?>" type="text" value="<?php echo esc_attr( $dribbble_text ); ?>" />
			</p>
		</div>

	<?php }



	

	public function widget($args, $instance){
		extract( $args );		

		// Facebook Options
		$facebook_page_url		= isset( $instance['facebook_page_url']) ? $instance['facebook_page_url']:"" ;
		$facebook_app_id 		= isset( $instance['facebook_app_id'] ) ? $instance['facebook_app_id'] : "";
		$facebook_access_token 	= isset( $instance['facebook_access_token'] ) ? $instance['facebook_access_token'] : "";
		$facebook_text			= isset( $instance['facebook_text'] ) ? $instance['facebook_text'] : "";

		// Twitter Options
		$twitter_id 					= isset( $instance['twitter_id'] ) ? $instance['twitter_id'] : "";
		$twitter_comsumer_key 			= isset( $instance['twitter_comsumer_key'] ) ? $instance['twitter_comsumer_key'] : "";
		$twitter_comsumer_secret 		= isset( $instance['twitter_comsumer_secret'] )? $instance['twitter_comsumer_secret'] : "";
		$twitter_access_token 			= isset( $instance['twitter_access_token'] ) ? $instance['twitter_access_token'] : "";
		$twitter_access_token_secret	= isset( $instance['twitter_access_token_secret'] ) ? $instance['twitter_access_token_secret'] : "";
		$twitter_text					= isset( $instance['twitter_text'] ) ? $instance['twitter_text'] : "";


		$googleplus_id 			= isset( $instance['googleplus_id'] ) ? $instance['googleplus_id'] : "";
		$googleplus_text		= isset( $instance['googleplus_text'] ) ? $instance['googleplus_text'] : "";

		$youtube_id 			= isset( $instance['youtube_id'] ) ? $instance['youtube_id'] : "";
		$youtube_channel 		= isset( $instance['youtube_channel'] ) ? $instance['youtube_channel'] : "";
		$youtube_app_key 		= isset( $instance['youtube_app_key'] ) ? $instance['youtube_app_key'] : "";
		$youtube_text			= isset( $instance['youtube_text'] ) ? $instance['youtube_text'] : "";

		$dribbble 				= isset( $instance['dribbble'] ) ? $instance['dribbble'] : "";
		$dribbble_access_token 	= isset( $instance['dribbble_access_token'] ) ? $instance['dribbble_access_token'] : "";
		$dribbble_text			= isset( $instance['dribbble_text'] ) ? $instance['dribbble_text'] : "";

		
		$title = apply_filters('widget_title', empty($instance['title']) ? esc_html__( 'Stay Connected', 'wp-social-follower' ) : $instance['title'], $instance, $this->id_base);
		
		echo $before_widget;

		echo '<h3 class="widget-title">' . esc_attr( $title ) . '</h3>';
	?>

		<div class="widget-details widget_social">
			<ul>
				<?php if(function_exists('curl_init') && !empty($facebook_page_url)){ ?> 					
					
					<li>
						<a class="facebook" href="<?php echo esc_url_raw( $facebook_page_url );?>" target="_blank">
							<i class="fa fa-facebook"></i>
							<span class="count"><?php echo wp_social_followers_number_shorten( $this->wp_social_followers_facebook_like_count($facebook_app_id, $facebook_access_token, $facebook_page_url) ); ?></span> <?php echo esc_attr( $facebook_text );?>
						</a>
					</li>

				<?php } if( !empty( $twitter_id ) ){ ?>
					
					<li>
						<a class="twitter" href="https://twitter.com/<?php echo esc_attr( $twitter_id );?>" target="_blank">
							<i class="fa fa-twitter"></i>
							<span class="count"><?php echo wp_social_followers_number_shorten( $this->wp_social_follower_tweet_count($twitter_id, $twitter_comsumer_key, $twitter_comsumer_secret, $twitter_access_token, $twitter_access_token_secret) ); ?></span> 
							<?php echo esc_attr( $twitter_text );?>
						</a>
					</li>					

				<?php } if( !empty( $googleplus_id )){ ?>
					
					<li>
						<a class="googleplus" href="https://plus.google.com/<?php echo esc_attr( $googleplus_id );?>" target="_blank">
							<i class="fa google-plus"></i>
							<span class="count"><?php echo wp_social_followers_number_shorten( $this->wp_social_follower_google_plus_count( $googleplus_id ) ); ?></span> 
							<?php echo esc_attr( $googleplus_text );?>
						</a>
					</li>

				<?php } if( !empty( $youtube_id ) && !empty( $youtube_channel ) ){ ?>
					
					<li>
						<a class="youtube" href="https://youtube.com/<?php echo esc_attr( $youtube_id );?>" target="_blank">
							<i class="fa fa-youtube"></i>
							<span class="count"><?php echo wp_social_followers_number_shorten( $this->wp_social_follower_youtube_subscribers( $youtube_id, $youtube_channel,  $youtube_app_key ) ); ?></span> 
							<?php echo esc_attr( $youtube_text );?>
						</a>
					</li>

				<?php } if( !empty( $dribbble )){ ?>
					
					<li>
						<a class="dribbble" href="https://dribbble.com/<?php echo esc_attr( $dribbble );?>" target="_blank">
							<i class="fa fa-dribbble"></i>
							<span class="count"><?php echo wp_social_followers_number_shorten( $this->wp_social_follower_dribbble_followers( $dribbble, $dribbble_access_token ) ); ?></span> 
							<?php echo esc_attr( $dribbble_text );?>
						</a>
					</li>

				<?php } ?>

			</ul>
		</div><!-- /.widget-details -->

	<?php 
		echo $args['after_widget'];
	}


	public function update( $new_instance, $old_instance ){

		$instance = $old_instance;
		
		$instance['title']	= strip_tags(stripcslashes($new_instance['title']));

		$instance['facebook_page_url']	= strip_tags(stripcslashes($new_instance['facebook_page_url']));
		$instance['facebook_app_id']	= strip_tags(stripcslashes($new_instance['facebook_app_id']));
		$instance['facebook_access_token']	= strip_tags(stripcslashes($new_instance['facebook_access_token']));
		$instance['facebook_text']	= strip_tags(stripcslashes($new_instance['facebook_text']));


		$instance['twitter_id']	= $new_instance['twitter_id'];
		$instance['twitter_comsumer_key']	= $new_instance['twitter_comsumer_key'];
		$instance['twitter_comsumer_secret']	= $new_instance['twitter_comsumer_secret'];
		$instance['twitter_access_token']	= $new_instance['twitter_access_token'];
		$instance['twitter_access_token_secret']	= $new_instance['twitter_access_token_secret'];
		$instance['twitter_text']	= strip_tags(stripcslashes($new_instance['twitter_text']));
		

		$instance['googleplus_id']	= strip_tags(stripcslashes($new_instance['googleplus_id']));
		$instance['googleplus_text']	= strip_tags(stripcslashes($new_instance['googleplus_text']));


		$instance['youtube_id']	= strip_tags(stripcslashes($new_instance['youtube_id']));
		$instance['youtube_channel']	= strip_tags(stripcslashes($new_instance['youtube_channel']));
		$instance['youtube_app_key']	= strip_tags(stripcslashes($new_instance['youtube_app_key']));
		$instance['youtube_text']	= strip_tags(stripcslashes($new_instance['youtube_text']));

		
		$instance['dribbble']	= strip_tags(stripcslashes($new_instance['dribbble']));
		$instance['dribbble_access_token']	= strip_tags(stripcslashes($new_instance['dribbble_access_token']));
		$instance['dribbble_text']	= strip_tags(stripcslashes($new_instance['dribbble_text']));

		return $instance;


	}


	// Social Count Functions


	public function wp_social_followers_get_access_token( $facebook_app_id, $facebook_access_token ) {
		$url = sprintf(
			'%s/oauth/access_token?client_id=%s&client_secret=%s&grant_type=client_credentials',
			$this->api_url,
			$facebook_app_id,
			$facebook_access_token 
			);
		$access_token = wp_remote_get( $url, array( 'timeout' => 60 ) );

		if ( is_wp_error( $access_token ) || ( isset( $access_token['response']['code'] ) && 200 != $access_token['response']['code'] ) ) {
			return '';
		} else {
			$access_token = json_decode( $access_token['body'], true );
			return sanitize_text_field( $access_token['access_token'] );
		}
	}



	public function wp_social_followers_facebook_like_count( $facebook_app_id, $facebook_access_token, $facebook_page_url ) {
		
		$access_token = $this->wp_social_followers_get_access_token( $facebook_app_id, $facebook_access_token );
		$url = sprintf(
			'%s%s?fields=fan_count&access_token=%s',
			'https://graph.facebook.com' . '/v2.7/',
			sanitize_text_field( $facebook_page_url ),
			$access_token
			);

		$connection = wp_remote_get( $url, array( 'timeout' => 60 ) );

		if ( is_wp_error( $connection ) || ( isset( $connection['response']['code'] ) && 200 != $connection['response']['code'] ) ) {
			$total = ( isset( $cache[ $this->id ] ) ) ? $cache[ $this->id ] : 0;
		} else {
			$_data = json_decode( $connection['body'], true );

			if ( isset( $_data['fan_count'] ) ) {
				$count = intval( $_data['fan_count'] );

				$total = $count;
			} else {
				$total = ( isset( $cache[ $this->id ] ) ) ? $cache[ $this->id ] : 0;
			}
		}	

		return $total;
	}



	public function wp_social_follower_tweet_count($twitter_id, $consumer_key, $consumer_secret, $access_token, $access_token_secret ){
		$twitter_id 			= 	$twitter_id;		
		$consumer_key 			= 	$consumer_key;
		$consumer_secret 		= 	$consumer_secret;
		$access_token 			= 	$access_token;
		$access_token_secret 	= 	$access_token_secret;


		if($twitter_id && $consumer_key && $consumer_secret && $access_token && $access_token_secret) { 

			// some variables
		    $consumerKey 		= 	$consumer_key;
		    $consumerSecret 	= 	$consumer_secret;
		    $token 				= 	get_option('cfTwitterToken');    
 
    		// cache version does not exist or expired
  
        	// getting new auth bearer only if we don't have one
        	if(!$token) {
	            // preparing credentials
	            $credentials 	= 	$consumerKey . ':' . $consumerSecret;
	            $toSend 		= 	base64_encode($credentials);
	 
	            // http post arguments
	            $args = array(
			                'method' 		=> 'POST',
			                'httpversion' 	=> '1.1',
			                'blocking' 		=> true,
			                'headers' 		=> array(
							                    'Authorization' => 'Basic ' . $toSend,
							                    'Content-Type' => 'application/x-www-form-urlencoded;charset=UTF-8'
								                ),
	                		'body' 			=> array( 'grant_type' => 'client_credentials' )
	            		);
	 
	            add_filter('https_ssl_verify', '__return_false');

	            $response 	= 	wp_remote_post('https://api.twitter.com/oauth2/token', $args);
	 
	            $keys 		= 	json_decode(wp_remote_retrieve_body($response));
	 
	            if( $keys ) {
	                // saving token to wp_options table
	                update_option('cfTwitterToken', $keys->access_token);
	                $token 	= 	$keys->access_token;
	            }
        	}
	        // we have bearer token wether we obtained it from API or from options
	        $args = array(
			            'httpversion' 	=> '1.1',
			            'blocking' 		=> true,
			            'headers' 		=> array(
								            'Authorization' => "Bearer $token"
								           )
	        		);
 
	        add_filter('https_ssl_verify', '__return_false');

	        $api_url 	= 	"https://api.twitter.com/1.1/users/show.json?screen_name=$twitter_id";

	        $response 	= 	wp_remote_get($api_url, $args);


 
	        if (!is_wp_error($response)) {

	            $followers 			= 	json_decode(wp_remote_retrieve_body($response));

	            $numberOfFollowers 	= 	$followers->followers_count;

	        } else {
	            // get old value and break
	            $numberOfFollowers 	= 	get_option('cfNumberOfFollowers');
	           
	            // uncomment below to debug
	            //die($response->get_error_message());
	        }
 
        	// cache for an hour

    		return $numberOfFollowers;
		}
	}


	public function wp_social_follower_google_plus_count($id) {

		$link 	= 	"https://plus.google.com/".$id."/posts";

		$page 	= 	file_get_contents($link);

		if (preg_match_all('/>([0-9,]+) people</i', $page, $matches)) {			

			return str_replace(',', '', $matches[1][1]);

		} 
	}


	public function wp_social_follower_youtube_subscribers( $uname, $channel, $api_key ) { 

		$id 		= $channel;
		$key 		= $api_key;
		$url 		= "https://www.googleapis.com/youtube/v3/channels?part=statistics&id=".$id."&key=".$key;

		$connection = wp_remote_get( $url, array( 'timeout' => 60 ) );
		
		if ( is_wp_error( $connection ) || 400 <= $connection['response']['code'] ) {

				$total = 0;

			} else {

				$_data = json_decode( $connection['body'], true );
				

				if ( isset( $_data['items'][0]['statistics']['subscriberCount'] ) ) {
					$count = intval( $_data['items'][0]['statistics']['subscriberCount'] );

					$total = $count;
				} else{

					$total = 0;

				}
			}

		return($total);
	 }


	public function wp_social_follower_dribbble_followers( $page_link, $dribbble_access_token ){

	 	$dribbble 			= @parse_url($page_link);
	 	$dribbble_at 		= $dribbble_access_token;

		if( $dribbble['host'] == 'www.dribbble.com' || $dribbble['host']  == 'dribbble.com' ){	

			$page_name 		= substr(@parse_url($page_link, PHP_URL_PATH), 1);			
			@$data_all 		= "https://api.dribbble.com/v1/user?access_token=".$dribbble_at;
			@$data_count 	= file_get_contents($data_all);
			@$d_data 		= json_decode( $data_count, true );					
			$dribbble_count = $d_data['followers_count'];

		} else {
			$dribbble_count = esc_html_e('Please enter correct Dribbble page url and access token!', 'wp-social-follower');
		}

		return $dribbble_count;
	}

}

add_action("widgets_init", function(){
	register_widget('WP_Social_Followers');
});


