/*!
 * JQVMap: jQuery Vector Map Library
 * @author JQVMap <me@peterschmalfeldt.com>
 * @version 1.5.1
 * @link http://jqvmap.com
 * @license https://github.com/manifestinteractive/jqvmap/blob/master/LICENSE
 * @builddate 2016/05/18
 */
;var VectorCanvas=function(b,a,d){this.mode=window.SVGAngle?"svg":"vml";this.params=d;if(this.mode==="svg"){this.createSvgNode=function(e){return document.createElementNS(this.svgns,e)}}else{try{if(!document.namespaces.rvml){document.namespaces.add("rvml","urn:schemas-microsoft-com:vml")}this.createVmlNode=function(e){return document.createElement("<rvml:"+e+' class="rvml">')}}catch(c){this.createVmlNode=function(e){return document.createElement("<"+e+' xmlns="urn:schemas-microsoft.com:vml" class="rvml">')}}document.createStyleSheet().addRule(".rvml","behavior:url(#default#VML)")}if(this.mode==="svg"){this.canvas=this.createSvgNode("svg")}else{this.canvas=this.createVmlNode("group");this.canvas.style.position="absolute"}this.setSize(b,a)};VectorCanvas.prototype={svgns:"http://www.w3.org/2000/svg",mode:"svg",width:0,height:0,canvas:null};var ColorScale=function(a,b,c,d){if(a){this.setColors(a)}if(b){this.setNormalizeFunction(b)}if(c){this.setMin(c)}if(c){this.setMax(d)}};ColorScale.prototype={colors:[]};var JQVMap=function(g){g=g||{};var e=this;var f=JQVMap.maps[g.map];var h;if(!f){throw new Error('Invalid "'+g.map+'" map parameter. Please make sure you have loaded this map file in your HTML.')}this.selectedRegions=[];this.multiSelectRegion=g.multiSelectRegion;this.container=g.container;this.defaultWidth=f.width;this.defaultHeight=f.height;this.color=g.color;this.selectedColor=g.selectedColor;this.hoverColor=g.hoverColor;this.hoverColors=g.hoverColors;this.hoverOpacity=g.hoverOpacity;this.setBackgroundColor(g.backgroundColor);this.width=g.container.width();this.height=g.container.height();this.resize();jQuery(window).resize(function(){var j=g.container.width();var i=g.container.height();if(j&&i){e.width=j;e.height=i;e.resize();e.canvas.setSize(e.width,e.height);e.applyTransform();var k=jQuery.Event("resize.jqvmap");jQuery(g.container).trigger(k,[j,i]);if(h){jQuery(".jqvmap-pin").remove();e.pinHandlers=false;e.placePins(h.pins,h.mode)}}});this.canvas=new VectorCanvas(this.width,this.height,g);g.container.append(this.canvas.canvas);this.makeDraggable();this.rootGroup=this.canvas.createGroup(true);this.index=JQVMap.mapIndex;this.label=jQuery("<div/>").addClass("jqvmap-label").appendTo(jQuery("body")).hide();if(g.enableZoom){jQuery("<div/>").addClass("jqvmap-zoomin").text("+").appendTo(g.container);jQuery("<div/>").addClass("jqvmap-zoomout").html("&#x2212;").appendTo(g.container)}e.countries=[];for(var b in f.paths){var d=this.canvas.createPath({path:f.paths[b].path});d.setFill(this.color);d.id=e.getCountryId(b);e.countries[b]=d;if(this.canvas.mode==="svg"){d.setAttribute("class","jqvmap-region")}else{jQuery(d).addClass("jqvmap-region")}jQuery(this.rootGroup).append(d)}jQuery(g.container).delegate(this.canvas.mode==="svg"?"path":"shape","mouseover mouseout",function(m){var j=m.target,k=m.target.id.split("_").pop(),i=jQuery.Event("labelShow.jqvmap"),l=jQuery.Event("regionMouseOver.jqvmap");k=k.toLowerCase();if(m.type==="mouseover"){jQuery(g.container).trigger(l,[k,f.paths[k].name]);if(!l.isDefaultPrevented()){e.highlight(k,j)}if(g.showTooltip){e.label.text(f.paths[k].name);jQuery(g.container).trigger(i,[e.label,k]);if(!i.isDefaultPrevented()){e.label.show();e.labelWidth=e.label.width();e.labelHeight=e.label.height()}}}else{e.unhighlight(k,j);e.label.hide();jQuery(g.container).trigger("regionMouseOut.jqvmap",[k,f.paths[k].name])}});jQuery(g.container).delegate(this.canvas.mode==="svg"?"path":"shape","click",function(i){var m=i.target;var k=i.target.id.split("_").pop();var j=jQuery.Event("regionClick.jqvmap");k=k.toLowerCase();jQuery(g.container).trigger(j,[k,f.paths[k].name]);if(!g.multiSelectRegion&&!j.isDefaultPrevented()){for(var l in f.paths){e.countries[l].currentFillColor=e.countries[l].getOriginalFill();e.countries[l].setFill(e.countries[l].getOriginalFill())}}if(!j.isDefaultPrevented()){if(e.isSelected(k)){e.deselect(k,m)}else{e.select(k,m)}}});if(g.showTooltip){g.container.mousemove(function(k){if(e.label.is(":visible")){var j=k.pageX-15-e.labelWidth;var i=k.pageY-15-e.labelHeight;if(j<0){j=k.pageX+15}if(i<0){i=k.pageY+15}e.label.css({left:j,top:i})}})}this.setColors(g.colors);this.canvas.canvas.appendChild(this.rootGroup);this.applyTransform();this.colorScale=new ColorScale(g.scaleColors,g.normalizeFunction,g.valueMin,g.valueMax);if(g.values){this.values=g.values;this.setValues(g.values)}if(g.selectedRegions){if(g.selectedRegions instanceof Array){for(var a in g.selectedRegions){this.select(g.selectedRegions[a].toLowerCase())}}else{this.select(g.selectedRegions.toLowerCase())}}this.bindZoomButtons();if(g.pins){h={pins:g.pins,mode:g.pinMode};this.pinHandlers=false;this.placePins(g.pins,g.pinMode)}if(g.showLabels){this.pinHandlers=false;var c={};for(b in e.countries){if(typeof e.countries[b]!=="function"){if(!g.pins||!g.pins[b]){c[b]=b.toUpperCase()}}}h={pins:c,mode:"content"};this.placePins(c,"content")}JQVMap.mapIndex++};JQVMap.prototype={transX:0,transY:0,scale:1,baseTransX:0,baseTransY:0,baseScale:1,width:0,height:0,countries:{},countriesColors:{},countriesData:{},zoomStep:1.4,zoomMaxStep:4,zoomCurStep:1};JQVMap.xlink="http://www.w3.org/1999/xlink";JQVMap.mapIndex=1;JQVMap.maps={};(function(){var b={colors:1,values:1,backgroundColor:1,scaleColors:1,normalizeFunction:1,enableZoom:1,showTooltip:1,borderColor:1,borderWidth:1,borderOpacity:1,selectedRegions:1,multiSelectRegion:1};var a={onLabelShow:"labelShow",onLoad:"load",onRegionOver:"regionMouseOver",onRegionOut:"regionMouseOut",onRegionClick:"regionClick",onRegionSelect:"regionSelect",onRegionDeselect:"regionDeselect",onResize:"resize"};jQuery.fn.vectorMap=function(c){var f={map:"world_en",backgroundColor:"white",color:"#f4f3f0",hoverColor:"#FCCFD4",hoverColors:{},selectedColor:"#FF95A1",scaleColors:["#FCCFD4","#F66E7E"],normalizeFunction:"linear",enableZoom:true,showTooltip:true,borderColor:"#D9D9D9",borderWidth:1,borderOpacity:0.25,selectedRegions:null,multiSelectRegion:false},h=this.data("mapObject");if(c==="addMap"){JQVMap.maps[arguments[1]]=arguments[2]}else{if(c==="set"&&b[arguments[1]]){h["set"+arguments[1].charAt(0).toUpperCase()+arguments[1].substr(1)].apply(h,Array.prototype.slice.call(arguments,2))}else{if(typeof c==="string"&&typeof h[c]==="function"){return h[c].apply(h,Array.prototype.slice.call(arguments,1))}else{jQuery.extend(f,c);f.container=this;this.css({position:"relative",overflow:"hidden"});h=new JQVMap(f);this.data("mapObject",h);this.unbind(".jqvmap");for(var g in a){if(f[g]){this.bind(a[g]+".jqvmap",f[g])}}var d=jQuery.Event("load.jqvmap");jQuery(f.container).trigger(d,h);return h}}}}})(jQuery);ColorScale.arrayToRgb=function(a){var b="#";var e;for(var c=0;c<a.length;c++){e=a[c].toString(16);b+=e.length===1?"0"+e:e}return b};ColorScale.prototype.getColor=function(e){if(typeof this.normalize==="function"){e=this.normalize(e)}var h=[];var f=0;var a;for(var d=0;d<this.colors.length-1;d++){a=this.vectorLength(this.vectorSubtract(this.colors[d+1],this.colors[d]));h.push(a);f+=a}var g=(this.maxValue-this.minValue)/f;for(d=0;d<h.length;d++){h[d]*=g}d=0;e-=this.minValue;while(e-h[d]>=0){e-=h[d];d++}var b;if(d===this.colors.length-1){b=this.vectorToNum(this.colors[d]).toString(16)}else{b=(this.vectorToNum(this.vectorAdd(this.colors[d],this.vectorMult(this.vectorSubtract(this.colors[d+1],this.colors[d]),(e)/(h[d]))))).toString(16)}while(b.length<6){b="0"+b}return"#"+b};ColorScale.rgbToArray=function(a){a=a.substr(1);return[parseInt(a.substr(0,2),16),parseInt(a.substr(2,2),16),parseInt(a.substr(4,2),16)]};ColorScale.prototype.setColors=function(a){for(var b=0;b<a.length;b++){a[b]=ColorScale.rgbToArray(a[b])}this.colors=a};ColorScale.prototype.setMax=function(a){this.clearMaxValue=a;if(typeof this.normalize==="function"){this.maxValue=this.normalize(a)}else{this.maxValue=a}};ColorScale.prototype.setMin=function(a){this.clearMinValue=a;if(typeof this.normalize==="function"){this.minValue=this.normalize(a)}else{this.minValue=a}};ColorScale.prototype.setNormalizeFunction=function(a){if(a==="polynomial"){this.normalize=function(b){return Math.pow(b,0.2)}}else{if(a==="linear"){delete this.normalize}else{this.normalize=a}}this.setMin(this.clearMinValue);this.setMax(this.clearMaxValue)};ColorScale.prototype.vectorAdd=function(d,c){var a=[];for(var b=0;b<d.length;b++){a[b]=d[b]+c[b]}return a};ColorScale.prototype.vectorLength=function(b){var a=0;for(var c=0;c<b.length;c++){a+=b[c]*b[c]}return Math.sqrt(a)};ColorScale.prototype.vectorMult=function(b,c){var a=[];for(var d=0;d<b.length;d++){a[d]=b[d]*c}return a};ColorScale.prototype.vectorSubtract=function(d,c){var a=[];for(var b=0;b<d.length;b++){a[b]=d[b]-c[b]}return a};ColorScale.prototype.vectorToNum=function(a){var b=0;for(var c=0;c<a.length;c++){b+=Math.round(a[c])*Math.pow(256,a.length-c-1)}return b};JQVMap.prototype.applyTransform=function(){var c,b,a,d;if(this.defaultWidth*this.scale<=this.width){c=(this.width-this.defaultWidth*this.scale)/(2*this.scale);a=(this.width-this.defaultWidth*this.scale)/(2*this.scale)}else{c=0;a=(this.width-this.defaultWidth*this.scale)/this.scale}if(this.defaultHeight*this.scale<=this.height){b=(this.height-this.defaultHeight*this.scale)/(2*this.scale);d=(this.height-this.defaultHeight*this.scale)/(2*this.scale)}else{b=0;d=(this.height-this.defaultHeight*this.scale)/this.scale}if(this.transY>b){this.transY=b}else{if(this.transY<d){this.transY=d}}if(this.transX>c){this.transX=c}else{if(this.transX<a){this.transX=a}}this.canvas.applyTransformParams(this.scale,this.transX,this.transY)};JQVMap.prototype.bindZoomButtons=function(){var a=this;this.container.find(".jqvmap-zoomin").click(function(){a.zoomIn()});this.container.find(".jqvmap-zoomout").click(function(){a.zoomOut()})};JQVMap.prototype.deselect=function(c,b){c=c.toLowerCase();b=b||jQuery("#"+this.getCountryId(c))[0];if(this.isSelected(c)){this.selectedRegions.splice(this.selectIndex(c),1);jQuery(this.container).trigger("regionDeselect.jqvmap",[c]);b.currentFillColor=b.getOriginalFill();b.setFill(b.getOriginalFill())}else{for(var a in this.countries){this.selectedRegions.splice(this.selectedRegions.indexOf(a),1);this.countries[a].currentFillColor=this.color;this.countries[a].setFill(this.color)}}};JQVMap.prototype.getCountryId=function(a){return"jqvmap"+this.index+"_"+a};JQVMap.prototype.getPin=function(b){var a=jQuery("#"+this.getPinId(b));return a.html()};JQVMap.prototype.getPinId=function(a){return this.getCountryId(a)+"_pin"};JQVMap.prototype.getPins=function(){var b=this.container.find(".jqvmap-pin");var a={};jQuery.each(b,function(d,e){e=jQuery(e);var f=e.attr("for").toLowerCase();var c=e.html();a[f]=c});return JSON.stringify(a)};JQVMap.prototype.highlight=function(b,a){a=a||jQuery("#"+this.getCountryId(b))[0];if(this.hoverOpacity){a.setOpacity(this.hoverOpacity)}else{if(this.hoverColors&&(b in this.hoverColors)){a.currentFillColor=a.getFill()+"";a.setFill(this.hoverColors[b])}else{if(this.hoverColor){a.currentFillColor=a.getFill()+"";a.setFill(this.hoverColor)}}}};JQVMap.prototype.isSelected=function(a){return this.selectIndex(a)>=0};JQVMap.prototype.makeDraggable=function(){var c=false;var e,d;var k=this;k.isMoving=false;k.isMovingTimeout=false;var f;var h;var g;var b;var a;var j;var i;this.container.mousemove(function(l){if(c){k.transX-=(e-l.pageX)/k.scale;k.transY-=(d-l.pageY)/k.scale;k.applyTransform();e=l.pageX;d=l.pageY;k.isMoving=true;if(k.isMovingTimeout){clearTimeout(k.isMovingTimeout)}k.container.trigger("drag")}return false}).mousedown(function(l){c=true;e=l.pageX;d=l.pageY;return false}).mouseup(function(){c=false;clearTimeout(k.isMovingTimeout);k.isMovingTimeout=setTimeout(function(){k.isMoving=false},100);return false}).mouseout(function(){if(c&&k.isMoving){clearTimeout(k.isMovingTimeout);k.isMovingTimeout=setTimeout(function(){c=false;k.isMoving=false},100);return false}});jQuery(this.container).bind("touchmove",function(n){var q;var p;var m=n.originalEvent.touches;var l;var o;if(m.length===1){if(f===1){if(j===m[0].pageX&&i===m[0].pageY){return}l=k.transX;o=k.transY;k.transX-=(j-m[0].pageX)/k.scale;k.transY-=(i-m[0].pageY)/k.scale;k.applyTransform();if(l!==k.transX||o!==k.transY){n.preventDefault()}k.isMoving=true;if(k.isMovingTimeout){clearTimeout(k.isMovingTimeout)}}j=m[0].pageX;i=m[0].pageY}else{if(m.length===2){if(f===2){p=Math.sqrt(Math.pow(m[0].pageX-m[1].pageX,2)+Math.pow(m[0].pageY-m[1].pageY,2))/b;k.setScale(a*p,h,g);n.preventDefault()}else{q=jQuery(k.container).offset();if(m[0].pageX>m[1].pageX){h=m[1].pageX+(m[0].pageX-m[1].pageX)/2}else{h=m[0].pageX+(m[1].pageX-m[0].pageX)/2}if(m[0].pageY>m[1].pageY){g=m[1].pageY+(m[0].pageY-m[1].pageY)/2}else{g=m[0].pageY+(m[1].pageY-m[0].pageY)/2}h-=q.left;g-=q.top;a=k.scale;b=Math.sqrt(Math.pow(m[0].pageX-m[1].pageX,2)+Math.pow(m[0].pageY-m[1].pageY,2))}}}f=m.length});jQuery(this.container).bind("touchstart",function(){f=0});jQuery(this.container).bind("touchend",function(){f=0})};JQVMap.prototype.placePins=function(b,d){var a=this;if(!d||(d!=="content"&&d!=="id")){d="content"}if(d==="content"){jQuery.each(b,function(g,f){if(jQuery("#"+a.getCountryId(g)).length===0){return}var e=a.getPinId(g);var h=jQuery("#"+e);if(h.length>0){h.remove()}a.container.append('<div id="'+e+'" for="'+g+'" class="jqvmap-pin" style="position:absolute">'+f+"</div>")})}else{jQuery.each(b,function(g,f){if(jQuery("#"+a.getCountryId(g)).length===0){return}var e=a.getPinId(g);var h=jQuery("#"+e);if(h.length>0){h.remove()}a.container.append('<div id="'+e+'" for="'+g+'" class="jqvmap-pin" style="position:absolute"></div>');h.append(jQuery("#"+f))})}this.positionPins();if(!this.pinHandlers){this.pinHandlers=true;var c=function(){a.positionPins()};this.container.bind("zoomIn",c).bind("zoomOut",c).bind("drag",c)}};JQVMap.prototype.positionPins=function(){var b=this;var a=this.container.find(".jqvmap-pin");jQuery.each(a,function(f,k){k=jQuery(k);var h=b.getCountryId(k.attr("for").toLowerCase());var j=jQuery("#"+h);var i=document.getElementById(h).getBBox();var e=j.position();var d=b.scale;var c=e.left+(i.width/2)*d-k.width()/2,g=e.top+(i.height/2)*d-k.height()/2;k.css("left",c).css("top",g)})};JQVMap.prototype.removePin=function(a){a=a.toLowerCase();jQuery("#"+this.getPinId(a)).remove()};JQVMap.prototype.removePins=function(){this.container.find(".jqvmap-pin").remove()};JQVMap.prototype.reset=function(){for(var a in this.countries){this.countries[a].setFill(this.color)}this.scale=this.baseScale;this.transX=this.baseTransX;this.transY=this.baseTransY;this.applyTransform()};JQVMap.prototype.resize=function(){var a=this.baseScale;if(this.width/this.height>this.defaultWidth/this.defaultHeight){this.baseScale=this.height/this.defaultHeight;this.baseTransX=Math.abs(this.width-this.defaultWidth*this.baseScale)/(2*this.baseScale)}else{this.baseScale=this.width/this.defaultWidth;this.baseTransY=Math.abs(this.height-this.defaultHeight*this.baseScale)/(2*this.baseScale)}this.scale*=this.baseScale/a;this.transX*=this.baseScale/a;this.transY*=this.baseScale/a};JQVMap.prototype.select=function(b,a){b=b.toLowerCase();a=a||jQuery("#"+this.getCountryId(b))[0];if(!this.isSelected(b)){if(this.multiSelectRegion){this.selectedRegions.push(b)}else{this.selectedRegions=[b]}jQuery(this.container).trigger("regionSelect.jqvmap",[b]);if(this.selectedColor&&a){a.currentFillColor=this.selectedColor;a.setFill(this.selectedColor)}}};JQVMap.prototype.selectIndex=function(b){b=b.toLowerCase();for(var a=0;a<this.selectedRegions.length;a++){if(b===this.selectedRegions[a]){return a}}return -1};JQVMap.prototype.setBackgroundColor=function(a){this.container.css("background-color",a)};JQVMap.prototype.setColors=function(c,b){if(typeof c==="string"){this.countries[c].setFill(b);this.countries[c].setAttribute("original",b)}else{var a=c;for(var d in a){if(this.countries[d]){this.countries[d].setFill(a[d]);this.countries[d].setAttribute("original",a[d])}}}};JQVMap.prototype.setNormalizeFunction=function(a){this.colorScale.setNormalizeFunction(a);if(this.values){this.setValues(this.values)}};JQVMap.prototype.setScale=function(a){this.scale=a;this.applyTransform()};JQVMap.prototype.setScaleColors=function(a){this.colorScale.setColors(a);if(this.values){this.setValues(this.values)}};JQVMap.prototype.setValues=function(c){var a=0,d=Number.MAX_VALUE,e;for(var f in c){f=f.toLowerCase();e=parseFloat(c[f]);if(isNaN(e)){continue}if(e>a){a=c[f]}if(e<d){d=e}}if(d===a){a++}this.colorScale.setMin(d);this.colorScale.setMax(a);var b={};for(f in c){f=f.toLowerCase();e=parseFloat(c[f]);b[f]=isNaN(e)?this.color:this.colorScale.getColor(e)}this.setColors(b);this.values=c};JQVMap.prototype.unhighlight=function(b,a){b=b.toLowerCase();a=a||jQuery("#"+this.getCountryId(b))[0];a.setOpacity(1);if(a.currentFillColor){a.setFill(a.currentFillColor)}};JQVMap.prototype.zoomIn=function(){var b=this;var a=(jQuery("#zoom").innerHeight()-6*2-15*2-3*2-7-6)/(this.zoomMaxStep-this.zoomCurStep);if(b.zoomCurStep<b.zoomMaxStep){b.transX-=(b.width/b.scale-b.width/(b.scale*b.zoomStep))/2;b.transY-=(b.height/b.scale-b.height/(b.scale*b.zoomStep))/2;b.setScale(b.scale*b.zoomStep);b.zoomCurStep++;var c=jQuery("#zoomSlider");c.css("top",parseInt(c.css("top"),10)-a);b.container.trigger("zoomIn")}};JQVMap.prototype.zoomOut=function(){var b=this;var a=(jQuery("#zoom").innerHeight()-6*2-15*2-3*2-7-6)/(this.zoomMaxStep-this.zoomCurStep);if(b.zoomCurStep>1){b.transX+=(b.width/(b.scale/b.zoomStep)-b.width/b.scale)/2;b.transY+=(b.height/(b.scale/b.zoomStep)-b.height/b.scale)/2;b.setScale(b.scale/b.zoomStep);b.zoomCurStep--;var c=jQuery("#zoomSlider");c.css("top",parseInt(c.css("top"),10)+a);b.container.trigger("zoomOut")}};VectorCanvas.prototype.applyTransformParams=function(c,b,a){if(this.mode==="svg"){this.rootGroup.setAttribute("transform","scale("+c+") translate("+b+", "+a+")")}else{this.rootGroup.coordorigin=(this.width-b)+","+(this.height-a);this.rootGroup.coordsize=this.width/c+","+this.height/c}};VectorCanvas.prototype.createGroup=function(a){var b;if(this.mode==="svg"){b=this.createSvgNode("g")}else{b=this.createVmlNode("group");b.style.width=this.width+"px";b.style.height=this.height+"px";b.style.left="0px";b.style.top="0px";b.coordorigin="0 0";b.coordsize=this.width+" "+this.height}if(a){this.rootGroup=b}return b};VectorCanvas.prototype.createPath=function(a){var b;if(this.mode==="svg"){b=this.createSvgNode("path");b.setAttribute("d",a.path);if(this.params.borderColor!==null){b.setAttribute("stroke",this.params.borderColor)}if(this.params.borderWidth>0){b.setAttribute("stroke-width",this.params.borderWidth);b.setAttribute("stroke-linecap","round");b.setAttribute("stroke-linejoin","round")}if(this.params.borderOpacity>0){b.setAttribute("stroke-opacity",this.params.borderOpacity)}b.setFill=function(e){this.setAttribute("fill",e);if(this.getAttribute("original")===null){this.setAttribute("original",e)}};b.getFill=function(){return this.getAttribute("fill")};b.getOriginalFill=function(){return this.getAttribute("original")};b.setOpacity=function(e){this.setAttribute("fill-opacity",e)}}else{b=this.createVmlNode("shape");b.coordorigin="0 0";b.coordsize=this.width+" "+this.height;b.style.width=this.width+"px";b.style.height=this.height+"px";b.fillcolor=JQVMap.defaultFillColor;b.stroked=false;b.path=VectorCanvas.pathSvgToVml(a.path);var d=this.createVmlNode("skew");d.on=true;d.matrix="0.01,0,0,0.01,0,0";d.offset="0,0";b.appendChild(d);var c=this.createVmlNode("fill");b.appendChild(c);b.setFill=function(e){this.getElementsByTagName("fill")[0].color=e;if(this.getAttribute("original")===null){this.setAttribute("original",e)}};b.getFill=function(){return this.getElementsByTagName("fill")[0].color};b.getOriginalFill=function(){return this.getAttribute("original")};b.setOpacity=function(e){this.getElementsByTagName("fill")[0].opacity=parseInt(e*100,10)+"%"}}return b};VectorCanvas.prototype.pathSvgToVml=function(e){var b="";var a=0,f=0,d,c;return e.replace(/([MmLlHhVvCcSs])((?:-?(?:\d+)?(?:\.\d+)?,?\s?)+)/g,function(k,j,m){m=m.replace(/(\d)-/g,"$1,-").replace(/\s+/g,",").split(",");if(!m[0]){m.shift()}for(var h=0,g=m.length;h<g;h++){m[h]=Math.round(100*m[h])}switch(j){case"m":a+=m[0];f+=m[1];b="t"+m.join(",");break;case"M":a=m[0];f=m[1];b="m"+m.join(",");break;case"l":a+=m[0];f+=m[1];b="r"+m.join(",");break;case"L":a=m[0];f=m[1];b="l"+m.join(",");break;case"h":a+=m[0];b="r"+m[0]+",0";break;case"H":a=m[0];b="l"+a+","+f;break;case"v":f+=m[0];b="r0,"+m[0];break;case"V":f=m[0];b="l"+a+","+f;break;case"c":d=a+m[m.length-4];c=f+m[m.length-3];a+=m[m.length-2];f+=m[m.length-1];b="v"+m.join(",");break;case"C":d=m[m.length-4];c=m[m.length-3];a=m[m.length-2];f=m[m.length-1];b="c"+m.join(",");break;case"s":m.unshift(f-c);m.unshift(a-d);d=a+m[m.length-4];c=f+m[m.length-3];a+=m[m.length-2];f+=m[m.length-1];b="v"+m.join(",");break;case"S":m.unshift(f+f-c);m.unshift(a+a-d);d=m[m.length-4];c=m[m.length-3];a=m[m.length-2];f=m[m.length-1];b="c"+m.join(",");break;default:break}return b}).replace(/z/g,"")};VectorCanvas.prototype.setSize=function(d,a){if(this.mode==="svg"){this.canvas.setAttribute("width",d);this.canvas.setAttribute("height",a)}else{this.canvas.style.width=d+"px";this.canvas.style.height=a+"px";this.canvas.coordsize=d+" "+a;this.canvas.coordorigin="0 0";if(this.rootGroup){var e=this.rootGroup.getElementsByTagName("shape");for(var c=0,b=e.length;c<b;c++){e[c].coordsize=d+" "+a;e[c].style.width=d+"px";e[c].style.height=a+"px"}this.rootGroup.coordsize=d+" "+a;this.rootGroup.style.width=d+"px";this.rootGroup.style.height=a+"px"}}this.width=d;this.height=a};