<?php declare( strict_types=1 );

namespace FernleafSystems\Wordpress\Plugin\Shield\Zones\Component;

use FernleafSystems\Wordpress\Plugin\Shield\Zones\Common\EnumEnabledStatus;

class VulnerabilityScanning extends Base {

	public function title() :string {
		return __( 'Vulnerability Scanning', 'wp-simple-firewall' );
	}

	public function subtitle() :string {
		return __( 'Regularly scan WordPress plugins and themes for known security vulnerabilities.', 'wp-simple-firewall' );
	}

	protected function tooltip() :string {
		return __( 'Switch on/off automatic scanning for vulnerabilities', 'wp-simple-firewall' );
	}

	/**
	 * @inheritDoc
	 */
	protected function status() :array {
		$con = self::con();
		$status = parent::status();

		$status[ 'level' ] = $con->comps->scans->WPV()->isEnabled() ? EnumEnabledStatus::GOOD : EnumEnabledStatus::BAD;
		if ( !$con->comps->scans->APC()->isEnabled() ) {
			$status[ 'exp' ][] = __( "No scan for plugins which may have been abandoned by their author.", 'wp-simple-firewall' );
		}
		if ( !$con->comps->scans->WPV()->isAutoupdatesEnabled() ) {
			$status[ 'exp' ][] = __( "Updates aren't automatically applied for vulnerable plugins.", 'wp-simple-firewall' );
		}
		return $status;
	}
}