<?php

declare (strict_types=1);
namespace WPSentry\ScopedVendor\PackageVersions;

use WPSentry\ScopedVendor\Composer\InstalledVersions;
use OutOfBoundsException;
\class_exists(\WPSentry\ScopedVendor\Composer\InstalledVersions::class);
/**
 * This class is generated by composer/package-versions-deprecated, specifically by
 * @see \PackageVersions\Installer
 *
 * This file is overwritten at every run of `composer install` or `composer update`.
 *
 * @deprecated in favor of the Composer\InstalledVersions class provided by Composer 2. Require composer-runtime-api:^2 to ensure it is present.
 */
final class Versions
{
    /**
     * @deprecated please use {@see self::rootPackageName()} instead.
     *             This constant will be removed in version 2.0.0.
     */
    const ROOT_PACKAGE_NAME = 'stayallive/wp-sentry';
    /**
     * Array of all available composer packages.
     * Dont read this array from your calling code, but use the \PackageVersions\Versions::getVersion() method instead.
     *
     * @var array<string, string>
     * @internal
     */
    const VERSIONS = array('composer/installers' => 'v2.3.0@12fb2dfe5e16183de69e784a7b84046c43d97e8e', 'composer/package-versions-deprecated' => '1.11.99.5@b4f54f74ef3453349c24a845d22392cd31e65f1d', 'guzzlehttp/psr7' => '2.8.0@21dc724a0583619cd1652f673303492272778051', 'jean85/pretty-package-versions' => '1.6.0@1e0104b46f045868f11942aea058cd7186d6c303', 'psr/http-factory' => '1.1.0@2b4765fddfe3b508ac62f829e852b1501d3f6e8a', 'psr/http-message' => '2.0@402d35bcb92c70c026d1a6a9883f06b2ead23d71', 'psr/log' => '1.1.4@d49695b909c3b7628b6289db5479a1c204601f11', 'ralouphie/getallheaders' => '3.0.3@120b605dfeb996808c31b6477290a714d356e822', 'sentry/sentry' => '4.18.1@04dcf20b39742b731b676f8b8d4f02d1db488af8', 'symfony/deprecation-contracts' => 'v2.5.4@605389f2a7e5625f273b53960dc46aeaf9c62918', 'symfony/options-resolver' => 'v5.4.45@74e5b6f0db3e8589e6cfd5efb317a1fc2bb52fb6', 'symfony/polyfill-php73' => 'v1.33.0@0f68c03565dcaaf25a890667542e8bd75fe7e5bb', 'symfony/polyfill-php80' => 'v1.33.0@0cc9dd0f17f61d8131e7df6b84bd344899fe2608', 'stayallive/wp-sentry' => 'v8.10.0@259eb9dda09581c0e86ccbe05e4aba115f1c460b');
    private function __construct()
    {
    }
    /**
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function rootPackageName() : string
    {
        if (!self::composer2ApiUsable()) {
            return self::ROOT_PACKAGE_NAME;
        }
        return \WPSentry\ScopedVendor\Composer\InstalledVersions::getRootPackage()['name'];
    }
    /**
     * @throws OutOfBoundsException If a version cannot be located.
     *
     * @psalm-param key-of<self::VERSIONS> $packageName
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function getVersion(string $packageName) : string
    {
        if (self::composer2ApiUsable()) {
            return \WPSentry\ScopedVendor\Composer\InstalledVersions::getPrettyVersion($packageName) . '@' . \WPSentry\ScopedVendor\Composer\InstalledVersions::getReference($packageName);
        }
        if (isset(self::VERSIONS[$packageName])) {
            return self::VERSIONS[$packageName];
        }
        throw new \OutOfBoundsException('Required package "' . $packageName . '" is not installed: check your ./vendor/composer/installed.json and/or ./composer.lock files');
    }
    private static function composer2ApiUsable() : bool
    {
        if (!\class_exists(\WPSentry\ScopedVendor\Composer\InstalledVersions::class, \false)) {
            return \false;
        }
        if (\method_exists(\WPSentry\ScopedVendor\Composer\InstalledVersions::class, 'getAllRawData')) {
            $rawData = \WPSentry\ScopedVendor\Composer\InstalledVersions::getAllRawData();
            if (\count($rawData) === 1 && \count($rawData[0]) === 0) {
                return \false;
            }
        } else {
            $rawData = \WPSentry\ScopedVendor\Composer\InstalledVersions::getRawData();
            if ($rawData === null || $rawData === []) {
                return \false;
            }
        }
        return \true;
    }
}
