<?php

namespace RebelCode\Composer;

class CleanupRules
{
    public static function getRules()
    {
        // Default patterns for common files
        $docs = 'README* CHANGELOG* FAQ* CONTRIBUTING* HISTORY* UPGRADING* UPGRADE* package* demo example examples doc/* docs/* doc docs readme*';
        $tests = '.travis.yml .scrutinizer.yml phpunit.xml* phpunit.php test/* tests/* test tests Test/* Tests/* Test Tests travis .coveralls.yml couscous.yml';
        $proj = 'nbproject .idea .phan phpmd.xml .editorconfig .php_cs .gitignore .codeclimate.yml';

        return [
            'anahkiasen/former'                     => [$docs, $tests],
            'anahkiasen/html-object'                => [$docs, 'phpunit.xml* tests/*'],
            'anahkiasen/rocketeer'                  => [$docs, $tests],
            'anahkiasen/underscore-php'             => [$docs, $tests],
            'barryvdh/composer-cleanup-plugin'      => [$docs, $tests],
            'barryvdh/laravel-debugbar'             => [$docs, $tests],
            'barryvdh/laravel-ide-helper'           => [$docs, $tests],
            'bllim/datatables'                      => [$docs, $tests],
            'cartalyst/sentry'                      => [$docs, $tests],
            'classpreloader/classpreloader'         => [$docs, $tests],
            'd11wtq/boris'                          => [$docs, $tests],
            'danielstjules/stringy'                 => [$docs, $tests],
            'dflydev/markdown'                      => [$docs, $tests],
            'dhii/collections-abstract'             => [$docs, $tests, $proj],
            'dhii/collections-abstract-base'        => [$docs, $tests, $proj],
            'dhii/collections-interface'            => [$docs, $tests, $proj],
            'dhii/container-helper-base'            => [$docs, $tests, $proj],
            'dhii/di'                               => [$docs, $tests, $proj],
            'dhii/di-abstract'                      => [$docs, $tests, $proj],
            'dhii/di-interface'                     => [$docs, $tests, $proj],
            'dhii/exception'                        => [$docs, $tests, $proj],
            'dhii/exception-interface'              => [$docs, $tests, $proj],
            'dhii/factory-interface'                => [$docs, $tests, $proj],
            'dhii/i18n-helper-base'                 => [$docs, $tests, $proj],
            'dhii/i18n-interface'                   => [$docs, $tests, $proj],
            'dhii/iterator-helper-base'             => [$docs, $tests, $proj],
            'dhii/normalization-helper-base'        => [$docs, $tests, $proj],
            'dhii/output-renderer-abstract'         => [$docs, $tests, $proj],
            'dhii/output-renderer-base'             => [$docs, $tests, $proj],
            'dhii/output-renderer-interface'        => [$docs, $tests, $proj],
            'dhii/stats-abstract'                   => [$docs, $tests, $proj],
            'dhii/stats-interface'                  => [$docs, $tests, $proj],
            'dhii/stringable-interface'             => [$docs, $tests, $proj],
            'dhii/transformer-interface'            => [$docs, $tests, $proj],
            'dhii/validation-abstract'              => [$docs, $tests, $proj],
            'dhii/validation-base'                  => [$docs, $tests, $proj],
            'dhii/validation-interface'             => [$docs, $tests, $proj],
            'dnoegel/php-xdg-base-dir'              => [$docs, $tests],
            'doctrine/annotations'                  => [$docs, $tests, 'bin'],
            'doctrine/cache'                        => [$docs, $tests, 'bin'],
            'doctrine/collections'                  => [$docs, $tests],
            'doctrine/common'                       => [$docs, $tests, 'bin lib/vendor'],
            'doctrine/dbal'                         => [$docs, $tests, 'bin build* docs2 lib/vendor'],
            'doctrine/inflector'                    => [$docs, $tests],
            'dompdf/dompdf'                         => [$docs, $tests, 'www'],
            'erusev/parsedown'                      => [$docs, $tests],
            'filp/whoops'                           => [$docs, $tests],
            'guzzle/guzzle'                         => [$docs, $tests],
            'guzzlehttp/guzzle'                     => [$docs, $tests],
            'guzzlehttp/oauth-subscriber'           => [$docs, $tests],
            'guzzlehttp/streams'                    => [$docs, $tests],
            'imagine/imagine'                       => [$docs, $tests, 'lib/Imagine/Test'],
            'intervention/image'                    => [$docs, $tests, 'public'],
            'ircmaxell/password-compat'             => [$docs, $tests],
            'jakub-onderka/php-console-color'       => [$docs, $tests, 'build.xml example.php'],
            'jakub-onderka/php-console-highlighter' => [$docs, $tests, 'build.xml'],
            'jasonlewis/basset'                     => [$docs, $tests],
            'jeremeamia/SuperClosure'               => [$docs, $tests, 'demo'],
            'kriswallsmith/assetic'                 => [$docs, $tests],
            'laravel/framework'                     => [$docs, $tests, 'build'],
            'leafo/lessphp'                         => [$docs, $tests, 'Makefile package.sh'],
            'league/flysystem'                      => [$docs, $tests],
            'league/stack-robots'                   => [$docs, $tests],
            'maximebf/debugbar'                     => [$docs, $tests, 'demo'],
            'mccool/laravel-auto-presenter'         => [$docs, $tests],
            'mockery/mockery'                       => [$docs, $tests],
            'monolog/monolog'                       => [$docs, $tests],
            'mrclay/minify'                         => [
                $docs,
                $tests,
                'MIN.txt min_extras min_unit_tests min/builder min/config* min/quick-test* min/utils.php min/groupsConfig.php min/index.php',
            ],
            'mtdowling/cron-expression'             => [$docs, $tests],
            'mustache/mustache'                     => [$docs, $tests, 'bin'],
            'nesbot/carbon'                         => [$docs, $tests],
            'nikic/php-parser'                      => [$docs, $tests, 'test_old'],
            'oyejorge/less.php'                     => [$docs, $tests],
            'php-di/invoker'                        => [],
            'php-di/php-di'                         => [$docs, $tests, 'news', 'website', '404.md'],
            'php-di/phpdoc-reader'                  => [$docs, $tests],
            'patchwork/utf8'                        => [$docs, $tests],
            'phenx/php-font-lib'                    => [$docs, $tests . 'www'],
            'phpdocumentor/reflection-docblock'     => [$docs, $tests],
            'phpoffice/phpexcel'                    => [$docs, $tests, 'Examples unitTests changelog.txt'],
            'phpseclib/phpseclib'                   => [$docs, $tests, 'build'],
            'predis/predis'                         => [$docs, $tests, 'bin'],
            'psr/container'                         => [$docs, $tests],
            'psr/log'                               => [$docs, $tests],
            'psy/psysh'                             => [$docs, $tests],
            'rcrowe/twigbridge'                     => [$docs, $tests],
            'rebelcode/composer-cleanup-plugin'     => [$docs, $tests],
            'simplepie/simplepie'                   => [$docs, $tests, 'build compatibility_test ROADMAP.md'],
            'stack/builder'                         => [$docs, $tests],
            'swiftmailer/swiftmailer'               => [
                $docs,
                $tests,
                'build* notes test-suite create_pear_package.php',
            ],
            'symfony/browser-kit'                   => [$docs, $tests],
            'symfony/class-loader'                  => [$docs, $tests],
            'symfony/console'                       => [$docs, $tests],
            'symfony/css-selector'                  => [$docs, $tests],
            'symfony/debug'                         => [$docs, $tests],
            'symfony/dom-crawler'                   => [$docs, $tests],
            'symfony/event-dispatcher'              => [$docs, $tests],
            'symfony/filesystem'                    => [$docs, $tests],
            'symfony/finder'                        => [$docs, $tests],
            'symfony/http-foundation'               => [$docs, $tests],
            'symfony/http-kernel'                   => [$docs, $tests],
            'symfony/polyfill-ctype'                => [$docs, $tests],
            'symfony/process'                       => [$docs, $tests],
            'symfony/routing'                       => [$docs, $tests],
            'symfony/security'                      => [$docs, $tests],
            'symfony/security-core'                 => [$docs, $tests],
            'symfony/translation'                   => [$docs, $tests],
            'symfony/var-dumper'                    => [$docs, $tests],
            'tijsverkoyen/css-to-inline-styles'     => [$docs, $tests],
            'twig/extensions'                       => [$docs, $tests],
            'twig/twig'                             => [$docs, $tests, 'ext/*'],
            'venturecraft/revisionable'             => [$docs, $tests],
            'vlucas/phpdotenv'                      => [$docs, $tests],
            'willdurand/geocoder'                   => [$docs, $tests],
        ];
    }
}
