<?php
/**
 * Plugin Name: WP Rate And Review
 * Description: A WooCommerce Add-on which provides complete feature to show your rating and review with progressbar.
 * Version: 1.2.0
 * Author: K.Kumar
 * Author URI: https://profiles.wordpress.org/krishna121/
 * Text Domain: wp-rate-and-review
 * WC tested up to: 9.7.1
 * WC requires at least: 3.0
 * @package wp-rate-and-review
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

/**
 * WCRR_Rate_Review main class
 * @package wp-rate-and-review
 * @author krishna121
 */

if (!class_exists('WCRR_Rate_Review')) {

	class WCRR_Rate_Review
	{



		/**
		 * Current plugin version
		 * @var $version
		 */
		public  $version = '1.2.0';

		/**
		 * Instance of plugin
		 * @var $instance 
		 */
		private static $instance;

		/**
		 * @var array
		 */
		public $result = array();

		/**
		 * Constructor of class
		 */
		function __construct()
		{

			if (!defined('WCRR_Path')) {
				define('WCRR_Path', plugin_dir_url(__FILE__));
			}

			$check_wooEnable = $this->wcrr_check_woo_enable();
			if ($check_wooEnable) {
				$this->wcrr_setup_plugin();
			} else {
				add_action('admin_notices', array($this, 'wcrr_required_woocommerce'));
			}
		}

		function wcrr_check_woo_enable()
		{

			$enable = false;
			$enable = in_array('woocommerce/woocommerce.php', get_option('active_plugins'));
			if (!function_exists('is_plugin_active_for_network')) {
				require_once(ABSPATH . '/wp-admin/includes/plugin.php');
			}

			if (is_multisite()) {
				$enable = (is_plugin_active_for_network('woocommerce/woocommerce.php')) ? true : false;
			}
			return $enable;
		}

		function wcrr_required_woocommerce()
		{
?>
			<div class="notice notice-error">
				<p><?php esc_html_e('WooCommerce is required for WP Rate and Review  plugin. Please install and configure woocommerce first.', 'wp-rate-and-review'); ?></p>
			</div>
			<?php
		}

		/**
		 * Setup plugin 
		 * @since 1.0.0
		 * @return void
		 */
		function wcrr_setup_plugin()
		{

			$this->wcrr_define_constant();
			$this->wcrr_load_files();
			$this->wcrr_hooks();
		}


		/**
		 * 
		 * Define constact of plugin
		 * @since 1.0.8
		 * 
		 */

		function wcrr_define_constant()
		{

			$this->wcrr_define('WCRR_VERSION', $this->version);
			$this->wcrr_define('WCRR_FILE', __FILE__);
			$this->wcrr_define('WCRR_PATH', dirname(WCRR_FILE));
			$this->wcrr_define('WCRR_INCLUDES', WCRR_PATH . '/includes');
			$this->wcrr_define('WCRR_URL', plugins_url('', WCRR_FILE));
			$this->wcrr_define('WCRR_ASSETS', WCRR_URL  . '/assets');
			$this->wcrr_define('WCRR_VIEWS', WCRR_PATH  . '/views');
			$this->wcrr_define('WCRR_TEMPLATES', WCRR_PATH  . '/templates/');
			$this->wcrr_define('WCRR_CSS', WCRR_URL . '/assets/css/');
			$this->wcrr_define('WCRR_JS', WCRR_URL . '/assets/js/');
			$this->wcrr_define('WCRR_IMAGES', WCRR_URL . '/assets/images/');
		}

		/**
		 * Define constant if not already set.
		 *
		 * @param string      $name
		 * @param string|bool $value
		 */
		function wcrr_define($name, $value)
		{
			if (!defined($name)) {
				define($name, $value);
			}
		}


		function wcrr_load_files()
		{

			if (is_admin()) {
				require_once WCRR_INCLUDES . '/class-wpub-form-fields.php';
				require_once WCRR_INCLUDES . '/class-wcrr-admin-menu.php';
				$this->wcrr_admin = new WCRR_Admin_Menu();
			}
		}

		/**
		 * Actual function for load hooks
		 */
		function wcrr_hooks()
		{

			add_action('wp_ajax_nopriv_wcrr_ajax_call', array($this, 'wcrr_ajax_call'));
			add_action('wp_ajax_wcrr_ajax_call', array($this, 'wcrr_ajax_call'));
			// Check admin
			if (!is_admin()) {
				$this->wcrr_frontend_hook();
			}
		}

		/**
		 * Ajax call handler 
		 * @since 1.0.0
		 * 
		 */
		function wcrr_ajax_call()
		{
			if (defined('DOING_AJAX') && DOING_AJAX) {
				if (isset($_POST['nonce']) && !wp_verify_nonce($_POST['nonce'], 'wcrr_nonce_value'))
					die('Busted!');
				$ajax_handler = isset($_POST['ajax_handler']) ? $_POST['ajax_handler'] : '';
				$response = $this->$ajax_handler($_POST);
				echo  json_encode($response);
				exit;
			}
		}
		/**
		 * Regiter hooks which worked into site frontend
		 * @since 1.0.0
		 * 
		 * 
		 */
		function wcrr_frontend_hook()
		{
			// Register comment
			add_filter('comments_template', array($this, 'wcrr_enhance_review_rating'));

			// Load css and js frontend files
			add_action('wp_enqueue_scripts', array($this, 'wcrr_load_css_js'));

			// Register shortcode of plugin
			add_shortcode('wp_rate_review', array($this, 'wcrr_review_markup_via_shortcode'));

			// Register new order actions on my-account's orders listing 
			add_filter('woocommerce_my_account_my_orders_actions', array($this, 'wcrr_show_review_actions'), 10, 2);
		}


		/**
		 * Register new order action button
		 */
		function wcrr_show_review_actions($actions, $order)
		{

			$order_status = $order->get_status();
			if ($order_status == 'completed') {

				$actions['review'] = array(
					'url' => get_home_url(),
					'name' => esc_html__('Review', 'wp-rate-and-review')
				);
			}
			return $actions;
		}


		/**
		 * Load css and js files
		 * @since 1.0.0
		 */
		function wcrr_load_css_js()
		{

			wp_enqueue_style('wpic-wcprogressbar-css', plugin_dir_url(__FILE__) . 'assets/css/wphp-progressbar.css');
			wp_enqueue_style('wpic-allfontawesome-css', plugin_dir_url(__FILE__) . 'assets/css/all.min.css');
			//wp_enqueue_style('wpic-frontend-css', plugin_dir_url(__FILE__) . 'assets/css/wpic-frontend.css');


			$plugin_seings_rate = maybe_unserialize(get_option('wcr_options_group'));
			$review_template = (!empty($plugin_seings_rate['review_template'][0])) ?$plugin_seings_rate['review_template'][0]:'';

			
			if ($review_template==$review_template) {
								wp_enqueue_style('wpic-frontend-css', plugin_dir_url(__FILE__) . 'templates/woocommerce/'.$review_template.'/'.$review_template.'.css');
			}



			$plugin_settings = maybe_unserialize(get_option('wcr_options_group'));
			$wp_pbar_bg_color = (!empty($plugin_settings['wp_pbar_bg_color'])) ? $plugin_settings['wp_pbar_bg_color'] : '';
			$wp_pbar_fill_color = (!empty($plugin_settings['wp_pbar_fill_color'])) ? $plugin_settings['wp_pbar_fill_color'] : '';
			$wp_progress_bar_height = (!empty($plugin_settings['wp_progress_bar_height'])) ? $plugin_settings['wp_progress_bar_height'] : 5;
			$wp_pbar_fill_color1 = (!empty($plugin_settings['wp_pbar_fill_color1'])) ? $plugin_settings['wp_pbar_fill_color1'] : '';
			$wp_pbar_fill_color2 = (!empty($plugin_settings['wp_pbar_fill_color2'])) ? $plugin_settings['wp_pbar_fill_color2'] : '';
			$wp_pbar_fill_color3 = (!empty($plugin_settings['wp_pbar_fill_color3'])) ? $plugin_settings['wp_pbar_fill_color3'] : '';
			$wp_pbar_fill_color4 = (!empty($plugin_settings['wp_pbar_fill_color4'])) ? $plugin_settings['wp_pbar_fill_color4'] : '';
			$wp_pbar_fill_color5 = (!empty($plugin_settings['wp_pbar_fill_color5'])) ? $plugin_settings['wp_pbar_fill_color5'] : '';
			$wp_star_fill_color1 = (!empty($plugin_settings['wp_star_fill_color1'])) ? $plugin_settings['wp_star_fill_color1'] : '';
			$wp_star_fill_color2 = (!empty($plugin_settings['wp_star_fill_color2'])) ? $plugin_settings['wp_star_fill_color2'] : '';
			$wp_star_fill_color3 = (!empty($plugin_settings['wp_star_fill_color3'])) ? $plugin_settings['wp_star_fill_color3'] : '';
			$wp_star_fill_color4 = (!empty($plugin_settings['wp_star_fill_color4'])) ? $plugin_settings['wp_star_fill_color4'] : '';
			$wp_star_fill_color5 = (!empty($plugin_settings['wp_star_fill_color5'])) ? $plugin_settings['wp_star_fill_color5'] : '';
			$wp_average_star_color = (!empty($plugin_settings['wp_average_star_color'])) ? $plugin_settings['wp_average_star_color'] : '';
			$wp_circle_stroke_color = (!empty($plugin_settings['wp_circle_stroke_color'])) ? $plugin_settings['wp_circle_stroke_color'] : '';
			$wp_average_star_background_color = (!empty($plugin_settings['wp_average_star_background_color'])) ? $plugin_settings['wp_average_star_background_color'] : '';
			$wp_progress_bar_height = (!empty($plugin_settings['wp_progress_bar_height'])) ? $plugin_settings['wp_progress_bar_height'] : '';

			$selected_tempalte = (!empty($plugin_settings['review_template'])) ? $plugin_settings['review_template'] : 'singlecolor';
			$custom_css = "";

			
			if ($review_template == 1) {

				
				 $custom_css .= "	.temp1progress5{background-color:" . $wp_pbar_fill_color1 . "  !important;}";
				 $custom_css .= "	.temp1star5{color:" . $wp_pbar_fill_color1 . "  !important;}";
				 $custom_css .= "	.temp1averagestar{color:" . $wp_pbar_fill_color1 . "  !important;}";
				 $custom_css .= "	.rating_wrapper .temp1background_progress_bar{height:" . $wp_progress_bar_height . "px;}";
				   $fill_height = $wp_progress_bar_height;


				 $custom_css .= "	.rating_wrapper .temp1background_progress_bar_height{height:" . $fill_height . "px;}";

				

				$custom_css .= "	.temp1progress4{background-color:" . $wp_pbar_fill_color1 . " !important;}";
				$custom_css .= "	.temp1star4{color:" . $wp_pbar_fill_color1 . "  !important;}";
				
				 
				 $custom_css .= "	.temp1progress3{background-color:" . $wp_pbar_fill_color1 . " !important;}";
				 $custom_css .= "	.temp1star3{color:" . $wp_pbar_fill_color1 . "  !important;}";
				$custom_css .= "	.wcrr_average_star .wcrr_av_score3:before{color:" . $wp_pbar_fill_color1 . " !important;}";

				 
				$custom_css .= "	.temp1progress2{background-color: " . $wp_pbar_fill_color1 . " !important;}";
				$custom_css .= "	.temp1star2{color:" . $wp_pbar_fill_color1 . "  !important;}";
				
				 $custom_css .= "	.temp1progress1{background-color: " . $wp_pbar_fill_color1 . " !important;}";
				 $custom_css .= "	.temp1star1{color:" . $wp_pbar_fill_color1 . "  !important;}";
			}

						if ($review_template == 2) {

			

				 $custom_css .= "	.temp2progress5{background-color:" . $wp_pbar_fill_color5 . "  !important;}";
				 $custom_css .= "	.temp2star5{color:" . $wp_star_fill_color5 . "  !important;}";
				 $custom_css .= "	.temp2averagestar{color:" . $wp_average_star_color . "  !important;}";
				 $custom_css .= "	.rating_wrapper .temp2background_progress_bar{height:" . $wp_progress_bar_height . "px;}";
				 $fill_height = $wp_progress_bar_height;


				 $custom_css .= "	.rating_wrapper .temp1background_progress_bar_height{height:" . $fill_height . "px;}";
				

				 $four_star_fill_color = apply_filters('wcrr_four_star_fill_color', '#eb131a');

				$custom_css .= "	.temp2progress4{background-color:" . $wp_pbar_fill_color4 . " !important;}";
				$custom_css .= "	.temp2star4{color:" . $wp_star_fill_color4 . "  !important;}";
				
				 
				 $custom_css .= "	.temp2progress3{background-color:" . $wp_pbar_fill_color3 . " !important;}";
				 $custom_css .= "	.temp2star3{color:" . $wp_star_fill_color3 . "  !important;}";
			

				 $two_star_fill_color = apply_filters('wcrr_two_star_fill_color', '#FFF568');
				$custom_css .= "	.temp2progress2{background-color: " . $wp_pbar_fill_color2 . " !important;}";
				$custom_css .= "	.temp2star2{color:" . $wp_star_fill_color2 . "  !important;}";
				
				 $custom_css .= "	.temp2progress1{background-color: " . $wp_pbar_fill_color1 . " !important;}";
				 $custom_css .= "	.temp2star1{color:" . $wp_star_fill_color1 . "  !important;}";
				
			}
	if ($review_template == 3) {

				
				 $custom_css .= "	.temp3progress5{background-color:" . $wp_pbar_fill_color5 . "  !important;}";
				 $custom_css .= "	.temp3star5{color:" . $wp_star_fill_color5 . "  !important;}";
				 $custom_css .= "	.temp1averagestar{color:" . $wp_average_star_color . "  !important;}";
				 $custom_css .= "	.temp3strokestar{stroke:" . $wp_circle_stroke_color . "  !important;}";
				 $custom_css .= "	.temp3strokestaraverage{color:" . $wp_circle_stroke_color . "  !important;}";
				$custom_css .= "	.rating .temp3background_progress_bar{height:" . $wp_progress_bar_height . "px;}";
				$fill_height = $wp_progress_bar_height;


				 $custom_css .= "	.rating_wrapper .temp3background_progress_bar_height{height:" . $fill_height . "px;}";

				 

				$custom_css .= "	.temp3progress4{background-color:" . $wp_pbar_fill_color4 . " !important;}";
				$custom_css .= "	.temp3star4{color:" . $wp_star_fill_color4 . "  !important;}";
				
				 
				 $custom_css .= "	.temp3progress3{background-color:" . $wp_pbar_fill_color3 . " !important;}";
				 $custom_css .= "	.temp3star3{color:" . $wp_star_fill_color3 . "  !important;}";
				$custom_css .= "	.wcrr_average_star .wcrr_av_score3:before{color:" . $three_star_fill_color . " !important;}";

				 
				$custom_css .= "	.temp3progress2{background-color: " . $wp_pbar_fill_color2 . " !important;}";
				$custom_css .= "	.temp3star2{color:" . $wp_star_fill_color2 . "  !important;}";
				
				 $custom_css .= "	.temp3progress1{background-color: " . $wp_pbar_fill_color1 . " !important;}";
				 $custom_css .= "	.temp3star1{color:" . $wp_star_fill_color1 . "  !important;}";
			}
			if ($review_template == 4) {

				
				 $custom_css .= "	.temp4progress5{background-color:" . $wp_pbar_fill_color5 . "  !important;}";
				 $custom_css .= "	.temp4star5{color:" . $wp_star_fill_color5 . "  !important;}";
				 $custom_css .= "	.rating .temp4background_progress_bar{height:" . $wp_progress_bar_height . "px;}";
				 
				 $fill_height = $wp_progress_bar_height;


				 $custom_css .= "	.rating .temp4background_progress_bar_height{height:" . $fill_height . "px;}";



				 $custom_css .= "	.temp1averagestar{color:" . $wp_average_star_color . "  !important;}";
				 $custom_css .= "	.temp3strokestar{stroke:" . $wp_circle_stroke_color . "  !important;}";
				 $custom_css .= "	.temp4strokestaraverage{color:" . $wp_circle_stroke_color . "  !important;}";
				

				

				$custom_css .= "	.temp4progress4{background-color:" . $wp_pbar_fill_color4 . " !important;}";
				$custom_css .= "	.temp4star4{color:" . $wp_star_fill_color4 . "  !important;}";
				
				 
				 $custom_css .= "	.temp4progress3{background-color:" . $wp_pbar_fill_color3 . " !important;}";
				 $custom_css .= "	.temp4star3{color:" . $wp_star_fill_color3 . "  !important;}";


				 
				$custom_css .= "	.temp4progress2{background-color: " . $wp_pbar_fill_color2 . " !important;}";
				$custom_css .= "	.temp4star2{color:" . $wp_star_fill_color2 . "  !important;}";
				
				 $custom_css .= "	.temp4progress1{background-color: " . $wp_pbar_fill_color1 . " !important;}";
				 $custom_css .= "	.temp4star1{color:" . $wp_star_fill_color1 . "  !important;}";
			}
			if ($review_template == 5) {

				$custom_css .= "	.temp5averagestarbackground{color:" . $wp_average_star_background_color . "  !important;}";
				 $custom_css .= "	.temp5averagestar{color:" . $wp_average_star_color . "  !important;}";
				$custom_css .= "	.temp5star5{background-color:" . $wp_star_fill_color5 . "  !important;}";
				$custom_css .= "	.temp5star4{background-color:" . $wp_star_fill_color4 . "  !important;}";
				$custom_css .= "	.temp5star3{background-color:" . $wp_star_fill_color3 . "  !important;}";
				$custom_css .= "	.temp5star2{background-color:" . $wp_star_fill_color2 . "  !important;}";
				$custom_css .= "	.temp5star1{background-color:" . $wp_star_fill_color1 . "  !important;}";
				$custom_css .= "	.rating .temp5background_progress_bar{height:" . $wp_progress_bar_height . "px;}";

				$fill_height = $wp_progress_bar_height;


				 $custom_css .= "	.rating .temp5background_progress_bar_height{height:" . $fill_height . "px;}";
			}
			if ($review_template == 6) {	

				
				 $custom_css .= "	.temp6progress5{background-color:" . $wp_pbar_fill_color5 . "  !important;}";
				 $custom_css .= "	.temp6star5{color:" . $wp_star_fill_color5 . "  !important;}";
				 $custom_css .= "	.rating .temp6background_progress_bar{height:" . $wp_progress_bar_height . "px;}";
				 $custom_css .= "	.rating .temp6background_progress_bar{height:" . $wp_progress_bar_height . "px;}";

				 $fill_height = $wp_progress_bar_height;


				 $custom_css .= "	.rating .temp6background_progress_bar_height{height:" . $fill_height . "px;}";


				 
				 $custom_css .= "	.temp6strokestar{stroke:" . $wp_circle_stroke_color . "  !important;}";
				 
				 
				

				

				$custom_css .= "	.temp6progress4{background-color:" . $wp_pbar_fill_color4 . " !important;}";
				$custom_css .= "	.temp6star4{color:" . $wp_star_fill_color4 . "  !important;}";
				
				 
				 $custom_css .= "	.temp6progress3{background-color:" . $wp_pbar_fill_color3 . " !important;}";
				 $custom_css .= "	.temp6star3{color:" . $wp_star_fill_color3 . "  !important;}";


				 
				$custom_css .= "	.temp6progress2{background-color: " . $wp_pbar_fill_color2 . " !important;}";
				$custom_css .= "	.temp6star2{color:" . $wp_star_fill_color2 . "  !important;}";
				
				 $custom_css .= "	.temp6progress1{background-color: " . $wp_pbar_fill_color1 . " !important;}";
				 $custom_css .= "	.temp6star1{color:" . $wp_star_fill_color1 . "  !important;}";
			}
			if ($review_template == 7) {

				
				 $custom_css .= "	.temp7progress5{background-color:" . $wp_pbar_fill_color5 . "  !important;}";
				 $custom_css .= "	.temp7star5{color:" . $wp_star_fill_color5 . "  !important;}";
				  $custom_css .= "	.rating .temp7background_progress_bar{height:" . $wp_progress_bar_height . "px;}";
				  $fill_height = $wp_progress_bar_height;


				 $custom_css .= "	.rating .temp7background_progress_bar_height{height:" . $fill_height . "px;}";


				 
				 $custom_css .= "	.temp7averagestar{color:" . $wp_average_star_color . "  !important;}";
				 $custom_css .= "	.temp7averagestarbackground{color:" . $wp_average_star_background_color . "  !important;}";
				 
				 
				

				

				$custom_css .= "	.temp7progress4{background-color:" . $wp_pbar_fill_color4 . " !important;}";
				$custom_css .= "	.temp7star4{color:" . $wp_star_fill_color4 . "  !important;}";
				
				 
				 $custom_css .= "	.temp7progress3{background-color:" . $wp_pbar_fill_color3 . " !important;}";
				 $custom_css .= "	.temp7star3{color:" . $wp_star_fill_color3 . "  !important;}";


				 
				$custom_css .= "	.temp7progress2{background-color: " . $wp_pbar_fill_color2 . " !important;}";
				$custom_css .= "	.temp7star2{color:" . $wp_star_fill_color2 . "  !important;}";
				
				 $custom_css .= "	.temp7progress1{background-color: " . $wp_pbar_fill_color1 . " !important;}";
				 $custom_css .= "	.temp7star1{color:" . $wp_star_fill_color1 . "  !important;}";
			}
			if ($review_template == 8) {

				
				 $custom_css .= "	.temp8progress5{background-color:" . $wp_pbar_fill_color5 . "  !important;}";
				 $custom_css .= "	.temp8star5{color:" . $wp_star_fill_color5 . "  !important;}";
				 $custom_css .= "	.rating .temp8background_progress_bar{height:" . $wp_progress_bar_height . "px;}";
				 		  $fill_height = $wp_progress_bar_height;


				 $custom_css .= "	.rating .temp8background_progress_bar_height{height:" . $fill_height . "px;}";


				 $custom_css .= "	.temp8strokestaraverage{color:" . $wp_circle_stroke_color . "  !important;}";
				

				 

				$custom_css .= "	.temp8progress4{background-color:" . $wp_pbar_fill_color4 . " !important;}";
				$custom_css .= "	.temp8star4{color:" . $wp_star_fill_color4 . "  !important;}";
				
				 
				 $custom_css .= "	.temp8progress3{background-color:" . $wp_pbar_fill_color3 . " !important;}";
				 $custom_css .= "	.temp8star3{color:" . $wp_star_fill_color3 . "  !important;}";

			

				 
				$custom_css .= "	.temp8progress2{background-color: " . $wp_pbar_fill_color2 . " !important;}";
				$custom_css .= "	.temp8star2{color:" . $wp_star_fill_color2 . "  !important;}";
				
				 $custom_css .= "	.temp8progress1{background-color: " . $wp_pbar_fill_color1 . " !important;}";
				 $custom_css .= "	.temp8star1{color:" . $wp_star_fill_color1 . "  !important;}";
			}
			wp_add_inline_style('wpic-wcprogressbar-css', $custom_css);
		}






		function wcrr_update_template_name($data)
		{
			$plugin_settings = maybe_unserialize(get_option('wcr_options_group'));
			$plugin_settings['review_template'] = $data['tempname'];

			update_option('wcr_options_group', serialize($plugin_settings));
			return $data;
		}



		function wcrr_review_markup_via_shortcode($atts)
		{
			$html = '';
			$atts = shortcode_atts(array(
				'product_id' => '',
			), $atts);

			$product_id = isset($atts['product_id']) ? $atts['product_id'] : null;
			if ($product_id) {
				$html = $this->wcrr_prepare_review_markup($product_id);
			}
			return $html;
		}

		/**
		 * Get Number of ratings of rating status of current products
		 * @param int $rating_number rating number of product like- 5*,4*,3*,2* 
		 * @param int $product_id product id
		 * @return int 
		 */
		function wcrr_get_number_ratings($rating_number, $product_id)
		{

			global $wpdb;

			$no_of_ratings = $wpdb->get_var(
				$wpdb->prepare(

					"SELECT COUNT(*) FROM $wpdb->commentmeta
				LEFT JOIN $wpdb->comments ON $wpdb->commentmeta.comment_id = $wpdb->comments.comment_ID
				WHERE meta_key = 'rating'
				AND comment_post_ID = %d
				AND comment_approved = '1'
				AND meta_value = %d
			",
					$product_id,
					$rating_number
				)
			);

			return $no_of_ratings;
		}


		function wcrr_prepare_review_markup1($product_id)
		{


			$plugin_settings = maybe_unserialize(get_option('wcr_options_group'));

			if (empty($plugin_settings['wp_enable_rate_review']))
				return;

			if (!empty($plugin_settings['wphp_exclude_products']) && in_array($product_id, $plugin_settings['wphp_exclude_products']))
				return;

			$product = new WC_Product($product_id);

			$wp_pbar_bg_color = (!empty($plugin_settings['wp_pbar_bg_color'])) ? $plugin_settings['wp_pbar_bg_color'] : '';
			$wp_pbar_fill_color = (!empty($plugin_settings['wp_pbar_fill_color'])) ? $plugin_settings['wp_pbar_fill_color'] : '';
			$wp_progress_bar_height = (!empty($plugin_settings['wp_progress_bar_height'])) ? $plugin_settings['wp_progress_bar_height'] : 5;
			$selected_tempalte = (!empty($plugin_settings['review_template'])) ? $plugin_settings['review_template'] : 'singlecolor';
			$total_review_count = $product->get_review_count();
			$rating_count = $product->get_rating_count();
			$average      = $product->get_average_rating();

			$html = '';

			if ($rating_count) {

				$average_percentage  = $average * 20;
				$complete_number = floor($average);

				$html .= '<div class="wcrrp_product_review_wrapper ' . $selected_tempalte . ' ">
					<div class="wcrr_average_review_rating">';


				switch ($selected_tempalte) {
					case 'multicolor_circle':


						$totalWidth = 284;
						$new_width = ($average_percentage / 100) * $totalWidth;
						$html .= '<div class="star_rating_point">
								<span>' . $average . '</span>
								<svg viewBox="0 0 100 100">
									<circle cx="50" cy="50" r="45" id="gray"></circle>
									<circle cx="50" cy="50" r="45" id="circle_fill" class="c_fill" style="stroke-dasharray: ' . $new_width . ', 284;"></circle>
								</svg>
							</div>

							<div class="prd_ratings"><span class="star"><span style="width:' . $average_percentage . 'px"></span></span></div></div>';

						$html .= '<div class="wcrr_total_review_rating">';
						for ($i = 5; $i >= 1; $i--) {
							$no_of_ratings_for_star = $this->wcrr_get_number_ratings($i, $product_id);
							$html .= '<div class="wcrr_rating_wrapper rating_number' . $i . '"><em>' . $i . ' </em>';
							$html .= '<div style="float:left;width:10%;display:inline-block;"><span class="wcrr_average_star"></span></div>';
							$width = ($no_of_ratings_for_star / $rating_count) * 100;
							$html .= '<div class="w3-light-grey">
											<div class="w3-grey" style="width:' . $width . '%"></div>
										</div>';
							$html .= '<span class="no_of_ratings_for_star">' . $no_of_ratings_for_star . '</span>';
							$html .= '</div>';
						}


						break;

					default:
						# code...

						$html .= '<div class="wcrr_total_avrage_rating">
									<span>' . $average . '</span>
									<span class="wcrr_average_star">
										<strong class=wcrr_av_score' . $selected_tempalte . ' style="width:100%">1</strong>
									</span>
								</div>
								<div class="wcrr_rating_review_summary">
									<span>' . $rating_count . ' Ratings</span>
									<span> & </span>
									<span>' . $total_review_count . ' Reviews</span>
								</div>
							</div>';

						$html .= '<div class="wcrr_total_review_rating">';
						for ($i = 5; $i >= 1; $i--) {
							$no_of_ratings_for_star = $this->wcrr_get_number_ratings($i, $product_id);
							$html .= '<div class="wcrr_rating_wrapper rating_number' . $i . '"><em>' . $i . ' </em>';
							$html .= '<div style="float:left;width:10%;display:inline-block;"><span class="wcrr_average_star"></span></div>';
							$width = ($no_of_ratings_for_star / $rating_count) * 100;
							$html .= '<div class="w3-light-grey">
									  <div class="w3-grey" style="width:' . $width . '%"></div>
									</div>';
							$html .= '<span class="no_of_ratings_for_star">' . $no_of_ratings_for_star . '</span>';
							$html .= '</div>';
						}

						break;
				}
				$html .= '</div></div>';
			}
			return $html;
		}

		function wcrr_prepare_review_markup($product_id)
		{


					$plugin_settings = maybe_unserialize(get_option('wcr_options_group'));

					if (empty($plugin_settings['wp_enable_rate_review']))
						return;

					if (!empty($plugin_settings['wphp_exclude_products']) && in_array($product_id, $plugin_settings['wphp_exclude_products']))
						return;

					$product = new WC_Product($product_id);

					$wp_pbar_bg_color = (!empty($plugin_settings['wp_pbar_bg_color'])) ? $plugin_settings['wp_pbar_bg_color'] : '';
					$wp_pbar_fill_color = (!empty($plugin_settings['wp_pbar_fill_color'])) ? $plugin_settings['wp_pbar_fill_color'] : '';
					$wp_progress_bar_height = (!empty($plugin_settings['wp_progress_bar_height'])) ? $plugin_settings['wp_progress_bar_height'] : 5;
					$selected_tempalte = (!empty($plugin_settings['review_template'])) ? $plugin_settings['review_template'] : 'singlecolor';
					$total_review_count = $product->get_review_count();
					$rating_count = $product->get_rating_count();
					$average      = $product->get_average_rating();
					

					if ($rating_count) {

						$average_percentage  = $average * 20;
						$complete_number = floor($average);

						?>

							<div class="wcrrp_product_review_wrapper <?php echo $selected_tempalte; ?> ">
								<h2>Reviews & Ratings</h2>
								<div class="wcrr_average_review_rating">

									<?php
									switch ($selected_tempalte) {


										case '3':
										$totalWidth = 284;
								$new_width = ($average_percentage / 100) * $totalWidth;


			
								
									?>
									
											<div class="rating">
												<div id="div1">
													<div class="star_rating_point">
									<span class="temp3strokestaraverage"> <?php echo $average; ?></span>
									<svg viewBox="0 0 100 100">
										<circle cx="50" cy="50" r="45" id="gray"></circle>
										<circle cx="50" cy="50" r="45" id="circle_fill" class="c_fill temp3strokestar" style="stroke-dasharray: <?php echo $new_width ?>, 284;"></circle>
									</svg>
								</div>

													<div id="div12">
														
														<div class="prd_ratings"><span class="star"><span class="temp3strokestaraverage" style="width: <?php echo $average_percentage; ?>px"></span></span></div>
													</div>
												</div>
												<div id="div2">
													
													<div class="progressbar_wrapper">
													<?php

													for ($i = 5; $i >= 1; $i--) {
														$no_of_ratings_for_star = $this->wcrr_get_number_ratings($i, $product_id);
														$width = ($no_of_ratings_for_star / $rating_count) * 100;
													?>
														<div class="rating_progressbar">
															<div class="rating_number"><?php echo $i; ?></div>
															<div class="rating_icon temp3star<?php echo $i; ?>"><i class="fa-sharp fa-solid fa-star"></i></div>
															<div class="background_progress_bar temp3background_progress_bar">
																<div class="fill_progress_bar temp3background_progress_bar temp3progress<?php echo $i; ?>" style="width:<?php echo $width; ?>%"></div>
															</div>
															<div class="rating_number"><?php echo $no_of_ratings_for_star; ?></div>
														</div>

													<?php
													}
													?>
												</div>
													
												</div>
											</div>
										<?php
											// code...
											break;

										case '2':
										?>
											<div class="rating_wrapper">
												<div class="rating_summary_wrapper">
													<div class="average_rating_wrapper">
														<div class="average_rating"><?php echo $average; ?></div>
														<div class="average_rating_icon"><i class="fa-sharp fa-solid fa-star temp2averagestar"></i></div>

													</div>
													<div class="total_rating_reviews"><?php echo $rating_count; ?> Ratings & <?php echo $total_review_count; ?> Reviews</div>
												</div>
												<div class="progressbar_wrapper">
													<?php

													for ($i = 5; $i >= 1; $i--) {
														$no_of_ratings_for_star = $this->wcrr_get_number_ratings($i, $product_id);
														$width = ($no_of_ratings_for_star / $rating_count) * 100;
													?>
														<div class="rating_progressbar">
															<div class="rating_number"><?php echo $i; ?></div>
															<div class="rating_icon temp2star<?php echo $i; ?>"><i class="fa-sharp fa-solid fa-star"></i></div>
															<div class="temp2background_progress_bar background_progress_bar ">
																<div class="fill_progress_bar temp2background_progress_bar temp2progress<?php echo $i; ?>" style="width:<?php echo $width; ?>%"></div>
															</div>
															<div class="rating_number"><?php echo $no_of_ratings_for_star; ?></div>
														</div>

													<?php
													}
													?>
												</div>
											</div>
										<?php
											break;
										case '1':
										?>
											<div class="rating_wrapper">
												<div class="rating_summary_wrapper">
													<div class="average_rating_wrapper">
														<div class="average_rating"><?php echo $average; ?></div>
														<div class="average_rating_icon"><i class="fa-sharp fa-solid fa-star temp1averagestar"></i></div>

													</div>
													<div class="total_rating_reviews"><?php echo $rating_count; ?> Ratings & <?php echo $total_review_count; ?> Reviews</div>
												</div>
												<div class="progressbar_wrapper">
													<?php

													for ($i = 5; $i >= 1; $i--) {
														$no_of_ratings_for_star = $this->wcrr_get_number_ratings($i, $product_id);
														$width = ($no_of_ratings_for_star / $rating_count) * 100;
													?>
														<div class="rating_progressbar">
															<div class="rating_number"><?php echo $i; ?></div>
															<div class="rating_icon"><i class="fa-sharp fa-solid fa-star temp1star<?php echo $i; ?>"></i></div>
															<div class="background_progress_bar temp1background_progress_bar">
																<div class="fill_progress_bar temp1background_progress_bar_height temp1progress<?php echo $i; ?>" style="width:<?php echo $width; ?>%"></div>
															</div>
															<div class="rating_number"><?php echo $no_of_ratings_for_star; ?></div>
														</div>

													<?php
													}
													?>
												</div>
											</div>
										<?php
											break;
										case '4':
										?>
											
											<div class="rating">
												<div id="div1">
													<div class="div01"><?php echo $average; ?></div>
													<div id="div12">
														
														<div class="prd_ratings"><span class="star temp4-star"><span class="temp4strokestaraverage" style="width: <?php echo $average_percentage; ?>px"></span></span></div>
													</div>
													<div class="div03">
														<i class="fa-solid fa-user temp4userspace"></i><?php echo $total_review_count; ?> Total
													</div>

												</div>
												<div class="progressbar_wrapper">
													<?php

													for ($i = 5; $i >= 1; $i--) {
														$no_of_ratings_for_star = $this->wcrr_get_number_ratings($i, $product_id);
														$width = ($no_of_ratings_for_star / $rating_count) * 100;
														$percentage=ceil($width);
													?>
														<div class="rating_progressbar">
															<div class="rating_number"><?php echo $i; ?></div>
															<div class="rating_icon"><i class="fa-sharp fa-solid fa-star temp4star<?php echo $i; ?>"></i></div>
															<div class="div214 temp4background_progress_bar">
																<span id="span"><?php echo $percentage; ?>%</span>
																<div class="div231 temp4background_progress_bar_height temp4progress<?php echo $i; ?>" style="width:<?php echo $width; ?>%"></div>
															</div>
														</div>

													<?php
													}
													?>
												</div>
											</div>
										<?php
											// code...
											break;

										case '5':
										?>
											
											<div class="rating">
												<div id="div1">
													<div class="div01">Product Rating</div>

												</div>
												<div class="progressbar_wrapper">
													<?php
													for ($i = 5; $i >= 1; $i--) {
														$no_of_ratings_for_star = $this->wcrr_get_number_ratings($i, $product_id);

														$width = round(($no_of_ratings_for_star / $rating_count) * 5);
													?>
														<div class="rating_progressbar">
															<div class="div212 temp5star<?php echo $i; ?>"><?php echo $i; ?></div>
															<div class="div214 temp5background_progress_bar">
																<?php for ($j = 1; $j <= 5; $j++) {
																	if ($i >= $j) {
																?>
																		<i class="fa-sharp fa-solid fa-star temp5averagestar temp5background_progress_bar_height" id="st1"></i>
																	<?php
																	} else {
																	?>

																		<i class="fa-sharp fa-solid fa-star temp5averagestarbackground temp5background_progress_bar_height" id="st2"></i>
																<?php
																	}
																} ?>
															</div>
															<div class="rating_number"><?php echo $no_of_ratings_for_star; ?></div>
														</div>

													<?php
													}
													?>
													
												</div>
											</div>
										<?php
											break;
										case '6':
										?>
											
											<div class="rating">
												<div id="div1">
													<div id="div11">
														<svg viewBox="0 0 24 24" id="star_filled" data-name="star filled" xmlns="http://www.w3.org/2000/svg" fill="#000000">
															<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
															<g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
															<g id="SVGRepo_iconCarrier">
																<rect id="Rectangle_4" data-name="Rectangle 4" width="24" height="24" fill="none"></rect>
																<path id="Star" class="temp6strokestar" d="M10,15,4.122,18.09l1.123-6.545L.489,6.91l6.572-.955L10,0l2.939,5.955,6.572.955-4.755,4.635,1.123,6.545Z" transform="translate(2 3)" stroke-miterlimit="10" stroke-width="1.5"></path>
															</g>
														</svg>
														<em class="temp6strokestarnumber"><?php echo $average; ?></em>
													</div>
													<div id="div12">Average Rating Based on <?php echo $rating_count; ?></div>
													<div id="div13">Ratings.</div>
												</div>
												<div class="progressbar_wrapper">
													<?php
													for ($i = 5; $i >= 1; $i--) {
														$no_of_ratings_for_star = $this->wcrr_get_number_ratings($i, $product_id);

														$width = round(($no_of_ratings_for_star / $rating_count) * 10);
														$new_widthtem6=$width  * 10;
													?>
														<div class="rating_progressbar">
															<div class="div212"><?php echo $i; ?></div>
															<div class="div213"><i class="fa-sharp fa-solid fa-star temp6star<?php echo $i; ?>"></i></div>
															<div class="div214 temp6background_progress_bar">
																<div class="div231 temp6background_progress_bar_height temp6progress<?php echo $i; ?>" style="width:<?php echo $new_widthtem6; ?>%"><?php echo $width; ?></div>
															</div>
														</div>

													<?php
													}
													?>
												</div>
											</div>
										<?php
											// code...
											break;
										case '7':
										?>
											
											<div class="rating">
												<div id="div1">
													<div class="div1a">Rating Overview</div>
													<div class="div1b">
														<div class="div1b1"><?php echo $average; ?></div>
														<div class="div1b2">/5</div>
													</div>
													<div class="div1c">
													<?php
													for ($j = 1; $j<=5; $j++) {
														if($j<= $average){
															?>
															<i class="fa-sharp fa-solid fa-star temp7averagestar"></i>
													<?php 	}else{ ?>
															<i class="fa-sharp temp7averagestarbackground"></i>
															
													<?php 	}

													}
													
													?>
														
													</div>
													<div class="div1d"><?php echo $rating_count; ?> Ratings</div>

												</div>
												<div class="progressbar_wrapper">
													<?php
													for ($i = 5; $i >= 1; $i--) {
														$no_of_ratings_for_star = $this->wcrr_get_number_ratings($i, $product_id);

														$width = round(($no_of_ratings_for_star / $rating_count) * 10);
														$new_widthtem7=$width  * 10;
													?>
														<div class="rating_progressbar">
															<div class="div21a"><?php echo $i; ?></div>
															
															<div class="div213"><i class="fa-sharp fa-solid fa-star temp7star<?php echo $i; ?>"></i></div>
															<div class="div214 temp7background_progress_bar">
																<div class="div231 temp7background_progress_bar_height temp7progress<?php echo $i; ?>" style="width:<?php echo $new_widthtem7; ?>%"></div>
															</div>
															<div class="div212"><?php echo $no_of_ratings_for_star; ?></div>
														</div>

													<?php
													}
													?>
												</div>


											</div>
										<?php
											// code...
											break;
										case '8':
										?>
											
											<div class="rating">
												<div id="div1">
													<div class="div01"><?php echo $average; ?></div>
													<div class="div02">
														<div class="prd_ratings tem8averagestart"><span class="star"><span class="temp8strokestaraverage" style="width: <?php echo $average_percentage; ?>px"></span></span></div>
													</div>
													<div class="div03">
														<i class="fa-solid fa-user temp8userspace"></i><?php echo $total_review_count; ?> Total
													</div>

												</div>
												<div class="progressbar_wrapper">
													<?php

													for ($i = 5; $i >= 1; $i--) {
														$no_of_ratings_for_star = $this->wcrr_get_number_ratings($i, $product_id);
														$width = ($no_of_ratings_for_star / $rating_count) * 100;
														$percentage=ceil($width);
													?>
														<div class="rating_progressbar">
															<div class="rating_number"><?php echo $i; ?></div>
															<div class="rating_icon"><i class="fa-sharp fa-solid fa-star temp8star<?php echo $i; ?>"></i></div>
															<div class="div214 temp8background_progress_bar">
																<span id="span"><?php echo $percentage; ?>%</span>
																<div class="div231 temp8background_progress_bar_height temp8progress<?php echo $i; ?>" style="width:<?php echo round($width,2); ?>%"></div>
															</div>
														</div>

													<?php
													}
													?>
												</div>

												


											</div>
										<?php
											// code...
											break;
										default:


											# code...
										?>

											<div class="wcrr_total_avrage_rating">
												<span><?php echo $average; ?></span>
												<span class="wcrr_average_star">
													<strong class=wcrr_av_score'.$selected_tempalte.' style="width:100%">1</strong>
												</span>
											</div>
											<div class="wcrr_rating_review_summary">
												<span><?php echo $rating_count . ' Ratings'; ?>1</span>
												<span> & </span>
												<span><?php echo $total_review_count . ' Reviews'; ?></span>
											</div>
								</div>

								<div class="wcrr_total_review_rating">
									<?php

											for ($i = 5; $i >= 1; $i--) {
												$no_of_ratings_for_star = $this->wcrr_get_number_ratings($i, $product_id); ?>

										<div class="wcrr_rating_wrapper rating_number <?php echo $i; ?>"><em><?php echo $i; ?> </em>
											<div style="float:left;width:10%;display:inline-block;"><span class="wcrr_average_star"></span></div>
											<?php $width = ($no_of_ratings_for_star / $rating_count) * 100; ?>
											<div class="w3-light-grey">
												<div class="w3-grey" style="width: <?php echo $width; ?>"></div>
											</div>
											<span class="no_of_ratings_for_star"><?php echo $no_of_ratings_for_star; ?></span>
										</div>
							<?php
											}
											// code...
											break;
									}

							?>
								</div>
							</div>
			<?php
					}

					$html = ob_get_contents();
					ob_clean();
					return $html;
				}

				/**
				 * Show Rating markup on product page
				 * 
				 * @param html @html 
				 */
				function wcrr_enhance_review_rating($html)
				{
					global $product, $post;
					$is_product_single = ($post->post_type == 'product' && is_single()) ? true : false;
					if (!$is_product_single)
						return;

					echo do_shortcode('[wp_rate_review product_id="' . $post->ID . '"]');
				}

				/**
				 * Main WCRR_Rate_Review Instance		
				 *
				 * @since 1.0.0
				 * @see instance()
				 * @return instance
				 */

				public static function instance()
				{
					if (is_null(self::$instance)) {
						self::$instance = new self();
					}
					return self::$instance;
				}

				/**
				 * Initializes the extension.
				 *
				 * @since 1.0.0
				 * @return Object Instance of extension.

				 */

				public static function wcrr_init()
				{

					$GLOBALS['wcrr_rate_review'] = WCRR_Rate_Review::instance();
				}


				/**
				 * Entry point of plugin
				 * 
				 * @since 1.0.0
				 */
				public static function init()
				{
					add_action('plugins_loaded', array(__CLASS__, 'wcrr_init'));
				}
			}

			WCRR_Rate_Review::init();
		}
