<?php

/**
 * Class WCRR_Admin_Menu
 *
 */
class WCRR_Admin_Menu
{

	/**
	 * Class constructor.
	 */
	public function __construct()
	{

			// Load plugin setttings menu
			add_action( 'admin_menu', array($this,'wcrr_plugin_menu' ));
			
			// Load css ad js files for plugin's admin pages
			add_action( 'admin_enqueue_scripts', array($this,'wcrr_enqueue_admin_script' ));
		    
			// Init function for check save settings
			add_action( 'admin_init', array($this,'wcrr_plugin_settings' ));
	}
		
	
	
		/**
		 * WP Rate And Review Plugins Menu
		 * 
		 */
		function wcrr_plugin_menu(){

			add_menu_page( 
				__('WP Rate And Review ', 'wp-rate-and-review' ),
				__('WP Rate And Review','wp-rate-and-review'),
				'manage_options',
				'wp_rate_overview',
				array($this,'wcrr_plugin_overview'),
	      		'dashicons-welcome-widgets-menus');

			add_submenu_page( 'wp_rate_overview',
			 __('Settings','wp-rate-and-review'), 
			 __('Settings','wp-rate-and-review'),
	    	'manage_options',
	    	'wcr_rate_review_settings',
	    	array($this,'wcrr_setting_page'));
		}

		function wcrr_plugin_overview(){
			global $wcrr_rate_review;

			ob_start();
			require_once(WCRR_VIEWS."/welcome.php");
			$welcome = ob_get_contents();
			ob_clean();
			echo $welcome;
		}


		function wcrr_setting_page(){

	    	if(!empty($this->result) && array_key_exists('error',$this->result) ){
	    			echo "<div class='error notice is-dismissible'><p><strong>".$this->result['error']."</strong></p><button type='button' class='notice-dismiss'><span class='screen-reader-text'>Dismiss this notice.</span></button></div>";
	    	}else if(!empty($this->result) &&  array_key_exists('success',$this->result)){
	    			echo "<div class='updated published'><p>".$this->result['success']."</p></div>";
	    	}
	    	$plugin_setting_markup = '';
	    	ob_start(); 
	    	require_once(WCRR_VIEWS."/settings.php");
			$plugin_setting_markup .= ob_get_contents();
			ob_clean();
			echo $plugin_setting_markup;
		}

		function wcrr_enqueue_admin_script($hook){

			if($hook=='toplevel_page_wp_rate_overview' || $hook=='wp-rate-and-review_page_wcr_rate_review_settings'){
					$plugin_settings = maybe_unserialize(get_option('wcr_options_group'));

					wp_enqueue_style( 'wp-color-picker' ); 
					wp_enqueue_style( 'wpic-slick-css', WCRR_CSS.'/slick.css');
					wp_enqueue_style( 'wpic-admin-css', WCRR_CSS.'/wpic-admin.css',array(),rand(10,100));
					wp_enqueue_style( 'select2-min-css', WCRR_CSS.'/select2.min.css');
					wp_enqueue_script( 'select2-min-js', WCRR_JS.'/select2.min.js');
					wp_enqueue_script( 'silk-min-js', WCRR_JS.'/slick.min.js');
					wp_enqueue_script( 'wpic-admin-js', WCRR_JS.'/wpic-admin.js',array( 'wp-color-picker' ), rand(10,100), true);

					wp_localize_script( 'wpic-admin-js', 'wcrr_ajax_obj', array(
						'ajax_url' => admin_url('admin-ajax.php'),
						'nonce'=> wp_create_nonce('wcrr_nonce_value'),
						'active_template'=>isset($plugin_settings['review_template']) ? $plugin_settings['review_template'] :'singlecolor'				
					));

			} 

		}

		/* Redirect */
		function wcrr_redirect( $url ) {
			?>
			<script type="text/javascript">
			window.location = "<?php echo esc_url_raw($url); ?>";
			</script>
			<?php 
		}

		function wcrr_plugin_settings(){


			$settings = array();
			register_setting( 'wcr_options_group','wcr_options_group');

 
			if(isset($_POST) && isset($_POST['action']) && ( sanitize_text_field( wp_unslash($_POST['action']))=="rating-form")  ){
				
				if ( isset( $_POST['wcr_nonce'] ) ) {
				 $nonce = sanitize_text_field( wp_unslash( $_POST['wcr_nonce'] ) );
			 }
			   $checknonce = wp_verify_nonce($nonce,'wcr');
				   if($checknonce){
					   $error=false;
					   if(!$error){ 

							unset($_POST['wcr_nonce']);
							unset($_POST['submit']);
							unset($_POST['action']);

							foreach($_POST as $key=>$posted_value){
								if(!empty($posted_value)){
									$settings[$key] = (!empty( $posted_value)) ? sanitize_text_field( wp_unslash( $posted_value ) ) : '';
								}
							}
						   update_option('wcr_options_group',$settings);
						   $this->result['success'] = esc_html__('Settings Saved Successfully.','wp-rate-and-review');
						   $this->wcrr_redirect("admin.php?page=wcr_rate_review_settings");
						}
				   }else{
					   wp_die('Cheating');
				   }
			}
		 }


}
