<?php
/**
 * Malcure Malware Removal, Monitor and Security Hardening
 *
 * @package     Malcure Malware Removal, Monitor and Security Hardening
 * @author      Malcure
 * @copyright   2026 malcure.com
 * @license     MIT
 *
 * @wordpress-plugin
 * Plugin Name: Malcure Malware Removal, Monitor and Security Hardening
 * Description: Ultra-precision, comprehensive malware scanner and security hardening to protect your site and find viruses, infections & other security threats & vulnerabilities. Detects over 50,000+ security threats & vulnerabilities. Do not forget to report bugs and share your reviews.
 * Version:     19.5
 * Author:      Malcure
 * Author URI:  https://malcure.com
 * License:     MIT
 * License URI: https://opensource.org/licenses/MIT
 * Plugin URI:  https://malcure.com/?p=116&utm_source=plugin-header&utm_medium=web&utm_campaign=wpmr
 */

/*
███╗   ███╗ █████╗ ██╗      ██████╗██╗   ██╗██████╗ ███████╗    ███╗   ███╗ █████╗ ██╗     ██╗    ██╗ █████╗ ██████╗ ███████╗    ███████╗ ██████╗ █████╗ ███╗   ██╗███╗   ██╗███████╗██████╗
████╗ ████║██╔══██╗██║     ██╔════╝██║   ██║██╔══██╗██╔════╝    ████╗ ████║██╔══██╗██║     ██║    ██║██╔══██╗██╔══██╗██╔════╝    ██╔════╝██╔════╝██╔══██╗████╗  ██║████╗  ██║██╔════╝██╔══██╗
██╔████╔██║███████║██║     ██║     ██║   ██║██████╔╝█████╗      ██╔████╔██║███████║██║     ██║ █╗ ██║███████║██████╔╝█████╗      ███████╗██║     ███████║██╔██╗ ██║██╔██╗ ██║█████╗  ██████╔╝
██║╚██╔╝██║██╔══██║██║     ██║     ██║   ██║██╔══██╗██╔══╝      ██║╚██╔╝██║██╔══██║██║     ██║███╗██║██╔══██║██╔══██╗██╔══╝      ╚════██║██║     ██╔══██║██║╚██╗██║██║╚██╗██║██╔══╝  ██╔══██╗
██║ ╚═╝ ██║██║  ██║███████╗╚██████╗╚██████╔╝██║  ██║███████╗    ██║ ╚═╝ ██║██║  ██║███████╗╚███╔███╔╝██║  ██║██║  ██║███████╗    ███████║╚██████╗██║  ██║██║ ╚████║██║ ╚████║███████╗██║  ██║
╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝ ╚═════╝ ╚═════╝ ╚═╝  ╚═╝╚══════╝    ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝ ╚══╝╚══╝ ╚═╝  ╚═╝╚═╝  ╚═╝╚══════╝    ╚══════╝ ╚═════╝╚═╝  ╚═╝╚═╝  ╚═══╝╚═╝  ╚═══╝╚══════╝╚═╝  ╚═╝

			██████╗ ██╗   ██╗    ███████╗██╗  ██╗██╗██╗   ██╗
			██╔══██╗╚██╗ ██╔╝    ██╔════╝██║  ██║██║██║   ██║
█████╗      ██████╔╝ ╚████╔╝     ███████╗███████║██║██║   ██║
╚════╝      ██╔══██╗  ╚██╔╝      ╚════██║██╔══██║██║╚██╗ ██╔╝
			██████╔╝   ██║       ███████║██║  ██║██║ ╚████╔╝
			╚═════╝    ╚═╝       ╚══════╝╚═╝  ╚═╝╚═╝  ╚═══╝

*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'WPMR_PLUGIN_DIR_URL', trailingslashit( plugin_dir_url( __FILE__ ) ) );
define( 'WPMR_SERVER', 'https://wp-malware-removal.com/' );
define( 'WPMR_PLUGIN', __FILE__ );
define( 'WPMR_PLUGIN_DIR', trailingslashit( __DIR__ ) );
define( 'WPMR_SLUG', 'wp-malware-removal' );
define( 'WPMRNS', 'WPMR_' );

if ( ! defined( 'MALCURE_API' ) ) {
	define( 'MALCURE_API', 'https://malcure.com' );
}

if ( file_exists( WPMR_PLUGIN_DIR . 'inc/pro.php' ) ) {
	include_once WPMR_PLUGIN_DIR . 'inc/pro.php';
}

// Include trait files
require_once WPMR_PLUGIN_DIR . 'traits/wpmr_helpers.php';
require_once WPMR_PLUGIN_DIR . 'traits/wpmr_admin_ui.php';
require_once WPMR_PLUGIN_DIR . 'traits/wpmr_account_mgt.php';
require_once WPMR_PLUGIN_DIR . 'traits/wpmr_scanner.php';
require_once WPMR_PLUGIN_DIR . 'traits/wpmr_checksums.php';
require_once WPMR_PLUGIN_DIR . 'traits/wpmr_definitions.php';
require_once WPMR_PLUGIN_DIR . 'traits/wpmr_client_js.php';
require_once WPMR_PLUGIN_DIR . 'traits/wpmr_event_log.php';
require_once WPMR_PLUGIN_DIR . 'traits/wpmr_session_mgt.php';
require_once WPMR_PLUGIN_DIR . 'traits/wpmr_firewall.php';
require_once WPMR_PLUGIN_DIR . 'traits/wpmr_api_operations.php';
require_once WPMR_PLUGIN_DIR . 'traits/wpmr_stateful_scanner.php';

if ( defined( 'WP_CLI' ) && WP_CLI && file_exists( WPMR_PLUGIN_DIR . 'non-versioned/tools/cli.php' ) ) {
	require_once WPMR_PLUGIN_DIR . 'non-versioned/tools/cli.php';
}

if ( file_exists( WPMR_PLUGIN_DIR . 'non-versioned/tools/update-test-injector.php' ) ) {
	require_once WPMR_PLUGIN_DIR . 'non-versioned/tools/update-test-injector.php';
}

final class WPMR_Init {

	// 1. Helper functions
	use WPMR_Helpers;

	// 2. Admin and UI
	use WPMR_Admin_UI;

	// 3. Account & Registration
	use WPMR_Account_Mgt;

	// 5. Definition management
	use WPMR_Definitions;

	// 6. Checksum management
	use WPMR_Checksums;

	// 7. Malware detection and handling
	use WPMR_Scanner;
	use WPMR_Client_JS;

	// 8. Event tracking and forensics
	use WPMR_Events_Log;

	// 9. Session management
	use WPMR_Session_Mgt;

	// 10. Firewall management and proactive security
	use WPMR_Firewall;

	// 11. API operations
	use WPMR_API_Operations;

	// 12. Stateful Scanner
	use WPMR_Stateful_Scanner;

	public $timeout = 30;
	public $dir;
	public $url;
	public $file;

	private $maxsize    = 11534336; // Ensure this is larger than the largest file inside WordPress
	private $cap        = 'activate_plugins';
	private $page_hooks = array();

	public $plugin_data = false; // else php-8.2 warning

	/**
	 * Private constructor (singleton).
	 *
	 * @return void
	 */
	private function __construct() {
	}

	/**
	 * Get the singleton instance.
	 *
	 * @return self
	 */
	static function get_instance() {
		static $instance = null;
		if ( is_null( $instance ) ) {
			$instance = new self();
			$instance->init();
		}
		return $instance;
	}

	/**
	 * Register hooks and initialize runtime state.
	 *
	 * @return void
	 */
	function init() {

		// $this->raise_limits_conditionally();
		// =============================
		// 1. Basic Initialization
		// =============================
		$this->dir     = trailingslashit( plugin_dir_path( $this->normalise_path( __FILE__ ) ) );
		$this->file    = WPMR_PLUGIN;
		$this->url     = trailingslashit( plugin_dir_url( __FILE__ ) );
		$this->timeout = $this->get_remote_timeout();
		$this->maybe_load_default_definitions();

		// =============================
		// 2. Plugin Lifecycle & Scheduled Events
		// =============================
		register_deactivation_hook( WPMR_PLUGIN, array( $this, 'deactivate' ) );

		// Schedule cron events
		if ( ! wp_next_scheduled( 'wpmr_daily' ) ) {
			wp_schedule_event( time(), 'daily', 'wpmr_daily' );
		}
		if ( ! wp_next_scheduled( 'wpmr_hourly' ) ) {
			wp_schedule_event( time(), 'hourly', 'wpmr_hourly' );
		}

		// Cron event handlers
		add_action( 'wpmr_daily', array( $this, 'check_definitions' ) );
		// add_action( 'wpmr_daily', array( $this, 'send_weekly_digest' ) );
		add_action( 'wpmr_hourly', array( $this, 'automate_routines' ) );
		add_action( 'upgrader_process_complete', array( $this, 'refresh_component_checksums' ), 9999, 2 );

		// =============================
		// 3. Admin Interface & UI
		// =============================
		add_action( 'init', array( $this, 'set_plugin_data' ) );
		add_action( 'admin_init', array( $this, 'save_gsc_profile' ) );
		add_action( 'admin_init', array( $this, 'register_settings' ) );

		// Admin notices
		add_action( 'network_admin_notices', array( $this, 'admin_notice' ) );
		add_action( 'admin_notices', array( $this, 'admin_notice' ) );

		// Plugin page links
		add_filter( 'plugin_action_links_' . plugin_basename( WPMR_PLUGIN ), array( $this, 'plugin_action_links' ) );
		add_filter( 'plugin_row_meta', array( $this, 'plugin_meta_links' ), 10, 2 );

		// Admin menus and pages
		add_action( 'network_admin_menu', array( $this, 'add_admin_pages' ) );
		add_action( 'admin_menu', array( $this, 'add_admin_pages' ) );

		// Styles and scripts
		add_action( 'admin_enqueue_scripts', array( $this, 'wpmr_admin_styles' ) );
		add_action( 'admin_head', array( $this, 'wpmr_add_admin_inline_styles' ) );
		add_action( 'admin_footer', array( $this, 'js_lib' ), -999999 );
		add_action( 'admin_footer', array( $this, 'operations_overlay' ) );
		add_action( 'admin_footer', array( $this, 'scripts' ) );

		// Meta boxes
		add_action( 'add_meta_boxes', array( $this, 'remove_metaboxes' ) );
		add_action( 'check_ajax_referer', array( $this, 'prevent_meta_box_order' ) );
		add_filter( 'hidden_meta_boxes', array( $this, 'no_hidden_meta_boxes' ), 10, 3 );
		add_filter( 'get_user_metadata', array( $this, 'malcure_prevent_meta_box_order_retrieval' ), 10, 5 );

		// Admin body classes and update messages
		add_filter( 'admin_body_class', array( $this, 'admin_body_classes' ) );
		add_action( 'in_plugin_update_message-' . basename( WPMR_PLUGIN_DIR ) . '/' . basename( WPMR_PLUGIN ), array( $this, 'plugin_update_message' ), 10, 2 );

		// =============================
		// 4. AJAX Actions - Authenticated Users
		// =============================
		add_action( 'wp_ajax_wpmr_ajax_request', array( $this, 'wpmr_ajax_request' ) );
		add_action( 'wp_ajax_wpmr_get_stats', array( $this, 'wpmr_get_stats' ) );
		add_action( 'wp_ajax_wpmr_init_scan', array( $this, 'wpmr_init_scan' ) );
		add_action( 'wp_ajax_wpmr_scan_db', array( $this, 'wpmr_scan_db' ) );
		add_action( 'wp_ajax_wpmr_scan_files', array( $this, 'wpmr_scan_files' ) );
		add_action( 'wp_ajax_wpmr_clean_file', array( $this, 'wpmr_clean_file' ) );
		add_action( 'wp_ajax_wpmr_delete_file', array( $this, 'wpmr_delete_file' ) );
		add_action( 'wp_ajax_wpmr_whitelist_file', array( $this, 'wpmr_whitelist_file' ) );
		add_action( 'wp_ajax_wpmr_unwhitelist_file', array( $this, 'wpmr_unwhitelist_file' ) );
		add_action( 'wp_ajax_wpmr_inspect_file', array( $this, 'wpmr_inspect_file' ) );
		add_action( 'wp_ajax_wpmr_inspect_db_record', array( $this, 'wpmr_inspect_db_record' ) );
		add_action( 'wp_ajax_wpmr_whitelist_db_record', array( $this, 'wpmr_whitelist_db_record' ) );
		add_action( 'wp_ajax_wpmr_unwhitelist_db_record', array( $this, 'wpmr_unwhitelist_db_record' ) );
		add_action( 'wp_ajax_wpmr_clear_infection_stats', array( $this, 'wpmr_clear_infection_stats' ) );
		add_action( 'wp_ajax_wpmr_update_sigs', array( $this, 'update_definitions' ) );
		add_action( 'wp_ajax_wpmr_reset', array( $this, 'reset' ) );
		add_action( 'wp_ajax_wpmr_web_register', array( $this, 'wpmr_web_register' ) );
		add_action( 'wp_ajax_wpmr_refresh_checksums', array( $this, 'wpmr_refresh_checksums' ) );
		add_action( 'wp_ajax_wpmr_def_auto_update_enabled', array( $this, 'update_wpmr_def_auto_update' ) );
		add_action( 'wp_ajax_wpmr_license_action', array( $this, 'wpmr_license_action' ) );
		add_action( 'wp_ajax_wpmr_fetch_license_status', array( $this, 'ajax_get_license_status' ) );

		// =============================
		// 5. Security & Scanning Features
		// =============================
		add_action( 'plugins_loaded', array( $this, 'waf' ), -1 );
		add_action( 'wp_dashboard_setup', array( $this, 'dashboard_widget' ), 1 );
		add_filter( 'postbox_classes_toplevel_page_wpmr_wpmr_updates_box', array( $this, 'prompt_register' ) );
		add_filter( 'wpmr_skip_dir', array( $this, 'wpmr_skip_dir' ) );
		add_action( 'wpmr_diagnostics_row', array( $this, 'malcure_user_sessions' ) );

		// =============================
		// 6. Event Logging System
		// =============================

		// WordPress Updates
		add_action( 'automatic_updates_complete', array( $this, 'log_automatic_update' ) );
		add_action( 'upgrader_process_complete', array( $this, 'log_update_event' ), 10, 2 );

		// Plugin & Theme Switching
		add_action( 'activated_plugin', array( $this, 'log_plugin_toggle' ), 10, 2 );
		add_action( 'deactivated_plugin', array( $this, 'log_plugin_toggle' ), 10, 2 );
		add_action( 'switch_theme', array( $this, 'log_theme_activation' ) );

		// Plugin & Theme Deletion
		add_action( 'delete_plugin', array( $this, 'log_plugin_deletion' ) );
		add_action( 'deleted_theme', array( $this, 'log_theme_deletion' ) );

		// File Operations
		add_action( 'edit_file', array( $this, 'log_file_edit' ), 10, 2 );
		add_filter( 'wp_handle_upload', array( $this, 'log_file_upload' ) );
		add_action( 'add_attachment', array( $this, 'log_add_attachment' ) );

		// User Management
		add_action( 'user_register', array( $this, 'log_user_creation' ) );
		add_action( 'profile_update', array( $this, 'log_user_update' ), 10, 2 );
		add_action( 'set_user_role', array( $this, 'log_user_role_change' ), 10, 2 );
		add_action( 'login_form_resetpass', array( $this, 'log_password_reset_attempt' ) );
		add_action( 'delete_user', array( $this, 'log_user_deletion' ) );
		add_action( 'add_user_to_blog', array( $this, 'log_add_user_to_blog' ), 10, 3 );

		// Login & Security Events
		add_action( 'wp_login_failed', array( $this, 'log_failed_login' ) );
		add_action( 'retrieve_password', array( $this, 'log_password_reset_request' ) );
		add_action( 'wp_login', array( $this, 'log_successful_login' ), 10, 2 );

		// XMLRPC Events
		add_action( 'xmlrpc_publish_post', array( $this, 'log_xmlrpc_publish_post' ) );

		// Scanning Events
		add_action( 'wpmr_scan_init', array( $this, 'log_malware_scan_start' ) );

		$this->init_stateful_scanner();
		
	}
}

	/**
	 * Bootstrap helper to access the plugin singleton.
	 *
	 * @return WPMR_Init
	 */
function wp_malware_removal() {
	return WPMR_Init::get_instance();
}

/**
 * Plugin activation handler.
 *
 * Ensures the plugin's custom database schema is installed/upgraded at activation time.
 * This is the canonical way to guarantee required tables exist (especially after DB resets
 * or when the plugin is activated on a fresh site).
 *
 * Note: On multisite network-wide activation, WordPress passes `$network_wide = true`.
 * This handler currently runs for the activating site context (single blog) and relies on
 * the existing runtime schema upgrade logic.
 *
 * @param bool $network_wide Whether the plugin is being activated network-wide.
 * @return void
 */
function wpmr_activate_plugin( $network_wide ) {

	/**
	 * Internal activation event.
	 *
	 * Fired after the plugin instance is constructed so trait hooks (e.g., stateful scanner)
	 * can attach activation-time routines such as database installation.
	 *
	 * @param bool $network_wide Whether the plugin is being activated network-wide.
	 */
	do_action( 'wpmr_plugin_activation', (bool) $network_wide );

}

register_activation_hook( __FILE__, 'wpmr_activate_plugin' );

wp_malware_removal();
