<?php
$page_data = apply_filters('wpfs_admin_nav_bar_data', []);
?>

<div class="wpfs-global-header">
    <div class="wpfs-global-header__brand">
        <a href="<?php echo esc_url(admin_url('admin.php?page=wpfs-forms')); ?>" class="wpfs-global-header__logo">
            <svg class="wpfs-global-header__logo-icon" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M0.7367 11.8183C0.50314 11.5858 0.317868 11.3098 0.191464 11.0061C0.0650596 10.7023 0 10.3768 0 10.048C0 9.71923 0.0650596 9.39368 0.191464 9.08993C0.317868 8.78618 0.50314 8.5102 0.7367 8.27773L4.29152 4.73526C4.52511 4.50219 4.8026 4.31728 5.10809 4.19111C5.41357 4.06494 5.74106 4 6.0718 4C6.40253 4 6.73002 4.06494 7.03551 4.19111C7.341 4.31728 7.61848 4.50219 7.85208 4.73526L11.4031 8.27392C11.6366 8.50638 11.8219 8.78237 11.9483 9.08611C12.0747 9.38986 12.1398 9.71542 12.1398 10.0442C12.1398 10.373 12.0747 10.6985 11.9483 11.0023C11.8219 11.306 11.6366 11.582 11.4031 11.8145L7.85208 15.3531C7.61855 15.5856 7.34131 15.7701 7.03617 15.8959C6.73104 16.0217 6.40399 16.0865 6.07371 16.0865C5.74343 16.0865 5.41639 16.0217 5.11125 15.8959C4.80612 15.7701 4.52887 15.5856 4.29535 15.3531L0.7367 11.8183Z" fill="currentColor"/>
                <path d="M10.0564 6.93408L11.3971 8.2687C11.6307 8.50117 11.8159 8.77716 11.9423 9.0809C12.0688 9.38465 12.1338 9.71021 12.1338 10.039C12.1338 10.3678 12.0688 10.6933 11.9423 10.9971C11.8159 11.3008 11.6307 11.5768 11.3971 11.8093L9.93956 13.2716L8.59885 11.937C8.36528 11.7045 8.18001 11.4286 8.05361 11.1248C7.9272 10.8211 7.86214 10.4955 7.86214 10.1667C7.86214 9.83795 7.9272 9.51239 8.05361 9.20864C8.18001 8.9049 8.36528 8.62891 8.59885 8.39645L10.0564 6.93408Z" fill="currentColor"/>
                <path d="M9.93958 13.2716L12.1498 15.4718C12.3834 15.7043 12.6606 15.8887 12.9657 16.0145C13.2709 16.1404 13.5979 16.2051 13.9282 16.2051C14.2585 16.2051 14.5855 16.1404 14.8907 16.0145C15.1958 15.8887 15.473 15.7043 15.7066 15.4718L19.2633 11.9312C19.4969 11.6988 19.6821 11.4228 19.8085 11.119C19.9349 10.8153 20 10.4897 20 10.1609C20 9.83216 19.9349 9.50661 19.8085 9.20286C19.6821 8.89911 19.4969 8.62313 19.2633 8.39066L15.7047 4.852C15.4711 4.61951 15.1939 4.43508 14.8888 4.30925C14.5836 4.18342 14.2566 4.11865 13.9263 4.11865C13.596 4.11865 13.269 4.18342 12.9638 4.30925C12.6587 4.43508 12.3815 4.61951 12.1479 4.852L10.0564 6.93402L11.3971 8.26864C11.6307 8.5011 11.816 8.77709 11.9424 9.08084C12.0688 9.38458 12.1338 9.71014 12.1338 10.0389C12.1338 10.3677 12.0688 10.6933 11.9424 10.997C11.816 11.3008 11.6307 11.5767 11.3971 11.8092L9.93958 13.2716Z" fill="currentColor" fill-opacity="0.8"/>
            </svg>
            <span class="wpfs-global-header__plugin-name">
                <?php esc_html_e('WP Full Pay', 'wp-full-stripe-free'); ?>
            </span>
        </a>
    </div>

    <div class="wpfs-global-header__plugin-meta">
        <!-- Version -->
        <?php if ( isset( $page_data['version_label'] ) && isset( $page_data['change_log_url'] ) ): ?>
        <a
            class="wpfs-global-header__plugin-version"
            target="_blank"
            href="<?php echo esc_url( $page_data['change_log_url'] ); ?>"
        >
            <?php echo esc_html( $page_data['version_label'] ); ?>
        </a>
        <?php endif; ?>
    
        <!-- Plan Badge -->
        <?php if ( isset( $page_data['product_type_label'] ) && isset( $page_data['plan_type'] ) ): ?>
        <div class="wpfs-global-header__plugin-plan wpfs-global-header__plugin-plan--<?php echo esc_attr( $page_data['plan_type'] ); ?>">
            <?php echo esc_html( $page_data['product_type_label'] ); ?>
        </div>
        <?php endif; ?>
    </div>

    <!-- Page Navigation -->
    <?php if ( isset( $page_data['pages'] ) && is_array( $page_data['pages'] ) && isset( $page_data['current_page'] ) ): ?>
    <div class="wpfs-global-header__nav">
        <?php foreach ( $page_data['pages'] as $slug => $page ) : ?>
            <a 
                href="<?php echo esc_url( $page['url'] ); ?>" 
                class="wpfs-global-header__nav-item <?php echo ( false !== strpos( $page_data['current_page'], $slug ) ) ? 'wpfs-global-header__nav-item--active' : ''; ?>"
            >
                <?php echo esc_html( $page['label'] ); ?>
            </a>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>

    <div class="wpfs-global-header__spacer"></div>

    <!-- Stripe Mode -->
    <?php if ( isset( $page_data['stripe_mode'] ) && isset( $page_data['stripe_settings_url']) ): ?>
    <a class="wpfs-global-header__stripe_mode" href="<?php echo esc_url( $page_data['stripe_settings_url'] ); ?>">
         <span class="wpfs-icon-stripe"></span>
        <?php esc_html_e('Mode', 'wp-full-stripe-free'); ?>:
        <?php echo esc_html( $page_data['stripe_mode'] ); ?>
    </a>
    <?php endif; ?>

    <!-- Find Help dropdown -->
    <?php include('wpfs-header-block-help.php'); ?>
</div>