<?php

add_action('init', 'wo3_init');
add_action('admin_menu', 'wo3_list_page');
add_action('admin_menu', 'wo3_config_page');

function wo3_init() {
	wo3_ensureDefaults();
	do_action('wo3_litmus_init');
}

function wo3_ensureDefaults() {
	global $keys;

	$n = "worst_offenders_";
	$keys['ui_vis'] = $n."ui_visibility_threshold";
	$keys['ui_preselect'] = $n."ui_preselect_threshold";
	$keys['ui_list_size'] = $n."ui_size_threshold";
	$keys['user_ban_list'] = $n."current_user_ban";
	$keys['user_ban_list_max_size'] = $n."user_ban_list_max_size";
	$keys['user_ban_list_size'] = $n."current_user_ban_count";
	$keys['debug'] = $n."debug";
	$keys['domain_cache'] = $n."domain_cache";
	$keys['counter'] = $n."counter";
	$keys['counter_offset'] = $n."counter_offset";

	$ui_vis = get_option( $keys['ui_vis'] );
	$ui_preselect = get_option( $keys['ui_preselect'] );
	$ui_list_size = get_option( $keys['ui_list_size'] );
	$ban_list = get_option( $keys['ban_list'] );
	$user_ban_list = get_option( $keys['user_ban_list'] );
	$ban_list_size = get_option( $keys['ban_list_size'] );
	$user_ban_list_size = get_option( $keys['user_ban_list_size'] );
	$user_ban_list_max_size = get_option( $keys['user_ban_list_max_size'] );
	$counter = get_option( $keys['counter'] );
	$counter_offset = get_option( $keys['$counter_offset'] );

	if ($ui_vis=="") update_option( $keys['ui_vis'], 2);
	if ($ui_preselect=="") update_option( $keys['ui_preselect'], 4);
	if ($ui_list_size=="") update_option($keys['ui_list_size'], 20);
	// if (!is_array($ban_list)) wo3_reset_user_ban( );
	if ($user_ban_list_max_size=="") update_option($keys['user_ban_list_max_size'], 800);
	if ($counter=="") update_option( $keys['counter'], 0);
	
	// if there's no offset, then set it to the current akismet spam count
	if ($counter_offset=="") {
		$count = get_option( 'akismet_spam_count' );
		$count = ($count == "" ? 0 : $count);
		update_option( $keys['counter_offset'], $count);
	}
	
}

//add_action('akismet_tabs', 'wo3_akismet_tab');

function wo3_akismet_tab() {	
	global $wo3_title, $keys;
	$active = $_GET['ctype'] === "worstoffenders";
	$count = get_current_count();
	$extra = ($active ? ' class="active"' : '');

	// draw the tab always
	echo "<li $extra><a href='edit-comments.php?page=akismet-admin&amp;ctype=worstoffenders'>Worst ($count)</a></li>";
	// but draw the content only when selected
	if ($active) {
		?>
		<ul class="commentlist" style="list-style:none;margin:0;padding:0;">
			<li>
				<p>Use Worst Offenders to remove <?php echo $count; ?> of spam comments immediately.</p>
				<p><a href='edit-comments.php?page=<?php echo $wo3_title; ?>'>Worst Offenders</a> has so far removed <?php	_e(get_option( $keys['counter'] )); ?> messages.</p>
			</li>
		</ul>
		<?php
	}
}

function wo3_config_page() {
	global $wpdb,	$wo3_title;
	if ( function_exists('add_submenu_page') )
		add_submenu_page('plugins.php',	__($wo3_title.'	Config'),	__($wo3_title.'	Config'),	1, __($wo3_title), 'wo3_conf');
}

function wo3_conf()	{
	if ( isset($_POST['submit']) ) {
		$thing = preg_replace('/[^a-h0-9]/i',	'',	$_POST['thing']);
		// update_option('thing',	$thing);
		echo '<div class="wrap">';
		do_action( "wo3_add_index" );
		echo '<p>Indexes added.</p>';
		echo '</div>';
	}
?><title></title>


<div class="wrap">
<h2><?php	_e($wo3_title.'	Configuration'); ?></h2>
<p><?php __('WO	Config explanation goes	here.'); ?></p>

<form	action=""	method="post"	id="wo-conf" style="margin:	auto;	width: 25em; ">
<h3><label for="key"><?php _e('Blah'); ?></label></h3>
<p><input	id="key" name="key"	type="text"	size="15"	maxlength="12" value="<?php	echo get_option('wo-thing'); ?>" style="font-family: 'Courier	New',	Courier, mono; font-size:	1.5em;"	/> </p>
<p class="submit"><input class="button" type="submit" name="submit" value="<?php	_e('Update Options &raquo;');	?>"	/></p>
<h2><?php	_e('Indexes'); ?></h2>
</form>
<h2><?php	_e('Modules'); ?></h2>
<?php	do_action( "wo3_rollcall"	); ?>



</div>
<?php
}




function wo3_list_page() {
	global $wpdb,	$wo3_title,	$submenu;
	$count = get_current_count();
	
	if ( isset(	$submenu['edit-comments.php']	)	)
		add_submenu_page('edit-comments.php',	__($wo3_title),	__($wo3_title . "(" . $count . ")"),	1, __($wo3_title), 'wo3_list'	);
	elseif ( function_exists('add_management_page')	)
		add_management_page(__($wo3_title),	__($wo3_title."x"),	1, __($wo3_title), 'wo3_list');
}

function css() { ?>
	<style type="text/css">
	.wo3_tabs	{
		list-style:	none;
		margin:	0;
		padding: 0;
		clear: both;
		border-bottom: 1px solid #ccc;
		height:	31px;
		margin-bottom: 20px;
		background:	#ddd;
		border-top:	1px	solid	#bdbdbd;
	}
	.wo3_tabs	li {
		float: left;
		margin:	5px	0	0	20px;
	}
	.wo3_tabs	a	{
		display: block;
		padding: 4px .5em	3px;
		border-bottom: none;
		color: #036;
	}
	.wo3_tabs	.active	a	{
		background:	#fff;
		border:	1px	solid	#ccc;
		border-bottom: none;
		color: #000;
		font-weight: bold;
		padding-bottom:	4px;
	}

	.wo3_count {
		color: #c30;
	}

	</style>
<?php
}

function reset_current_count() {
	global $keys;
	wp_cache_delete("current_count", $wo3_title);
	wp_cache_delete("current_ids", 'worstoffenders');
}

function get_current_count() {
	global $wo3_title;
	$result = wp_cache_get("current_count", $wo3_title);
	if ($result === false) {
		do_action('wo3_prep');
		$result = wp_cache_get("current_count", $wo3_title);
	}
	return $result;
}


function wo3_list()	{
	global $wpdb,	$comment,	$wo3_title;
	css();
	?>
	<div class='wrap'>
	<h2><?php	_e($wo3_title);	?></h2>
	<?php
	wo3_check_user_input();
	wo3_tabs();
	echo("</div>");
}


function do_delete($comma_separated_id_list) {
	global $wpdb, $keys;
	
	$query = "delete from	wp_comments	where	comment_ID in	($comma_separated_id_list)";
	$result = $wpdb->query($query);
	return $result;
}


function wo3_tabs()	{
	global $wo3_title;
	?>

<ul	class="wo3_tabs">
	<?php
	do_action( "wo3_tabs"	);
	?>
</ul>


<form	method="post"	action="<?php	echo $submit_url;	?>">
	<?php	do_action( "wo3_content" );	?>
	<input type="hidden" name="act"	value="delete" />
	<input type="submit" class="button delete" name="submit" value="<?php	_e('Delete selected'); ?>" />
</form>
<?php
}

function wo3_check_user_input()	{
	global $keys;
	if ($_POST['act']	== 'delete') {
		if (!empty($_POST['worst'])) {
			$deletionList	=	implode(",", $_POST['worst']);
			$deleted = do_delete($deletionList);
			if ($deleted === false)	{
				echo "<div class='updated'>DB	Error	-	Failed to	delete - Boo!	 Perhaps the DB	log	can	help!</div>";
			}	else {
				update_option( $keys['counter'], $deleted + get_option( $keys['counter'] ) );
				reset_current_count();
			}
		}
	}

}


function wo3_dashboard() {
	global $keys, $wo3_title;
	$count = get_current_count();
	$link = "edit-comments.php?page=$wo3_title";
		
	if ($count > 0) {
		$msg = "Worst Offenders has identified <a href='$link'>$count spam messages that you can delete immediately</a>.";
	} else {
		$msg = "The bad guys got squished.  No <a href='$link'>Worst Offenders</a> in your spam queue!";
	}
	echo "<p class='right-now'>$msg</p>\n";

}

add_action('rightnow_end', 'wo3_dashboard');
