<?php
/*
Plugin Name: WO2 MultiLinkLitmus
Plugin URI: http://boakes.org/worst-offenders-plugin
Description: Litmus test for messages that contain multiple links
Author: Rich Boakes
Version: 1
Author URI: http://boakes.org/
*/

if (class_exists('Litmus')) {
	add_action('wo3_prep', array('MultiLinkLitmus', 'getCount'));
	add_action('wo3_tabs', array('MultiLinkLitmus', 'tab'));
	add_action('wo3_content', array('MultiLinkLitmus', 'content'));
	add_action('wo3_add_index', array('MultiLinkLitmus', 'addIndex'));

	class MultiLinkLitmus extends Litmus {

		function getName() {
			return "MultiLink";
		}

		public static function getMatches() {
			global $keys;
			$lower_limit = get_option( $keys['ui_vis'] ); 
			return self::runCachedMatchesQuery(
				self::getName(),
				"SELECT wordcount2(comment_content, 'http://') as num, group_concat(comment_id separator ',') as comment_id_list FROM wp_comments where comment_approved='spam' group by num having num >= $lower_limit order by num desc;");
		}
		
		function content() {	
			if (self::isActive() || AllLitmus::isActive()) {
				$comments = MultiLinkLitmus::getMatches();
				echo("<table>");
				foreach($comments as $comment) {
						Litmus::wo3_show_row($comment->num, "links found in", $comment->comment_id_list );
				}
				echo("</table>");
			}
		}

		function addIndex() {
			global $wpdb;
			$q = "
				ALTER TABLE 'wp_comments' ENGINE = MyISAM ROW_FORMAT = DYNAMIC;
				ALTER TABLE 'wp_comments' ADD FULLTEXT INDEX 'content_fulltext'('comment_content');
				CREATE FUNCTION wordcount2 ( a text, b VARCHAR(255) )
				RETURNS INTEGER
				CONTAINS SQL DETERMINISTIC
				RETURN (CHAR_LENGTH(a)-CHAR_LENGTH(REPLACE(a, b, '')))/CHAR_LENGTH(b);
			";
			$wpdb->query($q);
			echo("<p>Adding index for MultiLinks.</p>");
		}

		//============================================
		// common class methods for litmus tests  
		// (there's got to be a better way to do this!
		//============================================
		
		function getCount() {
			global $wo3_title;
			self::getMatches();
			return wp_cache_get(self::getName()."_count", $wo3_title);
		}
		
		public static function tab() {	
			parent::tab(self::getName(), self::getCount(), self::isActive());
		}
		
		function isActive() {
			return ($_GET['tab'] == self::getName() ) && parent::isActive();
		}


	}
}
?>