<?php

abstract class Litmus {
	
	// Override this method to name your litmus test
	// Note that the name must not contain spaces!
	abstract function getName();

	// Override this method to count the current number of items matched by your litmus test
	abstract function getCount();
	
	abstract static function getMatches() ;

	// This method should only be overridden if you want your tab to look different
	public static function tab($name, $count, $extra = false) {
		global $wo3_title;
		$active = ($extra ? "active" : "");
		echo "<li class='$active'><a href='edit-comments.php?page=$wo3_title&amp;tab=$name'>$name <sup class='wo3_count'>$count</sup></a></li>";
	}

	public static function runCachedMatchesQuery($name, $q) {
		global $wpdb, $wo3_title;

		echo("\n<!-- Query is: $q -->\n");

		$result = wp_cache_get($name, $wo3_title);
		if($result == false) {
			$result= $wpdb->get_results($q);
			echo("<!-- cache miss $name -->\n");
			echo("<!-- query gave ".sizeof($result)." results -->\n");
			wp_cache_add($name, $result, $wo3_title);
		} else {
			echo("<!-- cache hit $name -->\n");
		}

		self::updateCount($name, $result);

		return $result;
	}


	private static function updateCount($name, $results) {
		global $wo3_title;
		echo("<!-- updating count from ".sizeof($results)." results -->\n");
		$ids = array();
		foreach($results as $result) {
			if (isset($result->comment_id_list)) {
				$ids = array_merge($ids, explode(",",$result->comment_id_list));
				echo("<!-- its a list of ".sizeof($ids)." -->\n");
			}
			if (isset($result->comment_id)) {
				echo("<!-- its an id -->\n");
				$ids[] = $result->comment_id;
			}
		}
		$ids = array_unique($ids);
		wp_cache_set($name."_count", sizeof($ids), $wo3_title);
		echo("<!-- ".sizeof($results)." results gave ".sizeof($ids)." distinct ids -->\n");

		$current_ids = wp_cache_get("current_ids", $wo3_title);
		if ($current_ids == false) $current_ids = array();
		$current_ids = array_merge($current_ids, $ids);
		$current_ids = array_unique($current_ids);
		wp_cache_set("current_ids", $current_ids, $wo3_title);
		wp_cache_set("current_count", sizeof($current_ids), $wo3_title);
		echo("<!-- current_count is now ".sizeof($current_ids)." -->\n");

	}

	function isActive() {
		global $wo3_title;
		return $_GET['page']==$wo3_title;
	}


	public static function wo3_show_row($num, $reason_or_offender, $ids) {
		if (AllLitmus::isActive()) {
			echo("<input id='$hids' type='hidden' name='worst[]' checked value='$ids' />");
		} else {
			$preselect_threshold = 3; // should be an option
			$checked = ($num >= $preselect_threshold ? "checked" : "");
			echo("<tr>");
			echo("<td><input id='$hids' type='checkbox' name='worst[]' $checked value='$ids' /></td>");
			echo("<td>$num</td>");
			echo("<td>$reason_or_offender</td><td>");
			Litmus::link_to_comments($ids);
			echo("</td></tr>");
		}
	}

	function link_to_comments($comma_separated_list) {
		foreach( explode( ",", $comma_separated_list ) as $id ) {
			$id = trim($id);
			$link[] = "<a href='comment.php?action=editcomment&c=$id'>$id</a>";
		}
		echo implode(", ",$link);
	}
}

?>
