!function(n){var t={};function e(i){if(t[i])return t[i].exports;var Q=t[i]={i:i,l:!1,exports:{}};return n[i].call(Q.exports,Q,Q.exports,e),Q.l=!0,Q.exports}e.m=n,e.c=t,e.d=function(n,t,i){e.o(n,t)||Object.defineProperty(n,t,{enumerable:!0,get:i})},e.r=function(n){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(n,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(n,"__esModule",{value:!0})},e.t=function(n,t){if(1&t&&(n=e(n)),8&t)return n;if(4&t&&"object"==typeof n&&n&&n.__esModule)return n;var i=Object.create(null);if(e.r(i),Object.defineProperty(i,"default",{enumerable:!0,value:n}),2&t&&"string"!=typeof n)for(var Q in n)e.d(i,Q,function(t){return n[t]}.bind(null,Q));return i},e.n=function(n){var t=n&&n.__esModule?function(){return n.default}:function(){return n};return e.d(t,"a",t),t},e.o=function(n,t){return Object.prototype.hasOwnProperty.call(n,t)},e.p="",e(e.s=87)}({104:function(module,__webpack_exports__,__webpack_require__){"use strict";eval('/* WEBPACK VAR INJECTION */(function(global) {/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17);\n/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _constants_faq_hook_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29);\n/* harmony import */ var _validators_faq_validator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65);\n/**\n * TinyMceToolbarHandler handles the toolbar button.\n * @since 3.26.0\n * @author Naveen Muthusamy <naveen@wordlift.io>\n */\n\n/**\n * Internal dependencies.\n */\n\n\n\nconst TINYMCE_TOOLBAR_BUTTON_NAME = "wl-faq-toolbar-button";\n\nclass TinymceToolbarHandler {\n  /**\n   * Construct the TinymceToolbarHandler\n   * @param editor {tinymce.Editor} instance.\n   * @param highlightHandler {TinymceHighlightHandler} instance.\n   */\n  constructor(editor, highlightHandler) {\n    this.editor = editor;\n    this.highlightHandler = highlightHandler;\n    this.faqItems = [];\n    const {\n      addQuestionText,\n      addAnswerText,\n      addQuestionOrAnswerText\n    } = global["_wlFaqSettings"];\n    this.addQuestionText = addQuestionText;\n    this.addAnswerText = addAnswerText;\n    this.addQuestionOrAnswerText = addQuestionOrAnswerText; // Listen to store changes on faq items and set the tool bar\n    // button state based on it.\n\n    Object(backbone__WEBPACK_IMPORTED_MODULE_0__["on"])(_constants_faq_hook_constants__WEBPACK_IMPORTED_MODULE_1__[/* FAQ_ITEMS_CHANGED */ "c"], faqItems => {\n      this.faqItems = faqItems;\n    });\n  }\n  /**\n   * Sets the button text based on the text selected by user.\n   * @param selectedText The text selected by user.\n   * @param button Button present in toolbar.\n   * @param container This container holds the button.\n   */\n\n\n  setButtonTextBasedOnSelectedText(selectedText, button, container) {\n    if (_validators_faq_validator__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"].isQuestion(selectedText)) {\n      button.innerText = this.addQuestionText;\n      container.setAttribute("aria-label", this.addQuestionText);\n    } else {\n      button.innerText = this.addAnswerText;\n      container.setAttribute("aria-label", this.addAnswerText);\n    }\n  }\n  /**\n   * Disable toolbar button\n   */\n\n\n  disableButton(container, button) {\n    container.classList.add("mce-disabled");\n    button.disabled = true;\n  }\n  /**\n   * Enable toolbar button\n   */\n\n\n  enableButton(container, button) {\n    container.classList.remove("mce-disabled");\n    button.disabled = false;\n  }\n  /**\n   * Determine if the tool bar button needed to be disabled.\n   * Conditions for disabling the button\n   * 1. If there is no selected text\n   * 2. If an answer is selected and there are no unanswered questions.\n   * @return {Boolean} True if we need to disable button, false if we dont want to.\n   */\n\n\n  static shouldDisableButton(selectedText, faqItems) {\n    if (0 === selectedText.length || typeof selectedText === "undefined") {\n      return true;\n    } // If there is some selected text then check if it is an answer.\n\n\n    const questionsWithoutAnswer = faqItems.filter(e => e.answer === "").length;\n\n    if (0 === questionsWithoutAnswer && !_validators_faq_validator__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"].isQuestion(selectedText)) {\n      // There are no questions without answer and selected text is answer then disable it.\n      return true;\n    } // Return false if no conditions are matching.\n\n\n    return false;\n  }\n  /**\n   * When there is no selection disable the button, determine\n   * if it is question or answer and change the button text.\n   */\n\n\n  changeButtonStateOnSelectedText() {\n    const editor = this.editor;\n    const selectedText = editor.selection.getContent({\n      format: "text"\n    });\n    const container = document.getElementById(TINYMCE_TOOLBAR_BUTTON_NAME); // If we cant find the toolbar buttons, then return early.\n\n    if (container === null) {\n      return;\n    }\n\n    const button = container.getElementsByTagName("button")[0];\n\n    if (TinymceToolbarHandler.shouldDisableButton(selectedText, this.faqItems)) {\n      this.disableButton(container, button);\n    } else {\n      this.enableButton(container, button);\n    }\n\n    this.setButtonTextBasedOnSelectedText(selectedText, button, container);\n  }\n  /**\n   * Listen for node changes, and alter the state of\n   * the button according to the text selected.\n   */\n\n\n  changeToolBarButtonStateBasedOnTextSelected() {\n    const editor = this.editor;\n    editor.on("NodeChange", e => {\n      this.changeButtonStateOnSelectedText();\n    });\n  }\n  /**\n   * Adds the button to the toolbar.\n   */\n\n\n  addButtonToToolBar() {\n    const editor = this.editor;\n    const self = this;\n    editor.addButton(TINYMCE_TOOLBAR_BUTTON_NAME, {\n      text: "Add Question or Answer",\n      id: TINYMCE_TOOLBAR_BUTTON_NAME,\n      onclick: function () {\n        const selectedText = editor.selection.getContent({\n          format: "text"\n        });\n        const selectedHTML = editor.selection.getNode().innerHTML;\n        /**\n         * Make the highlight handler to save the selection.\n         */\n\n        self.highlightHandler.saveSelection();\n        Object(backbone__WEBPACK_IMPORTED_MODULE_0__["trigger"])(_constants_faq_hook_constants__WEBPACK_IMPORTED_MODULE_1__[/* FAQ_EVENT_HANDLER_SELECTION_CHANGED */ "a"], {\n          selectedText: selectedText,\n          selectedHTML: selectedHTML\n        });\n      }\n    });\n    this.changeToolBarButtonStateBasedOnTextSelected();\n  }\n\n}\n\n/* harmony default export */ __webpack_exports__["a"] = (TinymceToolbarHandler);\n/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(22)))//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///104\n')},105:function(module,__webpack_exports__,__webpack_require__){"use strict";eval('/**\n * FaqTextEditorHook Provides a abstract class for the hooks to implement\n * the methods.\n *\n * @since 3.26.0\n * @author Naveen Muthusamy <naveen@wordlift.io>\n */\nclass FaqTextEditorHook {\n  constructor() {}\n  /**\n   * Perform text highlighting when the event is sent from store.\n   */\n\n\n  performTextHighlighting() {\n    this._throwFunctionNotImplementedError("doTextHighlighting()");\n  }\n  /**\n   * Show the floating action button to be used to add question or answer based\n   * on the text selected.\n   */\n\n\n  showFloatingActionButton() {\n    this._throwFunctionNotImplementedError("showFloatingActionButton()");\n  }\n  /**\n   * Initialize the hook in correct order, the order might\n   * be changed by the child class if it wants to change.\n   */\n\n\n  initialize() {\n    this.performTextHighlighting();\n    this.showFloatingActionButton();\n  }\n\n  _throwFunctionNotImplementedError(functionName) {\n    throw new Error(functionName + " should be implemented by the parent class ");\n  }\n\n}\n\n/* harmony default export */ __webpack_exports__["a"] = (FaqTextEditorHook);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///105\n')},115:function(module,__webpack_exports__,__webpack_require__){"use strict";eval('/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return FAQ_ANSWER_FORMAT_NAME; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return FAQ_QUESTION_FORMAT_NAME; });\n/* harmony import */ var _wordpress_rich_text__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(63);\n/* harmony import */ var _wordpress_rich_text__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_rich_text__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _tinymce_tinymce_highlight_handler__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(58);\n/**\n * GutenbergFormatTypeHandler Registers the format type required for the FAQ section in\n * the gutenberg.\n *\n * @since 3.26.0\n * @author Naveen Muthusamy <naveen@wordlift.io>\n */\n\n/**\n * WordPress dependencies\n */\n\n/**\n * Internal dependencies.\n */\n\n\nconst FAQ_ANSWER_FORMAT_NAME = "wordlift/faq-answer";\nconst FAQ_QUESTION_FORMAT_NAME = "wordlift/faq-question";\n\nclass GutenbergFormatTypeHandler {\n  registerAnswerFormatType() {\n    Object(_wordpress_rich_text__WEBPACK_IMPORTED_MODULE_0__["registerFormatType"])(FAQ_ANSWER_FORMAT_NAME, {\n      title: "Question",\n      tagName: "span",\n      className: _tinymce_tinymce_highlight_handler__WEBPACK_IMPORTED_MODULE_1__[/* FAQ_ANSWER_HIGHLIGHTING_CLASS */ "a"],\n      attributes: {\n        id: "id"\n      }\n    });\n  }\n\n  registerQuestionFormatType() {\n    Object(_wordpress_rich_text__WEBPACK_IMPORTED_MODULE_0__["registerFormatType"])(FAQ_QUESTION_FORMAT_NAME, {\n      title: "Answer",\n      tagName: "span",\n      className: _tinymce_tinymce_highlight_handler__WEBPACK_IMPORTED_MODULE_1__[/* FAQ_QUESTION_HIGHLIGHTING_CLASS */ "b"],\n      attributes: {\n        id: "id"\n      }\n    });\n  }\n  /**\n   * Registers all the format types needed by FAQ\n   */\n\n\n  registerAllFormatTypes() {\n    this.registerQuestionFormatType();\n    this.registerAnswerFormatType();\n  }\n\n}\n\n/* harmony default export */ __webpack_exports__["c"] = (GutenbergFormatTypeHandler);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///115\n')},151:function(module,__webpack_exports__,__webpack_require__){"use strict";eval('/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17);\n/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _constants_faq_hook_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29);\n/* harmony import */ var _gutenberg_format_type_handler__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(115);\n/* harmony import */ var _wordpress_rich_text__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(63);\n/* harmony import */ var _wordpress_rich_text__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_rich_text__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var _tinymce_tinymce_highlight_handler__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(58);\n/**\n * GutenbergHighlightHandler handles the highlight event from event handler and\n * applies the format type to gutenberg\n *\n * @since 3.26.0\n * @author Naveen Muthusamy <naveen@wordlift.io>\n */\n\n/**\n * External dependencies.\n */\n\n/**\n * Internal dependencies.\n */\n\n\n\n\n\n\nclass GutenbergHighlightHandler {\n  constructor() {\n    this.props = null;\n  }\n  /**\n   * Start listening for highlight events from\n   * the store.\n   */\n\n\n  listenForHighlightEvent() {\n    Object(backbone__WEBPACK_IMPORTED_MODULE_0__["on"])(_constants_faq_hook_constants__WEBPACK_IMPORTED_MODULE_1__[/* FAQ_HIGHLIGHT_TEXT */ "b"], result => {\n      if (this.props !== null) {\n        const {\n          isQuestion,\n          id\n        } = result;\n        const format = {\n          attributes: {}\n        };\n        /**\n         * Apply format depending on the type.\n         */\n\n        if (isQuestion) {\n          format.attributes.id = `${_tinymce_tinymce_highlight_handler__WEBPACK_IMPORTED_MODULE_4__[/* FAQ_QUESTION_HIGHLIGHTING_CLASS */ "b"]}--${id}`;\n          format.type = _gutenberg_format_type_handler__WEBPACK_IMPORTED_MODULE_2__[/* FAQ_QUESTION_FORMAT_NAME */ "b"];\n          this.props.onChange(Object(_wordpress_rich_text__WEBPACK_IMPORTED_MODULE_3__["applyFormat"])(this.props.value, format));\n        } else {\n          format.attributes.id = `${_tinymce_tinymce_highlight_handler__WEBPACK_IMPORTED_MODULE_4__[/* FAQ_ANSWER_HIGHLIGHTING_CLASS */ "a"]}--${id}`;\n          format.type = _gutenberg_format_type_handler__WEBPACK_IMPORTED_MODULE_2__[/* FAQ_ANSWER_FORMAT_NAME */ "a"];\n          this.props.onChange(Object(_wordpress_rich_text__WEBPACK_IMPORTED_MODULE_3__["applyFormat"])(this.props.value, format));\n        }\n      }\n    });\n  }\n\n}\n\n/* harmony default export */ __webpack_exports__["a"] = (GutenbergHighlightHandler);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///151\n')},152:function(module,__webpack_exports__,__webpack_require__){"use strict";eval('/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17);\n/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _constants_faq_hook_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29);\n/* harmony import */ var _common_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(19);\n/* harmony import */ var _gutenberg_faq_plugin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(87);\n/* harmony import */ var _tinymce_tinymce_toolbar_handler__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(104);\n/**\n * BlockEditorFabHandler handles the disable and enabling\n * the add question or answer button based on the store state.\n *\n * @since 3.26.0\n * @author Naveen Muthusamy <naveen@wordlift.io>\n */\n\n/**\n * External dependencies.\n */\n\n/**\n * Internal dependencies.\n */\n\n\n\n\n\n\nclass BlockEditorFabHandler {\n  constructor() {\n    this.faqItems = [];\n    Object(backbone__WEBPACK_IMPORTED_MODULE_0__["on"])(_constants_faq_hook_constants__WEBPACK_IMPORTED_MODULE_1__[/* FAQ_ITEMS_CHANGED */ "c"], faqItems => {\n      this.faqItems = faqItems;\n    });\n    this.startListeningForSelectionChangesAndSetState(); // When initailised set the button to disabled state.\n\n    this.disableButtons(document.getElementsByClassName(_gutenberg_faq_plugin__WEBPACK_IMPORTED_MODULE_3__["FAQ_GUTENBERG_TOOLBAR_BUTTON_CLASS_NAME"]));\n  }\n\n  startListeningForSelectionChangesAndSetState() {\n    /**\n     * Listen for event emitted by wordlift hook.\n     */\n    Object(backbone__WEBPACK_IMPORTED_MODULE_0__["on"])(_common_constants__WEBPACK_IMPORTED_MODULE_2__[/* SELECTION_CHANGED */ "d"], ({\n      selection\n    }) => {\n      this.setStateBasedOnStore(selection);\n    });\n  }\n  /**\n   * Disabling the buttons on selection change.\n   * @param toolbarButtons\n   */\n\n\n  disableButtons(toolbarButtons) {\n    for (let button of toolbarButtons) {\n      button.disabled = true;\n    }\n  }\n  /**\n   * Enable the buttons when the selection is changed.\n   * @param toolbarButtons\n   */\n\n\n  enableButtons(toolbarButtons) {\n    for (let button of toolbarButtons) {\n      button.disabled = false;\n    }\n  }\n  /**\n   * Set the state of toolbar button instances with text selection.\n   * @param selectedText\n   */\n\n\n  setStateBasedOnStore(selectedText) {\n    const toolbarButtons = document.getElementsByClassName(_gutenberg_faq_plugin__WEBPACK_IMPORTED_MODULE_3__["FAQ_GUTENBERG_TOOLBAR_BUTTON_CLASS_NAME"]);\n    const shouldDisableButton = _tinymce_tinymce_toolbar_handler__WEBPACK_IMPORTED_MODULE_4__[/* default */ "a"].shouldDisableButton(selectedText, this.faqItems);\n\n    if (shouldDisableButton) {\n      this.disableButtons(toolbarButtons);\n    } else {\n      this.enableButtons(toolbarButtons);\n    }\n  }\n\n}\n\n/* harmony default export */ __webpack_exports__["a"] = (BlockEditorFabHandler);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///152\n')},153:function(module,__webpack_exports__,__webpack_require__){"use strict";eval('/* WEBPACK VAR INJECTION */(function(global) {/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17);\n/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _constants_faq_hook_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29);\n/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(154);\n/* harmony import */ var _gutenberg_faq_plugin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(87);\n/**\n * External dependencies.\n */\n\n/**\n * Internal dependencies.\n */\n\n\n\n\n/**\n * GutenbergToolbarButtonRegister Registers the toolbar button for the\n * gutenberg.\n *\n * @since 3.26.0\n * @author Naveen Muthusamy <naveen@wordlift.io>\n */\n\nclass GutenbergToolbarButtonRegister {\n  constructor(wp, highlightHandler) {\n    this.wp = wp;\n    this.highlightHandler = highlightHandler;\n    this.addQuestionOrAnswerText = global["_wlFaqSettings"]["addQuestionOrAnswerText"];\n  }\n\n  registerFabButton() {\n    this.wp.richText.registerFormatType("wordlift/faq-plugin", {\n      title: this.addQuestionOrAnswerText,\n      tagName: "faq-gutenberg",\n      className: null,\n      edit: this.getFAQButton()\n    });\n  }\n\n  getFAQButton() {\n    const self = this;\n    return function (props) {\n      return wp.element.createElement(wp.editor.RichTextToolbarButton, {\n        title: self.addQuestionOrAnswerText,\n        icon: "plus",\n        className: _gutenberg_faq_plugin__WEBPACK_IMPORTED_MODULE_3__["FAQ_GUTENBERG_TOOLBAR_BUTTON_CLASS_NAME"],\n        onClick: function () {\n          /**\n           * We pass props.value in to extras, in order to make\n           * gutenberg highlight on the highlight event.\n           */\n          self.highlightHandler.props = props;\n          const {\n            text,\n            start,\n            end\n          } = props.value;\n          const selectedText = text.slice(start, end);\n          Object(backbone__WEBPACK_IMPORTED_MODULE_0__["trigger"])(_constants_faq_hook_constants__WEBPACK_IMPORTED_MODULE_1__[/* FAQ_EVENT_HANDLER_SELECTION_CHANGED */ "a"], {\n            selectedText: selectedText,\n            selectedHTML: Object(_helpers__WEBPACK_IMPORTED_MODULE_2__[/* getCurrentSelectionHTML */ "a"])()\n          });\n        }\n      });\n    };\n  }\n\n}\n\n/* harmony default export */ __webpack_exports__["a"] = (GutenbergToolbarButtonRegister);\n/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(22)))//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///153\n')},154:function(module,__webpack_exports__,__webpack_require__){"use strict";eval('/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return getCurrentSelectionHTML; });\n/**\n * List of helpers in order to extract the html from the selected gutenberg\n * block.\n *\n * @since 3.26.0\n * @author Naveen Muthusamy <naveen@wordlift.io>\n */\n\n/**\n * Gutenberg returns a selected object that represents a\n * text value, there is no way to return the selected html,\n * we can get the HTML manually from DOM using this method.\n * This method should only be called when the user clicks on\n * Add question/Answer in order to get the correct selected html.\n *\n * @return {string} HTML String\n */\nfunction getCurrentSelectionHTML() {\n  let html = "";\n  /** Check for selection */\n\n  if (window.getSelection() !== undefined) {\n    const selection = window.getSelection();\n    const rangeCount = selection.rangeCount; // Loop through all the ranges and append the child.\n\n    const container = document.createElement("div");\n\n    for (let i = 0; i < rangeCount; ++i) {\n      container.appendChild(selection.getRangeAt(i).cloneContents());\n    } // once we have appended the child to the dummy container, return the innerHTML\n\n\n    html = container.innerHTML;\n  }\n\n  return html;\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///154\n')},17:function(module,exports){eval("module.exports = Backbone;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vZXh0ZXJuYWwgXCJCYWNrYm9uZVwiPzViYzAiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEiLCJmaWxlIjoiMTcuanMiLCJzb3VyY2VzQ29udGVudCI6WyJtb2R1bGUuZXhwb3J0cyA9IEJhY2tib25lOyJdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///17\n")},19:function(module,__webpack_exports__,__webpack_require__){"use strict";eval('/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return SELECTION_CHANGED; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ANNOTATION_CHANGED; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return PLUGIN_NAMESPACE; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return EDITOR_STORE; });\n/* unused harmony export EDITOR_ELEMENT_ID */\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return WORDLIFT_STORE; });\n/**\n * This file defines constants used across different files and components.\n *\n * @author David Riccitelli <david@wordlift.io>\n * @since 3.23.0\n */\n\n/**\n * WordPress\' action hook to signal that a selection has changed.\n *\n * @since 3.23.0\n * @type {string}\n */\nconst SELECTION_CHANGED = "wordlift.selectionChanged";\n/**\n * WordPress\' action hook to signal that an annotation has changed. The action\n * provides the annotation id as `{ annotationId }`. The annotation id usually\n * matches the element id that caused the action to be fired.\n *\n * @since 3.23.0\n * @type {string}\n */\n\nconst ANNOTATION_CHANGED = "wordlift.annotationChanged";\n/**\n * The plugin namespace.\n *\n * @type {string}\n */\n\nconst PLUGIN_NAMESPACE = "wordlift";\n/**\n * Define the G\'berg editor store name.\n *\n * @since 3.23.0\n * @type {string}\n */\n\nconst EDITOR_STORE = "core/editor";\n/**\n * Define the editor element id.\n *\n * @since 3.23.0\n * @type {string}\n */\n\nconst EDITOR_ELEMENT_ID = "editor";\n/**\n * Define the WordLift Store name used for {@link select} and {@link dispatch}\n * functions.\n *\n * @type {string}\n */\n\nconst WORDLIFT_STORE = "wordlift/editor";//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///19\n')},22:function(module,exports){eval('var g;\n\n// This works in non-strict mode\ng = (function() {\n\treturn this;\n})();\n\ntry {\n\t// This works if eval is allowed (see CSP)\n\tg = g || new Function("return this")();\n} catch (e) {\n\t// This works if the window reference is available\n\tif (typeof window === "object") g = window;\n}\n\n// g can still be undefined, but nothing to do about it...\n// We return undefined, instead of nothing here, so it\'s\n// easier to handle this case. if(!global) { ...}\n\nmodule.exports = g;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vKHdlYnBhY2spL2J1aWxkaW4vZ2xvYmFsLmpzP2NkMDAiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsQ0FBQzs7QUFFRDtBQUNBO0FBQ0E7QUFDQSxDQUFDO0FBQ0Q7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQSw0Q0FBNEM7O0FBRTVDIiwiZmlsZSI6IjIyLmpzIiwic291cmNlc0NvbnRlbnQiOlsidmFyIGc7XG5cbi8vIFRoaXMgd29ya3MgaW4gbm9uLXN0cmljdCBtb2RlXG5nID0gKGZ1bmN0aW9uKCkge1xuXHRyZXR1cm4gdGhpcztcbn0pKCk7XG5cbnRyeSB7XG5cdC8vIFRoaXMgd29ya3MgaWYgZXZhbCBpcyBhbGxvd2VkIChzZWUgQ1NQKVxuXHRnID0gZyB8fCBuZXcgRnVuY3Rpb24oXCJyZXR1cm4gdGhpc1wiKSgpO1xufSBjYXRjaCAoZSkge1xuXHQvLyBUaGlzIHdvcmtzIGlmIHRoZSB3aW5kb3cgcmVmZXJlbmNlIGlzIGF2YWlsYWJsZVxuXHRpZiAodHlwZW9mIHdpbmRvdyA9PT0gXCJvYmplY3RcIikgZyA9IHdpbmRvdztcbn1cblxuLy8gZyBjYW4gc3RpbGwgYmUgdW5kZWZpbmVkLCBidXQgbm90aGluZyB0byBkbyBhYm91dCBpdC4uLlxuLy8gV2UgcmV0dXJuIHVuZGVmaW5lZCwgaW5zdGVhZCBvZiBub3RoaW5nIGhlcmUsIHNvIGl0J3Ncbi8vIGVhc2llciB0byBoYW5kbGUgdGhpcyBjYXNlLiBpZighZ2xvYmFsKSB7IC4uLn1cblxubW9kdWxlLmV4cG9ydHMgPSBnO1xuIl0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///22\n')},27:function(module,__webpack_exports__,__webpack_require__){"use strict";eval('/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return classExtractor; });\n/**\n * This file is used to provide helpers for styling.\n * @author Naveen Muthusamy <naveen@wordlift.io>\n * @since 3.25.0\n *\n */\n\n/**\n * classExtractor helps to return class name by applying boolean logic.\n * @param classConfig {Object} should be in format { "class-name": Boolean }\n * @returns {string} combined class name.\n */\nconst classExtractor = classConfig => {\n  let className = "";\n\n  for (let key of Object.keys(classConfig)) {\n    if (classConfig[key]) {\n      className += ` ${key}`;\n    }\n  }\n\n  return className.trim();\n};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9zcmMvbWFwcGluZ3MvYmxvY2tzL2hlbHBlci5qcz82ZWYwIl0sIm5hbWVzIjpbImNsYXNzRXh0cmFjdG9yIiwiY2xhc3NDb25maWciLCJjbGFzc05hbWUiLCJrZXkiLCJPYmplY3QiLCJrZXlzIiwidHJpbSJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTs7Ozs7OztBQU9BOzs7OztBQUtPLE1BQU1BLGNBQWMsR0FBR0MsV0FBVyxJQUFJO0FBQzNDLE1BQUlDLFNBQVMsR0FBRyxFQUFoQjs7QUFDQSxPQUFLLElBQUlDLEdBQVQsSUFBZ0JDLE1BQU0sQ0FBQ0MsSUFBUCxDQUFZSixXQUFaLENBQWhCLEVBQTBDO0FBQ3hDLFFBQUlBLFdBQVcsQ0FBQ0UsR0FBRCxDQUFmLEVBQXNCO0FBQ3BCRCxlQUFTLElBQUssSUFBR0MsR0FBSSxFQUFyQjtBQUNEO0FBQ0Y7O0FBQ0QsU0FBT0QsU0FBUyxDQUFDSSxJQUFWLEVBQVA7QUFDRCxDQVJNIiwiZmlsZSI6IjI3LmpzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBUaGlzIGZpbGUgaXMgdXNlZCB0byBwcm92aWRlIGhlbHBlcnMgZm9yIHN0eWxpbmcuXG4gKiBAYXV0aG9yIE5hdmVlbiBNdXRodXNhbXkgPG5hdmVlbkB3b3JkbGlmdC5pbz5cbiAqIEBzaW5jZSAzLjI1LjBcbiAqXG4gKi9cblxuLyoqXG4gKiBjbGFzc0V4dHJhY3RvciBoZWxwcyB0byByZXR1cm4gY2xhc3MgbmFtZSBieSBhcHBseWluZyBib29sZWFuIGxvZ2ljLlxuICogQHBhcmFtIGNsYXNzQ29uZmlnIHtPYmplY3R9IHNob3VsZCBiZSBpbiBmb3JtYXQgeyBcImNsYXNzLW5hbWVcIjogQm9vbGVhbiB9XG4gKiBAcmV0dXJucyB7c3RyaW5nfSBjb21iaW5lZCBjbGFzcyBuYW1lLlxuICovXG5leHBvcnQgY29uc3QgY2xhc3NFeHRyYWN0b3IgPSBjbGFzc0NvbmZpZyA9PiB7XG4gIGxldCBjbGFzc05hbWUgPSBcIlwiO1xuICBmb3IgKGxldCBrZXkgb2YgT2JqZWN0LmtleXMoY2xhc3NDb25maWcpKSB7XG4gICAgaWYgKGNsYXNzQ29uZmlnW2tleV0pIHtcbiAgICAgIGNsYXNzTmFtZSArPSBgICR7a2V5fWA7XG4gICAgfVxuICB9XG4gIHJldHVybiBjbGFzc05hbWUudHJpbSgpO1xufTtcbiJdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///27\n')},29:function(module,__webpack_exports__,__webpack_require__){"use strict";eval('/* unused harmony export FAQ_REQUEST_ADD_NEW_QUESTION */\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return FAQ_EVENT_HANDLER_SELECTION_CHANGED; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return FAQ_ITEMS_CHANGED; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return FAQ_HIGHLIGHT_TEXT; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return FAQ_ITEM_SELECTED_ON_TEXT_EDITOR; });\n/**\n * Constants for the FAQ hooks.\n *\n * @since 3.26.0\n * @author Naveen Muthusamy <naveen@wordlift.io>\n */\n\n/**\n * Event name when the text selection changed in any of text editor, emitted\n * from the hooks.\n * @type {string}\n */\nconst FAQ_REQUEST_ADD_NEW_QUESTION = "FAQ_REQUEST_ADD_NEW_QUESTION";\n/**\n * Event emitted by hook when the text selection is changed.\n * @type {string}\n */\n\nconst FAQ_EVENT_HANDLER_SELECTION_CHANGED = "FAQ_EVENT_HANDLER_SELECTION_CHANGED";\n/**\n * Event emitted by the store when the faq items are changed\n * @type {string}\n */\n\nconst FAQ_ITEMS_CHANGED = "FAQ_ITEMS_CHANGED";\n/**\n * Event emitted by the store when a question or answer\n * is added by ui, asking the editor to highlight the text.\n */\n\nconst FAQ_HIGHLIGHT_TEXT = "FAQ_HIGHLIGHT_TEXT";\n/**\n * Event emitted by the hook to event handler when the faq is selected by the user.\n */\n\nconst FAQ_ITEM_SELECTED_ON_TEXT_EDITOR = "FAQ_ITEM_SELECTED_ON_TEXT_EDITOR";//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///29\n')},58:function(module,__webpack_exports__,__webpack_require__){"use strict";eval('/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return FAQ_QUESTION_HIGHLIGHTING_CLASS; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return FAQ_ANSWER_HIGHLIGHTING_CLASS; });\n/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17);\n/* harmony import */ var backbone__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(backbone__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _constants_faq_hook_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29);\n/* harmony import */ var _mappings_blocks_helper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(27);\n/**\n * TinyMceHighlightHandler handles the toolbar button.\n * @since 3.26.0\n * @author Naveen Muthusamy <naveen@wordlift.io>\n */\n\n/**\n * External dependencies.\n */\n\n/**\n * Internal dependencies.\n */\n\n\n\nconst FAQ_QUESTION_HIGHLIGHTING_CLASS = "wl-faq--question";\nconst FAQ_ANSWER_HIGHLIGHTING_CLASS = "wl-faq--answer";\n\nclass TinymceHighlightHandler {\n  /**\n   * Construct highlight handler instance.\n   * @param editor {tinymce.Editor} The Tinymce editor instance.\n   */\n  constructor(editor) {\n    this.editor = editor;\n    this.selection = null;\n    /**\n     * Listen for highlighting events, then highlight the text.\n     * Expected object from the event\n     * {\n     *     text: string,\n     *     isQuestion:Boolean\n     *     id: Int\n     * }\n     */\n\n    Object(backbone__WEBPACK_IMPORTED_MODULE_0__["on"])(_constants_faq_hook_constants__WEBPACK_IMPORTED_MODULE_1__[/* FAQ_HIGHLIGHT_TEXT */ "b"], result => {\n      this.highlightSelectedText(result.text, result.isQuestion, result.id);\n    });\n  }\n  /**\n   * Save the currently selection to a instance\n   * variable, used for highlighting the text later even\n   * if the user unselected the text.\n   */\n\n\n  saveSelection() {\n    this.selection = this.editor.selection;\n  }\n  /**\n   * Highlight the selection done by the user.\n   * @param selectedText The text which was selected by the user.\n   * @param isQuestion {Boolean} Indicates if its question or answer.\n   * @param id {Int} Unique id for question and answer.\n   */\n\n\n  highlightSelectedText(selectedText, isQuestion, id) {\n    if (this.selection === null) {\n      /**\n       * Bail out if there is no selection on the editor.\n       */\n      return;\n    }\n\n    const html = this.selection.getContent();\n    const className = Object(_mappings_blocks_helper__WEBPACK_IMPORTED_MODULE_2__[/* classExtractor */ "a"])({\n      [FAQ_QUESTION_HIGHLIGHTING_CLASS]: isQuestion,\n      [FAQ_ANSWER_HIGHLIGHTING_CLASS]: !isQuestion\n    });\n    /**\n     * Prepare unique identifier for the string, we are appending the classname because ids should\n     * be unique.\n     * @type {string}\n     */\n\n    const identifier = `${className}--${id}`;\n    const highlightedElement = `<span id="${identifier}" class="${className}">${html}</span>`;\n    this.selection.setContent(highlightedElement);\n  }\n\n}\n\n/* harmony default export */ __webpack_exports__["c"] = (TinymceHighlightHandler);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///58\n')},63:function(module,exports){eval('(function() { module.exports = this["wp"]["richText"]; }());//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vZXh0ZXJuYWwge1widGhpc1wiOltcIndwXCIsXCJyaWNoVGV4dFwiXX0/YTdiZSJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxhQUFhLHlDQUF5QyxFQUFFIiwiZmlsZSI6IjYzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiKGZ1bmN0aW9uKCkgeyBtb2R1bGUuZXhwb3J0cyA9IHRoaXNbXCJ3cFwiXVtcInJpY2hUZXh0XCJdOyB9KCkpOyJdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///63\n')},65:function(module,__webpack_exports__,__webpack_require__){"use strict";eval('/**\n * FaqValidator validates the text selected by user, determines if it is question\n * or answer.\n *\n * @since 3.26.0\n * @author Naveen Muthusamy <naveen@wordlift.io>\n */\nclass FaqValidator {\n  static isQuestion(text) {\n    return text.trim().endsWith("?");\n  }\n\n}\n\n/* harmony default export */ __webpack_exports__["a"] = (FaqValidator);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9zcmMvZmFxL2hvb2tzL3ZhbGlkYXRvcnMvZmFxLXZhbGlkYXRvci5qcz9lOTdmIl0sIm5hbWVzIjpbIkZhcVZhbGlkYXRvciIsImlzUXVlc3Rpb24iLCJ0ZXh0IiwidHJpbSIsImVuZHNXaXRoIl0sIm1hcHBpbmdzIjoiQUFBQTs7Ozs7OztBQU9BLE1BQU1BLFlBQU4sQ0FBbUI7QUFDakIsU0FBT0MsVUFBUCxDQUFrQkMsSUFBbEIsRUFBd0I7QUFDdEIsV0FBT0EsSUFBSSxDQUFDQyxJQUFMLEdBQVlDLFFBQVosQ0FBcUIsR0FBckIsQ0FBUDtBQUNEOztBQUhnQjs7QUFNSkoscUVBQWYiLCJmaWxlIjoiNjUuanMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEZhcVZhbGlkYXRvciB2YWxpZGF0ZXMgdGhlIHRleHQgc2VsZWN0ZWQgYnkgdXNlciwgZGV0ZXJtaW5lcyBpZiBpdCBpcyBxdWVzdGlvblxuICogb3IgYW5zd2VyLlxuICpcbiAqIEBzaW5jZSAzLjI2LjBcbiAqIEBhdXRob3IgTmF2ZWVuIE11dGh1c2FteSA8bmF2ZWVuQHdvcmRsaWZ0LmlvPlxuICovXG5jbGFzcyBGYXFWYWxpZGF0b3Ige1xuICBzdGF0aWMgaXNRdWVzdGlvbih0ZXh0KSB7XG4gICAgcmV0dXJuIHRleHQudHJpbSgpLmVuZHNXaXRoKFwiP1wiKTtcbiAgfVxufVxuXG5leHBvcnQgZGVmYXVsdCBGYXFWYWxpZGF0b3I7XG4iXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///65\n')},87:function(module,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* WEBPACK VAR INJECTION */(function(global) {/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FAQ_GUTENBERG_TOOLBAR_BUTTON_CLASS_NAME", function() { return FAQ_GUTENBERG_TOOLBAR_BUTTON_CLASS_NAME; });\n/* harmony import */ var _gutenberg_format_type_handler__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(115);\n/* harmony import */ var _gutenberg_highlight_handler__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(151);\n/* harmony import */ var _gutenberg_toolbar_handler__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(152);\n/* harmony import */ var _interface_faq_text_editor_hook__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(105);\n/* harmony import */ var _gutenberg_toolbar_button_register__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(153);\n/**\n * Internal dependencies.\n */\n\n\n\n\n\nconst FAQ_GUTENBERG_TOOLBAR_BUTTON_CLASS_NAME = "wl-faq-gutenberg-toolbar-button";\n\nclass GutenbergFaqPlugin extends _interface_faq_text_editor_hook__WEBPACK_IMPORTED_MODULE_3__[/* default */ "a"] {\n  constructor(wp) {\n    super();\n    this.wp = wp;\n  }\n\n  performTextHighlighting() {\n    /**\n     * Register all the format types required by FAQ\n     * for the gutenberg\n     */\n    const formatTypeHandler = new _gutenberg_format_type_handler__WEBPACK_IMPORTED_MODULE_0__[/* default */ "c"]();\n    formatTypeHandler.registerAllFormatTypes();\n    /**\n     * Event handler / store emits highlight event upon faqitem\n     * save or edit.\n     */\n\n    const highlightHandler = new _gutenberg_highlight_handler__WEBPACK_IMPORTED_MODULE_1__[/* default */ "a"]();\n    highlightHandler.listenForHighlightEvent();\n    const toolbarRegister = new _gutenberg_toolbar_button_register__WEBPACK_IMPORTED_MODULE_4__[/* default */ "a"](this.wp, highlightHandler);\n    toolbarRegister.registerFabButton();\n  }\n\n  showFloatingActionButton() {\n    /**\n     * Initialize event handler to listen for text selection,\n     * enable/disable the toolbar button.\n     */\n    new _gutenberg_toolbar_handler__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"]();\n  }\n\n  initialize() {\n    this.performTextHighlighting();\n    this.showFloatingActionButton();\n  }\n\n}\n/**\n * This hook is automatically loaded with block editor, so\n * we can just initailize the hook here.\n */\n\n\nconst adapter = new GutenbergFaqPlugin(global["wp"]);\nadapter.initialize();\n/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(22)))//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///87\n')}});