<?php
/*
Plugin Name: WordBar
Plugin URI: http://woganmay.com/plugins/wordbar
Description: WordBar creates a wordcount progress bar based on the contents of your Posts table
Author: Wogan May
Version: 1.0
Author URI: http://woganmay.com/
*/

function wordbar()
{
	/* Initialization */
}
add_action("init", "wordbar");

function wordbar_render()
{
	global $wpdb;
	$total_wordcount = 0;
	$data = get_option('Wordbar_widget');
	$target_wordcount = $data['targetcount'];
	
	// Get all the posts
	$result = $wpdb->get_results("SELECT post_content FROM $wpdb->posts WHERE post_status = 'publish'", OBJECT);
	
	foreach($result as $post)
	{
		$total_wordcount = $total_wordcount + str_word_count(strip_tags($post->post_content));
	}
	
	if ($target_wordcount > 0) {
		$progress = $total_wordcount / $target_wordcount * 100;
		$bartext = $total_wordcount." of ".$target_wordcount;
	}
	else
	{
		$bartext = $total_wordcount." words";
		$progress = 100;
	}
	
	echo "
		<style type='text/css'>.wordbar-wrap{position: relative;} .wordbar-wrap, .wordbar-value, .wordbar-text {width: 100%; height: 30px;} .wordbar-wrap, .wordbar-value {background: #bdbdbd;} .wordbar-text {position: absolute;top:0; left:0;padding-top: 5px;color: #fff;text-align: center;width: 100%;}</style>
		<div id='wordbar_progress_bar_wrapper'>
			<div id='wordbar_progress_bar'>
			
				<div class='wordbar-wrap'>
					<div class='wordbar-value' style='background-color: #0a0; width: ".$progress."%;'>
						<div class='wordbar-text'>
							".$bartext."
						</div>
					</div>
				</div>
			
			</div>
		</div>
	";
	
}

/*
	Create the Wordbar widget
*/

add_action("widgets_init", array('Wordbar_widget', 'register'));
class Wordbar_widget {
  function control(){
	
	$data = get_option('Wordbar_widget');
	
	?><p><label>Title: <input name="Wordbar_widget_title" type="text" value="<?php echo stripcslashes($data['title']); ?>" /></label></p><?php
	?><p><label>Target Wordcount: <input name="Wordbar_widget_targetcount" type="text" value="<?php echo $data['targetcount']; ?>" /></label></p><?php
	
	if (isset($_POST['Wordbar_widget_targetcount'])) {
		$data = get_option('Wordbar_widget');
		$data['targetcount'] = attribute_escape($_POST['Wordbar_widget_targetcount']);
		update_option('Wordbar_widget', $data);
	}
	
	if (isset($_POST['Wordbar_widget_title'])) {
		$data = get_option('Wordbar_widget');
		$data['title'] = attribute_escape($_POST['Wordbar_widget_title']);
		update_option('Wordbar_widget', $data);
	}
	
  }
  function widget($args){
	
    echo $args['before_widget'];
    $data = get_option('Wordbar_widget');
    if (trim(@$data['title']) == "") { $title = "My Wordbar"; } else { $title = stripcslashes($data['title']); };
    echo $args['before_title'] . $title . $args['after_title'];
    wordbar_render();
    echo $args['after_widget'];
  }
  function register(){
    register_sidebar_widget('Wordbar Widget', array('Wordbar_Widget', 'widget'));
    register_widget_control('Wordbar Widget', array('Wordbar_Widget', 'control'));
  }
}

?>
