<?php
/**
 * Legacy channel statics.
 *
 * This file contains an array of channel statics
 *
 * @package AdTribes\PFP\i18n
 */

defined( 'ABSPATH' ) || exit;

return array(
    'All countries'               => array(
        'Google Shopping'                      => array(
            'channel_hash' => 'd4cb75caae5a73ac6b01171816b33bfb',
            'name'         => 'Google Shopping',
            'fields'       => 'google_shopping',
            'taxonomy'     => 'google_shopping',
            'utm_source'   => 'Google Shopping',
            'type'         => 'Advertising',
        ),
        'Google Merchant Promotions Feed'      => array(
            'channel_hash' => 'b139f056f1c86e71d11d0ebbd3bdd948',
            'name'         => 'Google Merchant Promotions Feed',
            'fields'       => 'google_shopping_promotions',
            'taxonomy'     => 'none',
            'utm_source'   => 'Google Shopping',
            'type'         => 'Advertising',
        ),
        'Google Remarketing - DRM'             => array(
            'channel_hash' => '5dd24aca187e3a6b5820868e57043428',
            'name'         => 'Google Remarketing - DRM',
            'fields'       => 'google_drm',
            'taxonomy'     => 'none',
            'utm_source'   => 'Google Remarketing',
            'type'         => 'Advertising',
        ),
        'Google DSA Feed'                      => array(
            'channel_hash' => '008e1fda379835ba11512429631a792e',
            'name'         => 'Google - DSA',
            'fields'       => 'google_dsa',
            'taxonomy'     => 'none',
            'utm_source'   => 'Google DSA',
            'type'         => 'Advertising',
        ),
        'Google Local Products Feed'           => array(
            'channel_hash' => '26e3e513a3ee25a114910f1e8c619c48',
            'name'         => 'Google Local Products',
            'fields'       => 'google_local_products',
            'taxonomy'     => 'google_shopping',
            'utm_source'   => 'Google Local Products',
            'type'         => 'Advertising',
        ),
        'Google Local Products Inventory Feed' => array(
            'channel_hash' => '8e2d11264b29ea626889c6ae07d1858b',
            'name'         => 'Google Local Products Inventory',
            'fields'       => 'google_local',
            'taxonomy'     => 'google_shopping',
            'utm_source'   => 'Google Local Product Inventory',
            'type'         => 'Advertising',
        ),
        'Google Product Review Feed'           => array(
            'channel_hash' => '338250275238e84c070b18fb7ef5067e',
            'name'         => 'Google Product Review',
            'fields'       => 'google_product_review',
            'taxonomy'     => 'none',
            'utm_source'   => 'Google Product Review',
            'type'         => 'Advertising',
        ),
        'Bing Shopping'                        => array(
            'channel_hash' => 'db9030c52a0642cf6e47df03541dec1c',
            'name'         => 'Bing Shopping',
            'fields'       => 'google_shopping',
            'taxonomy'     => 'google_shopping',
            'utm_source'   => 'Bing Shopping',
            'type'         => 'Advertising',
        ),
        'Bing Shopping Promotions'             => array(
            'channel_hash' => 'b6a2e990e44fd2882d860d36e033161a',
            'name'         => 'Bing Shopping Promotions',
            'fields'       => 'google_shopping_promotions',
            'taxonomy'     => 'google_shopping_promotions',
            'utm_source'   => 'Bing Shopping Promotions',
            'type'         => 'Advertising',
        ),
        'Facebook Catalog Feed / Instagram'    => array(
            'channel_hash' => 'a80023c048bcf50aa70821992617d970',
            'name'         => 'Meta / Facebook Catalog Feed / Instagram',
            'fields'       => 'facebook_drm',
            'taxonomy'     => 'google_shopping',
            'utm_source'   => 'Facebook Catalog Feed',
            'type'         => 'Advertising',
        ),
        'Pinterest'                            => array(
            'channel_hash' => '86709a608bd914b28221164e6680ebf7',
            'name'         => 'Pinterest',
            'fields'       => 'pinterest',
            'taxonomy'     => 'google_shopping',
            'utm_source'   => 'Pinterest',
            'type'         => 'Advertising',
        ),
        'Twitter'                              => array(
            'channel_hash' => '2491bc9c7d8731e1ae33124093bc7026',
            'name'         => 'Twitter',
            'fields'       => 'google_shopping',
            'taxonomy'     => 'google_shopping',
            'utm_source'   => 'Twitter',
            'type'         => 'Advertising',
        ),
        'Pinterest RSS Board'                  => array(
            'channel_hash' => '6150bd7ad3e007709de90f035ef1615c',
            'name'         => 'Pinterest RSS Board',
            'fields'       => 'pinterest_rss',
            'taxonomy'     => 'none',
            'utm_source'   => 'Pinterest RSS Board',
            'type'         => 'Advertising',
        ),
        'Snapchat Product Catalog'             => array(
            'channel_hash' => 'b0c642f1d81e0d8e359c6efae6d23007',
            'name'         => 'Snapchat Product Catalog',
            'fields'       => 'snapchat',
            'taxonomy'     => 'google_shopping',
            'utm_source'   => 'snapchat',
            'type'         => 'Advertising',
        ),
        'TikTok Product Catalog'               => array(
            'channel_hash' => 'c18b6f285f37a8f4106611c9a247dffc',
            'name'         => 'TikTok Product Catalog',
            'fields'       => 'snapchat',
            'taxonomy'     => 'google_shopping',
            'utm_source'   => 'tiktok',
            'type'         => 'Advertising',
        ),

        'Vivino'                               => array(
            'channel_hash' => '4f4d30ea9fef64d166fe50c577e7f312',
            'name'         => 'Vivino',
            'fields'       => 'vivino',
            'taxonomy'     => 'none',
            'utm_source'   => 'Vivino',
            'type'         => 'Advertising',
        ),
        'OpenAI Product Feed'                  => array(
            'channel_hash' => '3f7d9c8b5e4a6f1d2c0e7b8a4d5f3e9c',
            'name'         => 'OpenAI Product Feed',
            'fields'       => 'openai',
            'taxonomy'     => 'none',
            'utm_source'   => 'OpenAI Product Feed',
            'type'         => 'Advertising',
        ),
    ),
    'Custom Feed'                 => array(
        'Custom Feed' => array(
            'channel_hash' => 'b0c1fa7a7dd12cadb7d8be768ce91315',
            'name'         => 'Custom Feed',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Custom Feed',
            'type'         => 'Custom Feed',
        ),
    ),
    'Afghanistan'                 => array(),
    'Albania'                     => array(),
    'Algeria'                     => array(),
    'Andorra'                     => array(),
    'Angola'                      => array(),
    'Antigua & Deps'              => array(),
    'Argentina'                   => array(
        'ShopMania' => array(
            'channel_hash' => '6efc3cdaf65f3da218c65281fcfe1bc3',
            'name'         => 'Shopmania.com.ar',
            'fields'       => 'shopmania_ro',
            'taxonomy'     => 'none',
            'utm_source'   => 'Shopmania.com.ar',
            'type'         => 'Marketplace',
        ),
        'Wish.com'  => array(
            'channel_hash' => '70ec5f93b0f12e6f76d5f97657f23cd4',
            'name'         => 'Wish.com',
            'fields'       => 'wishcom',
            'taxonomy'     => 'none',
            'utm_source'   => 'Wish.com',
            'type'         => 'Marketplace',
        ),
    ),
    'Armenia'                     => array(),
    'Australia'                   => array(
        'Catch.com.au'    => array(
            'channel_hash' => '7116d4b51bb0bdf631df9becc635e8c2',
            'name'         => 'Catch.com.au',
            'fields'       => 'catchcomau',
            'taxonomy'     => 'none',
            'utm_source'   => 'Catch.com.au',
            'type'         => 'Marketplace',
        ),
        'Wish.com'        => array(
            'channel_hash' => '70ec5f93b0f12e6f76d5f97657f23cd4',
            'name'         => 'Wish.com',
            'fields'       => 'wishcom',
            'taxonomy'     => 'none',
            'utm_source'   => 'Wish.com',
            'type'         => 'Marketplace',
        ),
        'Kogan.com'       => array(
            'channel_hash' => '0167abe8de113cca248094c9abdfa9ba',
            'name'         => 'Kogan.com',
            'fields'       => 'kogan',
            'taxonomy'     => 'none',
            'utm_source'   => 'Kogan.com',
            'type'         => 'Marketplace',
        ),
        'Fruugoaustralia' => array(
            'channel_hash' => 'b7cb6aa0f80b909311ae54a6230c78f7',
            'name'         => 'Fruugoaustralia.com',
            'fields'       => 'fruugoaus',
            'taxonomy'     => 'none',
            'utm_source'   => 'Fruugoaustralia.com',
            'type'         => 'Marketplace',
        ),
        'Shopping.com'    => array(
            'channel_hash' => '6e3bbd8e7e9ca791bf13f28fb701e038',
            'name'         => 'Shopping.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Shopping.com',
            'type'         => 'Comparison shopping engine',
        ),
        'Myshopping'      => array(
            'channel_hash' => '77a755aef80d6b6357f42ca4c298500a',
            'name'         => 'Myshopping.com.au',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Myshopping.com.au',
            'type'         => 'Comparison shopping engine',
        ),
        'ShopMania'       => array(
            'channel_hash' => 'a0ddcc639228faef4a9e14d9cb23c809',
            'name'         => 'Shopmania.com.au',
            'fields'       => 'shopmania_ro',
            'taxonomy'     => 'none',
            'utm_source'   => 'Shopmania.com.au',
            'type'         => 'Comparison shopping engine',
        ),
        'Polyvore.com'    => array(
            'channel_hash' => '9a9abd8532878629e2b3487c1ad157eb',
            'name'         => 'Polyvore.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Polyvore.com',
            'type'         => 'Comparison shopping engine',
        ),
    ),
    'Austria'                     => array(),
    'Azerbaijan'                  => array(),
    'Bahamas'                     => array(),
    'Bahrain'                     => array(),
    'Bangladesh'                  => array(),
    'Barbados'                    => array(),
    'Belarus'                     => array(),
    'Belgium'                     => array(
        'Vergelijk.be'  => array(
            'channel_hash' => 'b14cc501a3a39111ada7d135eecaf1c8',
            'name'         => 'Vergelijk.be',
            'fields'       => 'vergelijkbe',
            'taxonomy'     => 'none',
            'utm_source'   => 'Vergelijk.be',
            'type'         => 'Comparison shopping engine',
        ),
        'Comparer.be'   => array(
            'channel_hash' => '94e9e3ebc8c4d09cf6d5678db730d312',
            'name'         => 'Comparer.be',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Comparer.be',
            'type'         => 'Comparison shopping engine',
        ),
        'Kieskeurig.be' => array(
            'channel_hash' => '2775af9e954da0528a1e9e7520d74cd4',
            'name'         => 'Kieskeurig.be',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Kieskeurig.be',
            'type'         => 'Comparison shopping engine',
        ),
        'Beslist.be'    => array(
            'channel_hash' => '04e1cd6fae01b2a7f92cf228192955c7',
            'name'         => 'Beslist.be',
            'fields'       => 'beslist',
            'taxonomy'     => 'none',
            'utm_source'   => 'Beslist.be',
            'type'         => 'Comparison shopping engine',
        ),
        'Bol.com'       => array(
            'channel_hash' => '304953957ace01b0632a659b05c976fa',
            'name'         => 'Bol.com',
            'fields'       => 'bol',
            'taxonomy'     => 'none',
            'utm_source'   => 'Bol.com',
            'type'         => 'Marketplace',
        ),
    ),
    'Belize'                      => array(),
    'Benin'                       => array(),
    'Bhutan'                      => array(),
    'Bolivia'                     => array(),
    'Bosnia Herzegovina'          => array(),
    'Botswana'                    => array(),
    'Brazil'                      => array(
        'Stylight'  => array(
            'channel_hash' => '37071bd1527b16cea909bf9efba4677c',
            'name'         => 'Stylight.com.br',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Stylight.com.br',
            'type'         => 'Comparison shopping engine',
        ),
        'Shopmania' => array(
            'channel_hash' => 'f106585b820c3ef031c5a4429d84658b',
            'name'         => 'Shopmania.com.br',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Shopmanie.com.br',
            'type'         => 'Comparison shopping engine',
        ),
    ),
    'Brunei'                      => array(),
    'Bulgaria'                    => array(
        'Shopmania' => array(
            'channel_hash' => 'fb595d74de3599b73a7e2463873db035',
            'name'         => 'Shopmania.bg',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Shopmanie.bg',
            'type'         => 'Comparison shopping engine',
        ),
    ),
    'Burkina'                     => array(),
    'Burundi'                     => array(),
    'Cambodia'                    => array(),
    'Cameroon'                    => array(),
    'Canada'                      => array(
        'Incurvy'      => array(
            'channel_hash' => 'b9c15c9c8b92b028ece8171dc10a1dcc',
            'name'         => 'Incurvy.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Incurvy.com',
            'type'         => 'Marketplace',
        ),
        'Kijiji'       => array(
            'channel_hash' => '9c050ba1834dbd534f2dcf58341bdb49',
            'name'         => 'Kijiji.ca',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Kijiji.ca',
            'type'         => 'Advertising',
        ),
        'Polyvore.com' => array(
            'channel_hash' => '9a9abd8532878629e2b3487c1ad157eb',
            'name'         => 'Polyvore.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Polyvore.com',
            'type'         => 'Comparison shopping engine',
        ),
        'Stylight.ca'  => array(
            'channel_hash' => '25722c8eecf57e6be5d90a7074617dce',
            'name'         => 'Stylight.ca',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Stylight.ca',
            'type'         => 'Comparison shopping engine',
        ),
    ),
    'Cape Verder'                 => array(),
    'Central African Rep'         => array(),
    'Chad'                        => array(),
    'Chile'                       => array(
        'Shopmania.cl' => array(
            'channel_hash' => 'c7b6ca35fa8657536447d821629d883c',
            'name'         => 'Shopmania.cl',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Shopmania.cl',
            'type'         => 'Comparison shopping engine',
        ),
    ),
    'China'                       => array(),
    'Colombia'                    => array(),
    'Comoros'                     => array(),
    'Congo'                       => array(),
    'Costa Rica'                  => array(),
    'Croatia'                     => array(),
    'Cuba'                        => array(),
    'Cyprus'                      => array(),
    'Czech Republic'              => array(
        'Shop-mania.cz' => array(
            'channel_hash' => '8f9ebbc4890cad87750226f60e072f16',
            'name'         => 'Shop-mania.cz',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Shop-mania.cz',
            'type'         => 'Comparison shopping engine',
        ),
        'Glami'         => array(
            'channel_hash' => '374cd7095ff1ddac2b22862387012c79',
            'name'         => 'Glami.cz',
            'fields'       => 'glami',
            'taxonomy'     => 'none',
            'utm_source'   => 'Glami.vz',
            'type'         => 'Comparison shopping engine',
        ),
        'Kelkoo.cz'     => array(
            'channel_hash' => '5ea8c05e549f9a84334ac21667ad8348',
            'name'         => 'Kelkoo.cz',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Kelkoo.cz',
            'type'         => 'Comparison shopping engine',
        ),
        'Zbozi.cz'      => array(
            'channel_hash' => '3dc562578553be9862881159004f0017',
            'name'         => 'Zbozi.cz',
            'fields'       => 'zbozi',
            'taxonomy'     => 'none',
            'utm_source'   => 'Zbozi.cz',
            'type'         => 'Comparison shopping engine',
        ),
        'Shopalike.cz'  => array(
            'channel_hash' => '305720fe0a9ecd993dbf4fa62319f314',
            'name'         => 'Shopalike.cz',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Shopalike.cz',
            'type'         => 'Comparison shopping engine',
        ),
        'Heureka.cz'    => array(
            'channel_hash' => '58f2a2d37c2437078ac08e3ea1771673',
            'name'         => 'Heureka.cz',
            'fields'       => 'heureka',
            'taxonomy'     => 'none',
            'utm_source'   => 'Heureka.cz',
            'type'         => 'Marketplace',
        ),
    ),
    'Denmark'                     => array(
        'Adform'      => array(
            'channel_hash' => '15602bd34e4d3e8a319b24328f5e1629',
            'name'         => 'Adform',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Adform.com',
            'type'         => 'Advertising',
        ),
        'Smartly.io'  => array(
            'channel_hash' => '461ad54178f49a7c738633afabf21c12',
            'name'         => 'Smartly.io',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Smartly.io',
            'type'         => 'Advertising',
        ),
        'Pricerunner' => array(
            'channel_hash' => '543d00bd13951a8155e712c12ac96e99',
            'name'         => 'Pricerunner.dk',
            'fields'       => 'pricerunner',
            'taxonomy'     => 'none',
            'utm_source'   => 'Pricerunner.dk',
            'type'         => 'Comparison shopping engine',
        ),
        'Shopalike'   => array(
            'channel_hash' => 'd46c69236087665b5439092b3db4af0e',
            'name'         => 'ShopAlike.dk',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'ShopAlike.dk',
            'type'         => 'Comparison shopping engine',
        ),
        'Miinto'      => array(
            'channel_hash' => 'f4d56ea28a3b6903c484ec6dfc15fd4b',
            'name'         => 'Miinto.dk',
            'fields'       => 'miinto_dk',
            'taxonomy'     => 'none',
            'utm_source'   => 'Miinto.dk',
            'type'         => 'Comparison shopping engine',
        ),
        'Katoni'      => array(
            'channel_hash' => '77aae8def5af3ac1136b5977e3f3894f',
            'name'         => 'Katoni.dk',
            'fields'       => 'katoni',
            'taxonomy'     => 'none',
            'utm_source'   => 'Katoni.dk',
            'type'         => 'Comparison shopping engine',
        ),
    ),
    'Djibouti'                    => array(),
    'Dominica'                    => array(),
    'Dominican Republic'          => array(),
    'East Timor'                  => array(),
    'Ecuador'                     => array(),
    'Egypt'                       => array(),
    'El Salvador'                 => array(),
    'Equatorial Guinea'           => array(),
    'Eritrea'                     => array(),
    'Estonia'                     => array(),
    'Ethiopia'                    => array(),
    'Fiji'                        => array(),
    'Finland'                     => array(
        'Adform'        => array(
            'channel_hash' => '15602bd34e4d3e8a319b24328f5e1629',
            'name'         => 'Adform',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Adform.com',
            'type'         => 'Advertising',
        ),
        'Smartly.io'    => array(
            'channel_hash' => '461ad54178f49a7c738633afabf21c12',
            'name'         => 'Smartly.io',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Smartly.io',
            'type'         => 'Advertising',
        ),
        'Vertaa.fi'     => array(
            'channel_hash' => '8eb68a68e5f26a54a96274cf535fdcdf',
            'name'         => 'Vertaa.fi',
            'fields'       => 'vertaafi',
            'taxonomy'     => 'none',
            'utm_source'   => 'Vertaa.fi',
            'type'         => 'Comparison shopping engine',
        ),
        'Prisjakt'      => array(
            'channel_hash' => 'a7c74fa1a6dab18191ba2da46450b4d4',
            'name'         => 'Prisjakt',
            'fields'       => 'google_shopping',
            'taxonomy'     => 'google_shopping',
            'utm_source'   => 'Prisjakt',
            'type'         => 'Comparison shopping engine',
        ),
        'Hintaseuranta' => array(
            'channel_hash' => '156bc501056b152b57baed207b1a13b7',
            'name'         => 'Hintaseuranta.fi',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Hintaseuranta.fi',
            'type'         => 'Comparison shopping engine',
        ),
    ),
    'France'                      => array(
        'Connexity'        => array(
            'channel_hash' => 'e8ce03e3f24a932e7ac633d37fef1654',
            'name'         => 'Connexity',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Connexity.com',
            'type'         => 'Advertising',
        ),
        'Cdiscount'        => array(
            'channel_hash' => 'd93f2d96234c4e431037e620d0cfed38',
            'name'         => 'Cdiscount.fr',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Cdiscount.fr',
            'type'         => 'Marketplace',
        ),
        'Fnac'             => array(
            'channel_hash' => 'd62c19cba6e3072a6b4aa1210ab97fe1',
            'name'         => 'Fnac.fr',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Fnac.fr',
            'type'         => 'Marketplace',
        ),
        'ManoMano'         => array(
            'channel_hash' => '96cf4957b22a5a4844ae6eeaecdd914e',
            'name'         => 'ManoMano.fr',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'ManoMano.fr',
            'type'         => 'Marketplace',
        ),
        'Incurvy'          => array(
            'channel_hash' => '8f5a5256a7f6fb954be381327445440b',
            'name'         => 'Incurvy',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Incurvy',
            'type'         => 'Marketplace',
        ),
        'Cherchons.com'    => array(
            'channel_hash' => '6a9697f23060d90ac2d090c6e59fe22d',
            'name'         => 'Cherchons.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Cherchons.com',
            'type'         => 'Comparison shopping engine',
        ),
        'Choozen.fr'       => array(
            'channel_hash' => '19041edf315d34d799f1f1608a9baa4d',
            'name'         => 'Choozen.fr',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Choozen.fr',
            'type'         => 'Comparison shopping engine',
        ),
        'Ciao.fr'          => array(
            'channel_hash' => 'dd98d44d496bfb11717dbef588c32a67',
            'name'         => 'Ciao.fr',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Ciao.fr',
            'type'         => 'Comparison shopping engine',
        ),
        'Comparer.fr'      => array(
            'channel_hash' => 'dd6f55470c8b1b90a099d2669befb132',
            'name'         => 'Comparer.fr',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Comparer.fr',
            'type'         => 'Comparison shopping engine',
        ),
        'Idealo.fr'        => array(
            'channel_hash' => 'dfec07026d2a6724bb609bbb9ad1028a',
            'name'         => 'Idealo.fr',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Idealo.fr',
            'type'         => 'Comparison shopping engine',
        ),
        'Kelkoo.fr'        => array(
            'channel_hash' => 'd3f1473a0f4eb16743e7d496a15c0af3',
            'name'         => 'Kelkoo.fr',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Kelkoo.fr',
            'type'         => 'Comparison shopping engine',
        ),
        'LeGuide.fr'       => array(
            'channel_hash' => '598ec5697697e716d95e7a7f12e029d5',
            'name'         => 'LeGuide.fr',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'LeGuide.fr',
            'type'         => 'Comparison shopping engine',
        ),
        'Miinto'           => array(
            'channel_hash' => '38ee6eeeb2c68f39c3d0b5759db8ffca',
            'name'         => 'Miinto.fr',
            'fields'       => 'miinto_fr',
            'taxonomy'     => 'none',
            'utm_source'   => 'Miinto.fr',
            'type'         => 'Comparison shopping engine',
        ),
        'Priceminister.fr' => array(
            'channel_hash' => '3b5483411970132dd1ac20a5d080162e',
            'name'         => 'Priceminister.fr',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Priceminister.fr',
            'type'         => 'Comparison shopping engine',
        ),
        'Pricerunner.fr'   => array(
            'channel_hash' => 'cdd7a67023b9761e66d22818731ded4e',
            'name'         => 'Pricerunner.fr',
            'fields'       => 'pricerunner',
            'taxonomy'     => 'none',
            'utm_source'   => 'Pricerunner.fr',
            'type'         => 'Comparison shopping engine',
        ),
        'ShopAlike.fr'     => array(
            'channel_hash' => 'a8a47c7477ab85d695dfbe59c02a9110',
            'name'         => 'ShopAlike.fr',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'ShopAlike.fr',
            'type'         => 'Comparison shopping engine',
        ),
        'ShopMania.fr'     => array(
            'channel_hash' => 'dc4d5c1673ce330ccd3250236f74974b',
            'name'         => 'ShopMania.fr',
            'fields'       => 'shopmania_ro',
            'taxonomy'     => 'none',
            'utm_source'   => 'ShopMania.fr',
            'type'         => 'Comparison shopping engine',
        ),
        'Shopping.com'     => array(
            'channel_hash' => '6e3bbd8e7e9ca791bf13f28fb701e038',
            'name'         => 'Shopping.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Shopping.com',
            'type'         => 'Comparison shopping engine',
        ),
        'Shopzilla.fr'     => array(
            'channel_hash' => '26347f8580ca8411762c47ba4980642b',
            'name'         => 'Shopzilla.fr',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Shopzilla.fr',
            'type'         => 'Comparison shopping engine',
        ),
        'Stylefruits.fr'   => array(
            'channel_hash' => '6e583ed7574776a8e14234fbba0cb5c6',
            'name'         => 'Stylefruits.fr',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Stylefruits.fr',
            'type'         => 'Comparison shopping engine',
        ),
        'Stylight.fr'      => array(
            'channel_hash' => '4297f0a03b3eb2c1f287788603294543',
            'name'         => 'Stylight.fr',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Stylight.fr',
            'type'         => 'Comparison shopping engine',
        ),
        'Twenga.fr'        => array(
            'channel_hash' => 'b1fd34002f837eaf30af24abdc75f3cb',
            'name'         => 'Twenga.fr',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Twenga.fr',
            'type'         => 'Comparison shopping engine',
        ),
        'Webmarchand.com'  => array(
            'channel_hash' => '5aee3b77e05409685dc54772210c89fa',
            'name'         => 'Webmarchand.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Webmarchand.com',
            'type'         => 'Comparison shopping engine',
        ),
    ),
    'French Guiana'               => array(),
    'Gabon'                       => array(),
    'Gambia'                      => array(),
    'Georgia'                     => array(),
    'Germany'                     => array(
        'Connexity'       => array(
            'channel_hash' => 'e8ce03e3f24a932e7ac633d37fef1654',
            'name'         => 'Connexity',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Connexity.com',
            'type'         => 'Advertising',
        ),
        'Adform'          => array(
            'channel_hash' => '1f8fd79bdc962ff2bd707095cb9b998e',
            'name'         => 'Adform',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Adform',
            'type'         => 'Advertising',
        ),
        'AdRoll'          => array(
            'channel_hash' => '66bb51c1b1beb93d13b3232548cd06c1',
            'name'         => 'AdRoll.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'AdRoll.de',
            'type'         => 'Advertising',
        ),
        'ElCheapo.de'     => array(
            'channel_hash' => '3158228c1b0ef249aa27f74879234938',
            'name'         => 'ElCheapo.de',
            'fields'       => 'vergelijknl',
            'taxonomy'     => 'none',
            'utm_source'   => 'ElCheapo.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Smartly.io'      => array(
            'channel_hash' => '461ad54178f49a7c738633afabf21c12',
            'name'         => 'Smartly.io',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Smartly.io',
            'type'         => 'Advertising',
        ),
        'TheNextAd'       => array(
            'channel_hash' => '313e53991d222faa60c8654d157adf91',
            'name'         => 'TheNextAd',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'TheNextAd',
            'type'         => 'Advertising',
        ),
        'Webgains'        => array(
            'channel_hash' => '0f30f50891d0306a7560532e75f8d972',
            'name'         => 'Webgains.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Webgains.de',
            'type'         => 'Advertising',
        ),
        'Crowdfox'        => array(
            'channel_hash' => '84536c34ee3130d6bc3cb8a2aca1af65',
            'name'         => 'Crowdfox.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Crowdfox.com',
            'type'         => 'Marketplace',
        ),
        'Real.de'         => array(
            'channel_hash' => 'e014d0bb084768f36664c749a1074631',
            'name'         => 'Real.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Real.de',
            'type'         => 'Marketplace',
        ),
        'Incurvy.de'      => array(
            'channel_hash' => 'a7ebc5d86ba15fe717ce8c53c97ed46f',
            'name'         => 'Incurvy.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Incurvy.de',
            'type'         => 'Marketplace',
        ),
        'Allyouneed'      => array(
            'channel_hash' => '049fb486d3893e0d6ad644e5860d105d',
            'name'         => 'Allyouneed.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Allyouneed.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Apomio'          => array(
            'channel_hash' => 'ffc2c824a3baba59aef78fb2aa527778',
            'name'         => 'Apomio.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Apomio.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Billiger'        => array(
            'channel_hash' => '960855afe1068c4577ffeea7c14d56f4',
            'name'         => 'Billiger.de',
            'fields'       => 'billiger',
            'taxonomy'     => 'none',
            'utm_source'   => 'Billiger.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Choozen'         => array(
            'channel_hash' => '7aa805f40ae37f794a1336fe9543a74e',
            'name'         => 'Choozen.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Choozen.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Ciao'            => array(
            'channel_hash' => '7af3a673866f2ab7525b721549d8d460',
            'name'         => 'Ciao.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Ciao.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Domodi'          => array(
            'channel_hash' => '6ec9a3eeb4f64c3d5aaf5e96710178b0',
            'name'         => 'Domodi.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Domodi.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Fashiola'        => array(
            'channel_hash' => '1936afcd82ebd5e3545e9fc11ccc353b',
            'name'         => 'Fashiola.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Fashiola.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Geizhals'        => array(
            'channel_hash' => 'cd92901262dc9fec50419741d2967df9',
            'name'         => 'Geizhals.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Geishals.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Guenstiger'      => array(
            'channel_hash' => '91274396f50a1d0bbeb85cacaaa7b128',
            'name'         => 'Guenstiger.de',
            'fields'       => 'guenstiger',
            'taxonomy'     => 'none',
            'utm_source'   => 'Guenstiger.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Hood.de'         => array(
            'channel_hash' => '5db45e968ba43c2bd407d45b032eed8c',
            'name'         => 'Hood.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Hood.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Idealo.de'       => array(
            'channel_hash' => '2ee3561d8c79d18f53203ca765482201',
            'name'         => 'Idealo.de',
            'fields'       => 'idealo',
            'taxonomy'     => 'none',
            'utm_source'   => 'Idealo.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Kelkoo.de'       => array(
            'channel_hash' => '4d910564613d32784060cc2f1a9fd151',
            'name'         => 'Kelkoo.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Kelkoo.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Ladenzeile.de'   => array(
            'channel_hash' => '223d4ab99245b88158fe5baef97bd0a8',
            'name'         => 'Ladenzeile.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Ladenzeile.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Livingo.de'      => array(
            'channel_hash' => '79a3d6a445837ab2ec62c291a9c0a8c2',
            'name'         => 'Livingo.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Livingo.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Medizinfuchs.de' => array(
            'channel_hash' => '182dc45ca30116e3216f82759cc015ee',
            'name'         => 'Medizinfuchs.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Medizinfuchs.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Moebel.de'       => array(
            'channel_hash' => '490f766df6fc7e0af4330da9894deb4d',
            'name'         => 'Moebel.de',
            'fields'       => 'moebel',
            'taxonomy'     => 'none',
            'utm_source'   => 'Moebel.de',
            'type'         => 'Comparison shopping engine',
        ),
        'My Best Brands'  => array(
            'channel_hash' => '453ca2dddfe68601d8cfcb0e98c76a89',
            'name'         => 'Mybestbrands.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Mybestbrands.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Miinto'          => array(
            'channel_hash' => 'fab6e42f1657ed83bb21f7111a5a7c7d',
            'name'         => 'Miinto.de',
            'fields'       => 'miinto_de',
            'taxonomy'     => 'none',
            'utm_source'   => 'Miinto.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Preis.de'        => array(
            'channel_hash' => '045f1a0c057d99ce462ae97ac89aa5ca',
            'name'         => 'Preis.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Preis.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Pricerunner.de'  => array(
            'channel_hash' => 'ea3b639b7af05673e1800526f24d5a1a',
            'name'         => 'Pricerunner.de',
            'fields'       => 'pricerunner',
            'taxonomy'     => 'none',
            'utm_source'   => 'Pricerunner.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Rakuten.de'      => array(
            'channel_hash' => 'de56d454b94ed12c1ef320321a748531',
            'name'         => 'Rakuten.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Rakuten.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Restposten.de'   => array(
            'channel_hash' => 'd8ace963800514a43bbecdc39080ac10',
            'name'         => 'Restposten.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Restposten.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Shopmania.de'    => array(
            'channel_hash' => 'bd851db4983a92fd0964aec473011294',
            'name'         => 'Shopmania.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Shopmania.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Shopping.com'    => array(
            'channel_hash' => '6e3bbd8e7e9ca791bf13f28fb701e038',
            'name'         => 'Shopping.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Shopping.com',
            'type'         => 'Comparison shopping engine',
        ),
        'Shopzilla.de'    => array(
            'channel_hash' => '7a63803182a008ed3601eb064778c14e',
            'name'         => 'Shopzilla.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Shopzilla.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Sparmedo.de'     => array(
            'channel_hash' => '226c5d6ef522a955723e39e41d790c95',
            'name'         => 'Sparmedo.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Sparmedo.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Stylefruits.de'  => array(
            'channel_hash' => '8adce1fb4e054d16a3b808cc2728db5e',
            'name'         => 'Stylefruits.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Stylefruits.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Stylelounge.de'  => array(
            'channel_hash' => 'b3be5fb5526c2a214a9e2ef33518fe4a',
            'name'         => 'Stylelounge.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Stylelounge.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Stylight.de'     => array(
            'channel_hash' => 'ad0e620da1822d19bd857d91f58b8c3d',
            'name'         => 'Stylight.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Stylight.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Twenga.de'       => array(
            'channel_hash' => '9a43d51ce80705fe2b3ef11e35effc85',
            'name'         => 'Twenga.de',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Twenga.de',
            'type'         => 'Comparison shopping engine',
        ),
        'Wish.com'        => array(
            'channel_hash' => '70ec5f93b0f12e6f76d5f97657f23cd4',
            'name'         => 'Wish.com',
            'fields'       => 'wishcom',
            'taxonomy'     => 'none',
            'utm_source'   => 'Wish.com',
            'type'         => 'Marketplace',
        ),
    ),
    'Ghana'                       => array(),
    'Greece'                      => array(
        'Incurvy'   => array(
            'channel_hash' => 'b9c15c9c8b92b028ece8171dc10a1dcc',
            'name'         => 'Incurvy',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Incurvy.com',
            'type'         => 'Marketplace',
        ),
        'Shopflix'  => array(
            'channel_hash' => 'edef5ac2c42264023ed18a3da1eff2c6',
            'name'         => 'Shopflix',
            'fields'       => 'shopflix',
            'taxonomy'     => 'none',
            'utm_source'   => 'Shopflix.gr',
            'type'         => 'Marketplace',
        ),
        'Skroutz'   => array(
            'channel_hash' => 'd4e5a1ae056299a65ce0d2b72b83ac00',
            'name'         => 'Skroutz',
            'fields'       => 'skroutz',
            'taxonomy'     => 'none',
            'utm_source'   => 'Skroutz.gr',
            'type'         => 'Comparison shopping engine',
        ),
        'Bestprice' => array(
            'channel_hash' => '3678b92a2e469b2d32d2918275b54f1b',
            'name'         => 'Bestprice',
            'fields'       => 'bestprice',
            'taxonomy'     => 'none',
            'utm_source'   => 'Bestprice.gr',
            'type'         => 'Comparison shopping engine',
        ),
        'Glami'     => array(
            'channel_hash' => '5eb6e7e39596930e78c653c83699ef04',
            'name'         => 'Glami.gr',
            'fields'       => 'glami',
            'taxonomy'     => 'none',
            'utm_source'   => 'Glami.gr',
            'type'         => 'Comparison shopping engine',
        ),
    ),
    'Grenada'                     => array(),
    'Guadeloupe'                  => array(),
    'Guatemala'                   => array(),
    'Guinea'                      => array(),
    'Guinea-Bissau'               => array(),
    'Guyana'                      => array(),
    'Haiti'                       => array(),
    'Honduras'                    => array(),
    'Hong Kong'                   => array(),
    'Hungary'                     => array(
        'ShopMania' => array(
            'channel_hash' => 'a4add996b9580ee7f1d08832c974cb0a',
            'name'         => 'ShopMania.hu',
            'fields'       => 'shopmania_ro',
            'taxonomy'     => 'none',
            'utm_source'   => 'ShopMania.hu',
            'type'         => 'Comparison shopping engine',
        ),
    ),
    'Iceland'                     => array(),
    'India'                       => array(
        'ShopMania' => array(
            'channel_hash' => 'b871141a936ff750db71bd3dfc3b1924',
            'name'         => 'ShopMania.in',
            'fields'       => 'shopmania_ro',
            'taxonomy'     => 'none',
            'utm_source'   => 'ShopMania.in',
            'type'         => 'Comparison shopping engine',
        ),
    ),
    'Indonesia'                   => array(),
    'Iran'                        => array(),
    'Iraq'                        => array(),
    'Ireland'                     => array(
        'ShopMania' => array(
            'channel_hash' => '3f4759c9332fedd2fa7182d7953793b6',
            'name'         => 'ShopMania.ie',
            'fields'       => 'shopmania_ro',
            'taxonomy'     => 'none',
            'utm_source'   => 'ShopMania.ie',
            'type'         => 'Comparison shopping engine',
        ),
        'Stylight'  => array(
            'channel_hash' => '7393cbc85411aba928c7443420a65eb1',
            'name'         => 'Stylight.ie',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Stylight.ie',
            'type'         => 'Comparison shopping engine',
        ),
    ),
    'Israel'                      => array(
        'Zap.co.il' => array(
            'channel_hash' => '173421ab95332639b860baf534501a35',
            'name'         => 'Zap.co.il',
            'fields'       => 'zap',
            'taxonomy'     => 'none',
            'utm_source'   => 'Zap.co.il',
            'type'         => 'Comparison shopping engine',
        ),
    ),
    'Italy'                       => array(
        'ShopAlike'   => array(
            'channel_hash' => 'd5b85ea8d340869b82e98a6ccfb4162d',
            'name'         => 'ShopAlike.it',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'ShopAlike.it',
            'type'         => 'Comparison shopping engine',
        ),
        'Idealo.it'   => array(
            'channel_hash' => '0362057dfeec1227d736e028b8f96d87',
            'name'         => 'Idealo.it',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Idealo.it',
            'type'         => 'Comparison shopping engine',
        ),
        'ShopMania'   => array(
            'channel_hash' => '03984d720f798a8278f72c4de8b9d13e',
            'name'         => 'ShopMania.it',
            'fields'       => 'shopmania_ro',
            'taxonomy'     => 'none',
            'utm_source'   => 'ShopMania.it',
            'type'         => 'Comparison shopping engine',
        ),
        'Trovaprezzi' => array(
            'channel_hash' => '704d5085f0631c2819207d73bc42324a',
            'name'         => 'Trovaprezzi.it',
            'fields'       => 'trovaprezzi',
            'taxonomy'     => 'none',
            'utm_source'   => 'Trovaprezzi.it',
            'type'         => 'Comparison shopping engine',
        ),
        'Stylight'    => array(
            'channel_hash' => '45bcc322af1565f20c6aa534b0b90986',
            'name'         => 'Stylight.it',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Stylight.it',
            'type'         => 'Comparison shopping engine',
        ),
        'Kijiji'      => array(
            'channel_hash' => 'da45d6e36e7d20a274a4165cc79aebdb',
            'name'         => 'Kijiji.it',
            'fields'       => 'kijiji',
            'taxonomy'     => 'none',
            'utm_source'   => 'Kijiji.it',
            'type'         => 'Marketplace',
        ),
        'Wish.com'    => array(
            'channel_hash' => '70ec5f93b0f12e6f76d5f97657f23cd4',
            'name'         => 'Wish.com',
            'fields'       => 'wishcom',
            'taxonomy'     => 'none',
            'utm_source'   => 'Wish.com',
            'type'         => 'Marketplace',
        ),
    ),
    'Ivory Coast'                 => array(),
    'Jamaica'                     => array(),
    'Japan'                       => array(
        'ShopMania' => array(
            'channel_hash' => 'd88609f76a0e1f87c7afd03c839c7cb7',
            'name'         => 'ShopMania.jp',
            'fields'       => 'shopmania_ro',
            'taxonomy'     => 'none',
            'utm_source'   => 'ShopMania.jp',
            'type'         => 'Comparison shopping engine',
        ),
    ),
    'Jordan'                      => array(),
    'Kazakhstan'                  => array(),
    'Kenya'                       => array(),
    'Kiribati'                    => array(),
    'Korea North'                 => array(),
    'Korea South'                 => array(),
    'Kosovo'                      => array(),
    'Kuwait'                      => array(),
    'Kyrgyzstan'                  => array(),
    'Laos'                        => array(),
    'Latvia'                      => array(
        'Salidzini.lv' => array(
            'channel_hash' => 'a935d1752ae3a0636a9e746e64fd3d77',
            'name'         => 'Salidzini.lv',
            'fields'       => 'salidzini',
            'taxonomy'     => 'none',
            'utm_source'   => 'Salidzini.lv',
            'type'         => 'Comparison shopping engine',
        ),
    ),
    'Lebanon'                     => array(),
    'Lesotho'                     => array(),
    'Liberia'                     => array(),
    'Libya'                       => array(),
    'Lichtenstein'                => array(),
    'Lithuania'                   => array(),
    'Luxembourg'                  => array(),
    'Macedonia'                   => array(),
    'Madagascar'                  => array(),
    'Malawi'                      => array(),
    'Malaysia'                    => array(),
    'Maldives'                    => array(),
    'Mali'                        => array(),
    'Malta'                       => array(),
    'Marshall Islands'            => array(),
    'Martinique'                  => array(),
    'Mauritania'                  => array(),
    'Mauritius'                   => array(),
    'Mexico'                      => array(
        'ShopMania' => array(
            'channel_hash' => '065f36bd06d8a8aedaf3b769c003a320',
            'name'         => 'ShopMania.com.mx',
            'fields'       => 'shopmania_ro',
            'taxonomy'     => 'none',
            'utm_source'   => 'ShopMania.com.mx',
            'type'         => 'Comparison shopping engine',
        ),
        'Stylight'  => array(
            'channel_hash' => '8d71e67b84160c2dd655c9eb9fa100f3',
            'name'         => 'Stylight.com.mx',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Stylight.com.mx',
            'type'         => 'Comparison shopping engine',
        ),

    ),
    'Micronesia'                  => array(),
    'Moldova'                     => array(),
    'Monaco'                      => array(),
    'Mongolia'                    => array(),
    'Montenegro'                  => array(),
    'Morocco'                     => array(),
    'Mozambiqua'                  => array(),
    'Myanmar'                     => array(),
    'Namibia'                     => array(),
    'Nauru'                       => array(),
    'Nepal'                       => array(),
    'Netherlands'                 => array(
        'Vergelijk.nl'         => array(
            'channel_hash' => '7c65ce50e8175aef25d8a8946c0b1368',
            'name'         => 'Vergelijk.nl',
            'fields'       => 'vergelijknl',
            'taxonomy'     => 'none',
            'utm_source'   => 'Vergelijk.nl',
            'type'         => 'Comparison shopping engine',
        ),
        'Kieskeurig.nl'        => array(
            'channel_hash' => '15e8f034cbbbc39d612225a650782f2b',
            'name'         => 'Kieskeurig.nl',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Kieskeurig.nl',
            'type'         => 'Comparison shopping engine',
        ),
        'Tweakers.nl'          => array(
            'channel_hash' => '873e1e4b39d951b129dee8e277319696',
            'name'         => 'Tweakers.nl',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Tweakers.nl',
            'type'         => 'Comparison shopping engine',
        ),
        'Boetiek.nl'           => array(
            'channel_hash' => '432a39d14c7d8e7fd362027a9a111512',
            'name'         => 'Boetiek.nl',
            'fields'       => 'boetiek',
            'taxonomy'     => 'none',
            'utm_source'   => 'Boetiek.nl',
            'type'         => 'Comparison shopping engine',
        ),
        'Fashionchick.nl'      => array(
            'channel_hash' => '4e943c208f8a5c17ba7743cd355cb335',
            'name'         => 'Fashionchick.nl',
            'fields'       => 'fashionchick',
            'taxonomy'     => 'none',
            'utm_source'   => 'Fashionchick.nl',
            'type'         => 'Comparison shopping engine',
        ),
        'Kleding.nl'           => array(
            'channel_hash' => 'a87809b5d8a28c0c1928c8b4a74a5aaf',
            'name'         => 'Kleding.nl',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Kleding.nl',
            'type'         => 'Comparison shopping engine',
        ),
        'Hardware.info'        => array(
            'channel_hash' => 'e29f2c729fe2ac1a65e6cff2bc137401',
            'name'         => 'Hardware.info',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Hardware.info',
            'type'         => 'Comparison shopping engine',
        ),
        'Kelkoo.nl'            => array(
            'channel_hash' => '255bfbafa81ea4f6543f0b0b4d84b3c8',
            'name'         => 'Kelkoo.nl',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Kelkoo.nl',
            'type'         => 'Comparison shopping engine',
        ),
        'Ciao-shopping.nl'     => array(
            'channel_hash' => '3f89f2f63b515336f47bb15960da3e3b',
            'name'         => 'Cia-shopping.nl',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Ciao-shopping.nl',
            'type'         => 'Comparison shopping engine',
        ),
        'Beslist.nl'           => array(
            'channel_hash' => 'c1dffa4aec7858719db7d59af8e3d1c9',
            'name'         => 'Beslist.nl',
            'fields'       => 'beslist',
            'taxonomy'     => 'none',
            'utm_source'   => 'Beslist.nl',
            'type'         => 'Comparison shopping engine',
        ),
        'Miinto'               => array(
            'channel_hash' => '47fe5a9cd14e2d763213711ab191138e',
            'name'         => 'Miinto.nl',
            'fields'       => 'miinto_nl',
            'taxonomy'     => 'none',
            'utm_source'   => 'Miinto.nl',
            'type'         => 'Comparison shopping engine',
        ),
        'Bol.com'              => array(
            'channel_hash' => '304953957ace01b0632a659b05c976fa',
            'name'         => 'Bol.com',
            'fields'       => 'bol',
            'taxonomy'     => 'none',
            'utm_source'   => 'Bol.com',
            'type'         => 'Marketplace',
        ),
        'Fruugo.nl'            => array(
            'channel_hash' => '59cfba15aef47e3743cdf4e388c6ef6a',
            'name'         => 'Fruugo.nl',
            'fields'       => 'fruugonl',
            'taxonomy'     => 'none',
            'utm_source'   => 'Fruugo.nl',
            'type'         => 'Marketplace',
        ),
        'Ooshopping.nl'        => array(
            'channel_hash' => 'c4d493daf417220eac8552b1fc1b18b3',
            'name'         => 'Ooshopping.nl',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Ooshopping.nl',
            'type'         => 'Marketplace',
        ),
        'Adform'               => array(
            'channel_hash' => '35a45b9c25f457dae6cc6fa782a05ed5',
            'name'         => 'Adform.nl',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Adform.nl',
            'type'         => 'Advertising',
        ),
        'AdRoll'               => array(
            'channel_hash' => '8e9e4e6cd88fe800934d15a19cfdae90',
            'name'         => 'AdRoll.nl',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'AdRoll.nl',
            'type'         => 'Advertising',
        ),
        'Smartly.io'           => array(
            'channel_hash' => '461ad54178f49a7c738633afabf21c12',
            'name'         => 'Smartly.io',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Smartly.io',
            'type'         => 'Advertising',
        ),
        'TheNextAd'            => array(
            'channel_hash' => '313e53991d222faa60c8654d157adf91',
            'name'         => 'TheNextAd',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'TheNextAd',
            'type'         => 'Advertising',
        ),
        'Daisycon huis & tuin' => array(
            'channel_hash' => 'ee514045c14c37216a57fc50f51ef89d',
            'name'         => 'Daisycon huis & tuin',
            'fields'       => 'daisyconhuisentuin',
            'taxonomy'     => 'google_shopping',
            'utm_source'   => 'Daisycon',
            'type'         => 'Advertising',
        ),
    ),
    'New Zealand'                 => array(),
    'Nicaragua'                   => array(),
    'Niger'                       => array(),
    'Nigeria'                     => array(),
    'Norway'                      => array(
        'Prisjakt' => array(
            'channel_hash' => '562c39b5a9bce897a6ccf60f8ac5f17f',
            'name'         => 'Prisjakt.no',
            'fields'       => 'google_shopping',
            'taxonomy'     => 'google_shopping',
            'utm_source'   => 'Prisjakt.no',
            'type'         => 'Comparison shopping engine',
        ),
    ),
    'Oman'                        => array(),
    'Pakistan'                    => array(),
    'Palau'                       => array(),
    'Panama'                      => array(),
    'Papua New Guinea'            => array(),
    'Paraguay'                    => array(),
    'Peru'                        => array(),
    'Philippines'                 => array(),
    'Poland'                      => array(
        'Adform'    => array(
            'channel_hash' => 'ad2a7c40fe2b4c7b149f4842216ebd35',
            'name'         => 'Adform.pl',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Adform.pl',
            'type'         => 'Advertising',
        ),
        'Cenowarka' => array(
            'channel_hash' => 'f99a2427e9fca097e8b082d17cea0ea2',
            'name'         => 'Cenowarka.pl',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Cenowarka.pl',
            'type'         => 'Comparison shopping engine',
        ),
        'Miinto'    => array(
            'channel_hash' => '0a0431594fd6db28ce32304229ec6c03',
            'name'         => 'Miinto.pl',
            'fields'       => 'miinto_pl',
            'taxonomy'     => 'none',
            'utm_source'   => 'Miinto.pl',
            'type'         => 'Comparison shopping engine',
        ),
        'ShopAlike' => array(
            'channel_hash' => '8025b4e98abe3a174a6be42c079e184a',
            'name'         => 'ShopAlike.pl',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'ShopAlike.pl',
            'type'         => 'Comparison shopping engine',
        ),
        'ShopMania' => array(
            'channel_hash' => 'd175e3586053ac0807560de4a79cd4a8',
            'name'         => 'ShopMania.pl',
            'fields'       => 'shopmania_ro',
            'taxonomy'     => 'none',
            'utm_source'   => 'ShoMania.pl',
            'type'         => 'Comparison shopping engine',
        ),
        'Skapiec'   => array(
            'channel_hash' => 'e3beaee26297764b2a1d1520837750fa',
            'name'         => 'Skapiec.pl',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Skapiec.pl',
            'type'         => 'Comparison shopping engine',
        ),
    ),
    'Portugal'                    => array(
        'ShopMania'   => array(
            'channel_hash' => 'b8efb0dc3ca9f99f004cbfe5c8b101ad',
            'name'         => 'ShopMania.pt',
            'fields'       => 'shopmania_ro',
            'taxonomy'     => 'none',
            'utm_source'   => 'ShoMania.pt',
            'type'         => 'Comparison shopping engine',
        ),
        'Kuantokusta' => array(
            'channel_hash' => 'a1acc82aa0cdecd85c1a4e002492e912',
            'name'         => 'Kuantokusta.pt',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Kuantokusta.pt',
            'type'         => 'Comparison shopping engine',
        ),
    ),
    'Puerto Rico'                 => array(),
    'Qatar'                       => array(),
    'Reunion'                     => array(),
    'Romania'                     => array(
        'Okazzi'    => array(
            'channel_hash' => '21a027b99bad4b38aecc8adbfbc216c0',
            'name'         => 'Okazzi.ro',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Okazzi.ro',
            'type'         => 'Marketplace',
        ),
        'ShopMania' => array(
            'channel_hash' => '44c4964ed5543059adc680399bf058bc',
            'name'         => 'ShopMania.ro',
            'fields'       => 'shopmania_ro',
            'taxonomy'     => 'none',
            'utm_source'   => 'ShoMania.ro',
            'type'         => 'Comparison shopping engine',
        ),
        'Compari'   => array(
            'channel_hash' => '79c8b98c255cea061a47abe5fcac7da4',
            'name'         => 'Compari.ro',
            'fields'       => 'compari_ro',
            'taxonomy'     => 'none',
            'utm_source'   => 'Compari.ro',
            'type'         => 'Comparison shopping engine',
        ),

    ),
    'Russian Federation'          => array(
        'Yandex' => array(
            'channel_hash' => '62909b17dbeb21fb278c53dfaab9b5b4',
            'name'         => 'Yandex',
            'fields'       => 'yandex',
            'taxonomy'     => 'none',
            'utm_source'   => 'Yandex.com',
            'type'         => 'Advertising',
        ),
    ),
    'Rwanda'                      => array(),
    'St Kitts & Nevis'            => array(),
    'St Lucia'                    => array(),
    'St Vincent & the Grenadines' => array(),
    'Samoa'                       => array(),
    'San Marino'                  => array(),
    'Sao Tome & Principe'         => array(),
    'Saudi Arabia'                => array(),
    'Senegal'                     => array(),
    'Serbia'                      => array(
        'ShopMania' => array(
            'channel_hash' => '4cace348da378bc016757f6d8c0adda7',
            'name'         => 'ShopMania.rs',
            'fields'       => 'shopmania_ro',
            'taxonomy'     => 'none',
            'utm_source'   => 'ShopMania.rs',
            'type'         => 'Comparison shopping engine',
        ),
    ),
    'Seychelles'                  => array(),
    'Sierra Leone'                => array(),
    'Singapore'                   => array(),
    'Slovakia'                    => array(
        'ShopMania'            => array(
            'channel_hash' => 'c8edd9bf39b7345dcccc31d6e1f36c6b',
            'name'         => 'ShopMania.sk',
            'fields'       => 'shopmania_ro',
            'taxonomy'     => 'none',
            'utm_source'   => 'ShopMania.sk',
            'type'         => 'Comparison shopping engine',
        ),
        'Glami'                => array(
            'channel_hash' => '7a9baabfe9de72bb67c1c3e6a07ecf4f',
            'name'         => 'Glami.sk',
            'fields'       => 'glami',
            'taxonomy'     => 'none',
            'utm_source'   => 'Glami.sk',
            'type'         => 'Comparison shopping engine',
        ),
        'Heureka.sk'           => array(
            'channel_hash' => 'b40e8dfa2e24d54731805e54b2786af2',
            'name'         => 'Heureka.sk',
            'fields'       => 'heureka',
            'taxonomy'     => 'none',
            'utm_source'   => 'Heureka.sk',
            'type'         => 'Marketplace',
        ),
        'Mall.sk availability' => array(
            'channel_hash' => '219a77b28af9cdf0e2971172e3b0cb79',
            'name'         => 'Mall.sk availability',
            'fields'       => 'mall_availability',
            'taxonomy'     => 'none',
            'utm_source'   => 'Mall.sk availability',
            'type'         => 'Marketplace',
        ),
        'Mall.sk'              => array(
            'channel_hash' => '37c5133028c11d1fabb1fd8c3cad24ce',
            'name'         => 'Mall.sk',
            'fields'       => 'mall',
            'taxonomy'     => 'none',
            'utm_source'   => 'Mall.sk',
            'type'         => 'Marketplace',
        ),
    ),
    'Slovenia'                    => array(),
    'Solomon Islands'             => array(),
    'South Africa'                => array(
        'ShopMania'  => array(
            'channel_hash' => '5984c2f6e246266d4b88f80d3ff9210a',
            'name'         => 'ShopMania.co.za',
            'fields'       => 'shopmania_ro',
            'taxonomy'     => 'none',
            'utm_source'   => 'ShopMania.co.za',
            'type'         => 'Comparison shopping engine',
        ),
        'Pricecheck' => array(
            'channel_hash' => 'b4fe8c3f2868abb8bb89569c95f314d4',
            'name'         => 'Pricecheck.co.za',
            'fields'       => 'pricecheck',
            'taxonomy'     => 'none',
            'utm_source'   => 'Pricecheck.co.za',
            'type'         => 'Comparison shopping engine',
        ),
    ),
    'South Sudan'                 => array(),
    'Spain'                       => array(
        'Adform'   => array(
            'channel_hash' => '1f8fd79bdc962ff2bd707095cb9b998e',
            'name'         => 'Adform',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Adform',
            'type'         => 'Advertising',
        ),
        'Fruugoes' => array(
            'channel_hash' => '19e52a8d2cb905e967e231022ffc8b68',
            'name'         => 'Fruugo.es',
            'fields'       => 'fruugoes',
            'taxonomy'     => 'none',
            'utm_source'   => 'Fruugo.es',
            'type'         => 'Marketplace',
        ),
        'Kelkoo'   => array(
            'channel_hash' => '169ef51d74066baa613278db8df0c094',
            'name'         => 'Kelkoo.es',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Kelkoo.es',
            'type'         => 'Comparison shopping engine',
        ),
    ),
    'Sri Lanka'                   => array(),
    'Sudan'                       => array(),
    'Suriname'                    => array(),
    'Swaziland'                   => array(),
    'Sweden'                      => array(
        'Adform'      => array(
            'channel_hash' => '1f8fd79bdc962ff2bd707095cb9b998e',
            'name'         => 'Adform',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Adform',
            'type'         => 'Advertising',
        ),
        'Kelkoo'      => array(
            'channel_hash' => '91fca891b978f27aaf7d5720f536c574',
            'name'         => 'Kelkoo.se',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Kelkoo.se',
            'type'         => 'Comparison shopping engine',
        ),
        'Fyndiq'      => array(
            'channel_hash' => 'f35224b877d2273ba263ac2840bf2bea',
            'name'         => 'Fyndiq.se',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Fyndiq.se',
            'type'         => 'Comparison shopping engine',
        ),
        'Pricerunner' => array(
            'channel_hash' => '26945ba0952a27dd18bc50e82af2129d',
            'name'         => 'Pricerunner.se',
            'fields'       => 'pricerunner',
            'taxonomy'     => 'none',
            'utm_source'   => 'Pricerunner.se',
            'type'         => 'Comparison shopping engine',
        ),
        'Miinto'      => array(
            'channel_hash' => '7f0b78dceb15aafbe3165d830b19212b',
            'name'         => 'Miinto.se',
            'fields'       => 'miinto_se',
            'taxonomy'     => 'none',
            'utm_source'   => 'Miinto.se',
            'type'         => 'Comparison shopping engine',
        ),
        'Prisjakt'    => array(
            'channel_hash' => '7eec67ad2626bb55796b9d2fe989f88a',
            'name'         => 'Prisjakt.se',
            'fields'       => 'google_shopping',
            'taxonomy'     => 'google_shopping',
            'utm_source'   => 'Prisjakt.se',
            'type'         => 'Comparison shopping engine',
        ),
    ),
    'Switzerland'                 => array(
        'Kauftipp' => array(
            'channel_hash' => '426be23b8b34568dec4c165980bcab1c',
            'name'         => 'Kauftipp.ch',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Kauftipp.ch',
            'type'         => 'Comparison shopping engine',
        ),
        'Ricardo'  => array(
            'channel_hash' => '8ee69ba8d4af2a3784c4a89b6ccc008b',
            'name'         => 'Ricardo.ch',
            'fields'       => 'ricardo',
            'taxonomy'     => 'none',
            'utm_source'   => 'Ricardo.ch',
            'type'         => 'Marketplace',
        ),
    ),
    'Syria'                       => array(),
    'Taiwan'                      => array(),
    'Tajikistan'                  => array(),
    'Tanzania'                    => array(),
    'Thailand'                    => array(),
    'Togo'                        => array(),
    'Tonga'                       => array(),
    'Trinidad & Tobago'           => array(),
    'Tunesia'                     => array(),
    'Turkey'                      => array(),
    'Turkmenistan'                => array(),
    'Tuvalu'                      => array(),
    'Uganda'                      => array(),
    'Ukraine'                     => array(
        'Yandex' => array(
            'channel_hash' => '62909b17dbeb21fb278c53dfaab9b5b4',
            'name'         => 'Yandex',
            'fields'       => 'yandex',
            'taxonomy'     => 'none',
            'utm_source'   => 'Yandex.com',
            'type'         => 'Advertising',
        ),
    ),
    'United Arab Emirates'        => array(),
    'United Kingdom'              => array(
        'Adform'        => array(
            'channel_hash' => '15602bd34e4d3e8a319b24328f5e1629',
            'name'         => 'Adform.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Adform.com',
            'type'         => 'Advertising',
        ),
        'AdRoll'        => array(
            'channel_hash' => '9c53b1f00d16db52f75c54a886cb256d',
            'name'         => 'AdRoll.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'AdRoll.com',
            'type'         => 'Advertising',
        ),
        'Connexity'     => array(
            'channel_hash' => 'e8ce03e3f24a932e7ac633d37fef1654',
            'name'         => 'Connexity.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Connexity.com',
            'type'         => 'Advertising',
        ),
        'Smartly.io'    => array(
            'channel_hash' => '461ad54178f49a7c738633afabf21c12',
            'name'         => 'Smartly.io',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Smartly.io',
            'type'         => 'Advertising',
        ),
        'TheNextAd'     => array(
            'channel_hash' => '556cd1fe29e03ee70606df062aa10bb1',
            'name'         => 'TheNextAd',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'TheNextAd.com',
            'type'         => 'Advertising',
        ),
        'Fruugouk'      => array(
            'channel_hash' => '7488cf7f3b5a112308b5d2f6851dd9ad',
            'name'         => 'Fruugo.co.uk',
            'fields'       => 'fruugouk',
            'taxonomy'     => 'none',
            'utm_source'   => 'Fruugo.co.uk',
            'type'         => 'Marketplace',
        ),
        'ManoMano'      => array(
            'channel_hash' => 'd2a2f51263047e14c773b25b44c66cc8',
            'name'         => 'ManoMano.co.uk',
            'fields'       => 'manomano',
            'taxonomy'     => 'none',
            'utm_source'   => 'ManoMano.co.uk',
            'type'         => 'Marketplace',
        ),
        'Choozen'       => array(
            'channel_hash' => 'f7bef404d973147066d95b8c809f5bc7',
            'name'         => 'Choozen.co.uk',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Choozen.co.uk',
            'type'         => 'Comparison shopping engine',
        ),
        'Ciao'          => array(
            'channel_hash' => 'f0f5e767cd40f159986b57fc4d7a7a64',
            'name'         => 'Ciao.co.uk',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Ciao.co.uk',
            'type'         => 'Comparison shopping engine',
        ),
        'Dooyoo'        => array(
            'channel_hash' => '0a1dca5316beebc521923df1dafde621',
            'name'         => 'Dooyoo.co.uk',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Dooyoo.co.uk',
            'type'         => 'Comparison shopping engine',
        ),
        'Idealo'        => array(
            'channel_hash' => 'ba5724e97b78754cb4606754ff21ed54',
            'name'         => 'Idealo.co.uk',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Idealo.co.uk',
            'type'         => 'Comparison shopping engine',
        ),
        'Kelkoo'        => array(
            'channel_hash' => 'bc5b6aa38b73d892e63ecd6f0bf01dd1',
            'name'         => 'Kelkoo.co.uk',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Kelkoo.co.uk',
            'type'         => 'Comparison shopping engine',
        ),
        'Pricegrabber'  => array(
            'channel_hash' => '19b0196034fbc680856cd8f1e2636be5',
            'name'         => 'Pricegrabber.co.uk',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Pricegrabber.co.uk',
            'type'         => 'Comparison shopping engine',
        ),
        'Priceminister' => array(
            'channel_hash' => '409626c96e7581f6e4021c2a7b1ed5d6',
            'name'         => 'Priceminister.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Priceminister.com',
            'type'         => 'Comparison shopping engine',
        ),
        'Pricerunner'   => array(
            'channel_hash' => '1d289e47be23e15e62dc8c32b21f35bb',
            'name'         => 'Pricerunner.co.uk',
            'fields'       => 'pricerunner',
            'taxonomy'     => 'none',
            'utm_source'   => 'Pricerunner.co.uk',
            'type'         => 'Comparison shopping engine',
        ),
        'Pricespy'      => array(
            'channel_hash' => '333dd17eef54033cfbfe71b4fad7561b',
            'name'         => 'Pricespy.co.uk',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Pricespy.co.uk',
            'type'         => 'Comparison shopping engine',
        ),
        'Rakuten'       => array(
            'channel_hash' => 'eb015c280c201c7fd4c82814f494081c',
            'name'         => 'Rakuten.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Rakuten.com',
            'type'         => 'Comparison shopping engine',
        ),
        'ShopMania'     => array(
            'channel_hash' => '04c3d36f8931862316f0b7566d618ad2',
            'name'         => 'ShapMania.co.uk',
            'fields'       => 'shopmania_ro',
            'taxonomy'     => 'none',
            'utm_source'   => 'ShopMania.co.uk',
            'type'         => 'Comparison shopping engine',
        ),
        'Shopping.com'  => array(
            'channel_hash' => '6e3bbd8e7e9ca791bf13f28fb701e038',
            'name'         => 'Shopping.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Shopping.com',
            'type'         => 'Comparison shopping engine',
        ),
        'Shopzilla'     => array(
            'channel_hash' => '949dd6b0b76423daad4135f4d25f41bd',
            'name'         => 'Shopzilla.co.uk',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Shopzilla.co.uk',
            'type'         => 'Comparison shopping engine',
        ),
        'Skinflint'     => array(
            'channel_hash' => 'd103e9a8fbd63eaad89195540b8a49ce',
            'name'         => 'Skinflint.co.uk',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Skinflint.co.uk',
            'type'         => 'Comparison shopping engine',
        ),
        'Stylight'      => array(
            'channel_hash' => 'a9ae78bf41067eefedfcfdc2c2a31cce',
            'name'         => 'Stylight.co.uk',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Stylight.co.uk',
            'type'         => 'Comparison shopping engine',
        ),
        'Twenga'        => array(
            'channel_hash' => '68d4e9f5d94b048f613cd975f59e6429',
            'name'         => 'Twenga.co.uk',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Twenga.co.uk',
            'type'         => 'Comparison shopping engine',
        ),
        'Wish.com'      => array(
            'channel_hash' => '70ec5f93b0f12e6f76d5f97657f23cd4',
            'name'         => 'Wish.com',
            'fields'       => 'wishcom',
            'taxonomy'     => 'none',
            'utm_source'   => 'Wish.com',
            'type'         => 'Marketplace',
        ),
    ),
    'United States'               => array(
        'Adform'       => array(
            'channel_hash' => '15602bd34e4d3e8a319b24328f5e1629',
            'name'         => 'Adform.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Adform.com',
            'type'         => 'Advertising',
        ),
        'AdRoll'       => array(
            'channel_hash' => '9c53b1f00d16db52f75c54a886cb256d',
            'name'         => 'Adroll.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Adroll.com',
            'type'         => 'Advertising',
        ),
        'Connexity'    => array(
            'channel_hash' => 'e8ce03e3f24a932e7ac633d37fef1654',
            'name'         => 'Connexity.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Connexity.com',
            'type'         => 'Advertising',
        ),
        'ShareASale'   => array(
            'channel_hash' => 'd9f4300c517acf7fcd76a4008dc36d05',
            'name'         => 'ShareASale',
            'fields'       => 'shareasale',
            'taxonomy'     => 'none',
            'utm_source'   => 'ShareASale',
            'type'         => 'Advertising',
        ),
        'Smartly.io'   => array(
            'channel_hash' => '461ad54178f49a7c738633afabf21c12',
            'name'         => 'Smartly.io',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Smartly.io',
            'type'         => 'Advertising',
        ),
        'TheNextAd'    => array(
            'channel_hash' => '313e53991d222faa60c8654d157adf91',
            'name'         => 'TheNextAd',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'TheNextAd',
            'type'         => 'Advertising',
        ),
        'Fruugo'       => array(
            'channel_hash' => 'bfd48c235251bf2078a514a7520d6e10',
            'name'         => 'Fruugo.us',
            'fields'       => 'fruugous',
            'taxonomy'     => 'none',
            'utm_source'   => 'Fruugo.us',
            'type'         => 'Marketplace',
        ),
        'Polyvore'     => array(
            'channel_hash' => '88cece5a7ed3b6ce7e0f5679d1e2df89',
            'name'         => 'Polyvore.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Polyvore.com',
            'type'         => 'Comparison shopping engine',
        ),
        'Pricegrabber' => array(
            'channel_hash' => '90a65c65552866697ff71feb202bdf35',
            'name'         => 'Pricegrabber.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Pricegrabber.com',
            'type'         => 'Comparison shopping engine',
        ),
        'ShopMania'    => array(
            'channel_hash' => '2b3f8be1c51261db7cec1f6ce324b720',
            'name'         => 'ShopMania.com',
            'fields'       => 'shopmania_ro',
            'taxonomy'     => 'none',
            'utm_source'   => 'ShopMania.com',
            'type'         => 'Comparison shopping engine',
        ),
        'Shopping'     => array(
            'channel_hash' => '6e3bbd8e7e9ca791bf13f28fb701e038',
            'name'         => 'Shopping.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Shopping.com',
            'type'         => 'Comparison shopping engine',
        ),
        'Shopzilla'    => array(
            'channel_hash' => '3de19c070f475cb55abe83e65fe97ee6',
            'name'         => 'Shopzilla.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Shopzilla.com',
            'type'         => 'Comparison shopping engine',
        ),
        'Stylight'     => array(
            'channel_hash' => 'f8ee4c4dd073862740839b37b5eecbd3',
            'name'         => 'Stylight.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Stylight.com',
            'type'         => 'Comparison shopping engine',
        ),
        'Twenga'       => array(
            'channel_hash' => 'db8273f5de4d66493cb0d1b804b88564',
            'name'         => 'Twenga.com',
            'fields'       => 'customfeed',
            'taxonomy'     => 'none',
            'utm_source'   => 'Twenga.com',
            'type'         => 'Comparison shopping engine',
        ),
        'Yandex'       => array(
            'channel_hash' => '62909b17dbeb21fb278c53dfaab9b5b4',
            'name'         => 'Yandex',
            'fields'       => 'yandex',
            'taxonomy'     => 'none',
            'utm_source'   => 'Yandex.com',
            'type'         => 'Advertising',
        ),
        'Wish.com'     => array(
            'channel_hash' => '70ec5f93b0f12e6f76d5f97657f23cd4',
            'name'         => 'Wish.com',
            'fields'       => 'wishcom',
            'taxonomy'     => 'none',
            'utm_source'   => 'Wish.com',
            'type'         => 'Marketplace',
        ),
    ),
    'Uraguay'                     => array(),
    'Uzbekistan'                  => array(),
    'Vanuatu'                     => array(),
    'Vatican City'                => array(),
    'Venezuela'                   => array(),
    'Vietnam'                     => array(),
    'Yemen'                       => array(),
    'Zambia'                      => array(),
    'Zimbabwe'                    => array(),
);
