<?php

namespace WolfOz\Admin\Walkers;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

require_once ABSPATH . 'wp-admin/includes/class-walker-category-checklist.php';

/**
 * Taxonomies walker
 *
 * @author wolfoz
 */
class TermsChecklist extends \Walker_Category_Checklist {

	protected $_options = array(
		'post'     => 0,
		'taxonomy' => '',      // taxonomy name.
		'enabled'  => '',      // enabled or disabled tree view.
		'parents'  => '',      // autoselect parents.
		'children' => '',      // aurodeselect childrens.
		'expanded' => '',      // expanded the tree on shows.
		'selected' => array(),      // selected items.
		'saved'    => array(),      // saved items to the post.
		'once'     => array(            // once rendered.
			'post' => false,
		),
		'action'   => '',       // current action from $_GET['action'].

	);

	/**
	 * Create the walker with options.
	 *
	 * @param array $args additional options.
	 */
	public function __construct( array $args = array() ) {
		global $action;

		$params = array();
		if ( array_key_exists( 'params', $args ) && is_array( $params ) ) {
			$params = $args['params'];
			unset( $args['params'] );
		}
		foreach ( array(
			'taxonomy'      => 'taxonomy',
			'selected_cats' => 'selected',
		) as $key => $nm ) {
			if ( array_key_exists( $key, $params ) ) {
				$args[ $nm ] = $params[ $key ];
			}
		}
		$args['selected'] = ! empty( $args['selected'] ) ? array_map( 'intval', $args['selected'] ) : array();
		$args['saved']    = array();
		if ( isset( $params['taxonomy'] ) ) {
			if ( isset( $_POST['tax_input'] ) && isset( $_POST['tax_input'][ $params['taxonomy'] ] )
					&& isset( $_POST['action'] )
			) {
				$pa            = sanitize_text_field( wp_unslash( $_POST['action'] ) );
				$ajax_nonce_pa = isset( $_POST[ '_ajax_nonce-' . $pa ] )
					? sanitize_text_field( wp_unslash( $_POST[ '_ajax_nonce-' . $pa ] ) )
					: false;
				if ( ! empty( $ajax_nonce_pa ) && wp_verify_nonce( $ajax_nonce_pa, $pa ) ) {
					$tax_input = array_map( 'intval', (array) $_POST['tax_input'][ $params['taxonomy'] ] );
					$pids      = array_diff( (array) $args['selected'], $tax_input );
					foreach ( $pids as $idx => $pid ) {
						$pid           = intval( $pid );
						$args['saved'] = array_unique(
							array_merge(
								$args['saved'],
								array( $pid ),
								get_ancestors( $pid, $params['taxonomy'], 'taxonomy' )
							)
						);
						unset( $args['selected'][ $idx ] );
					}
				}
				$args['expanded'] = 'yes';
			}
		}
		$this->_options           = wp_parse_args( $args, $this->_options );
		$this->_options['action'] = $action;
	}

	/**
	 * Get the option.
	 *
	 * @param string $name      the option name.
	 * @param mixed  $default    default value if the option not exists.
	 * @return mixed
	 */
	public function option( string $name, $default = null ) {
		if ( array_key_exists( $name, $this->_options ) ) {
			return $this->_options[ $name ];
		}
		return $default;
	}

	/**
	 * Starts the list before the elements are added.
	 *
	 * @see Walker:start_lvl()
	 *
	 * @since 2.5.1
	 *
	 * @param string $output Passed by reference. Used to append additional content.
	 * @param int    $depth  Depth of category. Used for tab indentation.
	 * @param array  $args   An array of arguments. @see wp_terms_checklist().
	 */
	public function start_lvl( &$output, $depth = 0, $args = array() ) {
		$indent  = str_repeat( "\t", $depth );
		$output .= (
				"$indent<ul class='children'"
				. ( 'yes' !== $this->_options['expanded']
						? ' style="display:none" aria-expanded="false"'
						: ' aria-expanded="true"' ) . ">\n" );
	}

	/**
	 * Start the element output.
	 *
	 * @see \Walker::start_el()
	 *
	 * @since 2.5.1
	 *
	 * @param string $output   Passed by reference. Used to append additional content.
	 * @param object $category The current term object.
	 * @param int    $depth    Depth of the term in reference to parents. Default 0.
	 * @param array  $args     An array of arguments. @see wp_terms_checklist().
	 * @param int    $current_object_id       ID of the current term.
	 */
	public function start_el( &$output, $category, $depth = 0, $args = array(), $current_object_id = 0 ) {
		if ( empty( $args['taxonomy'] ) ) {
			$taxonomy = 'category';
		} else {
			$taxonomy = $args['taxonomy'];
		}

		if ( 'category' === $taxonomy ) {
			$name = 'post_category';
		} else {
			$name = 'tax_input[' . $taxonomy . ']';
		}

		$args['popular_cats'] = ! empty( $args['popular_cats'] ) ? array_map( 'intval', $args['popular_cats'] ) : array();

		$args['selected_cats'] = ! empty( $args['selected_cats'] ) ? array_map( 'intval', $args['selected_cats'] ) : array();

		if ( ! empty( $this->_options['post'] ) && ! $this->_options['once']['post'] ) {
			$output                        .= '<input type="hidden" class="post-taxonomy-saved" value="' . implode( ',', $args['selected_cats'] ) . '" />';
			$this->_options['once']['post'] = true;
		}

		if ( ! empty( $args['list_only'] ) ) {

			$class = in_array( $category->term_id, $args['popular_cats'], true ) ? ' class="popular-category"' : '';

			$aria_checked = 'false';
			$inner_class  = 'category';

			if ( in_array( $category->term_id, $args['selected_cats'], true ) ) {
				$inner_class .= ' selected';
				$aria_checked = 'true';
			}

			$output .= "\n" . '<li' . $class . '>' .
					'<div class="' . $inner_class . '" data-term-id=' . $category->term_id .
					' tabindex="0" role="checkbox" aria-checked="' . $aria_checked . '">' .
					/** This filter is documented in wp-includes/category-template.php */
					esc_html( apply_filters( 'the_category', $category->name, '', '' ) ) . '</div>';
		} else {
			$class = in_array( $category->term_id, $args['popular_cats'], true ) ? ' class="popular-category tree-node"' : ' class="tree-node"';

			$is_selected = in_array( $category->term_id, $args['selected_cats'], true );
			$is_saved    = in_array( $category->term_id, $this->_options['saved'], true );
			$is_disabled = ! empty( $args['disabled'] );

			$label_class = array( 'selectit' );
			if ( $is_selected && ! empty( $this->_options['post'] ) ) {
				$label_class[] = 'a-saved';
			}

			/** This filter is documented in wp-includes/category-template.php */
			$output .= "\n<li id='{$taxonomy}-{$category->term_id}'$class>" .
			'<label class="' . implode( ' ', $label_class ) . '">';

			if ( $args['has_children'] ) {
				$output .=
				( '<a href="#" class="expander" data-expanded-icon="dashicons-arrow-down-alt2" data-collapsed-icon="dashicons-arrow-right-alt2">
					<i class="dashicons ' . ( 'yes' !== $this->_options['expanded'] ? 'dashicons-arrow-right-alt2' : 'dashicons-arrow-down-alt2' ) . '"></i>
				</a>' );
			}

			$input_class = array();
			foreach ( array( 'parents', 'children' ) as $type ) {
				if ( 'yes' === $this->_options[ $type ] ) {
					$input_class[] = 'a-' . $type;
				}
			}

			$output .=
			'<input class="' . implode( ' ', $input_class ) . '" value="' . $category->term_id . '" type="checkbox" name="'
						. $name . '[]" '
						. ( ( 'edit' === $this->_options['action'] ) ? 'id="in-' . $taxonomy . '-' . $category->term_id . '" ' : '' )
						. checked( $is_selected || $is_saved, true, false )
						. disabled( $is_disabled, true, false ) . ' /> ' .
						/** This filter is documented in wp-includes/category-template.php */
						esc_html( apply_filters( 'the_category', $category->name, '', '' ) ) . '</label>';
		}
	}
}
