/**
 * Taxonomy metaboxes.
 *
 * @package WolfOz taxonomy metaboxes.
 */

jQuery( document ).ready(
	function ($) {

		const log = false;
		/** .expander element object. */
		$( 'body' ).on(
			'click',
			'.expander',
			function (ev) {
				ev.preventDefault();
				el = $( this );
				try {
					state = el.closest( 'li' ).children( 'ul' ).attr( 'aria-expanded' ) === 'true' ? 'collapse' : 'expand';

					if (state == 'expand') {
						el.find( 'i' ).removeClass( el.data( 'collapsed-icon' ) ).addClass( el.data( 'expanded-icon' ) );
						el.closest( 'li' ).children( 'ul' ).css( 'display','' ).attr( 'aria-expanded', true );
						! log || console.log( 'toggle for ' + el.closest( 'li' ).attr( 'id' ) );
					} else {	// collapse.
						el.find( 'i' ).removeClass( el.data( 'expanded-icon' ) ).addClass( el.data( 'collapsed-icon' ) );
						el.closest( 'li' ).children( 'ul' ).css( 'display', 'none' ).attr( 'aria-expanded', false );
					}
				} catch ( error ) {
					console.log( error );
				}

			}
		).on(
			'change',
			'.tree-node .selectit input[type=checkbox]',
			function (ev) {
				debugger;
				if ( $( this ).prop( 'checked' )) {
					if ($( this ).hasClass( 'a-parents' ) ) {
						$( this ).parents( '.tree-node' ).find( '> .selectit input[type=checkbox]' ).not( this ).prop( 'checked', true );
					}
				} else {
					if ($( this ).hasClass( 'a-children' ) ) {
						$( this ).closest( '.tree-node' ).find( '.selectit input[type=checkbox]' ).not( this ).prop( 'checked', false );
					}
				}
			}
		).on(
			'click',
			'.row-actions .button-link.editinline',
			function (ev) {
				if ($( this ).attr( 'aria-expanded' ) === 'true') {
					$( this ).closest( 'tbody' ).find( '.cat-checklist input:checked' ).parent( 'label' ).addClass( 'a-saved' );
				}
			}
		);

		if ( $.fn.wpList ) {
			$( 'body' ).on(
				'wpListAddEnd',
				'[data-wp-lists]' ,
				function (ev, list, a) {
					try {
						var saved = $( this ).find( '.post-taxonomy-saved' ).val().split( ',' );
						$( this ).find( 'input[type=checkbox]' ).each(
							function () {
								if ($.inArray( $( this ).val(),saved ) < 0) {
									$( this ).parent( 'label' ).removeClass( 'a-saved' );
								} else {
									$( this ).parent( 'label' ).addClass( 'a-saved' );
								};
							}
						);
					} catch (error) {
						console.log( error );
					}
				}
			);
		}

	}
);