<?php
/**
 * API Function
 *
 * Handles interaction with the WordPress.org Plugins API.
 *
 * @package WithoutReviewsFinder
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Fetch plugins from WordPress.org API.
 */
function wrfnder_get_plugins_with_no_reviews( $max_plugins = 50, $per_page = 100, $start_page = 1 ) {
    $collected_plugins = [];
    $page = $start_page;

    while ( count( $collected_plugins ) < $max_plugins ) {
        $url = add_query_arg(
            [
                'action' => 'query_plugins',
                'request[browse]' => 'new',
                'request[page]' => $page,
                'request[per_page]' => $per_page,
                'request[fields][num_ratings]' => true,
                'request[fields][short_description]' => true,
            ],
            'https://api.wordpress.org/plugins/info/1.2/'
        );

        $response = wp_remote_get( $url );

        if ( is_wp_error( $response ) ) {
            break;
        }

        $body = wp_remote_retrieve_body( $response );
        $data = json_decode( $body, true );

        if ( ! is_array( $data ) || empty( $data['plugins'] ) ) {
            break;
        }

        foreach ( $data['plugins'] as $plugin ) {
            $num_ratings = isset( $plugin['num_ratings'] ) ? intval( $plugin['num_ratings'] ) : 0;

           if ( 0 === $num_ratings ) {
                $collected_plugins[] = [
                    'name'        => $plugin['name'],
                    'slug'        => $plugin['slug'],
                    'description' => isset( $plugin['short_description'] ) ? $plugin['short_description'] : '',
                ];
            }

            if ( count( $collected_plugins ) >= $max_plugins ) {
                break 2;
            }
        }

        $page++;
    }

    return $collected_plugins;
}