<?php
/**
 * Main Plugin Class
 *
 * Handles Without Reviews Finder functionality: admin menu and plugin search.
 *
 * @package WithoutReviewsFinder
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

class Wrfnder_Finder {

    private static $instance = null;

    /**
     * Singleton instance
     */
    public static function get_instance() {
        if ( self::$instance === null ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Constructor: add admin menus
     */
    private function __construct() {
        add_action( 'admin_menu', [ $this, 'wrfnder_admin_menu' ] );
        add_action( 'admin_menu', [ $this, 'wrfnder_remove_duplicate_submenu' ], 99 );
    }

    /**
     * Register admin menu and submenus
     */
    public function wrfnder_admin_menu() {
        add_menu_page(
            __( 'Without Reviews Finder', 'without-reviews-finder' ),
            __( 'Without Reviews Finder', 'without-reviews-finder' ),
            'manage_options',
            'wrfnder',
            [ $this, 'wrfnder_search_page' ],
            'dashicons-search',
            6
        );

        add_submenu_page(
            'wrfnder',
            __( 'Search Plugins Without Reviews', 'without-reviews-finder' ),
            __( 'Search Plugins Without Reviews', 'without-reviews-finder' ),
            'manage_options',
            'wrfnder-search',
            [ $this, 'wrfnder_search_page' ]
        );
    }

    /**
     * Remove duplicate submenu (top-level menu link)
     */
    public function wrfnder_remove_duplicate_submenu() {
        remove_submenu_page( 'wrfnder', 'wrfnder' );
    }

    /**
     * Search results page
     */
    public function wrfnder_search_page() {
        wrfnder_display_search_results_page();
    }
}