<?php
/**
 * Wise Stock Supplier Management Template
 *
 * This template displays the supplier management page with supplier
 * configuration, contact management, and notification settings.
 *
 * @package WiseStock
 * @since 1.0.0
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get current settings with proper defaults
$defaults = WISESTOCK_Core::get_default_options();
$options = wp_parse_args(get_option('wisestock_options', array()), $defaults);

// Check if suppliers table exists
global $wpdb;
$table_name = $wpdb->prefix . 'wisestock_suppliers';
$table_exists = $wpdb->get_var($wpdb->prepare("SHOW TABLES LIKE %s", $table_name));

if (!$table_exists) {
    echo '<div class="notice notice-error"><p><strong>' . esc_html__('Error:', 'wisestock') . '</strong> ' . esc_html__('WiseStock database tables are not installed. Please deactivate and reactivate the plugin.', 'wisestock') . '</p></div>';
    return;
}

// Get suppliers
$supplier_manager = new WISESTOCK_Supplier_Manager();
$suppliers = $supplier_manager->get_all_suppliers();
?>

<div class="wisestock-admin">
    <?php include WISESTOCK_PLUGIN_DIR . 'admin/partials/navigation.php'; ?>

    <div class="wisestock-dashboard">
        <!-- Supplier Management Header -->
        <div class="wisestock-dashboard-header">
            <h1 class="wisestock-dashboard-title">
                <?php esc_html_e('Suppliers', 'wisestock'); ?>
            </h1>
            <p class="wisestock-dashboard-subtitle">
                <?php esc_html_e('Manage supplier contacts and the product assignments', 'wisestock'); ?>
            </p>
        </div>

        <!-- Auto-save Status Indicator -->
        <div id="wisestock-autosave-status" class="wisestock-autosave-indicator" style="display: none;">
            <span class="wisestock-autosave-text"></span>
            <span class="wisestock-autosave-icon"></span>
        </div>

        <div class="wisestock-grid-1">
            <!-- Supplier Statistics -->
            <div class="wisestock-card">
                <div class="wisestock-card-header">
                    <h2 class="wisestock-card-title"><?php esc_html_e('Supplier Statistics', 'wisestock'); ?></h2>
                    <p class="wisestock-card-subtitle"><?php esc_html_e('Overview of supplier management activity', 'wisestock'); ?></p>
                </div>

                <div class="wisestock-supplier-stats">
                    <div class="wisestock-stat-item">
                        <div class="wisestock-stat-value">-</div>
                        <div class="wisestock-stat-label"><?php esc_html_e('Total Suppliers', 'wisestock'); ?></div>
                    </div>
                    <div class="wisestock-stat-item">
                        <div class="wisestock-stat-value">-</div>
                        <div class="wisestock-stat-label"><?php esc_html_e('Products Assigned', 'wisestock'); ?></div>
                    </div>
                </div>
            </div>

            <!-- Current Suppliers -->
            <div class="wisestock-card wisestock-current-suppliers">
                <div class="wisestock-card-header">
                    <h2 class="wisestock-card-title"><?php esc_html_e('Current Suppliers', 'wisestock'); ?></h2>
                    <p class="wisestock-card-subtitle"><?php esc_html_e('Manage your supplier contacts and product assignments', 'wisestock'); ?></p>
                </div>

                <div class="wisestock-card-body">
                    <div class="wisestock-loading"><?php esc_html_e('Loading suppliers...', 'wisestock'); ?></div>
                </div>

                <div class="wisestock-btn-group wisestock-dynamic-margin-top-20">
                    <button type="button" class="wisestock-btn wisestock-add-supplier">
                        <?php esc_html_e('Add New Supplier', 'wisestock'); ?>
                    </button>
                </div>
            </div>
        </div>

         <!-- Product-Supplier Overview -->
         <div class="wisestock-card wisestock-product-supplier-overview">
            <div class="wisestock-card-header">
                <h2 class="wisestock-card-title"><?php esc_html_e('Product-Supplier Overview', 'wisestock'); ?></h2>
                <p class="wisestock-card-subtitle"><?php esc_html_e('View which products are assigned to which suppliers', 'wisestock'); ?></p>
            </div>
            <div class="wisestock-card-body">
                <div class="wisestock-loading"><?php esc_html_e('Loading product-supplier overview...', 'wisestock'); ?></div>
            </div>
        </div>

        <!-- Multi-Supplier Products -->
        <div class="wisestock-card wisestock-multi-supplier-products">
            <div class="wisestock-card-header">
                <h2 class="wisestock-card-title"><?php esc_html_e('Multi-Supplier Products', 'wisestock'); ?></h2>
                <p class="wisestock-card-subtitle"><?php esc_html_e('Products with multiple suppliers - set default supplier for notifications', 'wisestock'); ?></p>
            </div>
            <div class="wisestock-card-body">
                <div class="wisestock-loading"><?php esc_html_e('Loading multi-supplier products...', 'wisestock'); ?></div>
            </div>
        </div>

        <!-- Notification Settings -->
        <form class="wisestock-supplier-form" method="post" action="">
            <?php wp_nonce_field('wisestock_admin_nonce', 'wisestock_admin_nonce'); ?>

            <!-- Notification Settings -->
            <div class="wisestock-card">
                <div class="wisestock-card-header">
                    <h2 class="wisestock-card-title"><?php esc_html_e('Supplier Notifications', 'wisestock'); ?></h2>
                    <p class="wisestock-card-subtitle"><?php esc_html_e('Configure how suppliers are notified about restock recommendations', 'wisestock'); ?></p>
                </div>

                <div class="wisestock-form-group">
                    <label class="wisestock-form-label" for="supplier_email_subject">
                        <?php esc_html_e('Email Subject Line', 'wisestock'); ?> <span class="required">*</span>
                    </label>
                    <input type="text"
                            id="supplier_email_subject"
                            name="supplier_email_subject"
                            class="wisestock-form-input"
                            required
                            value="<?php echo esc_attr($options['supplier_email_subject']); ?>"
                            placeholder="<?php esc_attr_e('Enter custom email subject line...', 'wisestock'); ?>">
                    <div class="wisestock-form-help">
                        <?php esc_html_e('Customize the email subject line. Use {site_name}, {urgency}, {product_name} as placeholders.', 'wisestock'); ?>
                    </div>
                    <div class="wisestock-validation-error" id="supplier_email_subject_error" style="display: none;"></div>
                </div>

                <div class="wisestock-form-group">
                    <label class="wisestock-form-label" for="supplier_from_email">
                        <?php esc_html_e('From Email', 'wisestock'); ?> <span class="required">*</span>
                    </label>
                    <input type="email"
                            id="supplier_from_email"
                            name="supplier_from_email"
                            class="wisestock-form-input"
                            required
                            value="<?php echo esc_attr($options['supplier_from_email']); ?>"
                            placeholder="<?php esc_attr_e('Enter sender email address...', 'wisestock'); ?>">
                    <div class="wisestock-form-help">
                        <?php esc_html_e('Email address used as the sender for supplier notifications', 'wisestock'); ?>
                    </div>
                    <div class="wisestock-validation-error" id="supplier_from_email_error" style="display: none;"></div>
                </div>

                <div class="wisestock-form-group">
                    <label class="wisestock-form-label" for="test_email_address">
                        <?php esc_html_e('Test Email Address', 'wisestock'); ?>
                    </label>
                    <input type="email"
                            id="test_email_address"
                            name="test_email_address"
                            class="wisestock-form-input"
                            placeholder="<?php esc_attr_e('Enter email address to test the template...', 'wisestock'); ?>">
                    <div class="wisestock-form-help">
                        <?php esc_html_e('Enter an email address to send a test notification using the template above', 'wisestock'); ?>
                    </div>
                </div>

                <div class="wisestock-form-group">
                    <button type="button" class="wisestock-btn wisestock-send-test-email">
                        <span class="dashicons dashicons-email-alt"></span>
                        <?php esc_html_e('Send Test Email', 'wisestock'); ?>
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Add Supplier Modal -->
<div id="wisestock-add-supplier-modal" class="wisestock-modal wisestock-dynamic-display-none">
    <div class="wisestock-modal-content">
        <div class="wisestock-modal-header">
            <h3 class="wisestock-modal-title"><?php esc_html_e('Add New Supplier', 'wisestock'); ?></h3>
            <button type="button" class="wisestock-modal-close">&times;</button>
        </div>
        <div class="wisestock-modal-body">
            <form id="wisestock-add-supplier-form" class="wisestock-form">
                <div class="wisestock-form-group">
                    <label for="supplier_name" class="wisestock-form-label">
                        <?php esc_html_e('Supplier Name', 'wisestock'); ?> <span class="required">*</span>
                    </label>
                    <input type="text"
                           id="supplier_name"
                           name="supplier_name"
                           class="wisestock-form-input"
                           required>
                    <div class="wisestock-form-help">
                        <?php esc_html_e('Enter the supplier company or contact name', 'wisestock'); ?>
                    </div>
                    <div class="wisestock-validation-error" id="supplier_name_error" style="display: none;"></div>
                </div>

                <div class="wisestock-form-group">
                    <label for="supplier_email" class="wisestock-form-label">
                        <?php esc_html_e('Email Address', 'wisestock'); ?> <span class="required">*</span>
                    </label>
                    <input type="email"
                           id="supplier_email"
                           name="supplier_email"
                           class="wisestock-form-input"
                           required>
                    <div class="wisestock-form-help">
                        <?php esc_html_e('Supplier contact email for notifications', 'wisestock'); ?>
                    </div>
                    <div class="wisestock-validation-error" id="supplier_email_error" style="display: none;"></div>
                </div>


                <div class="wisestock-form-group">
                    <label for="supplier_lead_time" class="wisestock-form-label">
                        <?php esc_html_e('Lead Time (Days)', 'wisestock'); ?> <span class="required">*</span>
                    </label>
                    <input type="number"
                           id="supplier_lead_time"
                           name="supplier_lead_time"
                           class="wisestock-form-input"
                           value="7"
                           min="1"
                           max="365"
                           required>
                    <div class="wisestock-form-help">
                        <?php esc_html_e('Average days to receive stock from this supplier', 'wisestock'); ?>
                    </div>
                    <div class="wisestock-validation-error" id="supplier_lead_time_error" style="display: none;"></div>
                </div>

                <div class="wisestock-form-group">
                    <label for="supplier_products" class="wisestock-form-label">
                        <?php esc_html_e('Assign Products', 'wisestock'); ?> <span class="required">*</span>
                    </label>
                    <div class="wisestock-product-selector">
                        <div class="wisestock-product-search">
                            <input type="text"
                                   id="product_search"
                                   class="wisestock-form-input"
                                   placeholder="<?php esc_attr_e('Search products...', 'wisestock'); ?>">
                        </div>
                        <div class="wisestock-product-list" id="available_products">
                            <?php
                            // Get all published products with stock management enabled
                            $products = wc_get_products(array(
                                'status' => 'publish',
                                'manage_stock' => true,
                                'limit' => 50,
                                'orderby' => 'title',
                                'order' => 'ASC'
                            ));

                            foreach ($products as $product) {
                                echo '<label class="wisestock-product-item">';
                                /* translators: %s: Product name. */
                                echo '<input type="checkbox" name="supplier_products[]" value="' . esc_attr($product->get_id()) . '" class="wisestock-product-checkbox" aria-label="' . esc_attr(sprintf(__('Select product %s', 'wisestock'), $product->get_name())) . '">';
                                echo '<span class="wisestock-product-name">' . esc_html($product->get_name()) . '</span>';
                                echo '<span class="wisestock-product-sku">(' . esc_html($product->get_sku() ?: __('No SKU', 'wisestock')) . ')</span>';
                                echo '</label>';
                            }
                            ?>
                        </div>
                        <div class="wisestock-selected-products" id="selected_products">
                            <h4><?php esc_html_e('Selected Products:', 'wisestock'); ?></h4>
                            <div class="wisestock-selected-list"></div>
                        </div>
                    </div>
                    <div class="wisestock-form-help">
                        <strong><?php esc_html_e('Only products with stock management enabled will appear here', 'wisestock'); ?></strong>
                    </div>
                    <div class="wisestock-validation-error" id="supplier_products_error" style="display: none;"></div>
                </div>
            </form>
        </div>
        <div class="wisestock-modal-footer">
            <button type="button" class="wisestock-btn secondary wisestock-modal-cancel">
                <?php esc_html_e('Cancel', 'wisestock'); ?>
            </button>
            <button type="button" class="wisestock-btn wisestock-modal-save">
                <?php esc_html_e('Add Supplier', 'wisestock'); ?>
            </button>
        </div>
    </div>
</div>

<!-- Edit Supplier Modal -->
<div id="wisestock-edit-supplier-modal" class="wisestock-modal wisestock-dynamic-display-none">
    <div class="wisestock-modal-content">
        <div class="wisestock-modal-header">
            <h3 class="wisestock-modal-title"><?php esc_html_e('Edit Supplier', 'wisestock'); ?></h3>
            <button type="button" class="wisestock-modal-close">&times;</button>
        </div>
        <div class="wisestock-modal-body">
            <form id="wisestock-edit-supplier-form" class="wisestock-form">
                <input type="hidden" id="edit_supplier_id" name="supplier_id">

                <div class="wisestock-form-group">
                    <label for="edit_supplier_name" class="wisestock-form-label">
                        <?php esc_html_e('Supplier Name', 'wisestock'); ?> <span class="required">*</span>
                    </label>
                    <input type="text"
                           id="edit_supplier_name"
                           name="supplier_name"
                           class="wisestock-form-input"
                           required>
                    <div class="wisestock-form-help">
                        <?php esc_html_e('Enter the supplier company or contact name', 'wisestock'); ?>
                    </div>
                </div>

                <div class="wisestock-form-group">
                    <label for="edit_supplier_email" class="wisestock-form-label">
                        <?php esc_html_e('Email Address', 'wisestock'); ?>
                    </label>
                    <input type="email"
                           id="edit_supplier_email"
                           name="supplier_email"
                           class="wisestock-form-input">
                    <div class="wisestock-form-help">
                        <?php esc_html_e('Supplier contact email for notifications', 'wisestock'); ?>
                    </div>
                </div>


                <div class="wisestock-form-group">
                    <label for="edit_supplier_lead_time" class="wisestock-form-label">
                        <?php esc_html_e('Lead Time (Days)', 'wisestock'); ?>
                    </label>
                    <input type="number"
                           id="edit_supplier_lead_time"
                           name="supplier_lead_time"
                           class="wisestock-form-input"
                           value="7"
                           min="0"
                           max="365">
                    <div class="wisestock-form-help">
                        <?php esc_html_e('Average days to receive stock from this supplier', 'wisestock'); ?>
                    </div>
                </div>

                <div class="wisestock-form-group">
                    <label for="edit_supplier_products" class="wisestock-form-label">
                        <?php esc_html_e('Assign Products', 'wisestock'); ?>
                    </label>
                    <div class="wisestock-product-selector">
                        <div class="wisestock-product-search">
                            <input type="text"
                                   id="edit_product_search"
                                   class="wisestock-form-input"
                                   placeholder="<?php esc_attr_e('Search products...', 'wisestock'); ?>">
                        </div>
                        <div class="wisestock-product-list" id="edit_available_products">
                            <?php
                            // Get all published products with stock management enabled
                            $products = wc_get_products(array(
                                'status' => 'publish',
                                'manage_stock' => true,
                                'limit' => 50,
                                'orderby' => 'title',
                                'order' => 'ASC'
                            ));

                            foreach ($products as $product) {
                                echo '<label class="wisestock-product-item">';
                                /* translators: %s: Product name. */
                                echo '<input type="checkbox" name="edit_supplier_products[]" value="' . esc_attr($product->get_id()) . '" class="wisestock-product-checkbox edit-product-checkbox" aria-label="' . esc_attr(sprintf(__('Select product %s', 'wisestock'), $product->get_name())) . '">';
                                echo '<span class="wisestock-product-name">' . esc_html($product->get_name()) . '</span>';
                                echo '<span class="wisestock-product-sku">(' . esc_html($product->get_sku() ?: __('No SKU', 'wisestock')) . ')</span>';
                                echo '</label>';
                            }
                            ?>
                        </div>
                        <div class="wisestock-selected-products" id="edit_selected_products">
                            <h4><?php esc_html_e('Selected Products:', 'wisestock'); ?></h4>
                            <div class="wisestock-selected-list"></div>
                        </div>
                    </div>
                    <div class="wisestock-form-help">
                        <?php esc_html_e('Only products with stock management enabled will appear here', 'wisestock'); ?>
                    </div>
                </div>
            </form>
        </div>
        <div class="wisestock-modal-footer">
            <button type="button" class="wisestock-btn secondary wisestock-modal-cancel">
                <?php esc_html_e('Cancel', 'wisestock'); ?>
            </button>
            <button type="button" class="wisestock-btn wisestock-modal-save-edit">
                <?php esc_html_e('Update Supplier', 'wisestock'); ?>
            </button>
        </div>
    </div>
</div>

