<?php
/**
 * Wise Stock Settings Template
 *
 * This template displays the Wise Stock settings page with configuration
 * options for notifications, suppliers, and general plugin settings.
 *
 * @package WiseStock
 * @since 1.0.0
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get current settings with proper defaults
$defaults = WISESTOCK_Core::get_default_options();
$options = wp_parse_args(get_option('wisestock_options', array()), $defaults);

// Store type presets data (timebound is now the only algorithm)
$timebound_settings = WISESTOCK_Timebound_Settings::get_instance();
$store_type_presets = $timebound_settings->get_store_type_presets();
?>

<div class="wisestock-admin">
    <?php include WISESTOCK_PLUGIN_DIR . 'admin/partials/navigation.php'; ?>
    
    <div class="wisestock-dashboard">
        <div class="wisestock-dashboard-header">
            <h1 class="wisestock-dashboard-title"><?php esc_html_e('Settings', 'wisestock'); ?></h1>
            <p class="wisestock-dashboard-subtitle"><?php esc_html_e('Configure your wisestock preferences', 'wisestock'); ?></p>
        </div>

        <!-- Auto-save Status Indicator -->
        <div id="wisestock-autosave-status" class="wisestock-autosave-indicator" style="display: none;">
            <span class="wisestock-autosave-text"></span>
            <span class="wisestock-autosave-icon"></span>
        </div>

        <form class="wisestock-settings-form" method="post" action="">
            <?php wp_nonce_field('wisestock_save_settings', 'wisestock_settings_nonce'); ?>

            <?php
            // Hook to add prediction settings sections (includes Store Type)
            do_action('wisestock_settings_sections', $options);
            ?>

            <!-- General Settings (Right Column) -->
            <!-- <div class="wisestock-grid-2">
                <div> -->
                       <!-- Notification Settings -->
                       <div class="wisestock-card">
                        <div class="wisestock-card-header">
                            <h2 class="wisestock-card-title"><?php esc_html_e('Alert Notification', 'wisestock'); ?></h2>
                            <p class="wisestock-card-subtitle"><?php esc_html_e('Configure inventory notification thresholds and alerts', 'wisestock'); ?></p>
                        </div>

                        <div class="wisestock-form-group">
                            <label class="wisestock-form-label" for="alert_critical">
                                <?php esc_html_e('Critical Notification Threshold (days)', 'wisestock'); ?>
                            </label>
                            <input type="number"
                                   id="alert_critical"
                                   name="notification_thresholds[critical]"
                                   class="wisestock-form-input"
                                   value="<?php echo esc_attr($options['notification_thresholds']['critical']); ?>"
                                   min="1"
                                   max="30">
                            <div class="wisestock-form-help">
                                <?php esc_html_e('System will trigger critical notification alert when stockout is predicted within this many days', 'wisestock'); ?>
                            </div>
                        </div>

                        <div class="wisestock-form-group">
                            <label class="wisestock-form-label" for="alert_warning">
                                <?php esc_html_e('Warning Notification Threshold (days)', 'wisestock'); ?>
                            </label>
                            <input type="number"
                                   id="alert_warning"
                                   name="notification_thresholds[warning]"
                                   class="wisestock-form-input"
                                   value="<?php echo esc_attr($options['notification_thresholds']['warning']); ?>"
                                   min="1"
                                   max="30">
                            <div class="wisestock-form-help">
                                <?php esc_html_e('System will trigger warning notification alert when stockout is predicted within this many days', 'wisestock'); ?>
                            </div>
                        </div>

                        <div class="wisestock-form-group">
                            <label class="wisestock-form-label" for="alert_mild">
                                <?php esc_html_e('Mild Notification Threshold (days)', 'wisestock'); ?>
                            </label>
                            <input type="number"
                                   id="alert_mild"
                                   name="notification_thresholds[mild]"
                                   class="wisestock-form-input"
                                   value="<?php echo esc_attr($options['notification_thresholds']['mild']); ?>"
                                   min="1"
                                   max="30">
                            <div class="wisestock-form-help">
                                <?php esc_html_e('System will trigger mild notification alert when stockout is predicted within this many days', 'wisestock'); ?>
                            </div>
                        </div>

                        <div class="wisestock-form-group">
                            <label class="wisestock-form-label" for="alert_frequency">
                                <?php esc_html_e('Notification Check Frequency', 'wisestock'); ?>
                            </label>
                            <select id="notification_frequency" name="notification_frequency" class="wisestock-form-select">
                                <option value="hourly" <?php selected($options['notification_frequency'], 'hourly'); ?>>
                                    <?php esc_html_e('Hourly', 'wisestock'); ?>
                                </option>
                                <option value="twicedaily" <?php selected($options['notification_frequency'], 'twicedaily'); ?>>
                                    <?php esc_html_e('Twice Daily', 'wisestock'); ?>
                                </option>
                                <option value="daily" <?php selected($options['notification_frequency'], 'daily'); ?>>
                                    <?php esc_html_e('Daily', 'wisestock'); ?>
                                </option>
                            </select>
                            <div class="wisestock-form-help">
                                <?php esc_html_e('How often to check for new notifications', 'wisestock'); ?>
                            </div>
                        </div>

                        <div class="wisestock-form-group">
                            <label class="wisestock-form-label">
                                <input type="checkbox"
                                       name="email_notifications"
                                       id="email_notifications"
                                       value="1"
                                       <?php checked($options['email_notifications'], true); ?>>
                                <?php esc_html_e('Email Notifications', 'wisestock'); ?>
                            </label>
                            <div class="wisestock-form-help">
                                <?php esc_html_e('Send email notifications to admin when inventory notifications are triggered', 'wisestock'); ?>
                            </div>
                        </div>

                        <!-- Notification Type Checkboxes -->
                        <div id="notification_types_fields" style="<?php echo $options['email_notifications'] ? '' : 'display: none;'; ?>">
                            <div class="wisestock-form-group">
                                <div class="wisestock-checkbox-group">
                                    <label class="wisestock-checkbox-item">
                                        <input type="checkbox"
                                               name="email_notification_types[]"
                                               value="critical"
                                               <?php checked(in_array('critical', $options['email_notification_types'] ?? ['critical', 'warning', 'mild']), true); ?>>
                                        <span class="wisestock-checkbox-label">
                                            <?php esc_html_e('Critical', 'wisestock'); ?>
                                            <span class="wisestock-checkbox-description">
                                                <?php esc_html_e('Send emails for critical stock alerts (immediate action required)', 'wisestock'); ?>
                                            </span>
                                        </span>
                                    </label>
                                    <label class="wisestock-checkbox-item">
                                        <input type="checkbox"
                                               name="email_notification_types[]"
                                               value="warning"
                                               <?php checked(in_array('warning', $options['email_notification_types'] ?? ['critical', 'warning', 'mild']), true); ?>>
                                        <span class="wisestock-checkbox-label">
                                            <?php esc_html_e('Warning', 'wisestock'); ?>
                                            <span class="wisestock-checkbox-description">
                                                <?php esc_html_e('Send emails for warning alerts (action needed soon)', 'wisestock'); ?>
                                            </span>
                                        </span>
                                    </label>
                                    <label class="wisestock-checkbox-item">
                                        <input type="checkbox"
                                               name="email_notification_types[]"
                                               value="mild"
                                               <?php checked(in_array('mild', $options['email_notification_types'] ?? ['critical', 'warning', 'mild']), true); ?>>
                                        <span class="wisestock-checkbox-label">
                                            <?php esc_html_e('Mild', 'wisestock'); ?>
                                            <span class="wisestock-checkbox-description">
                                                <?php esc_html_e('Send emails for mild alerts (informational only)', 'wisestock'); ?>
                                            </span>
                                        </span>
                                    </label>
                                </div>
                                <div class="wisestock-form-help">
                                    <?php esc_html_e('Select which types of notifications should trigger email alerts', 'wisestock'); ?>
                                </div>
                            </div>
                        </div>

                        <!-- Conditional Email Fields -->
                        <div id="email_notifications_fields" style="<?php echo $options['email_notifications'] ? '' : 'display: none;'; ?>">
                            <div class="wisestock-form-group">
                                <label for="admin_email_address" class="wisestock-form-label">
                                    <?php esc_html_e('Admin Email Address', 'wisestock'); ?>
                                    <span class="required">*</span>
                                </label>
                                <input type="email"
                                       id="admin_email_address"
                                       name="admin_email_address"
                                       class="wisestock-form-input"
                                       value="<?php echo esc_attr($options['admin_email_address'] ?? get_option('admin_email')); ?>"
                                       placeholder="<?php esc_attr_e('admin@example.com', 'wisestock'); ?>"
                                       required>
                                <div class="wisestock-form-help">
                                    <?php esc_html_e('Email address where inventory notifications will be sent', 'wisestock'); ?>
                                </div>
                                <div class="wisestock-validation-error" id="admin_email_address_error" style="display: none;"></div>
                            </div>

                            <div class="wisestock-form-group">
                                <label class="wisestock-form-label">
                                    <?php esc_html_e('Test Notification Email', 'wisestock'); ?>
                                </label>
                                <div class="wisestock-btn-group">
                                    <button type="button" class="wisestock-btn wisestock-send-test-notification-email">
                                        <?php esc_html_e('Send Test Email', 'wisestock'); ?>
                                    </button>
                                </div>
                                <div class="wisestock-form-help">
                                    <?php esc_html_e('Send a test notification email to verify your email settings are working correctly', 'wisestock'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <!-- </div> -->

                <!-- Right Column: Dashboard and System Settings -->
                <!-- <div> -->
                    <!-- Other Settings -->
                    <div class="wisestock-card">
                        <div class="wisestock-card-header">
                            <h2 class="wisestock-card-title"><?php esc_html_e('Other Settings', 'wisestock'); ?></h2>
                            <p class="wisestock-card-subtitle"><?php esc_html_e('Configure miscellaneous settings', 'wisestock'); ?></p>
                        </div>

                        <div class="wisestock-form-group">
                            <label class="wisestock-form-label">
                                <input type="checkbox"
                                       name="dashboard_widget"
                                       value="1"
                                       <?php checked($options['dashboard_widget'], true); ?>>
                                <?php esc_html_e('Show Dashboard Widget', 'wisestock'); ?>
                            </label>
                            <div class="wisestock-form-help">
                                <?php esc_html_e('Display WiseStock widget on WordPress admin dashboard', 'wisestock'); ?>
                            </div>
                        </div>

                        <div class="wisestock-form-group">
                            <label class="wisestock-form-label">
                                <input type="checkbox"
                                       name="demo_stats"
                                       value="1"
                                       <?php checked($options['demo_stats'], true); ?>>
                                <?php esc_html_e('Enable Demo Stats', 'wisestock'); ?>
                            </label>
                            <div class="wisestock-form-help">
                                <?php esc_html_e('Use demo order data to populate dashboard with demo statistics and notifications', 'wisestock'); ?>
                            </div>
                        </div>
                    </div>
                <!-- </div>
            </div> -->

            <!-- Installation Reset -->
            <div class="wisestock-card">
                <div class="wisestock-card-header">
                    <h2 class="wisestock-card-title"><?php esc_html_e('Installation Management', 'wisestock'); ?></h2>
                    <p class="wisestock-card-subtitle"><?php esc_html_e('Reset installation to reconfigure your store settings', 'wisestock'); ?></p>
                </div>
                <div class="wisestock-form-group">
                    <div class="wisestock-warning-box">
                        <h4><?php esc_html_e('⚠️ Reset Installation', 'wisestock'); ?></h4>
                        <p><?php esc_html_e('This will reset your installation settings and redirect you to the setup wizard. Your existing data will be preserved.', 'wisestock'); ?></p>
                        <button type="button" class="wisestock-btn wisestock-btn-warning" id="reset-installation-btn">
                            <span class="dashicons dashicons-update"></span>
                            <?php esc_html_e('Redo Installation', 'wisestock'); ?>
                        </button>
                    </div>
                </div>
            </div>

            <!-- Danger Zone -->
            <div class="wisestock-card wisestock-danger-zone">
                <div class="wisestock-card-header">
                    <h3 class="wisestock-card-title">
                        <?php esc_html_e('Danger Zone', 'wisestock'); ?>
                    </h3>
                </div>
                <div class="wisestock-card-content">
                    <div class="wisestock-danger-setting">
                        <p class="wisestock-danger-description">
                            <?php esc_html_e('When enabled, the plugin will automatically delete all its settings and database tables it created when the plugin is uninstalled. This includes sales velocity data, predictions, notifications, suppliers, and historical analytics.', 'wisestock'); ?>
                        </p>
                        <p class="wisestock-danger-warning">
                            <strong><?php esc_html_e('⚠️ Once uninstalled, this data cannot be recovered!', 'wisestock'); ?></strong>
                        </p>

                        <div class="wisestock-form-group">
                            <label class="wisestock-form-label">
                                <input type="checkbox"
                                       name="delete_data_on_uninstall"
                                       id="delete_data_on_uninstall"
                                       value="1"
                                       <?php checked(isset($options['delete_data_on_uninstall']) ? $options['delete_data_on_uninstall'] : false, true); ?>>
                                <div class="wisestock-delete-toggle-switch"></div>
                                <span class="wisestock-delete-toggle-label"><?php esc_html_e('Delete data on plugin uninstall', 'wisestock'); ?></span>
                            </label>
                            <div class="wisestock-form-help">
                                <?php esc_html_e('Enable this to automatically remove all plugin data when uninstalling. Leave unchecked to preserve data for future reinstallation.', 'wisestock'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
        
        <?php
        // Hook to add their settings sections
        do_action('wisestock_after_settings_form');
        ?>
    </div>
</div>

<!-- Delete Data Confirmation Popup -->
<div id="wisestock-delete-confirmation-popup" class="wisestock-popup-overlay" style="display: none;">
    <div class="wisestock-popup-content">
        <div class="wisestock-popup-header">
            <h3>
                <?php esc_html_e('Confirm Uninstall Data Deletion', 'wisestock'); ?>
            </h3>
            <button type="button" class="wisestock-popup-close" id="cancel-delete-btn">
                <span class="dashicons dashicons-dismiss"></span>
            </button>
        </div>
        <div class="wisestock-popup-body">
            <div class="wisestock-danger-icon">
                <span class="dashicons dashicons-trash"></span>
            </div>
            <h4><?php esc_html_e('⚠️ Data will be deleted on plugin uninstall!', 'wisestock'); ?></h4>
            <p><?php esc_html_e('You are enabling automatic deletion of ALL plugin data when Wise Stock is uninstalled. The following data will be permanently removed:', 'wisestock'); ?></p>
            <ul>
                <li>⛔️ <?php esc_html_e('Sales velocity data', 'wisestock'); ?></li>
                <li>⛔️ <?php esc_html_e('Prediction calculations', 'wisestock'); ?></li>
                <li>⛔️ <?php esc_html_e('Notification history', 'wisestock'); ?></li>
                <li>⛔️ <?php esc_html_e('Historical analytics', 'wisestock'); ?></li>
                <li>⛔️ <?php esc_html_e('Supplier information', 'wisestock'); ?></li>
                <li>⛔️ <?php esc_html_e('All plugin settings', 'wisestock'); ?></li>
            </ul>

            <div class="wisestock-confirmation-input">
                <label for="delete-confirmation-text">
                    <?php esc_html_e('Type "DELETE DATA" to confirm:', 'wisestock'); ?>
                </label>
                <input type="text" id="delete-confirmation-text" placeholder="<?php esc_attr_e('DELETE DATA', 'wisestock'); ?>" autocomplete="off" aria-label="<?php esc_attr_e('Type DELETE DATA to confirm', 'wisestock'); ?>">
                <div id="delete-confirmation-error" class="wisestock-error-message" style="display: none;">
                    <?php esc_html_e('Please type exactly "DELETE DATA" to confirm.', 'wisestock'); ?>
                </div>
            </div>
        </div>
        <div class="wisestock-popup-footer">
            <button type="button" class="wisestock-btn wisestock-btn-secondary" id="cancel-delete-btn-2">
                <?php esc_html_e('Cancel', 'wisestock'); ?>
            </button>
            <button type="button" class="wisestock-btn wisestock-btn-danger" id="confirm-delete-btn" disabled>
                <span class="dashicons dashicons-yes-alt"></span>
                <?php esc_html_e('Enable Delete on Uninstall', 'wisestock'); ?>
            </button>
        </div>
    </div>
</div>

<!-- Result Modal -->
<div id="result-modal" class="wisestock-popup-overlay" style="display: none;">
    <div class="wisestock-popup-content">
        <div class="wisestock-popup-header">
            <h3 class="wisestock-popup-title">
                <?php esc_html_e('Operation Complete', 'wisestock'); ?>
            </h3>
            <button type="button" class="wisestock-popup-close" onclick="WiseStockSettings.closeResultModal()">
                <span class="dashicons dashicons-dismiss"></span>
            </button>
        </div>
        <div class="wisestock-popup-body">
            <p id="result-message"></p>
        </div>
        <div class="wisestock-popup-footer">
            <button type="button" class="wisestock-btn wisestock-btn-primary" onclick="WiseStockSettings.closeResultModal()">
                <?php esc_html_e('OK', 'wisestock'); ?>
            </button>
        </div>
    </div>
</div>
