<?php
/**
 * Wise Stock Navigation Template
 *
 * This template displays the main navigation for Wise Stock pages.
 * It provides navigation between Dashboard and Settings pages.
 *
 * @package WiseStock
 * @since 1.0.0
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get current page
$current_page = isset($_GET['page']) ? sanitize_text_field($_GET['page']) : 'wisestock-dashboard';

// Define navigation items
$nav_items = array(
    'wisestock-dashboard' => array(
        'title' => __('Dashboard', 'wisestock'),
        'url' => admin_url('admin.php?page=wisestock-dashboard'),
        'icon' => 'dashicons-dashboard'
    ),
    'wisestock-notifications' => array(
        'title' => __('Notifications', 'wisestock'),
        'url' => admin_url('admin.php?page=wisestock-notifications'),
        'icon' => 'dashicons-bell'
    ),
    'wisestock-suppliers' => array(
        'title' => __('Suppliers', 'wisestock'),
        'url' => admin_url('admin.php?page=wisestock-suppliers'),
        'icon' => 'dashicons-groups'
    ),
    'wisestock-settings' => array(
        'title' => __('Settings', 'wisestock'),
        'url' => admin_url('admin.php?page=wisestock-settings'),
        'icon' => 'dashicons-admin-settings'
    ),
);
?>

<div class="wisestock-navigation">
    <div class="wisestock-nav-container">
        <div class="wisestock-nav-brand">
            <span class="wisestock-nav-icon dashicons dashicons-chart-line"></span>
            <span class="wisestock-nav-title"><?php esc_html_e('WiseStock', 'wisestock'); ?></span>
        </div>

        <nav class="wisestock-nav-menu">
            <?php foreach ($nav_items as $page_key => $nav_item): ?>
                <a href="<?php echo esc_url($nav_item['url']); ?>"
                   class="wisestock-nav-item <?php echo ($current_page === $page_key) ? 'active' : ''; ?>">
                    <span class="wisestock-nav-item-text"><?php echo esc_html($nav_item['title']); ?></span>
                </a>
            <?php endforeach; ?>
        </nav>
    </div>
</div>

