<?php
/**
 * Installation Wizard Page
 *
 * @package WiseStock
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

// Get current installation status with proper defaults
$installation_completed = get_option('wisestock_installation_completed', false);
$defaults = WISESTOCK_Core::get_default_options();
$options = wp_parse_args(get_option('wisestock_options', array()), $defaults);

// Get existing settings for pre-selection
$existing_store_preset = isset($options['store_type']) ? $options['store_type'] : 'default';
$existing_demo_stats = isset($options['demo_stats']) ? $options['demo_stats'] : false;

// Get timebound store type presets (timebound is now the only algorithm)
$timebound_settings = WISESTOCK_Timebound_Settings::get_instance();
$store_presets = $timebound_settings->get_store_type_presets();
?>

<div class="wrap wisestock-installation">
    <div class="wisestock-installation-container">
        <div class="wisestock-installation-header">
            <div class="wisestock-header-top">
                <h1 class="wisestock-installation-title"><?php esc_html_e('WiseStockk Setup', 'wisestock'); ?></h1>
                <?php
                // Only show exit button if not first time installation
                $installation_completed = get_option('wisestock_installation_completed', false);
                if ($installation_completed):
                ?>
                <button type="button" class="wisestock-exit-btn" id="wisestock-exit-installation" title="<?php esc_attr_e('Exit Setup', 'wisestock'); ?>">
                    <span class="dashicons dashicons-dismiss"></span>
                </button>
                <?php endif; ?>
            </div>
            <p class="wisestock-installation-subtitle">
                <?php esc_html_e("Let's configure your intelligent stock system in just a few steps", 'wisestock'); ?>
            </p>
        </div>

        <div class="wisestock-installation-wizard">
            <!-- Progress Bar -->
            <div class="wisestockgress-container">
                <div class="wisestockgress-bar">
                    <div class="wisestockgress-fill" id="wisestockgress-fill"></div>
                </div>
                <div class="wisestockgress-steps">
                    <div class="wisestock-step active" data-step="1">
                        <span class="wisestock-step-number">1</span>
                        <span class='wisestock-step-label'><?php esc_html_e('Store Category', 'wisestock'); ?></span>
                    </div>
                    <div class="wisestock-step" data-step="2">
                        <span class="wisestock-step-number">2</span>
                        <span class='wisestock-step-label'><?php esc_html_e('Stock Management', 'wisestock'); ?></span>
                    </div>
                    <div class="wisestock-step" data-step="3">
                        <span class="wisestock-step-number">3</span>
                        <span class='wisestock-step-label'><?php esc_html_e('Summary', 'wisestock'); ?></span>
                    </div>
                    <div class="wisestock-step" data-step="4">
                        <span class="wisestock-step-number">4</span>
                        <span class='wisestock-step-label'><?php esc_html_e('Complete', 'wisestock'); ?></span>
                    </div>
                </div>
            </div>

            <!-- Step 1: Store Category -->
            <div class="wisestock-installation-step active" id="step-1">
                <div class="wisestock-step-content">
                    <h2 class='wisestock-step-title'><?php esc_html_e('Choose your store category', 'wisestock'); ?></h2>
                    <p class="wisestock-step-description">
                        <?php esc_html_e('Select the category that best matches your business for optimized algorithm settings.', 'wisestock'); ?>
                    </p>

                    <div class="wisestock-presets-grid" id="presets-container">
                        <!-- Presets will be loaded dynamically based on store type -->
                    </div>

                    <div class="wisestock-info-box">
                        <h4><?php esc_html_e('💡 How Presets Work', 'wisestock'); ?></h4>
                        <p>
                            <?php esc_html_e('Each preset optimizes the algorithm\'s velocity weights and confidence settings for your specific industry. This ensures more accurate predictions tailored to your business model.', 'wisestock'); ?>
                        </p>
                    </div>
                </div>
            </div>


            <!-- Step 2: Stock Management Acknowledgement -->
            <div class="wisestock-installation-step" id="step-2">
                <div class="wisestock-step-content">
                    <h2 class='wisestock-step-title'><?php esc_html_e('Stock Management Information', 'wisestock'); ?></h2>
                    <p class="wisestock-step-description">
                        <?php esc_html_e('Only products with WooCommerce stock management enabled will show specific stats on the plugin dashboard. The stats are product-based, not store-wide.', 'wisestock'); ?>
                    </p>

                    <div class="wisestock-acknowledgement-options">
                        <div class="wisestock-acknowledgement-card">
                            <div class="wisestock-option-icon">✅</div>
                            <h3 class='wisestock-option-title'><?php esc_html_e('With Stock Management', 'wisestock'); ?></h3>
                            <p class="wisestock-option-description">
                                <?php esc_html_e('With WooCommerce stock management enabled for each product, you will get stockout predictions, restock alerts, and inventory optimization.', 'wisestock'); ?>
                            </p>
                        </div>

                        <div class="wisestock-acknowledgement-card">
                            <div class="wisestock-option-icon">⚠️</div>
                            <h3 class='wisestock-option-title'><?php esc_html_e('Without Stock Management', 'wisestock'); ?></h3>
                            <p class="wisestock-option-description">
                                <?php esc_html_e('You\'ll only see sales velocity data of products without restock recommendations.', 'wisestock'); ?>
                            </p>
                            <div class="wisestock-help-button">
                                <button type="button" class="wisestock-btn wisestock-btn-secondary" id="wisestock-help-button">
                                    <span class="dashicons dashicons-editor-help"></span>
                                    <?php esc_html_e('What is Stock Management?', 'wisestock'); ?>
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="wisestock-info-box">
                        <h4><?php esc_html_e('💡 What to do next? I don\'t use stock management in products.', 'wisestock'); ?></h4>
                        <p><?php esc_html_e('Don\'t worry! You can enable WooCommerce stock management for each products after completing this setup.', 'wisestock'); ?></p>
                    </div>
                </div>
            </div>


            <!-- Step 3: Configuration Summary -->
            <div class="wisestock-installation-step" id="step-3">
                <div class="wisestock-step-content">
                    <h2 class='wisestock-step-title'><?php esc_html_e('Review Your Configuration', 'wisestock'); ?></h2>
                    <p class="wisestock-step-description">
                        <?php esc_html_e('Here\'s what you\'ve selected. You can go back to make changes or proceed to finish.', 'wisestock'); ?>
                    </p>

                    <div class="wisestock-configuration-summary">
                        <div class="wisestock-summary-section">
                            <h3><?php esc_html_e('Store Configuration', 'wisestock'); ?></h3>
                            <div class="wisestock-summary-item" id="preset-summary">
                                <span class='wisestock-summary-label'><?php esc_html_e('Store Preset:', 'wisestock'); ?> </span>
                                <span class="wisestock-summary-value" id="summary-store-preset">-</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Step 4: Completion -->
            <div class="wisestock-installation-step" id="step-4">
                <div class="wisestock-step-content">
                    <h2 class='wisestock-step-title'><?php esc_html_e('🎉 Setup Complete!', 'wisestock'); ?></h2>
                    <p class="wisestock-step-description">
                        <?php esc_html_e('Your Wise Stock is now configured and ready to use', 'wisestock'); ?>
                    </p>

                    <div class="wisestock-how-it-works">
                        <h3><?php esc_html_e('📚 How Wise Stock Works', 'wisestock'); ?></h3>
                        <div class="wisestock-timeline">
                            <div class="wisestock-timeline-item">
                                <div class="wisestock-timeline-icon">⚡</div>
                                <div class="wisestock-timeline-content">
                                    <h4><?php esc_html_e('Immediate Data Collection', 'wisestock'); ?></h4>
                                    <p><?php esc_html_e('Plugin starts tracking sales from day one. All statistics data is stored on your website for analysis and reporting. First sale shows basic velocity with 30% confidence.', 'wisestock'); ?></p>
                                </div>
                            </div>

                            <div class="wisestock-timeline-item">
                                <div class="wisestock-timeline-icon">📊</div>
                                <div class="wisestock-timeline-content">
                                    <h4><?php esc_html_e('Week 1: Basic Analytics', 'wisestock'); ?></h4>
                                    <p><?php esc_html_e('7-day rolling averages begin. Confidence improves to 40-60% with more data points.', 'wisestock'); ?></p>
                                </div>
                            </div>

                            <div class="wisestock-timeline-item">
                                <div class="wisestock-timeline-icon">🎯</div>
                                <div class="wisestock-timeline-content">
                                    <h4><?php esc_html_e('Week 2: Reliable Predictions', 'wisestock'); ?></h4>
                                    <p><?php esc_html_e('Full weighted averages activate. Confidence reaches 60-80% with reliable forecasts.', 'wisestock'); ?></p>
                                </div>
                            </div>

                            <div class="wisestock-timeline-item">
                                <div class="wisestock-timeline-icon">🏆</div>
                                <div class="wisestock-timeline-content">
                                    <h4><?php esc_html_e('Month 1: Excellent Accuracy', 'wisestock'); ?></h4>
                                    <p><?php esc_html_e('Complete algorithm with 70-90% confidence. Very accurate predictions and recommendations.', 'wisestock'); ?></p>
                                </div>
                            </div>
                        </div>

                        <div class="wisestock-timeline-summary">
                            <h4><?php esc_html_e('📋 Quick Reference', 'wisestock'); ?></h4>
                            <table class="wisestock-reference-table">
                                <thead>
                                    <tr>
                                        <th><?php esc_html_e('Time Period', 'wisestock'); ?></th>
                                        <th><?php esc_html_e('Data Available', 'wisestock'); ?></th>
                                        <th><?php esc_html_e('Confidence', 'wisestock'); ?></th>
                                        <th><?php esc_html_e('Features', 'wisestock'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><strong><?php esc_html_e('Installation', 'wisestock'); ?></strong></td>
                                        <td><?php esc_html_e('None', 'wisestock'); ?></td>
                                        <td><?php esc_html_e('N/A', 'wisestock'); ?></td>
                                        <td><?php esc_html_e('Demo mode, settings', 'wisestock'); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php esc_html_e('First Sale', 'wisestock'); ?></strong></td>
                                        <td><?php esc_html_e('Basic velocity', 'wisestock'); ?></td>
                                        <td><?php esc_html_e('30-40%', 'wisestock'); ?></td>
                                        <td><?php esc_html_e('Basic predictions', 'wisestock'); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php esc_html_e('1 Week', 'wisestock'); ?></strong></td>
                                        <td><?php esc_html_e('7-day average', 'wisestock'); ?></td>
                                        <td><?php esc_html_e('40-60%', 'wisestock'); ?></td>
                                        <td><?php esc_html_e('Weighted predictions', 'wisestock'); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php esc_html_e('2 Weeks', 'wisestock'); ?></strong></td>
                                        <td><?php esc_html_e('14-day average', 'wisestock'); ?></td>
                                        <td><?php esc_html_e('60-80%', 'wisestock'); ?></td>
                                        <td><?php esc_html_e('Reliable predictions', 'wisestock'); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php esc_html_e('1 Month', 'wisestock'); ?></strong></td>
                                        <td><?php esc_html_e('30-day average', 'wisestock'); ?></td>
                                        <td><?php esc_html_e('70-90%', 'wisestock'); ?></td>
                                        <td><?php esc_html_e('Excellent predictions', 'wisestock'); ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="wisestock-demo-toggle">
                        <h3><?php esc_html_e('🎯 Want to see demo data while you wait?', 'wisestock'); ?></h3>
                        <p>
                            <?php esc_html_e('It will take time for the plugin to collect valuable data. Enable demo stats to see how the plugin works immediately.', 'wisestock'); ?>
                        </p>
                        <label class="wisestock-toggle">
                            <input type="checkbox" id="enable-demo-stats"<?php echo $existing_demo_stats ? ' checked' : ''; ?> aria-describedby="demo-stats-help">
                            <span class="wisestock-toggle-slider"></span>
                            <span class='wisestock-toggle-label'><?php esc_html_e('Demo Stats', 'wisestock'); ?></span>
                        </label>
                        <p class="wisestock-toggle-note" id="demo-stats-help">
                            <?php esc_html_e('You can disable demo stats anytime from the plugin settings.', 'wisestock'); ?>
                        </p>
                    </div>

                    <div class="wisestock-completion-actions">
                        <button type="button" class="wisestock-btn wisestock-btn-success wisestock-btn-large" id="wisestock-go-to-dashboard">
                            <span class="dashicons dashicons-chart-bar"></span>
                            <?php esc_html_e('Go to Stats Dashboard', 'wisestock'); ?>
                        </button>
                    </div>
                </div>
            </div>

            <!-- Navigation Buttons -->
            <div class="wisestock-installation-navigation">
                <div class="wisestock-nav-left">
                    <button type="button" class="wisestock-btn wisestock-btn-secondary" id="wisestock-prev-btn" style="display: none;">
                        <span class="dashicons dashicons-arrow-left-alt2"></span>
                        <?php esc_html_e('Previous', 'wisestock'); ?>
                    </button>
                </div>

                <div class="wisestock-nav-right">
                    <button type="button" class="wisestock-btn wisestock-btn-primary" id="wisestock-next-btn">
                        <?php esc_html_e('Next', 'wisestock'); ?>
                        <span class="dashicons dashicons-arrow-right-alt2"></span>
                    </button>

                    <button type="button" class="wisestock-btn wisestock-btn-success" id="wisestock-complete-btn" style="display: none;">
                        <span class="dashicons dashicons-yes"></span>
                        <?php esc_html_e('Complete Setup', 'wisestock'); ?>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Help Modal -->
<div id="wisestock-help-modal" class="wisestock-modal wisestock-dynamic-display-none">
    <div class="wisestock-modal-content">
        <div class="wisestock-modal-header">
            <h2 class="wisestock-modal-title">
                <span class="dashicons dashicons-editor-help"></span>
                <?php esc_html_e('Stock Management', 'wisestock'); ?>
            </h2>
            <button class="wisestock-modal-close" id="wisestock-modal-close">&times;</button>
        </div>
        <div class="wisestock-modal-body">
            <p><strong><?php esc_html_e('The WooCommerce Stock Management option allows you to:', 'wisestock'); ?></strong></p>
            <ul>
                <li>✅ <?php esc_html_e('Track inventory levels for individual products', 'wisestock'); ?></li>
                <li>✅ <?php esc_html_e('Set stock quantities and low stock thresholds', 'wisestock'); ?></li>
                <li>✅ <?php esc_html_e('Enable/disable stock management per product', 'wisestock'); ?></li>
            </ul>
        </div>
        <div class="wisestock-modal-footer">
            <button type="button" class="wisestock-btn wisestock-btn-primary" id="wisestock-modal-close-btn">
                <?php esc_html_e('Got it!', 'wisestock'); ?>
            </button>
        </div>
    </div>
</div>
