<?php

/**
 * Plugin Name:       Wingstech 3D Product Viewer Interactive
 * Plugin URI:        https://wingstechsolutions.com/
 * Description:       Easily display interactive 3D models on the web & in AR
 * Version:           1.0.0
 * Requires at least: 5.2
 * Requires PHP:      7.1
 * Author:            Wings Tech Solution
 * Author URI:        https://wingstechsolutions.com
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       wingstech-3d-product-viewer-interactive
 * Domain Path:       /languages
 *
 * @package Wingstech 3D Product Viewer Interactive
 */
/**
 * Direct access not allowed
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
// Load the Composer autoloader if it exists.
if ( file_exists( __DIR__ . '/vendor/autoload.php' ) ) {
    // Load the Composer autoloader.
    require_once __DIR__ . '/vendor/autoload.php';
} else {
    // If the autoloader does not exist, throw an error.
    wp_die( esc_html__( 'The required files for the Wingstech 3D Product Viewer Interactive plugin are missing. Please reinstall the plugin.', 'wingstech-3d-product-viewer-interactive' ) );
}
// Define plugin constants.
define( 'WINGS3DPR_PLUGIN_VER', '1.0.0' );
define( 'WINGS3DPR_PLUGIN_FILE', __FILE__ );
define( 'WINGS3DPR_PLUGIN_DIR', trailingslashit( plugin_dir_path( __FILE__ ) ) );
define( 'WINGS3DPR_PLUGIN_URL', trailingslashit( plugins_url( '/', __FILE__ ) ) );
if ( !function_exists( 'wings3dpr_fs' ) ) {
    // Create a helper function for easy SDK access.
    function wings3dpr_fs() {
        global $wings3dpr_fs;
        if ( !isset( $wings3dpr_fs ) ) {
            // Include Freemius SDK.
            // SDK is auto-loaded through Composer
            $wings3dpr_fs = fs_dynamic_init( array(
                'id'               => '19899',
                'slug'             => 'wingstech-3d-product-viewer-interactive',
                'premium_slug'     => 'wingstech-3d-product-viewer-interactive-pro',
                'type'             => 'plugin',
                'public_key'       => 'pk_877c9ada3854d52c621e2b7d8cfc4',
                'is_premium'       => false,
                'premium_suffix'   => 'Pro',
                'has_addons'       => false,
                'has_paid_plans'   => true,
                'is_org_compliant' => true,
                'trial'            => array(
                    'days'               => 7,
                    'is_require_payment' => false,
                ),
                'menu'             => array(
                    'slug'       => 'wingstech-3d-product-viewer-interactive',
                    'first-path' => 'edit.php?post_type=wings3dpr_model',
                    'contact'    => false,
                    'support'    => false,
                ),
                'is_live'          => true,
            ) );
        }
        return $wings3dpr_fs;
    }

    // Init Freemius.
    wings3dpr_fs();
    // Signal that SDK was initiated.
    do_action( 'wings3dpr_fs_loaded' );
}
if ( !defined( 'WINGS3DPR_IS_PREMIUM' ) ) {
    define( 'WINGS3DPR_IS_PREMIUM', function_exists( 'wings3dpr_fs' ) && wings3dpr_fs()->can_use_premium_code__premium_only() );
}
// Include require files.
require_once WINGS3DPR_PLUGIN_DIR . 'inc/Base/class-wings3dpr-extend-mime-type.php';
require_once WINGS3DPR_PLUGIN_DIR . 'admin/class-wings3dpr-admin-settings.php';
require_once WINGS3DPR_PLUGIN_DIR . 'admin/class-wings3dpr-model-meta-box.php';
require_once WINGS3DPR_PLUGIN_DIR . 'inc/class-wings3dpr-model-post-type.php';
require_once WINGS3DPR_PLUGIN_DIR . 'inc/class-wings3dpr-shortcodes.php';
require_once WINGS3DPR_PLUGIN_DIR . 'inc/Elementor/class-wings3dpr-elementor-loader.php';
/**
 * Plugin initialize.
 */
function wings3dpr_init() {
    new WINGS3DPR_Admin_Settings();
    new WINGS3DPR_Model_Post_Type();
    new WINGS3DPR_Model_Meta_Box();
    new WINGS3DPR_Shortcodes();
    new WINGS3DPR_Extend_Mime_Type();
    new WINGS3DPR_Elementor_Loader();
}

add_action( 'plugins_loaded', 'wings3dpr_init' );