<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Checked if not exists Wings3dpr_Model_Post_Type class.
 */
if ( ! class_exists( 'Wings3dpr_Model_Post_Type' ) ) {

	/**
	 * Wings3dpr_Model_Post_Type class file.
	 */
	class Wings3dpr_Model_Post_Type {

		/**
		 * Wings3dpr_Model_Post_Type class constructor.
		 */
		public function __construct() {
			add_action( 'init', array( $this, 'register_model_post_type' ) );
		}

		/**
		 * Register model custom post type.
		 */
		public function register_model_post_type() {
			$labels = array(
				'name'                  => __( '3D Model', 'wingstech-3d-product-viewer-interactive' ),
				'singular_name'         => __( '3D Model', 'wingstech-3d-product-viewer-interactive' ),
				'menu_name'             => __( '3D Model', 'wingstech-3d-product-viewer-interactive' ),
				'name_admin_bar'        => __( '3D Model', 'wingstech-3d-product-viewer-interactive' ),
				'add_new'               => __( 'Add New', 'wingstech-3d-product-viewer-interactive' ),
				'add_new_item'          => __( 'Add New', 'wingstech-3d-product-viewer-interactive' ),
				'new_item'              => __( 'New', 'wingstech-3d-product-viewer-interactive' ),
				'edit_item'             => __( 'Edit', 'wingstech-3d-product-viewer-interactive' ),
				'view_item'             => __( 'View', 'wingstech-3d-product-viewer-interactive' ),
				'all_items'             => __( 'All Models', 'wingstech-3d-product-viewer-interactive' ),
				'search_items'          => __( 'Search', 'wingstech-3d-product-viewer-interactive' ),
				'not_found'             => __( 'Not found.', 'wingstech-3d-product-viewer-interactive' ),
				'not_found_in_trash'    => __( 'Not found in Trash.', 'wingstech-3d-product-viewer-interactive' ),
				'featured_image'        => __( '3D Model Interactive File', 'wingstech-3d-product-viewer-interactive' ),
				'set_featured_image'    => __( 'Set 3D Model Interactive Image', 'wingstech-3d-product-viewer-interactive' ),
				'remove_featured_image' => __( 'Remove', 'wingstech-3d-product-viewer-interactive' ),
				'use_featured_image'    => __( 'Use as 3D Model Interactive Image', 'wingstech-3d-product-viewer-interactive' ),
				'archives'              => __( '3D Model Interactive Archives', 'wingstech-3d-product-viewer-interactive' ),
				'insert_into_item'      => __( 'Insert', 'wingstech-3d-product-viewer-interactive' ),
				'uploaded_to_this_item' => __( 'Uploaded to this 3D Model Interactive', 'wingstech-3d-product-viewer-interactive' ),
				'filter_items_list'     => __( 'Filter 3D Model Interactives list', 'wingstech-3d-product-viewer-interactive' ),
				'items_list_navigation' => __( 'List navigation', 'wingstech-3d-product-viewer-interactive' ),
				'items_list'            => __( 'List', 'wingstech-3d-product-viewer-interactive' ),
			);

			$args = array(
				'labels'             => $labels,
				'public'             => false,
				'menu_icon'          => 'dashicons-format-gallery',
				'publicly_queryable' => false,
				'show_ui'            => true,
				'show_in_menu'       => '3d-model-interactive',
				'query_var'          => true,
				'rewrite'            => array( 'slug' => 'model' ),
				'capability_type'    => 'post',
				'has_archive'        => true,
				'hierarchical'       => false,
				'menu_position'      => 999,
				'supports'           => array( 'title' ),
			);

			register_post_type( 'wings3dpr_model', $args );
		}
	}
}
