/**
 * Model Fullscreen code start.
 */
document.addEventListener("DOMContentLoaded", function () {
  document.querySelectorAll('[id^="tpvOpenBtn"]').forEach(function (openBtn) {
    openBtn.addEventListener("click", function () {
      var post_id = this.id.split("-")[1];
      var modelViewer = document.getElementById("model_viewer_" + post_id);

      if (modelViewer.requestFullscreen) {
        modelViewer.requestFullscreen().then(function () {
          addCloseButton(modelViewer, post_id);
        });
      } else if (modelViewer.webkitRequestFullscreen) {
        modelViewer.webkitRequestFullscreen().then(function () {
          addCloseButton(modelViewer, post_id);
        });
      } else if (modelViewer.msRequestFullscreen) {
        modelViewer.msRequestFullscreen().then(function () {
          addCloseButton(modelViewer, post_id);
        });
      }
    });
  });

  function addCloseButton(modelViewer, post_id) {
    const node = document.createElement("div");
    const textnode = document.createTextNode("X");
    node.appendChild(textnode);
    node.classList.add("tpv-close-icon");
    node.id = "dynamicCloseBtn-" + post_id;
    modelViewer.appendChild(node);

    node.addEventListener("click", function () {
      exitFullscreen();
    });
  }

  function exitFullscreen() {
    if (document.exitFullscreen) {
      document.exitFullscreen();
    } else if (document.webkitExitFullscreen) {
      document.webkitExitFullscreen();
    } else if (document.msExitFullscreen) {
      document.msExitFullscreen();
    }
  }

  document.addEventListener("fullscreenchange", function () {
    document
      .querySelectorAll('[id^="dynamicCloseBtn"]')
      .forEach(function (closeBtn) {
        if (document.fullscreenElement) {
          closeBtn.style.display = "flex";
        } else {
          closeBtn.style.display = "none";
          closeBtn.remove();
        }
      });
  });
});

/**
 * AR Popup Model JS
 *
 */
jQuery(document).on("click", ".tpv-ar-btn a", function (e) {
  e.preventDefault();
  var popup_id = jQuery(this).data("id");
  jQuery("#tpv-ar-popup-" + popup_id).removeClass("hide");
});

jQuery(document).on("click", ".tpv-ar-close-btn", function (e) {
  e.preventDefault();
  var popup_id = jQuery(this).data("id");
  jQuery("#tpv-ar-popup-" + popup_id).addClass("hide");
});


jQuery(document).ready(function ($) {
  // Select all model-viewer elements with data-id attribute
  const modelViewers = document.querySelectorAll("model-viewer[data-id]");

  modelViewers.forEach((modelViewer) => {
    const animationSpeed = modelViewer.getAttribute("data-animation-speed");
    if (animationSpeed) {
      modelViewer.addEventListener("load", function () {
        const speedValue = parseFloat(animationSpeed);
        modelViewer.timeScale = speedValue;
        modelViewer.setAttribute("animation-speed", speedValue);
      });
    }

    // Set effects based on initial blend-mode
    const effectComposer = modelViewer.querySelector("effect-composer");
    if (effectComposer) {
      const effects = effectComposer.children;
      for (let i = 0; i < effects.length; i++) {
        // Get initial blend-mode value
        const initialBlendMode =
          effects[i].getAttribute("blend-mode") || "skip";
        effects[i].setAttribute("blend-mode", initialBlendMode);
        effects[i].blendMode = initialBlendMode;
      }
    }
  });
});
