<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class WINGS3DPR_Elementor_Loader {

    public function __construct() {
        if ( did_action( 'elementor/loaded' ) ) {
            $this->init();
        } else {
            add_action( 'elementor/loaded', [ $this, 'init' ] );
        }
    }

    /**
     * Initialize Elementor integration
     */
    public function init() {
        
        // Register Elementor hooks
        add_action(
            'elementor/elements/categories_registered',
            [ $this, 'register_category' ]
        );

        add_action(
            'elementor/widgets/register',
            [ $this, 'register_widgets' ]
        );

        add_action(
            'elementor/editor/before_enqueue_scripts',
            [ $this, 'register_scripts' ]
        );

        add_action(
            'elementor/frontend/before_enqueue_scripts',
            [ $this, 'register_scripts' ]
        );

        add_filter(
            'script_loader_tag',
            [ $this, 'add_type_module' ],
            10,
            2
        );
    }

    /**
     * Register Elementor widget category
     */
    public function register_category( $elements_manager ) {
        $elements_manager->add_category(
            'wings3dpr-widgets',
            [
                'title' => __( 'Wings 3D Product Viewer', 'wingstech-3d-product-viewer-interactive' ),
                'icon'  => 'fa fa-cube',
            ]
        );
    }

    /**
     * Register widgets
     */
    public function register_widgets( $widgets_manager ) {
        require_once WINGS3DPR_PLUGIN_DIR . 'inc/Elementor/class-wings3dpr-elementor-widget.php';

        $widgets_manager->register(
            new Wings3dpr_Elementor_Widget()
        );
    }

    /**
     * Register scripts/styles for Elementor
     */
    public function register_scripts() {

        $three_module = WINGS3DPR_PLUGIN_URL . 'inc/assets/js/three.module.min.js';

        wp_add_inline_script(
            'wings3dpr-model-viewer',
            'window.WINGS3DPR_IMPORT_MAP = ' . wp_json_encode(
                [
                    'imports' => [
                        'three' => $three_module,
                    ],
                ],
                JSON_UNESCAPED_SLASHES
            ),
            'before'
        );

        wp_register_script(
            'wings3dpr-model-viewer',
            WINGS3DPR_PLUGIN_URL . 'inc/assets/js/model-viewer.min.js',
            [],
            WINGS3DPR_PLUGIN_VER,
            true
        );

        wp_register_script(
            'wings3dpr-model-viewer-effects',
            WINGS3DPR_PLUGIN_URL . 'inc/assets/js/model-viewer-effects.min.js',
            [ 'jquery' ],
            WINGS3DPR_PLUGIN_VER,
            true
        );

        wp_register_script(
            'wings3dpr-qrcode',
            WINGS3DPR_PLUGIN_URL . 'inc/assets/js/qrcode.js',
            [],
            WINGS3DPR_PLUGIN_VER,
            true
        );

        wp_register_script(
            'wings3dpr-model-public-js',
            WINGS3DPR_PLUGIN_URL . 'inc/assets/js/model-public.js',
            [ 'jquery' ],
            WINGS3DPR_PLUGIN_VER,
            true
        );

        wp_register_style(
            'wings3dpr-model-public',
            WINGS3DPR_PLUGIN_URL . 'inc/assets/css/model-public.css',
            [],
            WINGS3DPR_PLUGIN_VER
        );
    }

    /**
     * Add type="module" to scripts
     */
    public function add_type_module( $tag, $handle ) {

        if ( in_array(
            $handle,
            [ 'wings3dpr-model-viewer', 'wings3dpr-model-viewer-effects' ],
            true
        ) ) {
            return str_replace( ' src', ' type="module" src', $tag );
        }

        return $tag;
    }
}
