<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>
<div class="tpv-wrap">
    <h1>📘 How to Use the 3D Model Interactive Plugin</h1>
    <div class="tpv-box">
        <section class="tpv-step">
            <h2>🧩 Step 1: Add a New 3D Model</h2>
            <ol>
                <li>
                    Go to 
                    <a href="<?php echo esc_url( admin_url('edit.php?post_type=wings3dpr_model') ); ?>" class="tpv-admin-link">
                        <strong>3D Models</strong>
                    </a> 
                    in your WordPress dashboard.
                </li>
                <li>
                    Click 
                    <a href="<?php echo esc_url( admin_url('post-new.php?post_type=wings3dpr_model') ); ?>" class="tpv-admin-link">
                        <strong>Add New</strong>
                    </a> 
                    to create a new 3D model post.
                </li>
                <li>Enter a meaningful title for your model (e.g. "Red Water Bottle").</li>
                <li>Upload a supported 3D model file (.glb or .gltf) using the custom fields provided.</li>
                <li>Optionally, set a fallback image for browsers that don't support 3D rendering.</li>
            </ol>
        </section>

        <section class="tpv-step">
            <h2>🔧 Step 2: Set Model Details</h2>
            <ol>
                <li>Configure visual options like lighting, background color, and shadow intensity.</li>
                <li>You can enable or disable auto-rotation and zoom functionality.</li>
                <li>Customize AR settings like AR scale and placement mode if applicable.</li>
                <li>Click <strong>Publish</strong> to save your model.</li>
            </ol>
        </section>

        <section class="tpv-step">
            <h2>📋 Step 3: Copy the Shortcode</h2>
            <p>After publishing, copy the shortcode from the model meta box or use:</p>
            <code>[3d_model_interactive id="123"]</code>
            <p>Where <code>123</code> is the ID of your model post.</p>            
        </section>

        <section class="tpv-step">
            <h2>🖼️ Step 4: Insert into Page or Post</h2>
            <p>Paste the shortcode into any post, page, or block editor (Gutenberg) shortcode block.</p>
            <p>If you're using Elementor, use the “Shortcode” widget and paste the same code.</p>
        </section>

        <section class="tpv-step">
            <h2>🔍 Step 5: Preview and Test</h2>
            <ul>
                <li>View your post or page on the front-end to ensure the model loads correctly.</li>
                <li>Try using a mobile device to test the AR experience using the AR icon (if available).</li>
                <li>If the model doesn't appear, double-check the file format and browser support.</li>
            </ul>
        </section>

        <section class="tpv-note">
            <strong>Note:</strong> AR support depends on the device and browser. Most Android (Chrome) and iOS (Safari) devices support AR with proper GLB models.
        </section>

        <section class="tpv-step">
            <h2>❓ Troubleshooting</h2>
            <ul>
                <li>Only use supported file formats: <code>.glb</code> or <code>.gltf</code>.</li>
                <li>Ensure your model is optimized and under 10MB.</li>
                <li>Clear your browser cache after updating a model.</li>
                <li>Use a modern browser: Chrome, Safari, Edge (Firefox has limited support).</li>
                <li>Check for JavaScript errors in the browser console.</li>
            </ul>
        </section>
    </div>
</div>
