<?php

if ( !defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * Checked if not exists WINGS3DPR_Admin_Settings class.
 */
if ( !class_exists( 'WINGS3DPR_Admin_Settings' ) ) {
    /**
     * WINGS3DPR_Admin_Settings class file.
     */
    class WINGS3DPR_Admin_Settings {
        /**
         * WINGS3DPR_Admin_Settings construct.
         */
        public function __construct() {
            add_filter(
                'script_loader_tag',
                array($this, 'add_type_module_attribute'),
                10,
                2
            );
            if ( is_admin() ) {
                add_action( 'admin_enqueue_scripts', array($this, 'admin_enqueue_scripts') );
                add_action( 'edit_form_after_title', [$this, 'model_shortcode_area'] );
                add_action( 'admin_menu', [$this, 'admin_menu'] );
            }
        }

        /**
         * Add admin menu and submenu pages.
         */
        public function admin_menu() {
            add_menu_page(
                __( '3D Model', 'wingstech-3d-product-viewer-interactive' ),
                __( '3D Model', 'wingstech-3d-product-viewer-interactive' ),
                'manage_options',
                '3d-model-interactive',
                [$this, 'dashboard_page'],
                'dashicons-format-gallery',
                15
            );
            add_submenu_page(
                '3d-model-interactive',
                __( 'Add New', 'wingstech-3d-product-viewer-interactive' ),
                __( 'Add New', 'wingstech-3d-product-viewer-interactive' ),
                'manage_options',
                '3d-model-interactive-add-new',
                [$this, 'redirectToAddNew'],
                2
            );
            add_submenu_page(
                '3d-model-interactive',
                esc_html__( '3D Viewer Help', 'wingstech-3d-product-viewer-interactive' ),
                esc_html__( 'Help', 'wingstech-3d-product-viewer-interactive' ),
                'manage_options',
                'wings3dpr_support',
                array($this, 'render_help_page')
            );
        }

        /**
         * Render the dashboard page content.
         */
        function dashboard_page() {
            require_once WINGS3DPR_PLUGIN_DIR . 'admin/support-html.php';
        }

        /**
         * Render the help page content.
         */
        function render_help_page() {
            require_once WINGS3DPR_PLUGIN_DIR . 'admin/support-html.php';
        }

        /**	
         * Redirect to add new Model Viewer
         * */
        function redirectToAddNew() {
            if ( function_exists( 'headers_sent' ) && headers_sent() ) {
                ?>
				<script>
					window.location.href = "<?php 
                echo esc_url( admin_url( 'post-new.php?post_type=wings3dpr_model' ) );
                ?>";
				</script>
			<?php 
            } else {
                wp_safe_redirect( admin_url( 'post-new.php?post_type=wings3dpr_model' ) );
            }
        }

        /**
         * Add attribute to script.
         *
         * @param string $tag The script tag.
         * @param string $handle The handle of the script.
         *
         * @return string Modified script tag with the attribute added.
         */
        public function add_type_module_attribute( $tag, $handle ) {
            if ( 'model-viewer-admin-min' === $handle || 'model-viewer-effects-min' === $handle || 'three-module-min' === $handle || 'admin-model-effect' === $handle ) {
                return str_replace( 'src', 'type="module" src', $tag );
            }
            return $tag;
        }

        /**
         * Get allowed html for print model viewer.
         */
        public static function get_allowed_html() {
            return array(
                'model-viewer'         => array(
                    'src'                  => array(),
                    'alt'                  => array(),
                    'ar'                   => array(),
                    'ar-modes'             => array(),
                    'ar-placement'         => array(),
                    'camera-controls'      => array(),
                    'environment-image'    => array(),
                    'skybox-image'         => array(),
                    'poster'               => array(),
                    'exposure'             => array(),
                    'shadow-intensity'     => array(),
                    'shadow-softness'      => array(),
                    'tone-mapping'         => array(),
                    'ar-status'            => array(),
                    'auto-rotate'          => array(),
                    'disable-zoom'         => array(),
                    'loading'              => array(),
                    'id'                   => array(),
                    'img'                  => array(),
                    'camera-orbit'         => array(),
                    'field-of-view'        => array(),
                    'min-camera-orbit'     => array(),
                    'max-camera-orbit'     => array(),
                    'min-field-of-view'    => array(),
                    'autoplay'             => array(),
                    'animation-name'       => array(),
                    'animation-speed'      => array(),
                    'data-id'              => array(),
                    'data-animation-speed' => array(),
                    'effect_data'          => array(),
                ),
                'effect-composer'      => array(
                    'render-mode' => array(),
                ),
                'outline-effect'       => array(
                    'blend-mode' => array(),
                    'color'      => array(),
                    'smoothing'  => array(),
                    'strength'   => array(),
                ),
                'ssao-effect'          => array(
                    'blend-mode' => array(),
                ),
                'glitch-effect'        => array(
                    'blend-mode' => array(),
                ),
                'smaa-effect'          => array(
                    'blend-mode' => array(),
                ),
                'bloom-effect'         => array(
                    'blend-mode' => array(),
                ),
                'pixelate-effect'      => array(
                    'granularity' => array(),
                    'blend-mode'  => array(),
                ),
                'color-grade-effect'   => array(
                    'blend-mode'  => array(),
                    'tonemapping' => array(),
                ),
                'model-editor'         => array(),
                'div'                  => array(
                    'class' => array(),
                    'id'    => array(),
                ),
                'a'                    => array(
                    'href'    => array(),
                    'data-id' => array(),
                    'class'   => array(),
                ),
                'span'                 => array(
                    'data-id'     => array(),
                    'data-target' => array(),
                    'class'       => array(),
                ),
                'model-viewer-preview' => array(
                    'id'      => array(),
                    'img'     => array(),
                    'data-id' => array(),
                ),
                'svg'                  => array(
                    'id'      => array(),
                    'width'   => array(),
                    'height'  => array(),
                    'viewBox' => array(),
                    'xmlns'   => array(),
                    'fill'    => array(),
                    'class'   => array(),
                ),
                'path'                 => array(
                    'fill-rule'    => array(),
                    'd'            => array(),
                    'fill'         => array(),
                    'stroke'       => array(),
                    'stroke-width' => array(),
                ),
                'script'               => array(),
                'img'                  => array(
                    'src' => array(),
                    'alt' => array(),
                ),
                'style'                => array(
                    'type'  => array(),
                    'media' => array(),
                ),
                'button'               => array(
                    'class'                     => array(),
                    'slot'                      => array(),
                    'data-position'             => array(),
                    'data-normal'               => array(),
                    'data-visibility-attribute' => array(),
                    'data-visible'              => array(),
                ),
            );
        }

        /**
         * Enqueues admin scripts and styles based on the current screen.
         *
         * @param string $hook The current admin page hook.
         */
        public function admin_enqueue_scripts( $hook ) {
            global $post;
            $screen = get_current_screen();
            if ( isset( $screen->post_type ) && 'wings3dpr_model' === $screen->post_type && 'edit.php' === $hook ) {
                wp_enqueue_style( 'wp-color-picker' );
                wp_enqueue_style(
                    'wings3dpr-admin-copy-shortcode',
                    WINGS3DPR_PLUGIN_URL . 'admin/assets/css/admin-copy-shortcode.css',
                    array(),
                    WINGS3DPR_PLUGIN_VER
                );
                wp_enqueue_script(
                    'wings3dpr-admin-copy-shortcode',
                    WINGS3DPR_PLUGIN_URL . 'admin/assets/js/admin-copy-shortcode.js',
                    array('jquery'),
                    WINGS3DPR_PLUGIN_VER,
                    true
                );
            }
            wp_enqueue_style(
                'wings3dpr-admin-support-guide',
                WINGS3DPR_PLUGIN_URL . 'admin/assets/css/admin-support-guide.css',
                array(),
                WINGS3DPR_PLUGIN_VER
            );
            if ( 'post-new.php' === $hook || 'post.php' === $hook ) {
                if ( isset( $screen->post_type ) && 'wings3dpr_model' === $screen->post_type ) {
                    wp_enqueue_style(
                        'wings3dpr-admin-style',
                        WINGS3DPR_PLUGIN_URL . 'admin/assets/css/admin-style.css',
                        array(),
                        WINGS3DPR_PLUGIN_VER
                    );
                    wp_enqueue_media();
                    $threeModule = WINGS3DPR_PLUGIN_URL . 'admin/assets/js/three.module.min.js';
                    $import_map = [
                        'imports' => [
                            'three' => $threeModule,
                        ],
                    ];
                    ?>
					<script type="importmap">
						<?php 
                    echo wp_json_encode( $import_map, JSON_UNESCAPED_SLASHES );
                    ?>
					</script>
					<?php 
                    wp_enqueue_script(
                        'model-color-picker-script',
                        WINGS3DPR_PLUGIN_URL . 'admin/assets/js/model-color-picker.js',
                        array('wp-color-picker', 'jquery'),
                        WINGS3DPR_PLUGIN_VER,
                        true
                    );
                    wp_enqueue_script(
                        'model-viewer-admin-min',
                        WINGS3DPR_PLUGIN_URL . 'admin/assets/js/model-viewer.min.js',
                        array('jquery'),
                        WINGS3DPR_PLUGIN_VER,
                        true
                    );
                    wp_enqueue_script(
                        'model-viewer-effects-min',
                        WINGS3DPR_PLUGIN_URL . 'admin/assets/js/model-viewer-effects.min.js',
                        array('jquery'),
                        WINGS3DPR_PLUGIN_VER,
                        true
                    );
                    wp_enqueue_script(
                        'admin-settings',
                        WINGS3DPR_PLUGIN_URL . 'admin/assets/js/admin-settings.js',
                        array('jquery'),
                        WINGS3DPR_PLUGIN_VER,
                        true
                    );
                }
            }
        }

        /**
         * Display the Model Shortcode Area in the post editor.
         *
         * Adds a custom shortcode area to the WordPress editor for 'wings3dpr_model' post types.
         * This area provides users with a shortcode and PHP template code snippet for embedding
         * 3D model views within posts, pages, or template files.
         */
        public function model_shortcode_area() {
            global $post;
            if ( $post->post_type == 'wings3dpr_model' ) {
                ?>
			<div class="tpv-model-shortcode-area">
				<div class="tpv-model-shortcode-heading">
					<div class="tpv-model-shortcode-icon">
						<span class="dashicons dashicons-shortcode"></span>
						<?php 
                esc_html_e( "SHORTCODE", "wingstech-3d-product-viewer-interactive" );
                ?>
					</div>
					<div class="tpv-model-shortcode-text">
						<a href="https://view3d.wtsverse.com/" target="_blank">
							<?php 
                esc_html_e( "Supports", "wingstech-3d-product-viewer-interactive" );
                ?>
						</a>
					</div>
				</div>
				<div class="tpv-model-shortcode-left-part">
					<h3><?php 
                esc_html_e( "Shortcode", "wingstech-3d-product-viewer-interactive" );
                ?></h3>
					<p><?php 
                esc_html_e( "Copy and paste this shortcode into your posts, pages and widget:", "wingstech-3d-product-viewer-interactive" );
                ?>
					</p>
					<div class="shortcode" selectable>[3d_model_interactive id="<?php 
                echo esc_attr( $post->ID );
                ?>"]</div>
				</div>
				<div class="tpv-model-shortcode-right-part">
					<h3><?php 
                esc_html_e( "Template Include", "wingstech-3d-product-viewer-interactive" );
                ?></h3>
					<p><?php 
                esc_html_e( "Copy and paste the PHP code into your template file:", "wingstech-3d-product-viewer-interactive" );
                ?></p>
					<div class="shortcode">&lt;?php echo do_shortcode('[3d_model_interactive
						id="<?php 
                echo esc_html( $post->ID );
                ?>"]'); ?&gt;</div>
				</div>
			</div>
			<?php 
            }
        }

    }

}