jQuery(function ($) {
    $(document).on("click", ".copy-button", function (e) {
        e.preventDefault();

        let postId = $(this).data("id");
        let shortcode = $("#shortcode-" + postId).text();

        copyToClipboard(shortcode, postId);
    });
});

function copyToClipboard(text, postId) {
    const textarea = document.createElement("textarea");
    textarea.value = text;
    document.body.appendChild(textarea);

    textarea.select();
    document.execCommand("copy");

    document.body.removeChild(textarea);

    const tooltip = document.getElementById("tooltip-" + postId);
    tooltip.classList.add("show");

    setTimeout(() => {
        tooltip.classList.remove("show");
    }, 2000);
}



