<?php
/**
 * Functions help
 *
 * @package wimb-and-block
 */

//
function wimbblock_help() {
	require_once ABSPATH . 'wp-admin/includes/plugin-install.php';
	$plugin_info = plugins_api(
		'plugin_information',
		array(
			'slug'   => 'wimb-and-block',
			'fields' => array(
				'sections' => true,
			),
		)
	);
	if ( ! $plugin_info || is_wp_error( $plugin_info ) ) {
		return __( 'The information could not be retrieved.', 'wimb-and-block' );
	}
	$text = '';
	foreach ( $plugin_info as $key => $value ) {
		if ( $key === 'sections' ) {
			foreach ( $value as $section => $part ) {
				// ***description***installation***faq***changelog***screenshots***reviews
				switch ( $section ) {
					case 'description':
						if ( get_locale() === 'de_DE' ) {
							$text .= '<h3>Beschreibung</h3>';
						} else {
							$text .= '<h3>Description</h3>';
						}
						$text .= str_replace( '<li>', '<li class="adminli">', $part );
						break;
					default:
				}
			}
		}
	}
	return $text;
}
