<?php
/**
 * Plugin Name: Product Warranty and Guarantee for WooCommerce
 * Description: Adds a Warranty / Guarantee field to WooCommerce products (General Tab), controllable from Admin Settings.
 * Version: 1.0.2
 * Author: MD. Muslim
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Requires Plugins: woocommerce
 * Text Domain: wgpw-product-warranty
 */

if (!defined('ABSPATH')) exit;

class WGPW_WooCommerce {

    public function __construct() {
        // Load files
        $this->includes();

        // Admin Settings
        add_action('admin_menu', [$this, 'add_settings_page']);

        // WooCommerce field hooks (conditionally loaded inside includes/general-tab-field.php)
        add_action('wp', [$this, 'setup_frontend_display']);
    }

    private function includes() {
        require_once plugin_dir_path(__FILE__) . 'admin/settings-page.php';
        require_once plugin_dir_path(__FILE__) . 'includes/general-tab-field.php';
        require_once plugin_dir_path(__FILE__) . 'includes/frontend-display.php';
    }

    // Frontend display
    public function setup_frontend_display() {
        if (!is_product()) return;

        $enabled = get_option('wgpw_general_tab_enabled', 'yes');
        if ($enabled === 'yes') {
            add_action('woocommerce_single_product_summary', 'wgpw_display_warranty', 25);
            add_action('wp_enqueue_scripts', [$this, 'enqueue_frontend_scripts']);

            // Add badge hook based on position setting
            $badge_position = get_option('wgpw_badge_position', 'title');
            switch ($badge_position) {
                case 'title':
                    add_action('woocommerce_single_product_summary', 'wgpw_display_badge', 6); // After title
                    break;
                case 'price':
                    add_action('woocommerce_single_product_summary', 'wgpw_display_badge', 11); // After price
                    break;
                case 'meta':
                    add_action('woocommerce_product_meta_start', 'wgpw_display_badge', 10); // In meta section
                    break;
            }
        }
    }

    // Enqueue frontend scripts and styles
    public function enqueue_frontend_scripts() {
        wp_enqueue_script('wgpw-frontend-js', plugin_dir_url(__FILE__) . 'assets/js/frontend.js', ['jquery'], '1.0', true);
        wp_enqueue_style('wgpw-frontend-css', plugin_dir_url(__FILE__) . 'assets/css/frontend.css', [], '1.0');

        // Pass settings to JS
        $settings = [
            'bg_color' => get_option('wgpw_tooltip_bg_color', '#333'),
            'text_color' => get_option('wgpw_tooltip_text_color', '#fff'),
            'font_size' => get_option('wgpw_tooltip_font_size', 14),
        ];
        wp_localize_script('wgpw-frontend-js', 'wgpw_settings', $settings);
    }

    // Admin settings page
    public function add_settings_page() {
        add_menu_page(
            'Warranty Settings',
            'Warranty Settings',
            'manage_options',
            'wgpw-product-warranty',
            'wgpw_render_settings_page',
            'dashicons-shield-alt',
            56
        );
    }
}

// Initialize plugin
new WGPW_WooCommerce();
