<?php
if (!defined('ABSPATH')) exit;

// Add fields in General Tab if enabled
add_action('woocommerce_product_options_general_product_data', function() {
    $enabled = get_option('wgpw_general_tab_enabled', 'yes');
    if ($enabled !== 'yes') return;

    global $post;
    $warranties = get_post_meta($post->ID, '_wgpw_warranties', true);
    if (!is_array($warranties)) {
        $warranties = [];
    }
    if (empty($warranties)) {
        $warranties = [['name' => '', 'expiry' => '']];
    }

    echo '<div id="wgpw-warranties-list">';
    foreach ($warranties as $index => $warranty) {
        $name = isset($warranty['name']) ? $warranty['name'] : '';
        $expiry = isset($warranty['expiry']) ? $warranty['expiry'] : '';
        $description = isset($warranty['description']) ? $warranty['description'] : '';
        echo '<div class="wgpw-warranty">';
        woocommerce_wp_text_input([
            'id' => 'wgpw_warranty_name_' . esc_attr($index),
            'name' => 'wgpw_warranties[' . esc_attr($index) . '][name]',
            'value' => $name,
            'label' => __('Warranty Name', 'wgpw-product-warranty'),
            'placeholder' => __('e.g., 1-Year Warranty', 'wgpw-product-warranty'),
            'wrapper_class' => 'form-field',
        ]);
        echo '<p>';
        echo '<label for="wgpw_warranty_expiry_' . esc_attr($index) . '">' . esc_html(__('Expiry Date (optional)', 'wgpw-product-warranty')) . '</label>';
        echo '<input type="date" id="wgpw_warranty_expiry_' . esc_attr($index) . '" name="wgpw_warranties[' . esc_attr($index) . '][expiry]" value="' . esc_attr($expiry) . '" />';
        echo '</p>';
        woocommerce_wp_textarea_input([
            'id' => 'wgpw_warranty_description_' . esc_attr($index),
            'name' => 'wgpw_warranties[' . esc_attr($index) . '][description]',
            'value' => $description,
            'label' => __('Tooltip Description (optional)', 'wgpw-product-warranty'),
            'placeholder' => __('Extra info shown on hover', 'wgpw-product-warranty'),
            'desc_tip' => true,
            'description' => __('This will appear as a tooltip when hovering over the warranty name on the frontend.', 'wgpw-product-warranty'),
        ]);
        echo '<button type="button" class="button wgpw-remove-warranty">Remove</button>';
        echo '</div>';
    }
    echo '</div>';
    echo '<button type="button" class="button" id="wgpw-add-warranty">Add Warranty</button>';
    wp_nonce_field('wgpw_save_warranties', 'wgpw_nonce');
});

// Enqueue scripts
add_action('admin_enqueue_scripts', function($hook) {
    if ($hook !== 'post.php' && $hook !== 'post-new.php') return;
    wp_enqueue_script('wgpw-admin-js', plugin_dir_url(__FILE__) . '../assets/js/admin.js', ['jquery'], '1.0', true);
});

// Save fields
add_action('woocommerce_process_product_meta', function($post_id) {
    $enabled = get_option('wgpw_general_tab_enabled', 'yes');
    if ($enabled !== 'yes') return;

    $nonce_verified = isset($_POST['wgpw_nonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['wgpw_nonce'])), 'wgpw_save_warranties');
    if (isset($_POST['wgpw_warranties'])) {
        // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
        $warranties_raw = wp_unslash($_POST['wgpw_warranties']);
    } else {
        $warranties_raw = null;
    }
    if ($nonce_verified && is_array($warranties_raw)) {
        $warranties = [];
        $has_valid = 'no';
        $today = gmdate('Y-m-d');
        foreach ($warranties_raw as $warranty) {
            $name = isset($warranty['name']) ? sanitize_text_field($warranty['name']) : '';
            $expiry = isset($warranty['expiry']) ? sanitize_text_field($warranty['expiry']) : '';
            $description = isset($warranty['description']) ? sanitize_textarea_field($warranty['description']) : '';
            if ($name !== '') {
                $warranties[] = ['name' => $name, 'expiry' => $expiry, 'description' => $description];
                if ($expiry === '' || $expiry >= $today) {
                    $has_valid = 'yes';
                }
            }
        }
        update_post_meta($post_id, '_wgpw_warranties', $warranties);
        update_post_meta($post_id, '_wgpw_has_valid_warranty', $has_valid);
    }
});
