<?php
if (!defined('ABSPATH')) exit;

// The Customer-Facing Warranty Filter feature has been removed as per user request.

function wgpw_display_warranty() {
    global $post;
    $warranties = get_post_meta($post->ID, '_wgpw_warranties', true);
    if (!$warranties || !is_array($warranties)) {
        // Backward compatibility: check old single warranty
        $old_warranty = get_post_meta($post->ID, '_wgpw_warranty', true);
        if ($old_warranty) {
            $warranties = [['name' => $old_warranty, 'expiry' => '']];
        }
    }
    $valid_warranties = [];
    if ($warranties && is_array($warranties)) {
        $today = gmdate('Y-m-d');
        foreach ($warranties as $warranty) {
            if (is_array($warranty) && isset($warranty['name'])) {
                $expiry = isset($warranty['expiry']) ? $warranty['expiry'] : '';
                if ($expiry === '' || $expiry >= $today) {
                    $valid_warranties[] = $warranty;
                }
            } elseif (is_string($warranty)) {
                // Old format
                $valid_warranties[] = ['name' => $warranty, 'description' => ''];
            }
        }
    }
    if (count($valid_warranties) > 0) {
        echo '<div class="wgpw-warranty">';
        echo '<strong>' . esc_html(__('Warranties / Guarantees:', 'wgpw-product-warranty')) . '</strong>';
        echo '<ul>';
        foreach ($valid_warranties as $warranty) {
            $warranty_name = isset($warranty['name']) ? $warranty['name'] : '';
            $description = isset($warranty['description']) ? $warranty['description'] : '';
            $tooltip_class = $description ? 'wgpw-tooltip' : '';
            $data_attr = $description ? ' data-tooltip="' . esc_attr($description) . '"' : '';
            echo '<li><span class="' . esc_attr($tooltip_class) . '"' . esc_attr($data_attr) . '>' . esc_html($warranty_name) . '</span></li>';
        }
        echo '</ul>';
        echo '</div>';
    }
}

// Display warranty/guarantee badge on product page
function wgpw_display_badge() {
    global $post;

    // Check if product has valid warranties
    $warranties = get_post_meta($post->ID, '_wgpw_warranties', true);
    if (!$warranties || !is_array($warranties)) {
        // Backward compatibility: check old single warranty
        $old_warranty = get_post_meta($post->ID, '_wgpw_warranty', true);
        if ($old_warranty) {
            $warranties = [['name' => $old_warranty, 'expiry' => '']];
        }
    }

    $has_valid_warranty = false;
    if ($warranties && is_array($warranties)) {
        $today = gmdate('Y-m-d');
        foreach ($warranties as $warranty) {
            if (is_array($warranty) && isset($warranty['name'])) {
                $expiry = isset($warranty['expiry']) ? $warranty['expiry'] : '';
                if ($expiry === '' || $expiry >= $today) {
                    $has_valid_warranty = true;
                    break;
                }
            } elseif (is_string($warranty)) {
                // Old format
                $has_valid_warranty = true;
                break;
            }
        }
    }

    // Only display badge if product has valid warranty
    if ($has_valid_warranty) {
        $badge_type = get_option('wgpw_badge_type', 'warranty');
        $warranty_text = get_option('wgpw_warranty_badge_text', 'Warranty Available ✅');
        $guarantee_text = get_option('wgpw_guarantee_badge_text', 'Guarantee Available ✅');
        $badge_text = ($badge_type === 'guarantee') ? $guarantee_text : $warranty_text;

        echo '<div class="wgpw-badge">';
        echo '<span class="wgpw-badge-text">' . esc_html($badge_text) . '</span>';
        echo '</div>';
    }
}

// Shortcode function to display full warranty/guarantee info including tooltips
function wcpw_product_warranty() {
    global $post;

    if (!$post || !is_a($post, 'WP_Post')) {
        return '';
    }

    ob_start();
    wgpw_display_warranty();
    return ob_get_clean();
}

// Register the shortcode
add_shortcode('wgpw_product_warranty_info', 'wcpw_product_warranty');
