jQuery(document).ready(function($) {
    // Apply dynamic styles from settings
    if (typeof wgpw_settings !== 'undefined') {
        var style = '<style>';
        style += '.wgpw-tooltip:hover::after { background-color: ' + wgpw_settings.bg_color + '; color: ' + wgpw_settings.text_color + '; font-size: ' + wgpw_settings.font_size + 'px; }';
        style += '.wgpw-tooltip:hover::before { border-top-color: ' + wgpw_settings.bg_color + '; }';
        style += '</style>';
        $('head').append(style);
    }

    // For mobile tap
    $('.wgpw-tooltip').on('touchstart', function(e) {
        e.preventDefault();
        var $this = $(this);
        $this.toggleClass('active');
        $('.wgpw-tooltip').not($this).removeClass('active');
    });

    // Hide on tap outside
    $(document).on('touchstart', function(e) {
        if (!$(e.target).closest('.wgpw-tooltip').length) {
            $('.wgpw-tooltip').removeClass('active');
        }
    });
});
