<?php
if (!defined('ABSPATH')) exit;

function wgpw_render_settings_page() {
    if (isset($_POST['_wpnonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['_wpnonce'])), 'wgpw_settings_nonce')) {
        update_option('wgpw_general_tab_enabled', sanitize_text_field(wp_unslash($_POST['wgpw_general_tab_enabled'] ?? '')));
        update_option('wgpw_badge_type', sanitize_text_field(wp_unslash($_POST['wgpw_badge_type'] ?? '')));
        update_option('wgpw_badge_position', sanitize_text_field(wp_unslash($_POST['wgpw_badge_position'] ?? '')));
        update_option('wgpw_warranty_badge_text', sanitize_text_field(wp_unslash($_POST['wgpw_warranty_badge_text'] ?? '')));
        update_option('wgpw_guarantee_badge_text', sanitize_text_field(wp_unslash($_POST['wgpw_guarantee_badge_text'] ?? '')));
        update_option('wgpw_tooltip_bg_color', sanitize_hex_color(wp_unslash($_POST['wgpw_tooltip_bg_color'] ?? '')));
        update_option('wgpw_tooltip_text_color', sanitize_hex_color(wp_unslash($_POST['wgpw_tooltip_text_color'] ?? '')));
        update_option('wgpw_tooltip_font_size', intval(wp_unslash($_POST['wgpw_tooltip_font_size'] ?? 14)));
        echo '<div class="updated"><p>Settings saved!</p></div>';
    }

    $enabled = get_option('wgpw_general_tab_enabled', 'yes');
    $badge_type = get_option('wgpw_badge_type', 'warranty');
    $badge_position = get_option('wgpw_badge_position', 'title');
    $warranty_badge_text = get_option('wgpw_warranty_badge_text', 'Warranty Available ✅');
    $guarantee_badge_text = get_option('wgpw_guarantee_badge_text', 'Guarantee Available ✅');
    $bg_color = get_option('wgpw_tooltip_bg_color', '#333');
    $text_color = get_option('wgpw_tooltip_text_color', '#fff');
    $font_size = get_option('wgpw_tooltip_font_size', 14);
    ?>
    <div class="wrap wgpw-settings-wrap">
        <div class="wgpw-header">
            <h1><span class="dashicons dashicons-shield-alt"></span> Product Warranty / Guarantee Settings</h1>
            <p class="wgpw-description">Configure warranty and guarantee settings for your WooCommerce products</p>
        </div>

        <form method="post" class="wgpw-settings-form">
            <?php wp_nonce_field('wgpw_settings_nonce'); ?>

            <div class="wgpw-settings-grid">
                <!-- General Settings Card -->
                <div class="wgpw-card">
                    <div class="wgpw-card-header">
                        <h2><span class="dashicons dashicons-admin-settings"></span> General Settings</h2>
                    </div>
                    <div class="wgpw-card-body">
                        <div class="wgpw-setting-item">
                            <h3>Enable Warranty Field in General Tab</h3>
                            <p class="wgpw-setting-description">Allow adding warranty information to products in the general tab</p>
                            <div class="wgpw-radio-group">
                                <label class="wgpw-radio-label">
                                    <input type="radio" name="wgpw_general_tab_enabled" value="yes" <?php checked($enabled,'yes'); ?>>
                                    <span class="wgpw-radio-checkmark"></span>
                                    Enable
                                </label>
                                <label class="wgpw-radio-label">
                                    <input type="radio" name="wgpw_general_tab_enabled" value="no" <?php checked($enabled,'no'); ?>>
                                    <span class="wgpw-radio-checkmark"></span>
                                    Disable
                                </label>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Badge Settings Card -->
                <div class="wgpw-card">
                    <div class="wgpw-card-header">
                        <h2><span class="dashicons dashicons-awards"></span> Badge Settings</h2>
                    </div>
                    <div class="wgpw-card-body">
                        <div class="wgpw-setting-item">
                            <h3>Product Badge Type</h3>
                            <p class="wgpw-setting-description">Choose what type of badge to display on product pages</p>
                            <div class="wgpw-radio-group">
                                <label class="wgpw-radio-label">
                                    <input type="radio" name="wgpw_badge_type" value="warranty" <?php checked($badge_type,'warranty'); ?>>
                                    <span class="wgpw-radio-checkmark"></span>
                                    Warranty Available ✅
                                </label>
                                <label class="wgpw-radio-label">
                                    <input type="radio" name="wgpw_badge_type" value="guarantee" <?php checked($badge_type,'guarantee'); ?>>
                                    <span class="wgpw-radio-checkmark"></span>
                                    Guarantee Available ✅
                                </label>
                            </div>
                        </div>
                        <div class="wgpw-setting-item">
                            <h3>Custom Badge Text</h3>
                            <p class="wgpw-setting-description">Customize the text displayed on warranty and guarantee badges</p>
                            <div class="wgpw-form-table">
                                <div class="wgpw-form-row">
                                    <div class="wgpw-form-group">
                                        <label for="wgpw_warranty_badge_text">Warranty Badge Text</label>
                                        <input type="text" id="wgpw_warranty_badge_text" name="wgpw_warranty_badge_text" value="<?php echo esc_attr($warranty_badge_text); ?>" placeholder="Warranty Available ✅" />
                                    </div>
                                    <div class="wgpw-form-group">
                                        <label for="wgpw_guarantee_badge_text">Guarantee Badge Text</label>
                                        <input type="text" id="wgpw_guarantee_badge_text" name="wgpw_guarantee_badge_text" value="<?php echo esc_attr($guarantee_badge_text); ?>" placeholder="Guarantee Available ✅" />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Badge Position Card -->
                <div class="wgpw-card">
                    <div class="wgpw-card-header">
                        <h2><span class="dashicons dashicons-location"></span> Badge Position</h2>
                    </div>
                    <div class="wgpw-card-body">
                        <div class="wgpw-setting-item">
                            <h3>Display Position</h3>
                            <p class="wgpw-setting-description">Choose where to display the badge on product pages</p>
                            <div class="wgpw-radio-group">
                                <label class="wgpw-radio-label">
                                    <input type="radio" name="wgpw_badge_position" value="title" <?php checked($badge_position,'title'); ?>>
                                    <span class="wgpw-radio-checkmark"></span>
                                    Below Product Title
                                </label>
                                <label class="wgpw-radio-label">
                                    <input type="radio" name="wgpw_badge_position" value="price" <?php checked($badge_position,'price'); ?>>
                                    <span class="wgpw-radio-checkmark"></span>
                                    Below Price
                                </label>
                                <label class="wgpw-radio-label">
                                    <input type="radio" name="wgpw_badge_position" value="meta" <?php checked($badge_position,'meta'); ?>>
                                    <span class="wgpw-radio-checkmark"></span>
                                    Product Meta Section
                                </label>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Tooltip Styling Card -->
                <div class="wgpw-card">
                    <div class="wgpw-card-header">
                        <h2><span class="dashicons dashicons-art"></span> Tooltip Styling</h2>
                    </div>
                    <div class="wgpw-card-body">
                        <div class="wgpw-form-table">
                            <div class="wgpw-form-row">
                                <div class="wgpw-form-group">
                                    <label for="wgpw_tooltip_bg_color">Background Color</label>
                                    <div class="wgpw-color-input-wrapper">
                                        <input type="color" id="wgpw_tooltip_bg_color" name="wgpw_tooltip_bg_color" value="<?php echo esc_attr($bg_color); ?>" />
                                        <span class="wgpw-color-preview" style="background-color: <?php echo esc_attr($bg_color); ?>"></span>
                                    </div>
                                </div>
                                <div class="wgpw-form-group">
                                    <label for="wgpw_tooltip_text_color">Text Color</label>
                                    <div class="wgpw-color-input-wrapper">
                                        <input type="color" id="wgpw_tooltip_text_color" name="wgpw_tooltip_text_color" value="<?php echo esc_attr($text_color); ?>" />
                                        <span class="wgpw-color-preview" style="background-color: <?php echo esc_attr($text_color); ?>"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="wgpw-form-row">
                                <div class="wgpw-form-group">
                                    <label for="wgpw_tooltip_font_size">Font Size (px)</label>
                                    <div class="wgpw-number-input-wrapper">
                                        <input type="number" id="wgpw_tooltip_font_size" name="wgpw_tooltip_font_size" value="<?php echo esc_attr($font_size); ?>" min="10" max="24" />
                                        <span class="wgpw-input-unit">px</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="wgpw-submit-section">
                <input type="submit" class="button button-primary wgpw-save-button" value="Save Settings">
                <span class="spinner wgpw-spinner"></span>
            </div>
        </form>
    </div>

    <?php
    wp_enqueue_style('wgpw-admin-css', plugin_dir_url(__FILE__) . '../assets/css/admin.css', [], '1.0');

    // Handle update
    if (isset($_POST['wgpw_update_warranties']) && isset($_POST['_wpnonce']) &&
        wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['_wpnonce'])), 'wgpw_update_warranties_nonce')) {
        wgpw_update_all_warranty_status();
        echo '<div class="updated"><p>All product warranty statuses updated!</p></div>';
    }
}

function wgpw_update_all_warranty_status() {
    $args = array(
        'post_type' => 'product',
        'posts_per_page' => -1,
        'fields' => 'ids',
    );
    $products = get_posts($args);
    foreach ($products as $product_id) {
        $warranties = get_post_meta($product_id, '_wgpw_warranties', true);
        $has_valid = 'no';
        if (is_array($warranties)) {
            $today = gmdate('Y-m-d');
            foreach ($warranties as $warranty) {
                if (is_array($warranty) && isset($warranty['name']) && !empty($warranty['name'])) {
                    $expiry = isset($warranty['expiry']) ? $warranty['expiry'] : '';
                    if ($expiry === '' || $expiry >= $today) {
                        $has_valid = 'yes';
                        break;
                    }
                }
            }
        }
        update_post_meta($product_id, '_wgpw_has_valid_warranty', $has_valid);
    }
}
