<?php

namespace WeglotLanguages;

/**
 * @phpstan-type Language = array{
 *     code: string,
 *     english: string,
 *     local: string,
 *     rtl: bool,
 *     country: string,
 *     variant: bool,
 * }
 */
class Languages
{
    /** @phpstan-return array<string, Language> */
    public static function getData()
    {
        return [
            'af' => [
                'code' => 'af',
                'english' => "Afrikaans",
                'local' => "Afrikaans",
                'rtl' => false,
                'country' => 'za',
                'variant' => false,
            ],
            'am' => [
                'code' => 'am',
                'english' => "Amharic",
                'local' => "አማርኛ",
                'rtl' => false,
                'country' => 'et',
                'variant' => false,
            ],
            'ar' => [
                'code' => 'ar',
                'english' => "Arabic",
                'local' => "العربية‏",
                'rtl' => true,
                'country' => 'sa',
                'variant' => false,
            ],
            'az' => [
                'code' => 'az',
                'english' => "Azerbaijani",
                'local' => "Azərbaycan dili",
                'rtl' => false,
                'country' => 'az',
                'variant' => false,
            ],
            'ba' => [
                'code' => 'ba',
                'english' => "Bashkir",
                'local' => "башҡорт теле",
                'rtl' => false,
                'country' => 'ru',
                'variant' => false,
            ],
            'be' => [
                'code' => 'be',
                'english' => "Belarusian",
                'local' => "Беларуская",
                'rtl' => false,
                'country' => 'by',
                'variant' => false,
            ],
            'bg' => [
                'code' => 'bg',
                'english' => "Bulgarian",
                'local' => "Български",
                'rtl' => false,
                'country' => 'bg',
                'variant' => false,
            ],
            'bn' => [
                'code' => 'bn',
                'english' => "Bengali",
                'local' => "বাংলা",
                'rtl' => false,
                'country' => 'bd',
                'variant' => false,
            ],
            'pt-br' => [
                'code' => 'pt-br',
                'english' => "Brazilian Portuguese",
                'local' => "Português Brasileiro",
                'rtl' => false,
                'country' => 'br',
                'variant' => false,
            ],
            'bs' => [
                'code' => 'bs',
                'english' => "Bosnian",
                'local' => "Bosanski",
                'rtl' => false,
                'country' => 'ba',
                'variant' => false,
            ],
            'ca' => [
                'code' => 'ca',
                'english' => "Catalan",
                'local' => "Català",
                'rtl' => false,
                'country' => 'es-ca',
                'variant' => false,
            ],
            'co' => [
                'code' => 'co',
                'english' => "Corsican",
                'local' => "Corsu",
                'rtl' => false,
                'country' => 'fr-co',
                'variant' => false,
            ],
            'cs' => [
                'code' => 'cs',
                'english' => "Czech",
                'local' => "Čeština",
                'rtl' => false,
                'country' => 'cz',
                'variant' => false,
            ],
            'cy' => [
                'code' => 'cy',
                'english' => "Welsh",
                'local' => "Cymraeg",
                'rtl' => false,
                'country' => 'gb-wls',
                'variant' => false,
            ],
            'da' => [
                'code' => 'da',
                'english' => "Danish",
                'local' => "Dansk",
                'rtl' => false,
                'country' => 'dk',
                'variant' => false,
            ],
            'de' => [
                'code' => 'de',
                'english' => "German",
                'local' => "Deutsch",
                'rtl' => false,
                'country' => 'de',
                'variant' => false,
            ],
            'el' => [
                'code' => 'el',
                'english' => "Greek",
                'local' => "Ελληνικά",
                'rtl' => false,
                'country' => 'gr',
                'variant' => false,
            ],
            'en' => [
                'code' => 'en',
                'english' => "English",
                'local' => "English",
                'rtl' => false,
                'country' => 'gb',
                'variant' => false,
            ],
            'eo' => [
                'code' => 'eo',
                'english' => "Esperanto",
                'local' => "Esperanto",
                'rtl' => false,
                'country' => 'eo',
                'variant' => false,
            ],
            'es' => [
                'code' => 'es',
                'english' => "Spanish",
                'local' => "Español",
                'rtl' => false,
                'country' => 'es',
                'variant' => false,
            ],
            'et' => [
                'code' => 'et',
                'english' => "Estonian",
                'local' => "Eesti",
                'rtl' => false,
                'country' => 'ee',
                'variant' => false,
            ],
            'eu' => [
                'code' => 'eu',
                'english' => "Basque",
                'local' => "Euskara",
                'rtl' => false,
                'country' => 'eus',
                'variant' => false,
            ],
            'fa' => [
                'code' => 'fa',
                'english' => "Persian",
                'local' => "فارسی",
                'rtl' => true,
                'country' => 'ir',
                'variant' => false,
            ],
            'fi' => [
                'code' => 'fi',
                'english' => "Finnish",
                'local' => "Suomi",
                'rtl' => false,
                'country' => 'fi',
                'variant' => false,
            ],
            'fj' => [
                'code' => 'fj',
                'english' => "Fijian",
                'local' => "Vosa Vakaviti",
                'rtl' => false,
                'country' => 'fj',
                'variant' => false,
            ],
            'fl' => [
                'code' => 'fl',
                'english' => "Filipino",
                'local' => "Filipino",
                'rtl' => false,
                'country' => 'ph',
                'variant' => false,
            ],
            'fr' => [
                'code' => 'fr',
                'english' => "French",
                'local' => "Français",
                'rtl' => false,
                'country' => 'fr',
                'variant' => false,
            ],
            'fy' => [
                'code' => 'fy',
                'english' => "Western Frisian",
                'local' => "frysk",
                'rtl' => false,
                'country' => 'nl',
                'variant' => false,
            ],
            'ga' => [
                'code' => 'ga',
                'english' => "Irish",
                'local' => "Gaeilge",
                'rtl' => false,
                'country' => 'ie',
                'variant' => false,
            ],
            'gd' => [
                'code' => 'gd',
                'english' => "Scottish Gaelic",
                'local' => "Gàidhlig",
                'rtl' => false,
                'country' => 'gb-sct',
                'variant' => false,
            ],
            'gl' => [
                'code' => 'gl',
                'english' => "Galician",
                'local' => "Galego",
                'rtl' => false,
                'country' => 'es-ga',
                'variant' => false,
            ],
            'gu' => [
                'code' => 'gu',
                'english' => "Gujarati",
                'local' => "ગુજરાતી",
                'rtl' => false,
                'country' => 'in',
                'variant' => false,
            ],
            'ha' => [
                'code' => 'ha',
                'english' => "Hausa",
                'local' => "هَوُسَ",
                'rtl' => false,
                'country' => 'ne',
                'variant' => false,
            ],
            'he' => [
                'code' => 'he',
                'english' => "Hebrew",
                'local' => "עברית",
                'rtl' => true,
                'country' => 'il',
                'variant' => false,
            ],
            'hi' => [
                'code' => 'hi',
                'english' => "Hindi",
                'local' => "हिंदी",
                'rtl' => false,
                'country' => 'in',
                'variant' => false,
            ],
            'hr' => [
                'code' => 'hr',
                'english' => "Croatian",
                'local' => "Hrvatski",
                'rtl' => false,
                'country' => 'hr',
                'variant' => false,
            ],
            'ht' => [
                'code' => 'ht',
                'english' => "Haitian Creole",
                'local' => "Kreyòl ayisyen",
                'rtl' => false,
                'country' => 'ht',
                'variant' => false,
            ],
            'hu' => [
                'code' => 'hu',
                'english' => "Hungarian",
                'local' => "Magyar",
                'rtl' => false,
                'country' => 'hu',
                'variant' => false,
            ],
            'hw' => [
                'code' => 'hw',
                'english' => "Hawaiian",
                'local' => "‘Ōlelo Hawai‘i",
                'rtl' => false,
                'country' => 'hw',
                'variant' => false,
            ],
            'hy' => [
                'code' => 'hy',
                'english' => "Armenian",
                'local' => "հայերեն",
                'rtl' => false,
                'country' => 'am',
                'variant' => false,
            ],
            'id' => [
                'code' => 'id',
                'english' => "Indonesian",
                'local' => "Bahasa Indonesia",
                'rtl' => false,
                'country' => 'id',
                'variant' => false,
            ],
            'ig' => [
                'code' => 'ig',
                'english' => "Igbo",
                'local' => "Igbo",
                'rtl' => false,
                'country' => 'ne',
                'variant' => false,
            ],
            'is' => [
                'code' => 'is',
                'english' => "Icelandic",
                'local' => "Íslenska",
                'rtl' => false,
                'country' => 'is',
                'variant' => false,
            ],
            'it' => [
                'code' => 'it',
                'english' => "Italian",
                'local' => "Italiano",
                'rtl' => false,
                'country' => 'it',
                'variant' => false,
            ],
            'ja' => [
                'code' => 'ja',
                'english' => "Japanese",
                'local' => "日本語",
                'rtl' => false,
                'country' => 'jp',
                'variant' => false,
            ],
            'jv' => [
                'code' => 'jv',
                'english' => "Javanese",
                'local' => "Wong Jawa",
                'rtl' => false,
                'country' => 'id',
                'variant' => false,
            ],
            'ka' => [
                'code' => 'ka',
                'english' => "Georgian",
                'local' => "ქართული",
                'rtl' => false,
                'country' => 'ge',
                'variant' => false,
            ],
            'kk' => [
                'code' => 'kk',
                'english' => "Kazakh",
                'local' => "Қазақша",
                'rtl' => false,
                'country' => 'kz',
                'variant' => false,
            ],
            'km' => [
                'code' => 'km',
                'english' => "Central Khmer",
                'local' => "ភាសាខ្មែរ",
                'rtl' => false,
                'country' => 'kh',
                'variant' => false,
            ],
            'kn' => [
                'code' => 'kn',
                'english' => "Kannada",
                'local' => "ಕನ್ನಡ",
                'rtl' => false,
                'country' => 'in',
                'variant' => false,
            ],
            'ko' => [
                'code' => 'ko',
                'english' => "Korean",
                'local' => "한국어",
                'rtl' => false,
                'country' => 'kr',
                'variant' => false,
            ],
            'ku' => [
                'code' => 'ku',
                'english' => "Kurdish",
                'local' => "كوردی",
                'rtl' => true,
                'country' => 'iq',
                'variant' => false,
            ],
            'ky' => [
                'code' => 'ky',
                'english' => "Kyrgyz",
                'local' => "кыргызча",
                'rtl' => false,
                'country' => 'kg',
                'variant' => false,
            ],
            'la' => [
                'code' => 'la',
                'english' => "Latin",
                'local' => "Latine",
                'rtl' => false,
                'country' => 'it',
                'variant' => false,
            ],
            'lb' => [
                'code' => 'lb',
                'english' => "Luxembourgish",
                'local' => "Lëtzebuergesch",
                'rtl' => false,
                'country' => 'lu',
                'variant' => false,
            ],
            'lo' => [
                'code' => 'lo',
                'english' => "Lao",
                'local' => "ພາສາລາວ",
                'rtl' => false,
                'country' => 'la',
                'variant' => false,
            ],
            'lt' => [
                'code' => 'lt',
                'english' => "Lithuanian",
                'local' => "Lietuvių",
                'rtl' => false,
                'country' => 'lt',
                'variant' => false,
            ],
            'lv' => [
                'code' => 'lv',
                'english' => "Latvian",
                'local' => "Latviešu",
                'rtl' => false,
                'country' => 'lv',
                'variant' => false,
            ],
            'lg' => [
                'code' => 'lg',
                'english' => "Luganda",
                'local' => "Oluganda",
                'rtl' => false,
                'country' => 'ug',
                'variant' => false,
            ],
            'mg' => [
                'code' => 'mg',
                'english' => "Malagasy",
                'local' => "Malagasy",
                'rtl' => false,
                'country' => 'mg',
                'variant' => false,
            ],
            'mi' => [
                'code' => 'mi',
                'english' => "Māori",
                'local' => "te reo Māori",
                'rtl' => false,
                'country' => 'nz',
                'variant' => false,
            ],
            'mk' => [
                'code' => 'mk',
                'english' => "Macedonian",
                'local' => "Македонски",
                'rtl' => false,
                'country' => 'mk',
                'variant' => false,
            ],
            'ml' => [
                'code' => 'ml',
                'english' => "Malayalam",
                'local' => "മലയാളം",
                'rtl' => false,
                'country' => 'in',
                'variant' => false,
            ],
            'mn' => [
                'code' => 'mn',
                'english' => "Mongolian",
                'local' => "Монгол",
                'rtl' => false,
                'country' => 'mn',
                'variant' => false,
            ],
            'mr' => [
                'code' => 'mr',
                'english' => "Marathi",
                'local' => "मराठी",
                'rtl' => false,
                'country' => 'in',
                'variant' => false,
            ],
            'ms' => [
                'code' => 'ms',
                'english' => "Malay",
                'local' => "Bahasa Melayu",
                'rtl' => false,
                'country' => 'my',
                'variant' => false,
            ],
            'mt' => [
                'code' => 'mt',
                'english' => "Maltese",
                'local' => "Malti",
                'rtl' => false,
                'country' => 'mt',
                'variant' => false,
            ],
            'my' => [
                'code' => 'my',
                'english' => "Burmese",
                'local' => "မျန္မာစာ",
                'rtl' => false,
                'country' => 'mm',
                'variant' => false,
            ],
            'ne' => [
                'code' => 'ne',
                'english' => "Nepali",
                'local' => "नेपाली",
                'rtl' => false,
                'country' => 'np',
                'variant' => false,
            ],
            'nl' => [
                'code' => 'nl',
                'english' => "Dutch",
                'local' => "Nederlands",
                'rtl' => false,
                'country' => 'nl',
                'variant' => false,
            ],
            'no' => [
                'code' => 'no',
                'english' => "Norwegian",
                'local' => "Norsk",
                'rtl' => false,
                'country' => 'no',
                'variant' => false,
            ],
            'ny' => [
                'code' => 'ny',
                'english' => "Chichewa",
                'local' => "chiCheŵa",
                'rtl' => false,
                'country' => 'mw',
                'variant' => false,
            ],
            'pa' => [
                'code' => 'pa',
                'english' => "Punjabi",
                'local' => "ਪੰਜਾਬੀ",
                'rtl' => false,
                'country' => 'in',
                'variant' => false,
            ],
            'pl' => [
                'code' => 'pl',
                'english' => "Polish",
                'local' => "Polski",
                'rtl' => false,
                'country' => 'pl',
                'variant' => false,
            ],
            'ps' => [
                'code' => 'ps',
                'english' => "Pashto",
                'local' => "پښتو",
                'rtl' => true,
                'country' => 'pk',
                'variant' => false,
            ],
            'pt' => [
                'code' => 'pt',
                'english' => "Portuguese",
                'local' => "Português",
                'rtl' => false,
                'country' => 'pt',
                'variant' => false,
            ],
            'ro' => [
                'code' => 'ro',
                'english' => "Romanian",
                'local' => "Română",
                'rtl' => false,
                'country' => 'ro',
                'variant' => false,
            ],
            'ru' => [
                'code' => 'ru',
                'english' => "Russian",
                'local' => "Русский",
                'rtl' => false,
                'country' => 'ru',
                'variant' => false,
            ],
            'sd' => [
                'code' => 'sd',
                'english' => "Sindhi",
                'local' => "سنڌي، سندھی, सिन्धी",
                'rtl' => false,
                'country' => 'pk',
                'variant' => false,
            ],
            'si' => [
                'code' => 'si',
                'english' => "Sinhalese",
                'local' => "සිංහල",
                'rtl' => false,
                'country' => 'lk',
                'variant' => false,
            ],
            'sk' => [
                'code' => 'sk',
                'english' => "Slovak",
                'local' => "Slovenčina",
                'rtl' => false,
                'country' => 'sk',
                'variant' => false,
            ],
            'sl' => [
                'code' => 'sl',
                'english' => "Slovenian",
                'local' => "Slovenščina",
                'rtl' => false,
                'country' => 'si',
                'variant' => false,
            ],
            'sm' => [
                'code' => 'sm',
                'english' => "Samoan",
                'local' => "gagana fa'a Samoa",
                'rtl' => false,
                'country' => 'ws',
                'variant' => false,
            ],
            'sn' => [
                'code' => 'sn',
                'english' => "Shona",
                'local' => "chiShona",
                'rtl' => false,
                'country' => 'zw',
                'variant' => false,
            ],
            'so' => [
                'code' => 'so',
                'english' => "Somali",
                'local' => "Soomaaliga",
                'rtl' => false,
                'country' => 'so',
                'variant' => false,
            ],
            'sq' => [
                'code' => 'sq',
                'english' => "Albanian",
                'local' => "Shqip",
                'rtl' => false,
                'country' => 'al',
                'variant' => false,
            ],
            'sr' => [
                'code' => 'sr',
                'english' => "Serbian (Cyrillic)",
                'local' => "Српски",
                'rtl' => false,
                'country' => 'rs',
                'variant' => false,
            ],
            'st' => [
                'code' => 'st',
                'english' => "Southern Sotho",
                'local' => "seSotho",
                'rtl' => false,
                'country' => 'ng',
                'variant' => false,
            ],
            'su' => [
                'code' => 'su',
                'english' => "Sundanese",
                'local' => "Sundanese",
                'rtl' => false,
                'country' => 'sd',
                'variant' => false,
            ],
            'sv' => [
                'code' => 'sv',
                'english' => "Swedish",
                'local' => "Svenska",
                'rtl' => false,
                'country' => 'se',
                'variant' => false,
            ],
            'sw' => [
                'code' => 'sw',
                'english' => "Swahili",
                'local' => "Kiswahili",
                'rtl' => false,
                'country' => 'ke',
                'variant' => false,
            ],
            'ta' => [
                'code' => 'ta',
                'english' => "Tamil",
                'local' => "தமிழ்",
                'rtl' => false,
                'country' => 'in',
                'variant' => false,
            ],
            'te' => [
                'code' => 'te',
                'english' => "Telugu",
                'local' => "తెలుగు",
                'rtl' => false,
                'country' => 'in',
                'variant' => false,
            ],
            'tg' => [
                'code' => 'tg',
                'english' => "Tajik",
                'local' => "Тоҷикӣ",
                'rtl' => false,
                'country' => 'tj',
                'variant' => false,
            ],
            'th' => [
                'code' => 'th',
                'english' => "Thai",
                'local' => "ภาษาไทย",
                'rtl' => false,
                'country' => 'th',
                'variant' => false,
            ],
            'tl' => [
                'code' => 'tl',
                'english' => "Tagalog",
                'local' => "Tagalog",
                'rtl' => false,
                'country' => 'ph',
                'variant' => false,
            ],
            'to' => [
                'code' => 'to',
                'english' => "Tongan",
                'local' => "faka-Tonga",
                'rtl' => false,
                'country' => 'to',
                'variant' => false,
            ],
            'tr' => [
                'code' => 'tr',
                'english' => "Turkish",
                'local' => "Türkçe",
                'rtl' => false,
                'country' => 'tr',
                'variant' => false,
            ],
            'tt' => [
                'code' => 'tt',
                'english' => "Tatar",
                'local' => "Tatar",
                'rtl' => false,
                'country' => 'tr',
                'variant' => false,
            ],
            'zh-tw' => [
                'code' => 'zh-tw',
                'english' => "Traditional Chinese",
                'local' => "中文 (繁體)",
                'rtl' => false,
                'country' => 'tw',
                'variant' => false,
            ],
            'ty' => [
                'code' => 'ty',
                'english' => "Tahitian",
                'local' => "te reo Tahiti, te reo Māʼohi",
                'rtl' => false,
                'country' => 'pf',
                'variant' => false,
            ],
            'uk' => [
                'code' => 'uk',
                'english' => "Ukrainian",
                'local' => "Українська",
                'rtl' => false,
                'country' => 'ua',
                'variant' => false,
            ],
            'ur' => [
                'code' => 'ur',
                'english' => "Urdu",
                'local' => "اردو",
                'rtl' => true,
                'country' => 'pk',
                'variant' => false,
            ],
            'uz' => [
                'code' => 'uz',
                'english' => "Uzbek",
                'local' => "O'zbek",
                'rtl' => false,
                'country' => 'uz',
                'variant' => false,
            ],
            'vi' => [
                'code' => 'vi',
                'english' => "Vietnamese",
                'local' => "Tiếng Việt",
                'rtl' => false,
                'country' => 'vn',
                'variant' => false,
            ],
            'xh' => [
                'code' => 'xh',
                'english' => "Xhosa",
                'local' => "isiXhosa",
                'rtl' => false,
                'country' => 'za',
                'variant' => false,
            ],
            'yi' => [
                'code' => 'yi',
                'english' => "Yiddish",
                'local' => "ייִדיש",
                'rtl' => false,
                'country' => 'il',
                'variant' => false,
            ],
            'yo' => [
                'code' => 'yo',
                'english' => "Yoruba",
                'local' => "Yorùbá",
                'rtl' => false,
                'country' => 'ng',
                'variant' => false,
            ],
            'zh' => [
                'code' => 'zh',
                'english' => "Simplified Chinese",
                'local' => "中文 (简体)",
                'rtl' => false,
                'country' => 'cn',
                'variant' => false,
            ],
            'zu' => [
                'code' => 'zu',
                'english' => "Zulu",
                'local' => "isiZulu",
                'rtl' => false,
                'country' => 'za',
                'variant' => false,
            ],
            'hmn' => [
                'code' => 'hmn',
                'english' => "Hmong",
                'local' => "Hmoob",
                'rtl' => false,
                'country' => 'hmn',
                'variant' => false,
            ],
            'ceb' => [
                'code' => 'ceb',
                'english' => "Cebuano",
                'local' => "Sugbuanon",
                'rtl' => false,
                'country' => 'ph',
                'variant' => false,
            ],
            'or' => [
                'code' => 'or',
                'english' => "Odia",
                'local' => "ଓଡ଼ିଆ",
                'rtl' => false,
                'country' => 'in',
                'variant' => false,
            ],
            'tk' => [
                'code' => 'tk',
                'english' => "Turkmen",
                'local' => "Türkmen",
                'rtl' => false,
                'country' => 'tr',
                'variant' => false,
            ],
            'ug' => [
                'code' => 'ug',
                'english' => "Uyghur",
                'local' => "ئۇيغۇر",
                'rtl' => true,
                'country' => 'uig',
                'variant' => false,
            ],
            'fr-ca' => [
                'code' => 'fr-ca',
                'english' => "French (Canada)",
                'local' => "Français (Canada)",
                'rtl' => false,
                'country' => 'ca',
                'variant' => false,
            ],
            'as' => [
                'code' => 'as',
                'english' => "Assamese",
                'local' => "অসমীয়া",
                'rtl' => false,
                'country' => 'in',
                'variant' => false,
            ],
            'sr-latn' => [
                'code' => 'sr-latn',
                'english' => "Serbian (Latin)",
                'local' => "Srpski",
                'rtl' => false,
                'country' => 'rs',
                'variant' => false,
            ],
            'om' => [
                'code' => 'om',
                'english' => "Oromo",
                'local' => "Afaan Oromoo",
                'rtl' => false,
                'country' => 'et',
                'variant' => false,
            ],
            'iu' => [
                'code' => 'iu',
                'english' => "Inuktitut",
                'local' => "ᐃᓄᒃᑎᑐᑦ",
                'rtl' => false,
                'country' => 'ca',
                'variant' => false,
            ],
            'ti' => [
                'code' => 'ti',
                'english' => "Tigrinya",
                'local' => "ቲግሪንያ",
                'rtl' => false,
                'country' => 'er',
                'variant' => false,
            ],
            'bm' => [
                'code' => 'bm',
                'english' => "Bambara",
                'local' => "Bamanankan",
                'rtl' => false,
                'country' => 'ml',
                'variant' => false,
            ],
            'bo' => [
                'code' => 'bo',
                'english' => "Tibetan",
                'local' => "བོད་ཡིག",
                'rtl' => false,
                'country' => 'cn',
                'variant' => false,
            ],
            'ak' => [
                'code' => 'ak',
                'english' => "Akan",
                'local' => "Baoulé",
                'rtl' => false,
                'country' => 'gh',
                'variant' => false,
            ],
            'rw' => [
                'code' => 'rw',
                'english' => "Kinyarwanda",
                'local' => "Kinyarwanda",
                'rtl' => false,
                'country' => 'rw',
                'variant' => false,
            ],
            'kb' => [
                'code' => 'kb',
                'english' => "Kurdish (Sorani)",
                'local' => "سۆرانی",
                'rtl' => true,
                'country' => 'iq',
                'variant' => false,
            ],
            'fo' => [
                'code' => 'fo',
                'english' => "Faroese",
                'local' => "Føroyskt",
                'rtl' => false,
                'country' => 'fo',
                'variant' => false,
            ],
            'il' => [
                'code' => 'il',
                'english' => "Ilocano",
                'local' => "Ilokano",
                'rtl' => false,
                'country' => 'ph',
                'variant' => false,
            ],
            'ay' => [
                'code' => 'ay',
                'english' => "Aymara",
                'local' => "Aymara",
                'rtl' => false,
                'country' => 'bo',
                'variant' => false,
            ],
            'dv' => [
                'code' => 'dv',
                'english' => "Divehi",
                'local' => "ދިވެހި",
                'rtl' => true,
                'country' => 'mv',
                'variant' => false,
            ],
            'ee' => [
                'code' => 'ee',
                'english' => "Ewe",
                'local' => "Eʋegbe",
                'rtl' => false,
                'country' => 'gh',
                'variant' => false,
            ],
            'gn' => [
                'code' => 'gn',
                'english' => "Guarani",
                'local' => "Avañe'ẽ",
                'rtl' => false,
                'country' => 'py',
                'variant' => false,
            ],
            'ln' => [
                'code' => 'ln',
                'english' => "Lingala",
                'local' => "Lingála",
                'rtl' => false,
                'country' => 'cd',
                'variant' => false,
            ],
            'qu' => [
                'code' => 'qu',
                'english' => "Quechua",
                'local' => "Runa Simi",
                'rtl' => false,
                'country' => 'pe',
                'variant' => false,
            ],
            'ts' => [
                'code' => 'ts',
                'english' => "Tsonga",
                'local' => "Xitsonga",
                'rtl' => false,
                'country' => 'za',
                'variant' => false,
            ],
            'oc' => [
                'code' => 'oc',
                'english' => "Occitan",
                'local' => "Occitan",
                'rtl' => false,
                'country' => 'fr',
                'variant' => false,
            ],
            'nb' => [
                'code' => 'nb',
                'english' => "Norwegian Bokmål",
                'local' => "Norsk Bokmål",
                'rtl' => false,
                'country' => 'no',
                'variant' => false,
            ],
            'yue' => [
                'code' => 'yue',
                'english' => "Cantonese",
                'local' => "粵語",
                'rtl' => false,
                'country' => 'hk',
                'variant' => false,
            ],
            'mh' => [
                'code' => 'mh',
                'english' => "Marshallese",
                'local' => "Kajin M̧ajeļ",
                'rtl' => false,
                'country' => 'mh',
                'variant' => false,
            ],
            'chk' => [
                'code' => 'chk',
                'english' => "Chuukese",
                'local' => "Chuuk",
                'rtl' => false,
                'country' => 'fm',
                'variant' => false,
            ],
        ];
    }
}
