<?php
/**
 * Plugin Name: Websync Builder for Contact Form 7
 * Plugin URI: https://whistleblowing-form.de/en/builder-for-contact-form-7/
 * Description: A powerful visual builder for Contact Form 7. Build forms easily with a drag-and-drop interface instead of shortcodes and HTML.
 * Version: 1.1.0
 * Author: Whistleblowing System Team
 * Author URI: https://whistleblowing-form.de
 * Text Domain: websync-builder-cf7
 * License: GPL-3.0-or-later
 * License URI: https://www.gnu.org/licenses/gpl-3.0.html
 * Requires Plugins: contact-form-7
 */

defined( 'ABSPATH' ) || exit;

define( 'WBSY_CF7_VERSION', '1.1.0' );
define( 'WBSY_CF7_PREFIX', 'wblscf7' );
define( 'WBSY_CF7_PRO', false );
define( 'WBSY_CF7_PLUGIN_FILE', __FILE__ );
define( 'WBSY_CF7_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'WBSY_CF7_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

$wp_upload_dir = wp_upload_dir();
define( 'WBSY_CF7_UPLOAD_DIR', trailingslashit( $wp_upload_dir['basedir'] ) . 'cf7-builder/images' );
define( 'WBSY_CF7_UPLOAD_URL', trailingslashit( $wp_upload_dir['baseurl'] ) . 'cf7-builder/images' );

define( 'WBSY_CF7_CORE_URL', 'https://whistleblowing-form.de/' );
define( 'WBSY_CF7_DEACTIVATION_REST', 'https://whistleblowing-form.de/wp-json/custom/v1/receive-data/' );

// Load plugin config and autoload classes
require_once __DIR__ . '/vendor/autoload.php';

use WBSY\CF7\Core\Plugin;

(new Plugin())->init();
