<?php
namespace WBSY\CF7\Submissions;

class SubmissionsList extends \WP_List_Table {

    public function __construct() {
        parent::__construct([
            'singular' => 'form',
            'plural'   => 'forms',
            'ajax'     => false
        ]);
    }

    public function get_columns() {
        return [
            'cb'           => '<input type="checkbox" />', // ✅ This was missing!
            'form_id'      => __('Form ID', 'cf7-builder'),
            'form_name'    => __('Form Name', 'cf7-builder'),
            'submissions'  => __('Submissions', 'cf7-builder'),
            'created'      => __('Created', 'cf7-builder'),
            'actions'      => __('Actions', 'cf7-builder')
        ];
    }

    public function get_sortable_columns() {
        return [
            'form_id'   => ['form_id', false],
            'form_name' => ['form_name', false],
            'created'   => ['created', false]
        ];
    }

    public function column_cb($item) {
        return '<input type="checkbox" name="form_ids[]" value="' . esc_attr($item['ID']) . '">';
    }

    public function column_form_id($item) {
        return esc_html($item['form_id']);
    }

    public function column_form_name($item) {
        return esc_html($item['form_name']);
    }

    public function column_submissions($item) {
        return esc_html($item['submissions']);
    }

    public function column_created($item) {
        return esc_html($item['created']);
    }

    public function column_actions($item) {
        $view_url = admin_url('admin.php?page=wblscf7-submissions&form_id=' . $item['ID']);
        $delete_url = wp_nonce_url(admin_url('admin-post.php?action=wblscf7_delete_submissions&form_id=' . $item['ID']), 'wblscf7_delete_submissions');

        return sprintf(
            '<a href="%s">%s</a> | <a href="%s" onclick="return confirm(\'Are you sure you want to delete all submissions?\')">%s</a>',
            esc_url($view_url),
            __('View', 'cf7-builder'),
            esc_url($delete_url),
            __('Delete Submissions', 'cf7-builder')
        );
    }

    public function prepare_items() {
        $per_page = 20;
        $paged = $this->get_pagenum();

        $forms = get_posts([
            'post_type'      => 'wpcf7_contact_form',
            'posts_per_page' => $per_page,
            'paged'          => $paged
        ]);

        $data = [];
        foreach ($forms as $form) {
            $submissions = get_posts([
                'post_type'  => 'wblscf7_submission',
                'meta_key'   => '_form_id',
                'meta_value' => $form->ID,
                'fields'     => 'ids',
                'posts_per_page' => -1,
            ]);

            $data[] = [
                'ID'          => $form->ID,
                'form_id'     => $form->ID,
                'form_name'   => $form->post_title,
                'submissions' => count($submissions),
                'created'     => get_the_date('', $form),
            ];
        }

        $total_items = wp_count_posts('wpcf7_contact_form')->publish;

        $this->items = $data;

        $this->_column_headers = [
            $this->get_columns(),
            [], // no hidden columns
            $this->get_sortable_columns()
        ];

        $this->set_pagination_args([
            'total_items' => $total_items,
            'per_page'    => $per_page
        ]);
    }

    public function get_bulk_actions() {
        return [
            'delete' => __('Empty', 'cf7-builder')
        ];
    }

    public function process_bulk_action() {
        if ( $this->current_action() === 'delete' &&
            ! empty($_POST['form_ids']) ) {
            foreach ((array) $_POST['form_ids'] as $form_id) {
                $submissions = get_posts([
                    'post_type'  => 'wblscf7_submission',
                    'meta_key'   => '_form_id',
                    'meta_value' => (int) $form_id,
                    'posts_per_page' => -1,
                    'fields'     => 'ids'
                ]);

                foreach ($submissions as $sub_id) {
                    wp_trash_post($sub_id); // or wp_delete_post($sub_id, true) for permanent delete
                }
            }

            add_action('admin_notices', function () {
                echo '<div class="notice notice-success is-dismissible"><p>' .
                    esc_html__('Submissions deleted successfully.', 'cf7-builder') .
                    '</p></div>';
            });
        }
    }}
