<?php
namespace WBSY\CF7\Submissions;

class Manager {
    public function register_post_type() {
        // Register on init
        add_action('init', [$this, 'register_cpt']);
        add_action('wpcf7_before_send_mail', [$this, 'save_submission'], 10, 1);
    }

    public function register_cpt() {
        register_post_type('wblscf7_submission', [
            'labels' => [
                'name' => 'CF7 Submissions',
                'singular_name' => 'CF7 Submission',
            ],
            'public' => false,
            'show_ui' => false, // Don't show the default editor
            'has_archive' => false,
            'rewrite' => false,
            'supports' => ['title', 'custom-fields'],
            'show_in_menu' => false, // Don't add to admin menu
        ]);

        // Optional: if you need custom rewrite tags, do it **here**, not in constructor
        // global $wp_rewrite; // Not needed unless modifying permastructs manually
        // add_rewrite_tag('%cf7_submission%', '([^&]+)');
        // flush_rewrite_rules(); ← only once during activation!
    }

    public function save_submission($contact_form) {
        $submission = \WPCF7_Submission::get_instance();
        if (!$submission) return;

        $data = $submission->get_posted_data();
        $form_id = $contact_form->id();

        $post_id = wp_insert_post([
            'post_type'    => 'wblscf7_submission',
            'post_status'  => 'publish',
            'post_title'   => 'Submission ' . current_time('Y-m-d H:i:s'),
            'meta_input'   => ['_form_id' => $form_id],
        ]);

        if ($post_id && is_array($data)) {
            foreach ($data as $key => $value) {
                if (!is_array($value) && $key !== 'wbsycf7_hidden_names') {
                    update_post_meta($post_id, $key, sanitize_text_field($value));
                }
            }
        }
    }
}
