<?php

namespace WBSY\CF7\Core;

use WBSY\CF7\Admin\BuilderTab;
use WBSY\CF7\Frontend\Override;
use WBSY\CF7\Admin\PreviewPage;
use WBSY\CF7\Submissions\Exporter;
use WBSY\CF7\Submissions\Manager;
use WBSY\CF7\Submissions\AdminPage;

class Plugin {
    public function init() {
        (new BuilderTab())->register();
        (new Override())->register();
        (new PreviewPage())->register();

        (new Manager())->register_post_type();


        if (is_admin()) {
            (new AdminPage())->register_menu();
            (new Exporter())->register();
        }

        add_action( 'admin_enqueue_scripts', [ $this, 'adminAssets' ] );
        add_action( 'wp_enqueue_scripts', [ $this, 'frontendAssets' ] );

        // Enqueue per form at render time (one arg only)
        add_filter( 'wpcf7_form_elements', function( $elements ) {

            $cf = function_exists( '\wpcf7_get_current_contact_form' )
                ? \wpcf7_get_current_contact_form()
                : null;

            if ( $cf instanceof \WPCF7_ContactForm ) {

                $this->enqueue_form_conditions_js( $cf );
            }

            return $elements; // always return the HTML unchanged
        }, 10, 1 );

        add_action('wp_ajax_wbsycf7_send_deactivation_reason', array($this, 'wbsycf7_send_deactivation_reason') );
        add_action('current_screen', array( $this, 'wbsycf7_check_plugins_page' ) );
    }

    /**
     * Enqueue the generated JS when this CF7 form is displayed.
     * Hook this to a place that runs on the front-end before the form prints.
     */
    function enqueue_form_conditions_js( \WPCF7_ContactForm $contact_form ) {

        $form_id = (int) $contact_form->id();
        $uploads = wp_upload_dir();
        $url = trailingslashit( $uploads['baseurl'] ) . 'wbsycf7/wbsycf7-conditions-' . $form_id . '.js';
        $file_path = trailingslashit( $uploads['basedir'] ) . 'wbsycf7/wbsycf7-conditions-' . $form_id . '.js';
        if ( ! file_exists($file_path) ) return;

        // Unique handle per form so multiple forms can coexist
        wp_enqueue_script( 'wbsycf7-conditions-'.$form_id, $url, [], null, true );
    }

    public function adminAssets( $hook ) {
        if ( strpos( $hook, 'wpcf7' ) !== false || (isset($_GET['page']) && $_GET['page'] === 'wblscf7-submissions') ) {
            wp_enqueue_script( 'jquery-ui-sortable' );
            wp_enqueue_script(
                'wbsycf7-editor-js', 
                WBSY_CF7_PLUGIN_URL . 'assets/admin/js/editor.js', 
                ['jquery'], 
                WBSY_CF7_VERSION, true
            );
            wp_enqueue_script(
                'wbsycf7-admin-js', 
                WBSY_CF7_PLUGIN_URL . 'assets/admin/js/admin.js', 
                ['jquery'], 
                WBSY_CF7_VERSION, 
                true
            );

            wp_enqueue_script(
                'wbsycf7-conditions-js',
                WBSY_CF7_PLUGIN_URL . 'assets/admin/js/conditions.js',
                ['jquery'],
                WBSY_CF7_VERSION,
                true
            );

            $wblscf7_form_fields = [];
            $wblscf7_form_conditions = [];

            $page = isset($_GET['page']) ? sanitize_text_field(wp_unslash($_GET['page'])) : '';
            $post_id = isset($_GET['post']) ? intval(wp_unslash($_GET['post'])) : 0;
            if ( $page === 'wpcf7' && $post_id ) {
                $wblscf7_form_fields = get_post_meta($post_id, '_wblscf7_form_fields', true) ?: [];
                $wblscf7_form_conditions = get_post_meta($post_id, '_wbsycf7_conditions', true) ?: [];
            }

            wp_localize_script(
                'wbsycf7-conditions-js',
                'WBSY_CF7_CONDITIONS',
                [
                    'form_fields' => $wblscf7_form_fields,
                    'form_conditions' => $wblscf7_form_conditions,
                    'is_pro' => WBSY_CF7_PRO
                ]
            );


            wp_enqueue_style(
                'wbsycf7-admin-css', 
                WBSY_CF7_PLUGIN_URL . 'assets/admin/css/admin.css', 
                [], WBSY_CF7_VERSION
            );

            wp_enqueue_style(
                'wbsycf7-condition-css',
                WBSY_CF7_PLUGIN_URL . 'assets/admin/css/conditions.css',
                [],
                WBSY_CF7_VERSION
            );

            wp_enqueue_style(
                'wbsycf7-shared-css',
                WBSY_CF7_PLUGIN_URL . 'assets/shared/style.css',
                [],
                WBSY_CF7_VERSION
            );
        }

        wp_register_script('select2-js', WBSY_CF7_PLUGIN_URL . '/assets/admin/js/select2.min.js', ['jquery'], WBSY_CF7_VERSION, true);
        wp_register_style('select2-css', WBSY_CF7_PLUGIN_URL . '/assets/admin/css/select2.min.css', [],WBSY_CF7_VERSION);

        wp_register_script('wbsycf7-deactivate', WBSY_CF7_PLUGIN_URL . 'src/Apps/deactivate/assets/deactivate.js', array('jquery'), WBSY_CF7_VERSION);
        // Pass AJAX URL to the script
        wp_localize_script('wbsycf7-deactivate', 'deactivate_options', [
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('wbsycf7_ajax_nonce'),
            'pro' => WBSY_CF7_PRO,
        ]);
        wp_register_style('wbsycf7-deactivate', WBSY_CF7_PLUGIN_URL . 'src/Apps/deactivate/assets/deactivate.css', array(), WBSY_CF7_VERSION);

    }

    public function frontendAssets() {
        wp_enqueue_script(
            'wbsycf7-frontend-js',
            WBSY_CF7_PLUGIN_URL . 'assets/frontend/js/frontend.js',
            [],
            WBSY_CF7_VERSION,
            true
        );

        wp_enqueue_style(
            'wbsycf7-frontend-css',
            WBSY_CF7_PLUGIN_URL . 'assets/frontend/css/frontend.css',
            [],
            WBSY_CF7_VERSION
        );

        wp_enqueue_style(
            'wbsycf7-shared-css',
            WBSY_CF7_PLUGIN_URL . 'assets/shared/style.css',
            [],
            WBSY_CF7_VERSION
        );
    }

    public function wbsycf7_send_deactivation_reason() {
        $nonce = isset($_POST['nonce']) ? sanitize_text_field( wp_unslash($_POST['nonce']) ) : '';
        if ( ! wp_verify_nonce( $nonce, 'wbsycf7_ajax_nonce' ) ) {
            wp_send_json_error(['message' => 'Security issue.']);
        }
        $this->wbsycf7_check_plugins_page('plugins' );
    }

    public function wbsycf7_check_plugins_page( $current_screen ) {
        $task = isset($_POST['task']) ? sanitize_text_field( wp_unslash($_POST['task']) ) : '';
        $cid = '';
        if( isset($current_screen->id) ) {
            $cid = $current_screen->id;
        } elseif( $current_screen == 'plugins' ) {
            $cid = 'plugins';
        }
        if ( 'plugins' == $cid ) {
            require_once WBSY_CF7_PLUGIN_DIR."/src/Apps/deactivate/deactivate.php";
            new \WBSYCF7_deactivate\WBSYCF7_Deactivate($task);
        }
    }

}
